/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Segment;

public abstract class AbstractWriter {
    private ElementIterator it;
    private Writer out;
    private int indentLevel = 0;
    private int indentSpace = 2;
    private Document doc = null;
    private int maxLineLength = 100;
    private int currLength = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private int offsetIndent = 0;
    private String lineSeparator;
    private boolean canWrapLines;
    private boolean isLineEmpty;
    private char[] indentChars;
    private char[] tempChars;
    private char[] newlineChars;
    private Segment segment;
    protected static final char NEWLINE = '\n';

    protected AbstractWriter(Writer writer, Document document) {
        this(writer, document, 0, document.getLength());
    }

    protected AbstractWriter(Writer writer, Document document, int n, int n2) {
        this.doc = document;
        this.it = new ElementIterator(document.getDefaultRootElement());
        this.out = writer;
        this.startOffset = n;
        this.endOffset = n + n2;
        Object object = document.getProperty("__EndOfLine__");
        if (object instanceof String) {
            this.setLineSeparator((String)object);
        } else {
            String string = null;
            try {
                string = System.getProperty("line.separator");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string == null) {
                string = "\n";
            }
            this.setLineSeparator(string);
        }
        this.canWrapLines = true;
    }

    protected AbstractWriter(Writer writer, Element element) {
        this(writer, element, 0, element.getEndOffset());
    }

    protected AbstractWriter(Writer writer, Element element, int n, int n2) {
        this.doc = element.getDocument();
        this.it = new ElementIterator(element);
        this.out = writer;
        this.startOffset = n;
        this.endOffset = n + n2;
        this.canWrapLines = true;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    protected ElementIterator getElementIterator() {
        return this.it;
    }

    protected Writer getWriter() {
        return this.out;
    }

    protected Document getDocument() {
        return this.doc;
    }

    protected boolean inRange(Element element) {
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        return element.getStartOffset() >= n && element.getStartOffset() < n2 || n >= element.getStartOffset() && n < element.getEndOffset();
    }

    protected abstract void write() throws IOException, BadLocationException;

    protected String getText(Element element) throws BadLocationException {
        return this.doc.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
    }

    protected void text(Element element) throws BadLocationException, IOException {
        int n;
        int n2 = Math.max(this.getStartOffset(), element.getStartOffset());
        if (n2 < (n = Math.min(this.getEndOffset(), element.getEndOffset()))) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            this.getDocument().getText(n2, n - n2, this.segment);
            if (this.segment.count > 0) {
                this.write(this.segment.array, this.segment.offset, this.segment.count);
            }
        }
    }

    protected void setLineLength(int n) {
        this.maxLineLength = n;
    }

    protected int getLineLength() {
        return this.maxLineLength;
    }

    protected void setCurrentLineLength(int n) {
        this.currLength = n;
        this.isLineEmpty = this.currLength == 0;
    }

    protected int getCurrentLineLength() {
        return this.currLength;
    }

    protected boolean isLineEmpty() {
        return this.isLineEmpty;
    }

    protected void setCanWrapLines(boolean bl) {
        this.canWrapLines = bl;
    }

    protected boolean getCanWrapLines() {
        return this.canWrapLines;
    }

    protected void setIndentSpace(int n) {
        this.indentSpace = n;
    }

    protected int getIndentSpace() {
        return this.indentSpace;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    protected void incrIndent() {
        if (this.offsetIndent > 0) {
            ++this.offsetIndent;
        } else if (++this.indentLevel * this.getIndentSpace() >= this.getLineLength()) {
            ++this.offsetIndent;
            --this.indentLevel;
        }
    }

    protected void decrIndent() {
        if (this.offsetIndent > 0) {
            --this.offsetIndent;
        } else {
            --this.indentLevel;
        }
    }

    protected int getIndentLevel() {
        return this.indentLevel;
    }

    protected void indent() throws IOException {
        int n;
        int n2 = this.getIndentLevel() * this.getIndentSpace();
        if (this.indentChars == null || n2 > this.indentChars.length) {
            this.indentChars = new char[n2];
            for (n = 0; n < n2; ++n) {
                this.indentChars[n] = 32;
            }
        }
        n = this.getCurrentLineLength();
        boolean bl = this.isLineEmpty();
        this.output(this.indentChars, 0, n2);
        if (bl && n == 0) {
            this.isLineEmpty = true;
        }
    }

    protected void write(char c) throws IOException {
        if (this.tempChars == null) {
            this.tempChars = new char[128];
        }
        this.tempChars[0] = c;
        this.write(this.tempChars, 0, 1);
    }

    protected void write(String string) throws IOException {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (this.tempChars == null || this.tempChars.length < n) {
            this.tempChars = new char[n];
        }
        string.getChars(0, n, this.tempChars, 0);
        this.write(this.tempChars, 0, n);
    }

    protected void writeLineSeparator() throws IOException {
        String string = this.getLineSeparator();
        int n = string.length();
        if (this.newlineChars == null || this.newlineChars.length < n) {
            this.newlineChars = new char[n];
        }
        string.getChars(0, n, this.newlineChars, 0);
        this.output(this.newlineChars, 0, n);
        this.setCurrentLineLength(0);
    }

    protected void write(char[] cArray, int n, int n2) throws IOException {
        if (!this.getCanWrapLines()) {
            int n3 = n;
            int n4 = n + n2;
            int n5 = this.indexOf(cArray, '\n', n, n4);
            while (n5 != -1) {
                if (n5 > n3) {
                    this.output(cArray, n3, n5 - n3);
                }
                this.writeLineSeparator();
                n3 = n5 + 1;
                n5 = this.indexOf(cArray, '\n', n3, n4);
            }
            if (n3 < n4) {
                this.output(cArray, n3, n4 - n3);
            }
        } else {
            int n6;
            int n7 = n;
            int n8 = n + n2;
            int n9 = this.getCurrentLineLength();
            if (n9 >= (n6 = this.getLineLength()) && !this.isLineEmpty()) {
                this.writeLineSeparator();
            }
            while (n7 < n8) {
                int n10 = this.indexOf(cArray, '\n', n7, n8);
                boolean bl = false;
                n9 = this.getCurrentLineLength();
                if (n10 != -1 && n9 + (n10 - n7) < n6) {
                    if (n10 > n7) {
                        this.output(cArray, n7, n10 - n7);
                    }
                    n7 = n10 + 1;
                    bl = true;
                } else if (n10 == -1 && n9 + (n8 - n7) < n6) {
                    if (n8 > n7) {
                        this.output(cArray, n7, n8 - n7);
                    }
                    n7 = n8;
                } else {
                    int n11;
                    int n12 = -1;
                    int n13 = Math.min(n8 - n7, n6 - n9 - 1);
                    for (n11 = 0; n11 < n13; ++n11) {
                        if (!Character.isWhitespace(cArray[n11 + n7])) continue;
                        n12 = n11;
                    }
                    if (n12 != -1) {
                        this.output(cArray, n7, (n12 += n7 + 1) - n7);
                        n7 = n12;
                    } else if (this.isLineEmpty()) {
                        n11 = Math.max(0, n13);
                        n13 = n8 - n7;
                        while (n11 < n13) {
                            if (Character.isWhitespace(cArray[n11 + n7])) {
                                n12 = n11;
                                break;
                            }
                            ++n11;
                        }
                        if (n12 == -1) {
                            this.output(cArray, n7, n8 - n7);
                            n12 = n8;
                        } else if (cArray[n12 += n7] == '\n') {
                            this.output(cArray, n7, n12++ - n7);
                        } else {
                            this.output(cArray, n7, ++n12 - n7);
                        }
                        n7 = n12;
                    }
                    bl = true;
                }
                if (!bl && n7 >= n8) continue;
                this.writeLineSeparator();
                if (n7 >= n8) continue;
                this.indent();
            }
        }
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.write(" " + e + "=" + attributeSet.getAttribute(e));
        }
    }

    protected void output(char[] cArray, int n, int n2) throws IOException {
        this.getWriter().write(cArray, n, n2);
        this.setCurrentLineLength(this.getCurrentLineLength() + n2);
    }

    private int indexOf(char[] cArray, char c, int n, int n2) {
        while (n < n2) {
            if (cArray[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

