/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDragGestureRecognizer;
import javax.swing.plaf.basic.BasicDropTargetListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.text.Position;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.VariableHeightLayoutCache;

public class BasicTreeUI
extends TreeUI {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    private Color hashColor;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected Dimension preferredMinSize;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected AbstractLayoutCache treeState;
    protected Hashtable drawingCache;
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    private int lastWidth;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    private int leadRow;
    private boolean ignoreLAChange;
    private boolean leftToRight;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener selectionModelPropertyChangeListener;
    private MouseListener mouseListener;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private ComponentListener componentListener;
    private CellEditorListener cellEditorListener;
    private TreeSelectionListener treeSelectionListener;
    private TreeModelListener treeModelListener;
    private TreeExpansionListener treeExpansionListener;
    private static final TreeDragGestureRecognizer defaultDragRecognizer = new TreeDragGestureRecognizer();
    private static DropTargetListener defaultDropTargetListener = null;
    private static final TransferHandler defaultTransferHandler = new TreeTransferHandler();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTreeUI();
    }

    protected Color getHashColor() {
        return this.hashColor;
    }

    protected void setHashColor(Color color) {
        this.hashColor = color;
    }

    public void setLeftChildIndent(int n) {
        this.leftChildIndent = n;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int n) {
        this.rightChildIndent = n;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    protected void setLargeModel(boolean bl) {
        if (this.getRowHeight() < 1) {
            bl = false;
        }
        if (this.largeModel != bl) {
            this.completeEditing();
            this.largeModel = bl;
            this.treeState = this.createLayoutCache();
            this.configureLayoutCache();
            this.updateLayoutCacheExpandedNodes();
            this.updateSize();
        }
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected void setRowHeight(int n) {
        this.completeEditing();
        if (this.treeState != null) {
            this.setLargeModel(this.tree.isLargeModel());
            this.treeState.setRowHeight(n);
            this.updateSize();
        }
    }

    protected int getRowHeight() {
        return this.tree == null ? -1 : this.tree.getRowHeight();
    }

    protected void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.completeEditing();
        this.updateRenderer();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected TreeCellRenderer getCellRenderer() {
        return this.currentCellRenderer;
    }

    protected void setModel(TreeModel treeModel) {
        this.completeEditing();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        this.treeModel = treeModel;
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if (this.treeState != null) {
            this.treeState.setModel(treeModel);
            this.updateLayoutCacheExpandedNodes();
            this.updateSize();
        }
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    protected void setRootVisible(boolean bl) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.setRootVisible(bl);
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean isRootVisible() {
        return this.tree != null ? this.tree.isRootVisible() : false;
    }

    protected void setShowsRootHandles(boolean bl) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean getShowsRootHandles() {
        return this.tree != null ? this.tree.getShowsRootHandles() : false;
    }

    protected void setCellEditor(TreeCellEditor treeCellEditor) {
        this.updateCellEditor();
    }

    protected TreeCellEditor getCellEditor() {
        return this.tree != null ? this.tree.getCellEditor() : null;
    }

    protected void setEditable(boolean bl) {
        this.updateCellEditor();
    }

    protected boolean isEditable() {
        return this.tree != null ? this.tree.isEditable() : false;
    }

    protected void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        this.completeEditing();
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeSelectionModel = treeSelectionModel;
        if (this.treeSelectionModel != null) {
            if (this.selectionModelPropertyChangeListener != null) {
                this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
            }
            if (this.treeSelectionListener != null) {
                this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
            }
            if (this.treeState != null) {
                this.treeState.setSelectionModel(this.treeSelectionModel);
            }
        } else if (this.treeState != null) {
            this.treeState.setSelectionModel(null);
        }
        if (this.tree != null) {
            this.tree.repaint();
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        if (jTree != null && this.treeState != null) {
            Insets insets = jTree.getInsets();
            Rectangle rectangle = this.treeState.getBounds(treePath, null);
            if (rectangle != null && insets != null) {
                rectangle.x += insets.left;
                rectangle.y += insets.top;
            }
            return rectangle;
        }
        return null;
    }

    public TreePath getPathForRow(JTree jTree, int n) {
        return this.treeState != null ? this.treeState.getPathForRow(n) : null;
    }

    public int getRowForPath(JTree jTree, TreePath treePath) {
        return this.treeState != null ? this.treeState.getRowForPath(treePath) : -1;
    }

    public int getRowCount(JTree jTree) {
        return this.treeState != null ? this.treeState.getRowCount() : 0;
    }

    public TreePath getClosestPathForLocation(JTree jTree, int n, int n2) {
        if (jTree != null && this.treeState != null) {
            Insets insets = jTree.getInsets();
            if (insets == null) {
                insets = EMPTY_INSETS;
            }
            return this.treeState.getPathClosestTo(n - insets.left, n2 - insets.top);
        }
        return null;
    }

    public boolean isEditing(JTree jTree) {
        return this.editingComponent != null;
    }

    public boolean stopEditing(JTree jTree) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    public void cancelEditing(JTree jTree) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    public void startEditingAtPath(JTree jTree, TreePath treePath) {
        jTree.scrollPathToVisible(treePath);
        if (treePath != null && jTree.isVisible(treePath)) {
            this.startEditing(treePath, null);
        }
    }

    public TreePath getEditingPath(JTree jTree) {
        return this.editingPath;
    }

    public void installUI(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("null component passed to BasicTreeUI.installUI()");
        }
        this.tree = (JTree)jComponent;
        this.prepareForUIInstall();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.installComponents();
        this.completeUIInstall();
    }

    protected void prepareForUIInstall() {
        this.drawingCache = new Hashtable(7);
        this.leftToRight = BasicGraphicsUtils.isLeftToRight(this.tree);
        this.lastWidth = this.tree.getWidth();
        this.stopEditingInCompleteEditing = true;
        this.lastSelectedRow = -1;
        this.leadRow = -1;
        this.preferredSize = new Dimension();
        this.tree.setRowHeight(UIManager.getInt("Tree.rowHeight"));
        Object object = UIManager.get("Tree.scrollsOnExpand");
        if (object != null) {
            this.tree.setScrollsOnExpand((Boolean)object);
        }
        this.largeModel = this.tree.isLargeModel();
        if (this.getRowHeight() <= 0) {
            this.largeModel = false;
        }
        this.setModel(this.tree.getModel());
    }

    protected void completeUIInstall() {
        this.setShowsRootHandles(this.tree.getShowsRootHandles());
        this.updateRenderer();
        this.updateDepthOffset();
        this.setSelectionModel(this.tree.getSelectionModel());
        this.treeState = this.createLayoutCache();
        this.configureLayoutCache();
        this.updateSize();
    }

    protected void installDefaults() {
        DropTarget dropTarget;
        if (this.tree.getBackground() == null || this.tree.getBackground() instanceof UIResource) {
            this.tree.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.getHashColor() == null || this.getHashColor() instanceof UIResource) {
            this.setHashColor(UIManager.getColor("Tree.hash"));
        }
        if (this.tree.getFont() == null || this.tree.getFont() instanceof UIResource) {
            this.tree.setFont(UIManager.getFont("Tree.font"));
        }
        this.setExpandedIcon((Icon)UIManager.get("Tree.expandedIcon"));
        this.setCollapsedIcon((Icon)UIManager.get("Tree.collapsedIcon"));
        this.setLeftChildIndent((Integer)UIManager.get("Tree.leftChildIndent"));
        this.setRightChildIndent((Integer)UIManager.get("Tree.rightChildIndent"));
        TransferHandler transferHandler = this.tree.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.tree.setTransferHandler(defaultTransferHandler);
        }
        if ((dropTarget = this.tree.getDropTarget()) instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TreeDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tree.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.tree.addMouseListener(defaultDragRecognizer);
        this.tree.addMouseMotionListener(defaultDragRecognizer);
        this.mouseListener = this.createMouseListener();
        if (this.mouseListener != null) {
            this.tree.addMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.tree.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tree.addFocusListener(this.focusListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.tree.addKeyListener(this.keyListener);
        }
        if ((this.treeExpansionListener = this.createTreeExpansionListener()) != null) {
            this.tree.addTreeExpansionListener(this.treeExpansionListener);
        }
        if ((this.treeModelListener = this.createTreeModelListener()) != null && this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if ((this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if ((this.treeSelectionListener = this.createTreeSelectionListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tree, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tree, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.tree, actionMap);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("Tree.ancestorInputMap");
        }
        if (n == 0) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)UIManager.get("Tree.focusInputMap");
            if (this.tree.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)UIManager.get("Tree.focusInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("selectPrevious", new TreeIncrementAction(-1, "selectPrevious", false, true));
        actionMapUIResource.put("selectPreviousChangeLead", new TreeIncrementAction(-1, "selectPreviousLead", false, false));
        actionMapUIResource.put("selectPreviousExtendSelection", new TreeIncrementAction(-1, "selectPreviousExtendSelection", true, true));
        actionMapUIResource.put("selectNext", new TreeIncrementAction(1, "selectNext", false, true));
        actionMapUIResource.put("selectNextChangeLead", new TreeIncrementAction(1, "selectNextLead", false, false));
        actionMapUIResource.put("selectNextExtendSelection", new TreeIncrementAction(1, "selectNextExtendSelection", true, true));
        actionMapUIResource.put("selectChild", new TreeTraverseAction(1, "selectChild", true));
        actionMapUIResource.put("selectChildChangeLead", new TreeTraverseAction(1, "selectChildLead", false));
        actionMapUIResource.put("selectParent", new TreeTraverseAction(-1, "selectParent", true));
        actionMapUIResource.put("selectParentChangeLead", new TreeTraverseAction(-1, "selectParentLead", false));
        actionMapUIResource.put("scrollUpChangeSelection", new TreePageAction(-1, "scrollUpChangeSelection", false, true));
        actionMapUIResource.put("scrollUpChangeLead", new TreePageAction(-1, "scrollUpChangeLead", false, false));
        actionMapUIResource.put("scrollUpExtendSelection", new TreePageAction(-1, "scrollUpExtendSelection", true, true));
        actionMapUIResource.put("scrollDownChangeSelection", new TreePageAction(1, "scrollDownChangeSelection", false, true));
        actionMapUIResource.put("scrollDownExtendSelection", new TreePageAction(1, "scrollDownExtendSelection", true, true));
        actionMapUIResource.put("scrollDownChangeLead", new TreePageAction(1, "scrollDownChangeLead", false, false));
        actionMapUIResource.put("selectFirst", new TreeHomeAction(-1, "selectFirst", false, true));
        actionMapUIResource.put("selectFirstChangeLead", new TreeHomeAction(-1, "selectFirst", false, false));
        actionMapUIResource.put("selectFirstExtendSelection", new TreeHomeAction(-1, "selectFirstExtendSelection", true, true));
        actionMapUIResource.put("selectLast", new TreeHomeAction(1, "selectLast", false, true));
        actionMapUIResource.put("selectLastChangeLead", new TreeHomeAction(1, "selectLast", false, false));
        actionMapUIResource.put("selectLastExtendSelection", new TreeHomeAction(1, "selectLastExtendSelection", true, true));
        actionMapUIResource.put("toggle", new TreeToggleAction("toggle"));
        actionMapUIResource.put("cancel", new TreeCancelEditingAction("cancel"));
        actionMapUIResource.put("startEditing", new TreeEditAction("startEditing"));
        actionMapUIResource.put("selectAll", new TreeSelectAllAction("selectAll", true));
        actionMapUIResource.put("clearSelection", new TreeSelectAllAction("clearSelection", false));
        actionMapUIResource.put("toggleSelectionPreserveAnchor", new TreeAddSelectionAction("toggleSelectionPreserveAnchor", false));
        actionMapUIResource.put("toggleSelection", new TreeAddSelectionAction("toggleSelection", true));
        actionMapUIResource.put("extendSelection", new TreeExtendSelectionAction("extendSelection"));
        actionMapUIResource.put("scrollLeft", new ScrollAction(this.tree, 0, -10));
        actionMapUIResource.put("scrollLeftExtendSelection", new TreeScrollLRAction(-1, "scrollLeftExtendSelection", true, true));
        actionMapUIResource.put("scrollRight", new ScrollAction(this.tree, 0, 10));
        actionMapUIResource.put("scrollRightExtendSelection", new TreeScrollLRAction(1, "scrollRightExtendSelection", true, true));
        actionMapUIResource.put("scrollRightChangeLead", new TreeScrollLRAction(1, "scrollRightChangeLead", false, false));
        actionMapUIResource.put("scrollLeftChangeLead", new TreeScrollLRAction(-1, "scrollLeftChangeLead", false, false));
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.tree.add(this.rendererPane);
        }
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return new SelectionModelPropertyChangeHandler();
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new TreeExpansionHandler();
    }

    protected AbstractLayoutCache createLayoutCache() {
        if (this.isLargeModel() && this.getRowHeight() > 0) {
            return new FixedHeightLayoutCache();
        }
        return new VariableHeightLayoutCache();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellEditor defaultTreeCellEditor = new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer);
            return defaultTreeCellEditor;
        }
        return new DefaultTreeCellEditor(this.tree, null);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    public void uninstallUI(JComponent jComponent) {
        this.completeEditing();
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void prepareForUIUninstall() {
    }

    protected void completeUIUninstall() {
        if (this.createdRenderer) {
            this.tree.setCellRenderer(null);
        }
        if (this.createdCellEditor) {
            this.tree.setCellEditor(null);
        }
        this.cellEditor = null;
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.mouseListener = null;
        this.focusListener = null;
        this.keyListener = null;
        this.setSelectionModel(null);
        this.treeState = null;
        this.drawingCache = null;
        this.selectionModelPropertyChangeListener = null;
        this.tree = null;
        this.treeModel = null;
        this.treeSelectionModel = null;
        this.treeSelectionListener = null;
        this.treeExpansionListener = null;
    }

    protected void uninstallDefaults() {
        if (this.tree.getTransferHandler() instanceof UIResource) {
            this.tree.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        DropTarget dropTarget;
        if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.tree.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.tree.removeMouseListener(defaultDragRecognizer);
        this.tree.removeMouseMotionListener(defaultDragRecognizer);
        if (this.mouseListener != null) {
            this.tree.removeMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.tree.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if (this.focusListener != null) {
            this.tree.removeFocusListener(this.focusListener);
        }
        if (this.keyListener != null) {
            this.tree.removeKeyListener(this.keyListener);
        }
        if (this.treeExpansionListener != null) {
            this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        }
        if ((dropTarget = this.tree.getDropTarget()) != null && defaultDropTargetListener != null && dropTarget instanceof UIResource) {
            dropTarget.removeDropTargetListener(defaultDropTargetListener);
        }
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tree, null);
        SwingUtilities.replaceUIInputMap(this.tree, 1, null);
        SwingUtilities.replaceUIInputMap(this.tree, 0, null);
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.tree.remove(this.rendererPane);
        }
    }

    private void redoTheLayout() {
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.tree != jComponent) {
            throw new InternalError("incorrect component");
        }
        if (this.treeState == null) {
            return;
        }
        int n = this.tree.getWidth();
        if (n != this.lastWidth) {
            this.lastWidth = n;
            if (!this.leftToRight) {
                this.redoTheLayout();
                this.updateSize();
            }
        }
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.tree.getInsets();
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration enumeration = this.treeState.getVisiblePathsFrom(treePath);
        int n2 = this.treeState.getRowForPath(treePath);
        int n3 = rectangle.y + rectangle.height;
        this.drawingCache.clear();
        if (treePath != null && enumeration != null) {
            TreePath treePath2 = treePath;
            for (treePath2 = treePath2.getParentPath(); treePath2 != null; treePath2 = treePath2.getParentPath()) {
                this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath2);
                this.drawingCache.put(treePath2, Boolean.TRUE);
            }
            boolean bl = false;
            Rectangle rectangle2 = new Rectangle();
            boolean bl2 = this.isRootVisible();
            while (!bl && enumeration.hasMoreElements()) {
                TreePath treePath3 = (TreePath)enumeration.nextElement();
                if (treePath3 != null) {
                    boolean bl3;
                    boolean bl4;
                    boolean bl5 = this.treeModel.isLeaf(treePath3.getLastPathComponent());
                    if (bl5) {
                        bl4 = false;
                        bl3 = false;
                    } else {
                        bl3 = this.treeState.getExpandedState(treePath3);
                        bl4 = this.tree.hasBeenExpanded(treePath3);
                    }
                    Rectangle rectangle3 = this.treeState.getBounds(treePath3, rectangle2);
                    if (rectangle3 == null) {
                        return;
                    }
                    rectangle3.x += insets.left;
                    rectangle3.y += insets.top;
                    treePath2 = treePath3.getParentPath();
                    if (treePath2 != null) {
                        if (this.drawingCache.get(treePath2) == null) {
                            this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath2);
                            this.drawingCache.put(treePath2, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle3, treePath3, n2, bl3, bl4, bl5);
                    } else if (bl2 && n2 == 0) {
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle3, treePath3, n2, bl3, bl4, bl5);
                    }
                    if (this.shouldPaintExpandControl(treePath3, n2, bl3, bl4, bl5)) {
                        this.paintExpandControl(graphics, rectangle, insets, rectangle3, treePath3, n2, bl3, bl4, bl5);
                    }
                    if (!this.leftToRight) {
                        rectangle3.x += 4;
                    }
                    this.paintRow(graphics, rectangle, insets, rectangle3, treePath3, n2, bl3, bl4, bl5);
                    if (rectangle3.y + rectangle3.height >= n3) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                ++n2;
            }
        }
        this.rendererPane.removeAll();
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        int n2 = treePath.getPathCount() - 1;
        if ((n2 == 0 || n2 == 1 && !this.isRootVisible()) && !this.getShowsRootHandles()) {
            return;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.x + (rectangle.width - 1);
        int n5 = rectangle.y;
        int n6 = rectangle.y + (rectangle.height - 1);
        int n7 = rectangle2.y + rectangle2.height / 2;
        if (this.leftToRight) {
            int n8 = rectangle2.x - this.getRightChildIndent();
            int n9 = rectangle2.x - this.getHorizontalLegBuffer();
            if (n7 >= n5 && n7 <= n6 && n9 >= n3 && n8 <= n4 && (n8 = Math.max(Math.max(insets.left, n8), n3)) != (n9 = Math.min(Math.max(insets.left, n9), n4))) {
                graphics.setColor(this.getHashColor());
                this.paintHorizontalLine(graphics, this.tree, n7, n8, n9);
            }
        } else {
            int n10 = rectangle2.x + rectangle2.width + this.getRightChildIndent();
            int n11 = rectangle2.x + rectangle2.width + this.getHorizontalLegBuffer() - 1;
            if (n7 >= n5 && n7 <= n6 && n10 >= n3 && n11 <= n4) {
                n10 = Math.min(n10, n4);
                n11 = Math.max(n11, n3);
                graphics.setColor(this.getHashColor());
                this.paintHorizontalLine(graphics, this.tree, n7, n11, n10);
            }
        }
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        int n = treePath.getPathCount() - 1;
        if (n == 0 && !this.getShowsRootHandles() && !this.isRootVisible()) {
            return;
        }
        int n2 = this.leftToRight ? (n + 1 + this.depthOffset) * this.totalChildIndent - this.getRightChildIndent() + insets.left : this.lastWidth - (n + this.depthOffset) * this.totalChildIndent - 9;
        int n3 = rectangle.x;
        int n4 = rectangle.x + (rectangle.width - 1);
        if (n2 >= n3 && n2 <= n4) {
            int n5;
            Object object;
            TreeModel treeModel;
            int n6 = rectangle.y;
            int n7 = rectangle.y + rectangle.height;
            Rectangle rectangle2 = this.getPathBounds(this.tree, treePath);
            Rectangle rectangle3 = this.getPathBounds(this.tree, this.getLastChildPath(treePath));
            if (rectangle3 == null) {
                return;
            }
            int n8 = rectangle2 == null ? Math.max(insets.top + this.getVerticalLegBuffer(), n6) : Math.max(rectangle2.y + rectangle2.height + this.getVerticalLegBuffer(), n6);
            if (n == 0 && !this.isRootVisible() && (treeModel = this.getModel()) != null && treeModel.getChildCount(object = treeModel.getRoot()) > 0 && (rectangle2 = this.getPathBounds(this.tree, treePath.pathByAddingChild(treeModel.getChild(object, 0)))) != null) {
                n8 = Math.max(insets.top + this.getVerticalLegBuffer(), rectangle2.y + rectangle2.height / 2);
            }
            if (n8 <= (n5 = Math.min(rectangle3.y + rectangle3.height / 2, n7))) {
                graphics.setColor(this.getHashColor());
                this.paintVerticalLine(graphics, this.tree, n2, n8, n5);
            }
        }
    }

    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object = treePath.getLastPathComponent();
        if (!(bl3 || bl2 && this.treeModel.getChildCount(object) <= 0)) {
            int n2 = this.leftToRight ? rectangle2.x - (this.getRightChildIndent() - 1) : rectangle2.x + rectangle2.width + this.getRightChildIndent();
            int n3 = rectangle2.y + rectangle2.height / 2;
            if (bl) {
                Icon icon = this.getExpandedIcon();
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n2, n3);
                }
            } else {
                Icon icon = this.getCollapsedIcon();
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n2, n3);
                }
            }
        }
    }

    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.editingComponent != null && this.editingRow == n) {
            return;
        }
        int n2 = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, treePath.getLastPathComponent(), this.tree.isRowSelected(n), bl, bl3, n, n2 == n);
        this.rendererPane.paintComponent(graphics, component, this.tree, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
    }

    protected boolean shouldPaintExpandControl(TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            return false;
        }
        int n2 = treePath.getPathCount() - 1;
        return n2 != 0 && (n2 != 1 || this.isRootVisible()) || this.getShowsRootHandles();
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.drawLine(n, n2, n, n3);
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.drawLine(n2, n, n3, n);
    }

    protected int getVerticalLegBuffer() {
        return 0;
    }

    protected int getHorizontalLegBuffer() {
        return 0;
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        icon.paintIcon(component, graphics, n - icon.getIconWidth() / 2, n2 - icon.getIconHeight() / 2);
    }

    protected void drawDashedHorizontalLine(Graphics graphics, int n, int n2, int n3) {
        n2 += n2 % 2;
        for (int i = n2; i <= n3; i += 2) {
            graphics.drawLine(i, n, i, n);
        }
    }

    protected void drawDashedVerticalLine(Graphics graphics, int n, int n2, int n3) {
        n2 += n2 % 2;
        for (int i = n2; i <= n3; i += 2) {
            graphics.drawLine(n, i, n, i);
        }
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    protected void updateExpandedDescendants(TreePath treePath) {
        this.completeEditing();
        if (this.treeState != null) {
            this.treeState.setExpandedState(treePath, true);
            Enumeration enumeration = this.tree.getExpandedDescendants(treePath);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    treePath = (TreePath)enumeration.nextElement();
                    this.treeState.setExpandedState(treePath, true);
                }
            }
            this.updateLeadRow();
            this.updateSize();
        }
    }

    protected TreePath getLastChildPath(TreePath treePath) {
        int n;
        if (this.treeModel != null && (n = this.treeModel.getChildCount(treePath.getLastPathComponent())) > 0) {
            return treePath.pathByAddingChild(this.treeModel.getChild(treePath.getLastPathComponent(), n - 1));
        }
        return null;
    }

    protected void updateDepthOffset() {
        this.depthOffset = this.isRootVisible() ? (this.getShowsRootHandles() ? 1 : 0) : (!this.getShowsRootHandles() ? -1 : 0);
    }

    protected void updateCellEditor() {
        TreeCellEditor treeCellEditor;
        this.completeEditing();
        if (this.tree == null) {
            treeCellEditor = null;
        } else if (this.tree.isEditable()) {
            treeCellEditor = this.tree.getCellEditor();
            if (treeCellEditor == null && (treeCellEditor = this.createDefaultCellEditor()) != null) {
                this.tree.setCellEditor(treeCellEditor);
                this.createdCellEditor = true;
            }
        } else {
            treeCellEditor = null;
        }
        if (treeCellEditor != this.cellEditor) {
            if (this.cellEditor != null && this.cellEditorListener != null) {
                this.cellEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = treeCellEditor;
            if (this.cellEditorListener == null) {
                this.cellEditorListener = this.createCellEditorListener();
            }
            if (treeCellEditor != null && this.cellEditorListener != null) {
                treeCellEditor.addCellEditorListener(this.cellEditorListener);
            }
            this.createdCellEditor = false;
        }
    }

    protected void updateRenderer() {
        if (this.tree != null) {
            TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
            if (treeCellRenderer == null) {
                this.tree.setCellRenderer(this.createDefaultCellRenderer());
                this.createdRenderer = true;
            } else {
                this.createdRenderer = false;
                this.currentCellRenderer = treeCellRenderer;
                if (this.createdCellEditor) {
                    this.tree.setCellEditor(null);
                }
            }
        } else {
            this.createdRenderer = false;
            this.currentCellRenderer = null;
        }
        this.updateCellEditor();
    }

    protected void configureLayoutCache() {
        if (this.treeState != null && this.tree != null) {
            if (this.nodeDimensions == null) {
                this.nodeDimensions = this.createNodeDimensions();
            }
            this.treeState.setNodeDimensions(this.nodeDimensions);
            this.treeState.setRootVisible(this.tree.isRootVisible());
            this.treeState.setRowHeight(this.tree.getRowHeight());
            this.treeState.setSelectionModel(this.getSelectionModel());
            if (this.treeState.getModel() != this.tree.getModel()) {
                this.treeState.setModel(this.tree.getModel());
            }
            this.updateLayoutCacheExpandedNodes();
            if (this.isLargeModel()) {
                if (this.componentListener == null) {
                    this.componentListener = this.createComponentListener();
                    if (this.componentListener != null) {
                        this.tree.addComponentListener(this.componentListener);
                    }
                }
            } else if (this.componentListener != null) {
                this.tree.removeComponentListener(this.componentListener);
                this.componentListener = null;
            }
        } else if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
            this.componentListener = null;
        }
    }

    protected void updateSize() {
        this.validCachedPreferredSize = false;
        this.tree.treeDidChange();
    }

    protected void updateCachedPreferredSize() {
        if (this.treeState != null) {
            Insets insets = this.tree.getInsets();
            if (this.isLargeModel()) {
                Rectangle rectangle = this.tree.getVisibleRect();
                if (insets != null) {
                    rectangle.x -= insets.left;
                    rectangle.y -= insets.top;
                }
                this.preferredSize.width = this.leftToRight ? this.treeState.getPreferredWidth(rectangle) : (this.getRowCount(this.tree) == 0 ? 0 : this.lastWidth - this.getMinX(rectangle));
            } else if (this.leftToRight) {
                this.preferredSize.width = this.treeState.getPreferredWidth(null);
            } else {
                Rectangle rectangle = null;
                int n = this.tree.getRowCount();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    rectangle = this.treeState.getBounds(this.treeState.getPathForRow(i), rectangle);
                    if (rectangle == null) continue;
                    n2 = Math.max(this.lastWidth - rectangle.x, n2);
                }
                this.preferredSize.width = n2;
            }
            this.preferredSize.height = this.treeState.getPreferredHeight();
            if (insets != null) {
                this.preferredSize.width += insets.left + insets.right;
                this.preferredSize.height += insets.top + insets.bottom;
            }
        }
        this.validCachedPreferredSize = true;
    }

    private int getMinX(Rectangle rectangle) {
        int n;
        TreePath treePath;
        if (rectangle == null) {
            treePath = this.getPathForRow(this.tree, 0);
            n = Integer.MAX_VALUE;
        } else {
            treePath = this.treeState.getPathClosestTo(rectangle.x, rectangle.y);
            n = rectangle.height + rectangle.y;
        }
        Enumeration enumeration = this.treeState.getVisiblePathsFrom(treePath);
        int n2 = 0;
        if (enumeration != null && enumeration.hasMoreElements()) {
            Rectangle rectangle2 = this.treeState.getBounds((TreePath)enumeration.nextElement(), null);
            if (rectangle2 != null) {
                n2 = rectangle2.x + rectangle2.width;
                if (rectangle2.y >= n) {
                    return n2;
                }
            }
            while (rectangle2 != null && enumeration.hasMoreElements()) {
                rectangle2 = this.treeState.getBounds((TreePath)enumeration.nextElement(), rectangle2);
                if (rectangle2 != null && rectangle2.y < n) {
                    n2 = Math.min(n2, rectangle2.x);
                    continue;
                }
                rectangle2 = null;
            }
            return n2;
        }
        return n2;
    }

    protected void pathWasExpanded(TreePath treePath) {
        if (this.tree != null) {
            this.tree.fireTreeExpanded(treePath);
        }
    }

    protected void pathWasCollapsed(TreePath treePath) {
        if (this.tree != null) {
            this.tree.fireTreeCollapsed(treePath);
        }
    }

    protected void ensureRowsAreVisible(int n, int n2) {
        if (this.tree != null && n >= 0 && n2 < this.getRowCount(this.tree)) {
            if (n == n2) {
                Rectangle rectangle = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n));
                if (rectangle != null) {
                    this.tree.scrollRectToVisible(rectangle);
                }
            } else {
                Rectangle rectangle = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n));
                Rectangle rectangle2 = this.tree.getVisibleRect();
                Rectangle rectangle3 = rectangle;
                int n3 = rectangle.y;
                int n4 = n3 + rectangle2.height;
                for (int i = n + 1; i <= n2; ++i) {
                    rectangle3 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i));
                    if (rectangle3.y + rectangle3.height <= n4) continue;
                    i = n2;
                }
                this.tree.scrollRectToVisible(new Rectangle(rectangle2.x, n3, 1, rectangle3.y + rectangle3.height - n3));
            }
        }
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent, true);
    }

    public Dimension getPreferredSize(JComponent jComponent, boolean bl) {
        Dimension dimension = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.tree != null) {
            if (dimension != null) {
                return new Dimension(Math.max(dimension.width, this.preferredSize.width), Math.max(dimension.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (dimension != null) {
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.tree != null) {
            return this.getPreferredSize(this.tree);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component component = this.editingComponent;
            TreePath treePath = this.editingPath;
            TreeCellEditor treeCellEditor = this.cellEditor;
            Object object = treeCellEditor.getCellEditorValue();
            Rectangle rectangle = this.getPathBounds(this.tree, this.editingPath);
            boolean bl4 = this.tree != null && (this.tree.hasFocus() || SwingUtilities.findFocusOwner(this.editingComponent) != null);
            this.editingComponent = null;
            this.editingPath = null;
            if (bl) {
                treeCellEditor.stopCellEditing();
            } else if (bl2) {
                treeCellEditor.cancelCellEditing();
            }
            this.tree.remove(component);
            if (this.editorHasDifferentSize) {
                this.treeState.invalidatePathBounds(treePath);
                this.updateSize();
            } else {
                rectangle.x = 0;
                rectangle.width = this.tree.getSize().width;
                this.tree.repaint(rectangle);
            }
            if (bl4) {
                this.tree.requestFocus();
            }
            if (bl3) {
                this.treeModel.valueForPathChanged(treePath, object);
            }
        }
    }

    protected boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.stopEditing(this.tree)) {
            return false;
        }
        this.completeEditing();
        if (this.cellEditor != null && this.tree.isPathEditable(treePath)) {
            int n = this.getRowForPath(this.tree, treePath);
            if (this.cellEditor.isCellEditable(mouseEvent)) {
                this.editingComponent = this.cellEditor.getTreeCellEditorComponent(this.tree, treePath.getLastPathComponent(), this.tree.isPathSelected(treePath), this.tree.isExpanded(treePath), this.treeModel.isLeaf(treePath.getLastPathComponent()), n);
                Rectangle rectangle = this.getPathBounds(this.tree, treePath);
                this.editingRow = n;
                Dimension dimension = this.editingComponent.getPreferredSize();
                if (dimension.height != rectangle.height && this.getRowHeight() > 0) {
                    dimension.height = this.getRowHeight();
                }
                if (dimension.width != rectangle.width || dimension.height != rectangle.height) {
                    this.editorHasDifferentSize = true;
                    this.treeState.invalidatePathBounds(treePath);
                    this.updateSize();
                } else {
                    this.editorHasDifferentSize = false;
                }
                this.tree.add(this.editingComponent);
                this.editingComponent.setBounds(rectangle.x, rectangle.y, dimension.width, dimension.height);
                this.editingPath = treePath;
                this.editingComponent.validate();
                Rectangle rectangle2 = this.tree.getVisibleRect();
                this.tree.paintImmediately(rectangle.x, rectangle.y, rectangle2.width + rectangle2.x - rectangle.x, dimension.height);
                if (this.cellEditor.shouldSelectCell(mouseEvent)) {
                    this.stopEditingInCompleteEditing = false;
                    try {
                        this.tree.setSelectionRow(n);
                    }
                    catch (Exception exception) {
                        System.err.println("Editing exception: " + exception);
                    }
                    this.stopEditingInCompleteEditing = true;
                }
                BasicLookAndFeel.compositeRequestFocus(this.editingComponent);
                if (mouseEvent != null && mouseEvent instanceof MouseEvent) {
                    Point point = SwingUtilities.convertPoint(this.tree, new Point(mouseEvent.getX(), mouseEvent.getY()), this.editingComponent);
                    Component component = SwingUtilities.getDeepestComponentAt(this.editingComponent, point.x, point.y);
                    if (component != null) {
                        new MouseInputHandler(this.tree, component, mouseEvent);
                    }
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    protected void checkForClickInExpandControl(TreePath treePath, int n, int n2) {
        if (this.isLocationInExpandControl(treePath, n, n2)) {
            this.handleExpandControlClick(treePath, n, n2);
        }
    }

    protected boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        if (treePath != null && !this.treeModel.isLeaf(treePath.getLastPathComponent())) {
            int n3;
            Insets insets = this.tree.getInsets();
            int n4 = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() : 8;
            int n5 = n3 = insets != null ? insets.left : 0;
            n3 = this.leftToRight ? (n3 += (treePath.getPathCount() + this.depthOffset - 2) * this.totalChildIndent + this.getLeftChildIndent() - n4 / 2) : (n3 += this.lastWidth - 1 - (treePath.getPathCount() - 2 + this.depthOffset) * this.totalChildIndent - this.getLeftChildIndent() - n4 / 2);
            int n6 = n3 + n4;
            return n >= n3 && n <= n6;
        }
        return false;
    }

    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        this.toggleExpandState(treePath);
    }

    protected void toggleExpandState(TreePath treePath) {
        if (!this.tree.isExpanded(treePath)) {
            int n = this.getRowForPath(this.tree, treePath);
            this.tree.expandPath(treePath);
            this.updateSize();
            if (n != -1) {
                if (this.tree.getScrollsOnExpand()) {
                    this.ensureRowsAreVisible(n, n + this.treeState.getVisibleChildCount(treePath));
                } else {
                    this.ensureRowsAreVisible(n, n);
                }
            }
        } else {
            this.tree.collapsePath(treePath);
            this.updateSize();
        }
    }

    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isControlDown();
    }

    protected boolean isMultiSelectEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isShiftDown();
    }

    protected boolean isToggleEvent(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return false;
        }
        int n = this.tree.getToggleClickCount();
        if (n <= 0) {
            return false;
        }
        return mouseEvent.getClickCount() == n;
    }

    protected void selectPathForEvent(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isToggleSelectionEvent(mouseEvent)) {
            if (this.tree.isPathSelected(treePath)) {
                this.tree.removeSelectionPath(treePath);
            } else {
                this.tree.addSelectionPath(treePath);
            }
            this.lastSelectedRow = this.getRowForPath(this.tree, treePath);
            this.setAnchorSelectionPath(treePath);
            this.setLeadSelectionPath(treePath);
        } else if (this.isMultiSelectEvent(mouseEvent)) {
            int n;
            TreePath treePath2 = this.getAnchorSelectionPath();
            int n2 = n = treePath2 == null ? -1 : this.getRowForPath(this.tree, treePath2);
            if (n == -1 || this.tree.getSelectionModel().getSelectionMode() == 1) {
                this.tree.setSelectionPath(treePath);
            } else {
                int n3 = this.getRowForPath(this.tree, treePath);
                TreePath treePath3 = treePath2;
                if (n3 < n) {
                    this.tree.setSelectionInterval(n3, n);
                } else {
                    this.tree.setSelectionInterval(n, n3);
                }
                this.lastSelectedRow = n3;
                this.setAnchorSelectionPath(treePath3);
                this.setLeadSelectionPath(treePath);
            }
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.tree.setSelectionPath(treePath);
            if (this.isToggleEvent(mouseEvent)) {
                this.toggleExpandState(treePath);
            }
        }
    }

    protected boolean isLeaf(int n) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath != null) {
            return this.treeModel.isLeaf(treePath.getLastPathComponent());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnchorSelectionPath(TreePath treePath) {
        this.ignoreLAChange = true;
        try {
            this.tree.setAnchorSelectionPath(treePath);
        }
        finally {
            this.ignoreLAChange = false;
        }
    }

    private TreePath getAnchorSelectionPath() {
        return this.tree.getAnchorSelectionPath();
    }

    private void setLeadSelectionPath(TreePath treePath) {
        this.setLeadSelectionPath(treePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLeadSelectionPath(TreePath treePath, boolean bl) {
        Rectangle rectangle = bl ? this.getPathBounds(this.tree, this.getLeadSelectionPath()) : null;
        this.ignoreLAChange = true;
        try {
            this.tree.setLeadSelectionPath(treePath);
        }
        finally {
            this.ignoreLAChange = false;
        }
        this.leadRow = this.getRowForPath(this.tree, treePath);
        if (bl) {
            if (rectangle != null) {
                this.tree.repaint(rectangle);
            }
            if ((rectangle = this.getPathBounds(this.tree, treePath)) != null) {
                this.tree.repaint(rectangle);
            }
        }
    }

    private TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    private void updateLeadRow() {
        this.leadRow = this.getRowForPath(this.tree, this.getLeadSelectionPath());
    }

    private int getLeadSelectionRow() {
        return this.leadRow;
    }

    private void extendSelection(TreePath treePath) {
        TreePath treePath2 = this.getAnchorSelectionPath();
        int n = treePath2 == null ? -1 : this.getRowForPath(this.tree, treePath2);
        int n2 = this.getRowForPath(this.tree, treePath);
        if (n == -1) {
            this.tree.setSelectionRow(n2);
        } else {
            if (n < n2) {
                this.tree.setSelectionInterval(n, n2);
            } else {
                this.tree.setSelectionInterval(n2, n);
            }
            this.setAnchorSelectionPath(treePath2);
            this.setLeadSelectionPath(treePath);
        }
    }

    private void repaintPath(TreePath treePath) {
        Rectangle rectangle;
        if (treePath != null && (rectangle = this.getPathBounds(this.tree, treePath)) != null) {
            this.tree.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    static class TreeTransferHandler
    extends TransferHandler
    implements UIResource,
    Comparator {
        private JTree tree;

        TreeTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTree) {
                this.tree = (JTree)jComponent;
                TreePath[] treePathArray = this.tree.getSelectionPaths();
                if (treePathArray == null || treePathArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<ul>\n");
                TreeModel treeModel = this.tree.getModel();
                Object var6_6 = null;
                TreePath[] treePathArray2 = this.getDisplayOrderPaths(treePathArray);
                for (int i = 0; i < treePathArray2.length; ++i) {
                    TreePath treePath = treePathArray2[i];
                    Object object = treePath.getLastPathComponent();
                    boolean bl = treeModel.isLeaf(object);
                    String string = this.getDisplayString(treePath, true, bl);
                    stringBuffer.append(string + "\n");
                    stringBuffer2.append("  <li>" + string + "\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</ul>\n</body>\n</html>");
                this.tree = null;
                return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        public int compare(Object object, Object object2) {
            int n = this.tree.getRowForPath((TreePath)object);
            int n2 = this.tree.getRowForPath((TreePath)object2);
            return n - n2;
        }

        String getDisplayString(TreePath treePath, boolean bl, boolean bl2) {
            int n = this.tree.getRowForPath(treePath);
            boolean bl3 = this.tree.getLeadSelectionRow() == n;
            Object object = treePath.getLastPathComponent();
            return this.tree.convertValueToText(object, bl, this.tree.isExpanded(n), bl2, n, bl3);
        }

        TreePath[] getDisplayOrderPaths(TreePath[] treePathArray) {
            int n;
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            for (n = 0; n < treePathArray.length; ++n) {
                arrayList.add(treePathArray[n]);
            }
            Collections.sort(arrayList, this);
            n = arrayList.size();
            TreePath[] treePathArray2 = new TreePath[n];
            for (int i = 0; i < n; ++i) {
                treePathArray2[i] = (TreePath)arrayList.get(i);
            }
            return treePathArray2;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    static class TreeDropTargetListener
    extends BasicDropTargetListener {
        private int[] selectedIndices;

        TreeDropTargetListener() {
        }

        protected void saveComponentState(JComponent jComponent) {
            JTree jTree = (JTree)jComponent;
            this.selectedIndices = jTree.getSelectionRows();
        }

        protected void restoreComponentState(JComponent jComponent) {
            JTree jTree = (JTree)jComponent;
            jTree.setSelectionRows(this.selectedIndices);
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JTree jTree = (JTree)jComponent;
            BasicTreeUI basicTreeUI = (BasicTreeUI)jTree.getUI();
            TreePath treePath = basicTreeUI.getClosestPathForLocation(jTree, point.x, point.y);
            if (treePath != null) {
                jTree.setSelectionPath(treePath);
            }
        }
    }

    static class TreeDragGestureRecognizer
    extends BasicDragGestureRecognizer {
        TreeDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            TreeUI treeUI;
            TreePath treePath;
            JTree jTree;
            return super.isDragPossible(mouseEvent) && (jTree = (JTree)this.getComponent(mouseEvent)).getDragEnabled() && (treePath = (treeUI = jTree.getUI()).getClosestPathForLocation(jTree, mouseEvent.getX(), mouseEvent.getY())) != null && jTree.isPathSelected(treePath);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component component, Component component2, MouseEvent mouseEvent) {
            this.source = component;
            this.destination = component2;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            component2.dispatchEvent(SwingUtilities.convertMouseEvent(component, mouseEvent, component2));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
            this.removeFromSource();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.destination = null;
            this.source = null;
        }
    }

    private class TreeExtendSelectionAction
    extends AbstractAction {
        public TreeExtendSelectionAction(String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree) > 0 && (n = BasicTreeUI.this.getLeadSelectionRow()) != -1) {
                TreePath treePath = BasicTreeUI.this.getLeadSelectionPath();
                TreePath treePath2 = BasicTreeUI.this.getAnchorSelectionPath();
                int n2 = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath2);
                if (n2 == -1) {
                    n2 = 0;
                }
                BasicTreeUI.this.tree.setSelectionInterval(n2, n);
                BasicTreeUI.this.setLeadSelectionPath(treePath);
                BasicTreeUI.this.setAnchorSelectionPath(treePath2);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeAddSelectionAction
    extends AbstractAction {
        private boolean changeAnchor;

        public TreeAddSelectionAction(String string, boolean bl) {
            this.changeAnchor = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree);
            if (BasicTreeUI.this.tree != null && n > 0) {
                int n2 = BasicTreeUI.this.getLeadSelectionRow();
                TreePath treePath = BasicTreeUI.this.getAnchorSelectionPath();
                TreePath treePath2 = BasicTreeUI.this.getLeadSelectionPath();
                if (n2 == -1) {
                    n2 = 0;
                }
                if (!this.changeAnchor) {
                    if (BasicTreeUI.this.tree.isRowSelected(n2)) {
                        BasicTreeUI.this.tree.removeSelectionRow(n2);
                        BasicTreeUI.this.setLeadSelectionPath(treePath2);
                        BasicTreeUI.this.setAnchorSelectionPath(treePath2);
                    } else {
                        BasicTreeUI.this.tree.addSelectionRow(n2);
                    }
                } else {
                    BasicTreeUI.this.tree.setSelectionRow(n2);
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeSelectAllAction
    extends AbstractAction {
        private boolean selectAll;

        public TreeSelectAllAction(String string, boolean bl) {
            this.selectAll = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree);
            if (BasicTreeUI.this.tree != null && n > 0) {
                if (this.selectAll) {
                    TreePath treePath = BasicTreeUI.this.getLeadSelectionPath();
                    TreePath treePath2 = BasicTreeUI.this.getAnchorSelectionPath();
                    if (treePath != null && !BasicTreeUI.this.tree.isVisible(treePath)) {
                        treePath = null;
                    }
                    BasicTreeUI.this.tree.setSelectionInterval(0, n - 1);
                    if (treePath != null) {
                        BasicTreeUI.this.setLeadSelectionPath(treePath);
                    }
                    if (treePath2 != null && BasicTreeUI.this.tree.isVisible(treePath2)) {
                        BasicTreeUI.this.setAnchorSelectionPath(treePath2);
                    } else if (treePath != null) {
                        BasicTreeUI.this.setAnchorSelectionPath(treePath);
                    }
                } else {
                    TreePath treePath = BasicTreeUI.this.getLeadSelectionPath();
                    TreePath treePath3 = BasicTreeUI.this.getAnchorSelectionPath();
                    BasicTreeUI.this.tree.clearSelection();
                    BasicTreeUI.this.setAnchorSelectionPath(treePath3);
                    BasicTreeUI.this.setLeadSelectionPath(treePath);
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeEditAction
    extends AbstractAction {
        public TreeEditAction(String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled()) {
                int n;
                TreePath treePath = BasicTreeUI.this.getLeadSelectionPath();
                int n2 = n = treePath != null ? BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath) : -1;
                if (n != -1) {
                    BasicTreeUI.this.tree.startEditingAtPath(treePath);
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        public TreeCancelEditingAction(String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                BasicTreeUI.this.tree.cancelEditing();
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled() && BasicTreeUI.this.isEditing(BasicTreeUI.this.tree);
        }
    }

    private static class ScrollAction
    extends AbstractAction {
        private JComponent component;
        private int direction;
        private int amount;

        public ScrollAction(JComponent jComponent, int n, int n2) {
            this.component = jComponent;
            this.direction = n;
            this.amount = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Rectangle rectangle = this.component.getVisibleRect();
            Dimension dimension = this.component.getSize();
            if (this.direction == 0) {
                rectangle.x += this.amount;
                rectangle.x = Math.max(0, rectangle.x);
                rectangle.x = Math.min(Math.max(0, dimension.width - rectangle.width), rectangle.x);
            } else {
                rectangle.y += this.amount;
                rectangle.y = Math.max(0, rectangle.y);
                rectangle.y = Math.min(Math.max(0, dimension.width - rectangle.height), rectangle.y);
            }
            this.component.scrollRectToVisible(rectangle);
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        public TreeToggleAction(String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && (n = BasicTreeUI.this.getLeadSelectionRow()) != -1 && !BasicTreeUI.this.isLeaf(n)) {
                TreePath treePath = BasicTreeUI.this.getAnchorSelectionPath();
                TreePath treePath2 = BasicTreeUI.this.getLeadSelectionPath();
                BasicTreeUI.this.toggleExpandState(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n));
                BasicTreeUI.this.setAnchorSelectionPath(treePath);
                BasicTreeUI.this.setLeadSelectionPath(treePath2);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeHomeAction(int n, String string) {
            this(n, string, false, true);
        }

        private TreeHomeAction(int n, String string, boolean bl, boolean bl2) {
            this.direction = n;
            this.changeSelection = bl2;
            this.addToSelection = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree);
            if (BasicTreeUI.this.tree != null && n > 0) {
                if (this.direction == -1) {
                    BasicTreeUI.this.ensureRowsAreVisible(0, 0);
                    if (this.addToSelection) {
                        int n2;
                        TreePath treePath = BasicTreeUI.this.getAnchorSelectionPath();
                        int n3 = n2 = treePath == null ? -1 : BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath);
                        if (n2 == -1) {
                            BasicTreeUI.this.tree.setSelectionInterval(0, 0);
                        } else {
                            BasicTreeUI.this.tree.setSelectionInterval(0, n2);
                            BasicTreeUI.this.setAnchorSelectionPath(treePath);
                            BasicTreeUI.this.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, 0));
                        }
                    } else if (this.changeSelection) {
                        BasicTreeUI.this.tree.setSelectionInterval(0, 0);
                    } else {
                        BasicTreeUI.this.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, 0), true);
                    }
                } else {
                    BasicTreeUI.this.ensureRowsAreVisible(n - 1, n - 1);
                    if (this.addToSelection) {
                        int n4;
                        TreePath treePath = BasicTreeUI.this.getAnchorSelectionPath();
                        int n5 = n4 = treePath == null ? -1 : BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath);
                        if (n4 == -1) {
                            BasicTreeUI.this.tree.setSelectionInterval(n - 1, n - 1);
                        } else {
                            BasicTreeUI.this.tree.setSelectionInterval(n4, n - 1);
                            BasicTreeUI.this.setAnchorSelectionPath(treePath);
                            BasicTreeUI.this.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n - 1));
                        }
                    } else if (this.changeSelection) {
                        BasicTreeUI.this.tree.setSelectionInterval(n - 1, n - 1);
                    } else {
                        BasicTreeUI.this.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n - 1), true);
                    }
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeIncrementAction(int n, String string) {
            this(n, string, false, true);
        }

        private TreeIncrementAction(int n, String string, boolean bl, boolean bl2) {
            this.direction = n;
            this.addToSelection = bl;
            this.changeSelection = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.treeSelectionModel != null && (n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree)) > 0) {
                int n2 = BasicTreeUI.this.getLeadSelectionRow();
                int n3 = n2 == -1 ? (this.direction == 1 ? 0 : n - 1) : Math.min(n - 1, Math.max(0, n2 + this.direction));
                if (this.addToSelection && BasicTreeUI.this.treeSelectionModel.getSelectionMode() != 1) {
                    BasicTreeUI.this.extendSelection(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n3));
                } else if (this.changeSelection) {
                    BasicTreeUI.this.tree.setSelectionInterval(n3, n3);
                } else {
                    BasicTreeUI.this.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n3), true);
                }
                BasicTreeUI.this.ensureRowsAreVisible(n3, n3);
                BasicTreeUI.this.lastSelectedRow = n3;
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeScrollLRAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        TreeScrollLRAction(int n, String string, boolean bl, boolean bl2) {
            this.direction = n;
            this.addToSelection = bl;
            this.changeSelection = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && (n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree)) > 0 && BasicTreeUI.this.treeSelectionModel != null) {
                TreePath treePath;
                Rectangle rectangle = BasicTreeUI.this.tree.getVisibleRect();
                if (this.direction == -1) {
                    treePath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, rectangle.x, rectangle.y);
                    rectangle.x = Math.max(0, rectangle.x - rectangle.width);
                } else {
                    rectangle.x = Math.min(Math.max(0, BasicTreeUI.this.tree.getWidth() - rectangle.width), rectangle.x + rectangle.width);
                    treePath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, rectangle.x, rectangle.y + rectangle.height);
                }
                BasicTreeUI.this.tree.scrollRectToVisible(rectangle);
                if (this.addToSelection) {
                    BasicTreeUI.this.extendSelection(treePath);
                } else if (this.changeSelection) {
                    BasicTreeUI.this.tree.setSelectionPath(treePath);
                } else {
                    BasicTreeUI.this.setLeadSelectionPath(treePath, true);
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreePageAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreePageAction(int n, String string) {
            this(n, string, false, true);
        }

        private TreePageAction(int n, String string, boolean bl, boolean bl2) {
            this.direction = n;
            this.addToSelection = bl;
            this.changeSelection = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && (n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree)) > 0 && BasicTreeUI.this.treeSelectionModel != null) {
                TreePath treePath;
                Dimension dimension = BasicTreeUI.this.tree.getSize();
                TreePath treePath2 = BasicTreeUI.this.getLeadSelectionPath();
                Rectangle rectangle = BasicTreeUI.this.tree.getVisibleRect();
                if (this.direction == -1) {
                    treePath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, rectangle.x, rectangle.y);
                    if (treePath.equals(treePath2)) {
                        rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                        treePath = BasicTreeUI.this.tree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    }
                } else {
                    rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                    treePath = BasicTreeUI.this.tree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    if (treePath.equals(treePath2)) {
                        rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                        treePath = BasicTreeUI.this.tree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    }
                }
                Rectangle rectangle2 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath);
                rectangle2.x = rectangle.x;
                rectangle2.width = rectangle.width;
                if (this.direction == -1) {
                    rectangle2.height = rectangle.height;
                } else {
                    rectangle2.y -= rectangle.height - rectangle2.height;
                    rectangle2.height = rectangle.height;
                }
                if (this.addToSelection) {
                    BasicTreeUI.this.extendSelection(treePath);
                } else if (this.changeSelection) {
                    BasicTreeUI.this.tree.setSelectionPath(treePath);
                } else {
                    BasicTreeUI.this.setLeadSelectionPath(treePath, true);
                }
                BasicTreeUI.this.tree.scrollRectToVisible(rectangle2);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;
        private boolean changeSelection;

        public TreeTraverseAction(int n, String string) {
            this(n, string, true);
        }

        private TreeTraverseAction(int n, String string, boolean bl) {
            this.direction = n;
            this.changeSelection = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && (n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree)) > 0) {
                int n2;
                int n3 = BasicTreeUI.this.getLeadSelectionRow();
                if (n3 == -1) {
                    n2 = 0;
                } else if (this.direction == 1) {
                    if (!BasicTreeUI.this.isLeaf(n3) && !BasicTreeUI.this.tree.isExpanded(n3)) {
                        BasicTreeUI.this.toggleExpandState(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n3));
                        n2 = -1;
                    } else {
                        n2 = Math.min(n3 + 1, n - 1);
                    }
                } else if (!BasicTreeUI.this.isLeaf(n3) && BasicTreeUI.this.tree.isExpanded(n3)) {
                    BasicTreeUI.this.toggleExpandState(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n3));
                    n2 = -1;
                } else {
                    TreePath treePath = BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n3);
                    n2 = treePath != null && treePath.getPathCount() > 1 ? BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath.getParentPath()) : -1;
                }
                if (n2 != -1) {
                    if (this.changeSelection) {
                        BasicTreeUI.this.tree.setSelectionInterval(n2, n2);
                    } else {
                        BasicTreeUI.this.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n2), true);
                    }
                    BasicTreeUI.this.ensureRowsAreVisible(n2, n2);
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicTreeUI.this.treeSelectionModel) {
                BasicTreeUI.this.treeSelectionModel.resetRowSelection();
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicTreeUI.this.tree) {
                DropTarget dropTarget;
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("leadSelectionPath")) {
                    if (!BasicTreeUI.this.ignoreLAChange) {
                        BasicTreeUI.this.updateLeadRow();
                        BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getOldValue());
                        BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getNewValue());
                    }
                } else if (string.equals("anchorSelectionPath") && !BasicTreeUI.this.ignoreLAChange) {
                    BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getOldValue());
                    BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getNewValue());
                }
                if (string.equals("cellRenderer")) {
                    BasicTreeUI.this.setCellRenderer((TreeCellRenderer)propertyChangeEvent.getNewValue());
                    BasicTreeUI.this.redoTheLayout();
                } else if (string.equals("model")) {
                    BasicTreeUI.this.setModel((TreeModel)propertyChangeEvent.getNewValue());
                } else if (string.equals("rootVisible")) {
                    BasicTreeUI.this.setRootVisible((Boolean)propertyChangeEvent.getNewValue());
                } else if (string.equals("showsRootHandles")) {
                    BasicTreeUI.this.setShowsRootHandles((Boolean)propertyChangeEvent.getNewValue());
                } else if (string.equals("rowHeight")) {
                    BasicTreeUI.this.setRowHeight((Integer)propertyChangeEvent.getNewValue());
                } else if (string.equals("cellEditor")) {
                    BasicTreeUI.this.setCellEditor((TreeCellEditor)propertyChangeEvent.getNewValue());
                } else if (string.equals("editable")) {
                    BasicTreeUI.this.setEditable((Boolean)propertyChangeEvent.getNewValue());
                } else if (string.equals("largeModel")) {
                    BasicTreeUI.this.setLargeModel(BasicTreeUI.this.tree.isLargeModel());
                } else if (string.equals("selectionModel")) {
                    BasicTreeUI.this.setSelectionModel(BasicTreeUI.this.tree.getSelectionModel());
                } else if (string.equals("font")) {
                    BasicTreeUI.this.completeEditing();
                    if (BasicTreeUI.this.treeState != null) {
                        BasicTreeUI.this.treeState.invalidateSizes();
                    }
                    BasicTreeUI.this.updateSize();
                } else if (string.equals("componentOrientation")) {
                    if (BasicTreeUI.this.tree != null) {
                        BasicTreeUI.this.leftToRight = BasicGraphicsUtils.isLeftToRight(BasicTreeUI.this.tree);
                        BasicTreeUI.this.redoTheLayout();
                        BasicTreeUI.this.tree.treeDidChange();
                        InputMap inputMap = BasicTreeUI.this.getInputMap(0);
                        SwingUtilities.replaceUIInputMap(BasicTreeUI.this.tree, 0, inputMap);
                    }
                } else if ("transferHandler".equals(string) && (dropTarget = BasicTreeUI.this.tree.getDropTarget()) instanceof UIResource) {
                    if (defaultDropTargetListener == null) {
                        defaultDropTargetListener = new TreeDropTargetListener();
                    }
                    try {
                        dropTarget.addDropTargetListener(defaultDropTargetListener);
                    }
                    catch (TooManyListenersException tooManyListenersException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        boolean selectedOnPress;

        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.handleSelection(mouseEvent);
                this.selectedOnPress = true;
            } else {
                this.selectedOnPress = false;
            }
        }

        void handleSelection(MouseEvent mouseEvent) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled()) {
                TreePath treePath;
                if (BasicTreeUI.this.isEditing(BasicTreeUI.this.tree) && BasicTreeUI.this.tree.getInvokesStopCellEditing() && !BasicTreeUI.this.stopEditing(BasicTreeUI.this.tree)) {
                    return;
                }
                if (BasicTreeUI.this.tree.isRequestFocusEnabled()) {
                    BasicTreeUI.this.tree.requestFocus();
                }
                if ((treePath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, mouseEvent.getX(), mouseEvent.getY())) != null) {
                    int n;
                    Rectangle rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath);
                    if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        BasicTreeUI.this.checkForClickInExpandControl(treePath, mouseEvent.getX(), mouseEvent.getY());
                    }
                    if ((n = mouseEvent.getX()) > rectangle.x && n <= rectangle.x + rectangle.width && !BasicTreeUI.this.startEditing(treePath, mouseEvent)) {
                        BasicTreeUI.this.selectPathForEvent(treePath, mouseEvent);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && !this.selectedOnPress) {
                this.handleSelection(mouseEvent);
            }
        }
    }

    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            if (BasicTreeUI.this.editingComponent != null && BasicTreeUI.this.editingRow == n) {
                Dimension dimension = BasicTreeUI.this.editingComponent.getPreferredSize();
                int n3 = BasicTreeUI.this.getRowHeight();
                if (n3 > 0 && n3 != dimension.height) {
                    dimension.height = n3;
                }
                if (rectangle != null) {
                    rectangle.x = this.getRowX(n, n2);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(this.getRowX(n, n2), 0, dimension.width, dimension.height);
                }
                if (!BasicTreeUI.this.leftToRight) {
                    rectangle.x = BasicTreeUI.this.lastWidth - rectangle.width - rectangle.x - 2;
                }
                return rectangle;
            }
            if (BasicTreeUI.this.currentCellRenderer != null) {
                Component component = BasicTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(BasicTreeUI.this.tree, object, BasicTreeUI.this.tree.isRowSelected(n), bl, BasicTreeUI.this.treeModel.isLeaf(object), n, false);
                if (BasicTreeUI.this.tree != null) {
                    BasicTreeUI.this.rendererPane.add(component);
                    component.validate();
                }
                Dimension dimension = component.getPreferredSize();
                if (rectangle != null) {
                    rectangle.x = this.getRowX(n, n2);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(this.getRowX(n, n2), 0, dimension.width, dimension.height);
                }
                if (!BasicTreeUI.this.leftToRight) {
                    rectangle.x = BasicTreeUI.this.lastWidth - rectangle.width - rectangle.x - 2;
                }
                return rectangle;
            }
            return null;
        }

        protected int getRowX(int n, int n2) {
            return BasicTreeUI.this.totalChildIndent * (n2 + BasicTreeUI.this.depthOffset);
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            if (BasicTreeUI.this.tree != null) {
                Rectangle rectangle;
                if (BasicTreeUI.this.tree.getLeadSelectionPath() == null && BasicTreeUI.this.tree.getRowCount() > 0) {
                    BasicTreeUI.this.tree.setSelectionInterval(0, 0);
                }
                if ((rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, BasicTreeUI.this.tree.getLeadSelectionPath())) != null) {
                    BasicTreeUI.this.tree.repaint(rectangle);
                }
                if ((rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, BasicTreeUI.this.getLeadSelectionPath())) != null) {
                    BasicTreeUI.this.tree.repaint(rectangle);
                }
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.focusGained(focusEvent);
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public void keyTyped(KeyEvent keyEvent) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.getRowCount() > 0 && BasicTreeUI.this.tree.hasFocus() && BasicTreeUI.this.tree.isEnabled()) {
                TreePath treePath;
                if (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                    return;
                }
                boolean bl = true;
                char[] cArray = new char[]{keyEvent.getKeyChar()};
                String string = new String(cArray);
                int n = BasicTreeUI.this.tree.getMinSelectionRow() + 1;
                if (n < 0 || n >= BasicTreeUI.this.tree.getRowCount()) {
                    bl = false;
                    n = 0;
                }
                if ((treePath = BasicTreeUI.this.tree.getNextMatch(string, n, Position.Bias.Forward)) != null) {
                    BasicTreeUI.this.tree.setSelectionPath(treePath);
                } else if (bl && (treePath = BasicTreeUI.this.tree.getNextMatch(string, 0, Position.Bias.Forward)) != null) {
                    BasicTreeUI.this.tree.setSelectionPath(treePath);
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.hasFocus() && BasicTreeUI.this.tree.isEnabled()) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                if (BasicTreeUI.this.tree.getConditionForKeyStroke(keyStroke) == 0) {
                    ActionListener actionListener = BasicTreeUI.this.tree.getActionForKeyStroke(keyStroke);
                    if (actionListener instanceof Action) {
                        this.repeatKeyAction = (Action)actionListener;
                        if (!this.repeatKeyAction.isEnabled()) {
                            this.repeatKeyAction = null;
                        }
                    } else {
                        this.repeatKeyAction = null;
                    }
                } else {
                    this.repeatKeyAction = null;
                }
                if (this.isKeyDown && this.repeatKeyAction != null) {
                    this.repeatKeyAction.actionPerformed(new ActionEvent(BasicTreeUI.this.tree, 1001, "", keyEvent.getWhen(), keyEvent.getModifiers()));
                    keyEvent.consume();
                } else {
                    this.isKeyDown = true;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.isKeyDown = false;
        }
    }

    public class CellEditorHandler
    implements CellEditorListener {
        public void editingStopped(ChangeEvent changeEvent) {
            BasicTreeUI.this.completeEditing(false, false, true);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            BasicTreeUI.this.completeEditing(false, false, false);
        }
    }

    public class TreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object;
            TreePath[] treePathArray;
            BasicTreeUI.this.completeEditing();
            if (BasicTreeUI.this.tree.getExpandsSelectedPaths() && BasicTreeUI.this.treeSelectionModel != null && (treePathArray = BasicTreeUI.this.treeSelectionModel.getSelectionPaths()) != null) {
                for (int i = treePathArray.length - 1; i >= 0; --i) {
                    object = treePathArray[i].getParentPath();
                    boolean bl = true;
                    while (object != null) {
                        if (BasicTreeUI.this.treeModel.isLeaf(object.getLastPathComponent())) {
                            bl = false;
                            object = null;
                            continue;
                        }
                        object = object.getParentPath();
                    }
                    if (!bl) continue;
                    BasicTreeUI.this.tree.makeVisible(treePathArray[i]);
                }
            }
            treePathArray = BasicTreeUI.this.getLeadSelectionPath();
            BasicTreeUI.this.lastSelectedRow = BasicTreeUI.this.tree.getMinSelectionRow();
            TreePath treePath = BasicTreeUI.this.tree.getSelectionModel().getLeadSelectionPath();
            BasicTreeUI.this.setAnchorSelectionPath(treePath);
            BasicTreeUI.this.setLeadSelectionPath(treePath);
            object = treeSelectionEvent.getPaths();
            Rectangle rectangle = BasicTreeUI.this.tree.getVisibleRect();
            boolean bl = true;
            int n = BasicTreeUI.this.tree.getWidth();
            if (object != null) {
                int n2 = ((TreePath[])object).length;
                if (n2 > 4) {
                    BasicTreeUI.this.tree.repaint();
                    bl = false;
                } else {
                    for (int i = 0; i < n2; ++i) {
                        Rectangle rectangle2 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, object[i]);
                        if (rectangle2 == null || !rectangle.intersects(rectangle2)) continue;
                        BasicTreeUI.this.tree.repaint(0, rectangle2.y, n, rectangle2.height);
                    }
                }
            }
            if (bl) {
                Rectangle rectangle3 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, (TreePath)treePathArray);
                if (rectangle3 != null && rectangle.intersects(rectangle3)) {
                    BasicTreeUI.this.tree.repaint(0, rectangle3.y, n, rectangle3.height);
                }
                if ((rectangle3 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath)) != null && rectangle.intersects(rectangle3)) {
                    BasicTreeUI.this.tree.repaint(0, rectangle3.y, n, rectangle3.height);
                }
            }
        }
    }

    public class TreeModelHandler
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeNodesChanged(treeModelEvent);
                TreePath treePath = treeModelEvent.getTreePath().getParentPath();
                if (treePath == null || BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeNodesInserted(treeModelEvent);
                BasicTreeUI.this.updateLeadRow();
                TreePath treePath = treeModelEvent.getTreePath();
                if (BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    BasicTreeUI.this.updateSize();
                } else {
                    int[] nArray = treeModelEvent.getChildIndices();
                    int n = BasicTreeUI.this.treeModel.getChildCount(treePath.getLastPathComponent());
                    if (nArray != null && n - nArray.length == 0) {
                        BasicTreeUI.this.updateSize();
                    }
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeNodesRemoved(treeModelEvent);
                BasicTreeUI.this.updateLeadRow();
                TreePath treePath = treeModelEvent.getTreePath();
                if (BasicTreeUI.this.treeState.isExpanded(treePath) || BasicTreeUI.this.treeModel.getChildCount(treePath.getLastPathComponent()) == 0) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeStructureChanged(treeModelEvent);
                BasicTreeUI.this.updateLeadRow();
                TreePath treePath = treeModelEvent.getTreePath();
                if (treePath != null) {
                    treePath = treePath.getParentPath();
                }
                if (treePath == null || BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.timer == null) {
                JScrollPane jScrollPane = this.getScrollPane();
                if (jScrollPane == null) {
                    BasicTreeUI.this.updateSize();
                } else {
                    this.scrollBar = jScrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = jScrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicTreeUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container container;
            for (container = BasicTreeUI.this.tree.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
            }
            if (container instanceof JScrollPane) {
                return (JScrollPane)container;
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicTreeUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }

    public class TreeExpansionHandler
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            if (treeExpansionEvent != null && BasicTreeUI.this.tree != null) {
                TreePath treePath = treeExpansionEvent.getPath();
                BasicTreeUI.this.updateExpandedDescendants(treePath);
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            if (treeExpansionEvent != null && BasicTreeUI.this.tree != null) {
                TreePath treePath = treeExpansionEvent.getPath();
                BasicTreeUI.this.completeEditing();
                if (treePath != null && BasicTreeUI.this.tree.isVisible(treePath)) {
                    BasicTreeUI.this.treeState.setExpandedState(treePath, false);
                    BasicTreeUI.this.updateLeadRow();
                    BasicTreeUI.this.updateSize();
                }
            }
        }
    }
}

