/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.basic.ComboPopup;

public class BasicRootPaneUI
extends RootPaneUI
implements PropertyChangeListener {
    private static RootPaneUI rootPaneUI = new BasicRootPaneUI();
    private static final AltProcessor altProcessor = new AltProcessor();
    private Object[] oldDefaultButtonBindings = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return rootPaneUI;
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults((JRootPane)jComponent);
        this.installComponents((JRootPane)jComponent);
        this.installListeners((JRootPane)jComponent);
        this.installKeyboardActions((JRootPane)jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JRootPane)jComponent);
        this.uninstallComponents((JRootPane)jComponent);
        this.uninstallListeners((JRootPane)jComponent);
        this.uninstallKeyboardActions((JRootPane)jComponent);
    }

    protected void installDefaults(JRootPane jRootPane) {
    }

    protected void installComponents(JRootPane jRootPane) {
    }

    protected void installListeners(JRootPane jRootPane) {
        jRootPane.addPropertyChangeListener(this);
        if (UIManager.get("altProcessor") == null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(altProcessor);
            UIManager.put("altProcessor", altProcessor);
        }
    }

    protected void installKeyboardActions(JRootPane jRootPane) {
        InputMap inputMap = this.getInputMap(2, jRootPane);
        SwingUtilities.replaceUIInputMap(jRootPane, 2, inputMap);
        ActionMap actionMap = this.getActionMap(jRootPane);
        SwingUtilities.replaceUIActionMap(jRootPane, actionMap);
        this.updateDefaultButtonBindings(jRootPane);
    }

    protected void uninstallDefaults(JRootPane jRootPane) {
    }

    protected void uninstallComponents(JRootPane jRootPane) {
    }

    protected void uninstallListeners(JRootPane jRootPane) {
        jRootPane.removePropertyChangeListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(altProcessor);
        if (UIManager.get("altProcessor") == altProcessor) {
            UIManager.put("altProcessor", null);
        }
    }

    protected void uninstallKeyboardActions(JRootPane jRootPane) {
        SwingUtilities.replaceUIInputMap(jRootPane, 2, null);
        SwingUtilities.replaceUIActionMap(jRootPane, null);
    }

    InputMap getInputMap(int n, JComponent jComponent) {
        if (n == 2) {
            return this.createInputMap(n, jComponent);
        }
        return null;
    }

    ActionMap getActionMap(JComponent jComponent) {
        return this.createActionMap(jComponent);
    }

    ComponentInputMap createInputMap(int n, JComponent jComponent) {
        RootPaneInputMap rootPaneInputMap = new RootPaneInputMap(jComponent);
        Object[] objectArray = (Object[])UIManager.get("RootPane.windowBindings");
        if (objectArray != null) {
            LookAndFeel.loadKeyBindings(rootPaneInputMap, objectArray);
        }
        return rootPaneInputMap;
    }

    ActionMap createActionMap(JComponent jComponent) {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("press", new DefaultAction((JRootPane)jComponent, true));
        actionMapUIResource.put("release", new DefaultAction((JRootPane)jComponent, false));
        actionMapUIResource.put("postpopup", new PostPopupAction());
        return actionMapUIResource;
    }

    void updateDefaultButtonBindings(JRootPane jRootPane) {
        InputMap inputMap;
        for (inputMap = SwingUtilities.getUIInputMap(jRootPane, 2); inputMap != null && !(inputMap instanceof RootPaneInputMap); inputMap = inputMap.getParent()) {
        }
        if (inputMap != null) {
            Object[] objectArray;
            this.clearDefaultButtonBindings(inputMap);
            if (jRootPane.getDefaultButton() != null && (objectArray = (Object[])UIManager.get("RootPane.defaultButtonWindowKeyBindings")) != null) {
                LookAndFeel.loadKeyBindings(inputMap, objectArray);
                this.oldDefaultButtonBindings = objectArray;
            }
        }
    }

    private void clearDefaultButtonBindings(InputMap inputMap) {
        if (this.oldDefaultButtonBindings != null) {
            int n = this.oldDefaultButtonBindings.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                KeyStroke keyStroke = (object = this.oldDefaultButtonBindings[i++]) instanceof KeyStroke ? (KeyStroke)object : KeyStroke.getKeyStroke((String)object);
                inputMap.remove(keyStroke);
            }
            this.oldDefaultButtonBindings = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("defaultButton")) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            this.updateDefaultButtonBindings(jRootPane);
            if (jRootPane.getClientProperty("temporaryDefaultButton") == null) {
                jRootPane.putClientProperty("initialDefaultButton", propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class AltProcessor
    implements KeyEventPostProcessor {
        static boolean altKeyPressed = false;
        static boolean menuCanceledOnPress = false;
        static JRootPane root = null;
        static Window winAncestor = null;
        private static JMenuBar mbar = null;
        private int topTier = 0;
        private JMenuBar topMBar = null;

        private AltProcessor() {
        }

        void altPressed(KeyEvent keyEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0 && !(menuElementArray[0] instanceof ComboPopup)) {
                menuSelectionManager.clearSelectedPath();
                menuCanceledOnPress = true;
                keyEvent.consume();
            } else if (menuElementArray.length > 0) {
                menuCanceledOnPress = false;
                keyEvent.consume();
            } else {
                JMenu jMenu;
                menuCanceledOnPress = false;
                JMenu jMenu2 = jMenu = mbar != null ? mbar.getMenu(0) : null;
                if (jMenu != null) {
                    keyEvent.consume();
                }
            }
        }

        void altReleased(KeyEvent keyEvent) {
            if (menuCanceledOnPress) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.getSelectedPath().length == 0) {
                JMenu jMenu;
                JMenu jMenu2 = jMenu = mbar != null ? mbar.getMenu(0) : null;
                if (jMenu != null) {
                    MenuElement[] menuElementArray = new MenuElement[3];
                    JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                    menuElementArray[0] = mbar;
                    menuElementArray[1] = jMenu;
                    menuElementArray[2] = jPopupMenu;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }

        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 18) {
                root = SwingUtilities.getRootPane(keyEvent.getComponent());
                if (root == null) {
                    return false;
                }
                winAncestor = SwingUtilities.getWindowAncestor(root);
                mbar = this.getJMenuBar(root);
                if (keyEvent.getID() == 401) {
                    if (!altKeyPressed) {
                        this.altPressed(keyEvent);
                    }
                    altKeyPressed = true;
                    return true;
                }
                if (keyEvent.getID() == 402) {
                    if (altKeyPressed) {
                        this.altReleased(keyEvent);
                    } else {
                        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                    }
                    altKeyPressed = false;
                }
            } else {
                altKeyPressed = false;
            }
            return false;
        }

        private JMenuBar getJMenuBar(JRootPane jRootPane) {
            Window window;
            JMenuBar jMenuBar;
            JMenuBar jMenuBar2 = jMenuBar = jRootPane != null ? jRootPane.getJMenuBar() : null;
            if (jRootPane != null && jMenuBar == null && (jMenuBar = this.getTopJMenuBar(jRootPane)) == null && jRootPane.getParent() instanceof JInternalFrame && (window = SwingUtilities.windowForComponent(jRootPane.getParent())) != null && window instanceof RootPaneContainer) {
                jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                jMenuBar = this.getTopJMenuBar(jRootPane);
            }
            return jMenuBar;
        }

        private JMenuBar getTopJMenuBar(JRootPane jRootPane) {
            this.topTier = 0;
            this.topMBar = null;
            if (jRootPane != null) {
                Container container = jRootPane.getContentPane();
                this.searchChildren(container, 0);
            }
            return this.topMBar;
        }

        private boolean searchChildren(Container container, int n) {
            if (container != null) {
                if (this.topTier != 0 && ++n >= this.topTier) {
                    return false;
                }
                Component[] componentArray = container.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    Component component = componentArray[i];
                    if (component instanceof JMenuBar) {
                        if (this.topTier != 0 && n >= this.topTier) continue;
                        this.topTier = n;
                        this.topMBar = (JMenuBar)component;
                        return true;
                    }
                    if (component instanceof Container && this.searchChildren((Container)component, n)) break;
                }
            }
            return false;
        }
    }

    private static class RootPaneInputMap
    extends ComponentInputMapUIResource {
        public RootPaneInputMap(JComponent jComponent) {
            super(jComponent);
        }
    }

    private static class PostPopupAction
    extends AbstractAction {
        private PostPopupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null) {
                component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            }
            if (component != null) {
                Object object;
                boolean bl = false;
                if (component instanceof JRootPane && (object = MenuSelectionManager.defaultManager().getSelectedPath())[0] == ((JRootPane)component).getJMenuBar()) {
                    bl = true;
                }
                if (!bl) {
                    object = component.getSize();
                    MouseEvent mouseEvent = new MouseEvent(component, 501, System.currentTimeMillis(), 0, object.width / 2, object.height / 2, 1, true);
                    component.dispatchEvent(mouseEvent);
                    MouseEvent mouseEvent2 = new MouseEvent(component, 502, System.currentTimeMillis(), 0, object.width / 2, object.height / 2, 1, true);
                    component.dispatchEvent(mouseEvent2);
                    MouseEvent mouseEvent3 = new MouseEvent(component, 500, System.currentTimeMillis(), 0, object.width / 2, object.height / 2, 1, true);
                    component.dispatchEvent(mouseEvent3);
                }
            }
        }
    }

    static class DefaultAction
    extends AbstractAction {
        JRootPane root;
        boolean press;

        DefaultAction(JRootPane jRootPane, boolean bl) {
            this.root = jRootPane;
            this.press = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = this.root.getDefaultButton();
            if (jButton != null && SwingUtilities.getRootPane(jButton) == this.root && this.press) {
                jButton.doClick(20);
            }
        }

        public boolean isEnabled() {
            JButton jButton = this.root.getDefaultButton();
            return jButton != null && jButton.getModel().isEnabled();
        }
    }
}

