/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

public class JLayeredPane
extends JComponent
implements Accessible {
    public static final Integer DEFAULT_LAYER = new Integer(0);
    public static final Integer PALETTE_LAYER = new Integer(100);
    public static final Integer MODAL_LAYER = new Integer(200);
    public static final Integer POPUP_LAYER = new Integer(300);
    public static final Integer DRAG_LAYER = new Integer(400);
    public static final Integer FRAME_CONTENT_LAYER = new Integer(-30000);
    public static final String LAYER_PROPERTY = "layeredContainerLayer";
    private Hashtable componentToLayer;
    private boolean optimizedDrawingPossible = true;

    public JLayeredPane() {
        this.setLayout(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateOptimizedDrawing() {
        boolean bl = false;
        Object object = this.getTreeLock();
        synchronized (object) {
            Integer n = null;
            int n2 = this.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                n = null;
                if (!(this.getComponent(i) instanceof JInternalFrame) && (!(this.getComponent(i) instanceof JComponent) || (n = (Integer)((JComponent)this.getComponent(i)).getClientProperty(LAYER_PROPERTY)) == null) || n != null && n.equals(FRAME_CONTENT_LAYER)) continue;
                bl = true;
                break;
            }
        }
        this.optimizedDrawingPossible = !bl;
    }

    protected void addImpl(Component component, Object object, int n) {
        int n2 = DEFAULT_LAYER;
        if (object instanceof Integer) {
            n2 = (Integer)object;
            this.setLayer(component, n2);
        } else {
            n2 = this.getLayer(component);
        }
        int n3 = this.insertIndexForLayer(n2, n);
        super.addImpl(component, object, n3);
        component.validate();
        component.repaint();
        this.validateOptimizedDrawing();
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        super.remove(n);
        if (component != null && !(component instanceof JComponent)) {
            this.getComponentToLayer().remove(component);
        }
        this.validateOptimizedDrawing();
    }

    public boolean isOptimizedDrawingEnabled() {
        return this.optimizedDrawingPossible;
    }

    public static void putLayer(JComponent jComponent, int n) {
        Integer n2 = new Integer(n);
        jComponent.putClientProperty(LAYER_PROPERTY, n2);
    }

    public static int getLayer(JComponent jComponent) {
        Integer n = (Integer)jComponent.getClientProperty(LAYER_PROPERTY);
        if (n != null) {
            return n;
        }
        return DEFAULT_LAYER;
    }

    public static JLayeredPane getLayeredPaneAbove(Component component) {
        Container container;
        if (component == null) {
            return null;
        }
        for (container = component.getParent(); container != null && !(container instanceof JLayeredPane); container = container.getParent()) {
        }
        return (JLayeredPane)container;
    }

    public void setLayer(Component component, int n) {
        this.setLayer(component, n, -1);
    }

    public void setLayer(Component component, int n, int n2) {
        Integer n3 = this.getObjectForLayer(n);
        if (n == this.getLayer(component) && n2 == this.getPosition(component)) {
            if (component instanceof JComponent) {
                this.repaint(((JComponent)component)._bounds);
            } else {
                this.repaint(component.getBounds());
            }
            return;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty(LAYER_PROPERTY, n3);
        } else {
            this.getComponentToLayer().put(component, n3);
        }
        if (component.getParent() == null || component.getParent() != this) {
            if (component instanceof JComponent) {
                this.repaint(((JComponent)component)._bounds);
            } else {
                this.repaint(component.getBounds());
            }
            return;
        }
        this.remove(component);
        this.add(component, null, n2);
        if (component instanceof JComponent) {
            this.repaint(((JComponent)component)._bounds);
        } else {
            this.repaint(component.getBounds());
        }
    }

    public int getLayer(Component component) {
        Integer n = component instanceof JComponent ? (Integer)((JComponent)component).getClientProperty(LAYER_PROPERTY) : (Integer)this.getComponentToLayer().get(component);
        if (n == null) {
            return DEFAULT_LAYER;
        }
        return n;
    }

    public int getIndexOf(Component component) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (component != this.getComponent(i)) continue;
            return i;
        }
        return -1;
    }

    public void moveToFront(Component component) {
        this.setPosition(component, 0);
    }

    public void moveToBack(Component component) {
        this.setPosition(component, this.getComponentCountInLayer(this.getLayer(component)));
    }

    public void setPosition(Component component, int n) {
        this.setLayer(component, this.getLayer(component), n);
    }

    public int getPosition(Component component) {
        int n = 0;
        int n2 = this.getComponentCount();
        int n3 = this.getIndexOf(component);
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.getLayer(component);
        for (int i = n3 - 1; i >= 0; --i) {
            int n5 = this.getLayer(this.getComponent(i));
            if (n5 == n4) {
                ++n;
                continue;
            }
            return n;
        }
        return n;
    }

    public int highestLayer() {
        if (this.getComponentCount() > 0) {
            return this.getLayer(this.getComponent(0));
        }
        return 0;
    }

    public int lowestLayer() {
        int n = this.getComponentCount();
        if (n > 0) {
            return this.getLayer(this.getComponent(n - 1));
        }
        return 0;
    }

    public int getComponentCountInLayer(int n) {
        int n2 = 0;
        int n3 = this.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.getLayer(this.getComponent(i));
            if (n4 == n) {
                ++n2;
                continue;
            }
            if (n2 > 0 || n4 < n) break;
        }
        return n2;
    }

    public Component[] getComponentsInLayer(int n) {
        int n2 = 0;
        Component[] componentArray = new Component[this.getComponentCountInLayer(n)];
        int n3 = this.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.getLayer(this.getComponent(i));
            if (n4 == n) {
                componentArray[n2++] = this.getComponent(i);
                continue;
            }
            if (n2 > 0 || n4 < n) break;
        }
        return componentArray;
    }

    public void paint(Graphics graphics) {
        if (this.isOpaque()) {
            Rectangle rectangle = graphics.getClipBounds();
            Color color = this.getBackground();
            if (color == null) {
                color = Color.lightGray;
            }
            graphics.setColor(color);
            if (rectangle != null) {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        super.paint(graphics);
    }

    protected Hashtable getComponentToLayer() {
        if (this.componentToLayer == null) {
            this.componentToLayer = new Hashtable(4);
        }
        return this.componentToLayer;
    }

    protected Integer getObjectForLayer(int n) {
        Integer n2;
        switch (n) {
            case 0: {
                n2 = DEFAULT_LAYER;
                break;
            }
            case 100: {
                n2 = PALETTE_LAYER;
                break;
            }
            case 200: {
                n2 = MODAL_LAYER;
                break;
            }
            case 300: {
                n2 = POPUP_LAYER;
                break;
            }
            case 400: {
                n2 = DRAG_LAYER;
                break;
            }
            default: {
                n2 = new Integer(n);
            }
        }
        return n2;
    }

    protected int insertIndexForLayer(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = this.getComponentCount();
        for (int i = 0; i < n5; ++i) {
            int n6 = this.getLayer(this.getComponent(i));
            if (n3 == -1 && n6 == n) {
                n3 = i;
            }
            if (n6 >= n) continue;
            if (i == 0) {
                n3 = 0;
                n4 = 0;
                break;
            }
            n4 = i;
            break;
        }
        if (n3 == -1 && n4 == -1) {
            return n5;
        }
        if (n3 != -1 && n4 == -1) {
            n4 = n5;
        }
        if (n4 != -1 && n3 == -1) {
            n3 = n4;
        }
        if (n2 == -1) {
            return n4;
        }
        if (n2 > -1 && n3 + n2 <= n4) {
            return n3 + n2;
        }
        return n4;
    }

    protected String paramString() {
        String string = this.optimizedDrawingPossible ? "true" : "false";
        return super.paramString() + ",optimizedDrawingPossible=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLayeredPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJLayeredPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJLayeredPane() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LAYERED_PANE;
        }
    }
}

