/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.StyledParagraph;
import java.awt.font.TextAttribute;
import java.awt.font.TextJustifier;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.util.Map;
import sun.awt.font.BidiUtils;
import sun.awt.font.Decoration;
import sun.awt.font.ExtendedTextLabel;
import sun.awt.font.FontResolver;
import sun.awt.font.GraphicComponent;
import sun.awt.font.TextLabelFactory;
import sun.awt.font.TextLineComponent;

final class TextLine {
    private TextLineComponent[] fComponents;
    private float[] fBaselineOffsets;
    private int[] fComponentVisualOrder;
    private char[] fChars;
    private int fCharsStart;
    private int fCharsLimit;
    private int[] fCharVisualOrder;
    private int[] fCharLogicalOrder;
    private byte[] fCharLevels;
    private boolean fIsDirectionLTR;
    private TextLineMetrics fMetrics = null;
    private static Function fgAdvanceF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            TextLineComponent textLineComponent = textLine.fComponents[n];
            return textLineComponent.getCharAdvance(n2);
        }
    };
    private static Function fgXPositionF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            int n3;
            float f = 0.0f;
            if (textLine.fComponentVisualOrder == null) {
                for (n3 = 0; n3 < n; ++n3) {
                    Rectangle2D rectangle2D = textLine.fComponents[n3].getLogicalBounds();
                    f += (float)rectangle2D.getWidth();
                }
            } else {
                n3 = 0;
                while (textLine.fComponentVisualOrder[n3] != n) {
                    int n4 = textLine.fComponentVisualOrder[n3];
                    Rectangle2D rectangle2D = textLine.fComponents[n4].getLogicalBounds();
                    f += (float)rectangle2D.getWidth();
                    ++n3;
                }
            }
            TextLineComponent textLineComponent = textLine.fComponents[n];
            return f + textLineComponent.getCharX(n2);
        }
    };
    private static Function fgYPositionF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            TextLineComponent textLineComponent = textLine.fComponents[n];
            float f = textLineComponent.getCharY(n2);
            return f + textLine.getComponentShift(n);
        }
    };

    public TextLine(TextLineComponent[] textLineComponentArray, float[] fArray, char[] cArray, int n, int n2, int[] nArray, byte[] byArray, boolean bl) {
        int[] nArray2 = TextLine.computeComponentOrder(textLineComponentArray, nArray);
        this.fComponents = textLineComponentArray;
        this.fBaselineOffsets = fArray;
        this.fComponentVisualOrder = nArray2;
        this.fChars = cArray;
        this.fCharsStart = n;
        this.fCharsLimit = n2;
        this.fCharLogicalOrder = nArray;
        this.fCharLevels = byArray;
        this.fIsDirectionLTR = bl;
        this.checkCtorArgs();
    }

    private void checkCtorArgs() {
        int n = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            n += this.fComponents[i].getNumCharacters();
        }
        if (n != this.characterCount()) {
            throw new IllegalArgumentException("Invalid TextLine!  char count is different from sum of char counts of components.");
        }
    }

    public int characterCount() {
        return this.fCharsLimit - this.fCharsStart;
    }

    public boolean isDirectionLTR() {
        return this.fIsDirectionLTR;
    }

    public TextLineMetrics getMetrics() {
        if (this.fMetrics == null) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            boolean bl = false;
            for (int i = 0; i < this.fComponents.length; ++i) {
                float f7;
                float f8;
                TextLineComponent textLineComponent = this.fComponents[i];
                Rectangle2D rectangle2D = textLineComponent.getLogicalBounds();
                f4 += (float)rectangle2D.getWidth();
                byte by = (byte)textLineComponent.getLineMetrics().getBaselineIndex();
                LineMetrics lineMetrics = textLineComponent.getLineMetrics();
                if (by >= 0) {
                    f8 = this.fBaselineOffsets[by];
                    f = Math.max(f, -f8 + lineMetrics.getAscent());
                    f7 = f8 + lineMetrics.getDescent();
                    f2 = Math.max(f2, f7);
                    f3 = Math.max(f3, f7 + lineMetrics.getLeading());
                    continue;
                }
                bl = true;
                f8 = lineMetrics.getAscent() + lineMetrics.getDescent();
                f7 = f8 + lineMetrics.getLeading();
                f5 = Math.max(f5, f8);
                f6 = Math.max(f6, f7);
            }
            if (bl) {
                if (f5 > f + f2) {
                    f2 = f5 - f;
                }
                if (f6 > f + f3) {
                    f3 = f6 - f;
                }
            }
            this.fMetrics = new TextLineMetrics(f, f2, f3 -= f2, f4);
        }
        return this.fMetrics;
    }

    public int visualToLogical(int n) {
        if (this.fCharLogicalOrder == null) {
            return n;
        }
        if (this.fCharVisualOrder == null) {
            this.fCharVisualOrder = BidiUtils.createInverseMap(this.fCharLogicalOrder);
        }
        return this.fCharVisualOrder[n];
    }

    public int logicalToVisual(int n) {
        return this.fCharLogicalOrder == null ? n : this.fCharLogicalOrder[n];
    }

    public byte getCharLevel(int n) {
        return this.fCharLevels == null ? (byte)0 : this.fCharLevels[n];
    }

    public boolean isCharLTR(int n) {
        return (this.getCharLevel(n) & 1) == 0;
    }

    public int getCharType(int n) {
        return Character.getType(this.fChars[n + this.fCharsStart]);
    }

    public boolean isCharSpace(int n) {
        return Character.isSpaceChar(this.fChars[n + this.fCharsStart]);
    }

    public boolean isCharWhitespace(int n) {
        return Character.isWhitespace(this.fChars[n + this.fCharsStart]);
    }

    public float getCharAngle(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        if (n > this.fCharsLimit - this.fCharsStart) {
            throw new IllegalArgumentException("logicalIndex too large.");
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 += this.fComponents[n2].getNumCharacters()) <= n && ++n2 < this.fComponents.length) {
        }
        return this.fComponents[n2].getItalicAngle();
    }

    private LineMetrics getLineMetricsAt(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        if (n > this.fCharsLimit - this.fCharsStart) {
            throw new IllegalArgumentException("logicalIndex too large.");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n4 += this.fComponents[n2].getNumCharacters()) <= n) {
            n3 = n4;
            if (++n2 < this.fComponents.length) continue;
        }
        return this.fComponents[n2].getLineMetrics();
    }

    public float getCharAscent(int n) {
        return this.getLineMetricsAt(n).getAscent();
    }

    public float getCharDescent(int n) {
        return this.getLineMetricsAt(n).getDescent();
    }

    private float applyFunctionAtIndex(int n, Function function) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int n2 = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int n3 = n2 + this.fComponents[i].getNumCharacters();
            if (n3 > n) {
                return function.computeFunction(this, i, n - n2);
            }
            n2 = n3;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    public float getCharAdvance(int n) {
        return this.applyFunctionAtIndex(n, fgAdvanceF);
    }

    public float getCharXPosition(int n) {
        return this.applyFunctionAtIndex(n, fgXPositionF);
    }

    public float getCharYPosition(int n) {
        return this.applyFunctionAtIndex(n, fgYPositionF);
    }

    public float getCharLinePosition(int n) {
        return this.getCharXPosition(n);
    }

    public boolean caretAtOffsetIsValid(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative offset.");
        }
        int n2 = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int n3 = n2 + this.fComponents[i].getNumCharacters();
            if (n3 > n) {
                return this.fComponents[i].caretAtOffsetIsValid(n - n2);
            }
            n2 = n3;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    public Rectangle2D getCharBounds(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int n2 = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int n3 = n2 + this.fComponents[i].getNumCharacters();
            if (n3 > n) {
                TextLineComponent textLineComponent = this.fComponents[i];
                int n4 = n - n2;
                Rectangle2D rectangle2D = textLineComponent.getCharVisualBounds(n4);
                float f = 0.0f;
                if (this.fComponentVisualOrder == null) {
                    for (int j = 0; j < i; ++j) {
                        Rectangle2D rectangle2D2 = this.fComponents[j].getLogicalBounds();
                        f += (float)rectangle2D2.getWidth();
                    }
                } else {
                    int n5 = 0;
                    while (this.fComponentVisualOrder[n5] != i) {
                        int n6 = this.fComponentVisualOrder[n5];
                        Rectangle2D rectangle2D3 = this.fComponents[n6].getLogicalBounds();
                        f += (float)rectangle2D3.getWidth();
                        ++n5;
                    }
                }
                rectangle2D.setRect(rectangle2D.getX() + (double)f, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                return rectangle2D;
            }
            n2 = n3;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    private float getComponentShift(int n) {
        byte by = (byte)this.fComponents[n].getLineMetrics().getBaselineIndex();
        if (by >= 0) {
            return this.fBaselineOffsets[by];
        }
        TextLineMetrics textLineMetrics = this.getMetrics();
        LineMetrics lineMetrics = this.fComponents[n].getLineMetrics();
        if (by == -1) {
            return lineMetrics.getAscent() - textLineMetrics.ascent;
        }
        return textLineMetrics.descent - lineMetrics.getDescent();
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        float f3 = f;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int n = this.fComponentVisualOrder == null ? i : this.fComponentVisualOrder[i];
            TextLineComponent textLineComponent = this.fComponents[n];
            float f4 = this.getComponentShift(n);
            textLineComponent.draw(graphics2D, f3, f2 + f4);
            if (i == this.fComponents.length - 1) continue;
            Rectangle2D rectangle2D = textLineComponent.getLogicalBounds();
            f3 += (float)rectangle2D.getWidth();
        }
    }

    public Rectangle2D getBounds() {
        float f = 0.0f;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MAX_VALUE;
        float f5 = Float.MIN_VALUE;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int n = this.fComponentVisualOrder == null ? i : this.fComponentVisualOrder[i];
            TextLineComponent textLineComponent = this.fComponents[n];
            Rectangle2D rectangle2D = textLineComponent.getVisualBounds();
            f2 = Math.min(f2, (float)rectangle2D.getX() + f);
            f3 = Math.max(f3, (float)rectangle2D.getMaxX() + f);
            float f6 = this.getComponentShift(n);
            f4 = Math.min(f4, (float)rectangle2D.getY() + f6);
            f5 = Math.max(f5, (float)rectangle2D.getMaxY() + f6);
            Rectangle2D rectangle2D2 = textLineComponent.getLogicalBounds();
            f += (float)rectangle2D2.getWidth();
        }
        return new Rectangle2D.Float(f2, f4, f3 - f2, f5 - f4);
    }

    public Shape getOutline(AffineTransform affineTransform) {
        GeneralPath generalPath = new GeneralPath(1);
        float f = 0.0f;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int n = this.fComponentVisualOrder == null ? i : this.fComponentVisualOrder[i];
            TextLineComponent textLineComponent = this.fComponents[n];
            float f2 = this.getComponentShift(n);
            generalPath.append(textLineComponent.getOutline(f, f2), false);
            Rectangle2D rectangle2D = textLineComponent.getLogicalBounds();
            f += (float)rectangle2D.getWidth();
        }
        if (affineTransform != null) {
            generalPath.transform(affineTransform);
        }
        return generalPath;
    }

    public int hashCode() {
        return this.fComponents.length << 16 ^ this.fComponents[0].hashCode() << 3 ^ this.fCharsLimit - this.fCharsStart;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.fComponents.length; ++i) {
            stringBuffer.append(this.fComponents[i]);
        }
        return stringBuffer.toString();
    }

    public static TextLine fastCreateTextLine(FontRenderContext fontRenderContext, char[] cArray, Font font, LineMetrics lineMetrics, Map map) {
        int n;
        boolean bl = true;
        byte[] byArray = null;
        int[] nArray = null;
        Bidi bidi = null;
        int n2 = cArray.length;
        boolean bl2 = false;
        boolean bl3 = false;
        byte[] byArray2 = null;
        if (map != null) {
            Comparable<Boolean> comparable;
            try {
                comparable = (Boolean)map.get(TextAttribute.RUN_DIRECTION);
                if (comparable != null) {
                    bl3 = true;
                    bl = TextAttribute.RUN_DIRECTION_LTR.equals(comparable);
                    bl2 = !bl;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            try {
                comparable = (Integer)map.get(TextAttribute.BIDI_EMBEDDING);
                if (comparable != null && (n = ((Integer)comparable).intValue()) >= -61 && n < 62) {
                    byte by = (byte)n;
                    bl2 = true;
                    byArray2 = new byte[n2];
                    for (int i = 0; i < byArray2.length; ++i) {
                        byArray2[i] = by;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (!bl2) {
            bl2 = Bidi.requiresBidi(cArray, 0, cArray.length);
        }
        if (bl2) {
            int n3 = -2;
            if (bl3) {
                n3 = bl ? 0 : 1;
            }
            if (!(bidi = new Bidi(cArray, 0, byArray2, 0, cArray.length, n3)).isLeftToRight()) {
                byArray = BidiUtils.getLevels(bidi);
                int[] nArray2 = BidiUtils.createVisualToLogicalMap(byArray);
                nArray = BidiUtils.createInverseMap(nArray2);
                bl = bidi.baseIsLeftToRight();
            }
        }
        Decoration decoration = map != null ? Decoration.getDecoration(StyledParagraph.addInputMethodAttrs(map)) : Decoration.getPlainDecoration();
        n = 0;
        TextLabelFactory textLabelFactory = new TextLabelFactory(fontRenderContext, cArray, bidi, n);
        TextLineComponent[] textLineComponentArray = new TextLineComponent[1];
        textLineComponentArray = TextLine.createComponentsOnRun(0, cArray.length, cArray, nArray, byArray, textLabelFactory, font, lineMetrics, fontRenderContext, decoration, textLineComponentArray, 0);
        int n4 = textLineComponentArray.length;
        while (textLineComponentArray[n4 - 1] == null) {
            --n4;
        }
        if (n4 != textLineComponentArray.length) {
            TextLineComponent[] textLineComponentArray2 = new TextLineComponent[n4];
            System.arraycopy(textLineComponentArray, 0, textLineComponentArray2, 0, n4);
            textLineComponentArray = textLineComponentArray2;
        }
        return new TextLine(textLineComponentArray, lineMetrics.getBaselineOffsets(), cArray, 0, cArray.length, nArray, byArray, bl);
    }

    private static TextLineComponent[] expandArray(TextLineComponent[] textLineComponentArray) {
        TextLineComponent[] textLineComponentArray2 = new TextLineComponent[textLineComponentArray.length + 8];
        System.arraycopy(textLineComponentArray, 0, textLineComponentArray2, 0, textLineComponentArray.length);
        return textLineComponentArray2;
    }

    public static TextLineComponent[] createComponentsOnRun(int n, int n2, char[] cArray, int[] nArray, byte[] byArray, TextLabelFactory textLabelFactory, Font font, LineMetrics lineMetrics, FontRenderContext fontRenderContext, Decoration decoration, TextLineComponent[] textLineComponentArray, int n3) {
        int n4 = n;
        if (lineMetrics != null && lineMetrics.getNumChars() != n2 - n) {
            throw new IllegalArgumentException("Invalid LineMetrics");
        }
        do {
            int n5;
            int n6 = TextLine.firstVisualChunk(nArray, byArray, n4, n2);
            do {
                LineMetrics lineMetrics2;
                int n7 = n4;
                if (lineMetrics == null) {
                    lineMetrics2 = font.getLineMetrics(cArray, n7, n6, fontRenderContext);
                    n5 = lineMetrics2.getNumChars();
                } else {
                    lineMetrics2 = lineMetrics;
                    n5 = n6 - n7;
                }
                ExtendedTextLabel extendedTextLabel = textLabelFactory.createExtended(font, lineMetrics2, decoration, n7, n7 + n5);
                if (++n3 >= textLineComponentArray.length) {
                    textLineComponentArray = TextLine.expandArray(textLineComponentArray);
                }
                textLineComponentArray[n3 - 1] = extendedTextLabel;
            } while ((n4 += n5) < n6);
        } while (n4 < n2);
        return textLineComponentArray;
    }

    public static TextLineComponent[] getComponents(StyledParagraph styledParagraph, char[] cArray, int n, int n2, int[] nArray, byte[] byArray, TextLabelFactory textLabelFactory) {
        TextLineComponent[] textLineComponentArray;
        FontRenderContext fontRenderContext = textLabelFactory.getFontRenderContext();
        int n3 = 0;
        TextLineComponent[] textLineComponentArray2 = new TextLineComponent[1];
        int n4 = n;
        do {
            Object object;
            int n5 = Math.min(styledParagraph.getRunLimit(n4), n2);
            Decoration decoration = styledParagraph.getDecorationAt(n4);
            Object object2 = styledParagraph.getFontOrGraphicAt(n4);
            if (object2 instanceof GraphicAttribute) {
                object = (GraphicAttribute)object2;
                do {
                    int n6 = TextLine.firstVisualChunk(nArray, byArray, n4, n5);
                    GraphicComponent graphicComponent = new GraphicComponent((GraphicAttribute)object, decoration, nArray, byArray, n4, n6);
                    n4 = n6;
                    if (++n3 >= textLineComponentArray2.length) {
                        textLineComponentArray2 = TextLine.expandArray(textLineComponentArray2);
                    }
                    textLineComponentArray2[n3 - 1] = graphicComponent;
                } while (n4 < n5);
                continue;
            }
            object = (Font)object2;
            textLineComponentArray2 = TextLine.createComponentsOnRun(n4, n5, cArray, nArray, byArray, textLabelFactory, (Font)object, null, fontRenderContext, decoration, textLineComponentArray2, n3);
            n4 = n5;
            n3 = textLineComponentArray2.length;
            while (textLineComponentArray2[n3 - 1] == null) {
                --n3;
            }
        } while (n4 < n2);
        if (textLineComponentArray2.length == n3) {
            textLineComponentArray = textLineComponentArray2;
        } else {
            textLineComponentArray = new TextLineComponent[n3];
            System.arraycopy(textLineComponentArray2, 0, textLineComponentArray, 0, n3);
        }
        return textLineComponentArray;
    }

    public static TextLine createLineFromText(char[] cArray, StyledParagraph styledParagraph, TextLabelFactory textLabelFactory, boolean bl, float[] fArray) {
        Object[] objectArray;
        textLabelFactory.setLineContext(0, cArray.length);
        Bidi bidi = textLabelFactory.getLineBidi();
        int[] nArray = null;
        byte[] byArray = null;
        if (bidi != null) {
            byArray = BidiUtils.getLevels(bidi);
            objectArray = BidiUtils.createVisualToLogicalMap(byArray);
            nArray = BidiUtils.createInverseMap(objectArray);
        }
        objectArray = TextLine.getComponents(styledParagraph, cArray, 0, cArray.length, nArray, byArray, textLabelFactory);
        return new TextLine((TextLineComponent[])objectArray, fArray, cArray, 0, cArray.length, nArray, byArray, bl);
    }

    private static int[] computeComponentOrder(TextLineComponent[] textLineComponentArray, int[] nArray) {
        int[] nArray2 = null;
        if (nArray != null && textLineComponentArray.length > 1) {
            nArray2 = new int[textLineComponentArray.length];
            int n = 0;
            for (int i = 0; i < textLineComponentArray.length; ++i) {
                nArray2[i] = nArray[n];
                n += textLineComponentArray[i].getNumCharacters();
            }
            nArray2 = BidiUtils.createContiguousOrder(nArray2);
            nArray2 = BidiUtils.createInverseMap(nArray2);
        }
        return nArray2;
    }

    public static TextLine standardCreateTextLine(FontRenderContext fontRenderContext, AttributedCharacterIterator attributedCharacterIterator, char[] cArray, float[] fArray) {
        StyledParagraph styledParagraph = new StyledParagraph(attributedCharacterIterator, cArray);
        Bidi bidi = new Bidi(attributedCharacterIterator);
        if (bidi.isLeftToRight()) {
            bidi = null;
        }
        int n = 0;
        TextLabelFactory textLabelFactory = new TextLabelFactory(fontRenderContext, cArray, bidi, n);
        boolean bl = true;
        if (bidi != null) {
            bl = bidi.baseIsLeftToRight();
        }
        return TextLine.createLineFromText(cArray, styledParagraph, textLabelFactory, bl, fArray);
    }

    static boolean advanceToFirstFont(AttributedCharacterIterator attributedCharacterIterator) {
        char c = attributedCharacterIterator.first();
        while (true) {
            if (c == '\uffff') break;
            if (attributedCharacterIterator.getAttribute(TextAttribute.CHAR_REPLACEMENT) == null) {
                return true;
            }
            c = attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
        }
        return false;
    }

    static float[] getNormalizedOffsets(float[] fArray, byte by) {
        if (fArray[by] != 0.0f) {
            float f = fArray[by];
            float[] fArray2 = new float[fArray.length];
            for (int i = 0; i < fArray2.length; ++i) {
                fArray2[i] = fArray[i] - f;
            }
            fArray = fArray2;
        }
        return fArray;
    }

    static Font getFontAtCurrentPos(AttributedCharacterIterator attributedCharacterIterator) {
        char c = attributedCharacterIterator.current();
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.FONT);
        if (object != null) {
            return (Font)object;
        }
        if (attributedCharacterIterator.getAttribute(TextAttribute.FAMILY) != null) {
            return Font.getFont(attributedCharacterIterator.getAttributes());
        }
        FontResolver fontResolver = FontResolver.getInstance();
        return fontResolver.getFont(fontResolver.getFontIndex(c), attributedCharacterIterator.getAttributes());
    }

    static float getJustifyRatio(Map map) {
        Object v = map.get(TextAttribute.JUSTIFICATION);
        if (v == null) {
            return 1.0f;
        }
        float f = ((Float)v).floatValue();
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private static int firstVisualChunk(int[] nArray, byte[] byArray, int n, int n2) {
        if (nArray != null && byArray != null) {
            byte by = byArray[n];
            while (++n < n2 && byArray[n] == by) {
            }
            return n;
        }
        return n2;
    }

    public TextLine getJustifiedLine(float f, float f2, int n, int n2) {
        int n3;
        TextLineComponent[] textLineComponentArray = new TextLineComponent[this.fComponents.length];
        System.arraycopy(this.fComponents, 0, textLineComponentArray, 0, this.fComponents.length);
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl = false;
        block0: do {
            int n4;
            int n5;
            int n6;
            f4 = TextLine.getAdvanceBetween(textLineComponentArray, 0, this.characterCount());
            float f6 = TextLine.getAdvanceBetween(textLineComponentArray, n, n2);
            f5 = (f - f6) * f2;
            int[] nArray = new int[textLineComponentArray.length];
            int n7 = 0;
            for (int i = 0; i < textLineComponentArray.length; ++i) {
                n6 = this.fComponentVisualOrder == null ? i : this.fComponentVisualOrder[i];
                nArray[n6] = n7;
                n7 += textLineComponentArray[n6].getNumJustificationInfos();
            }
            GlyphJustificationInfo[] glyphJustificationInfoArray = new GlyphJustificationInfo[n7];
            n6 = 0;
            for (n5 = 0; n5 < textLineComponentArray.length; ++n5) {
                TextLineComponent textLineComponent = textLineComponentArray[n5];
                int n8 = textLineComponent.getNumCharacters();
                int n9 = n6 + n8;
                if (n9 <= n) continue;
                n4 = Math.max(0, n - n6);
                n3 = Math.min(n8, n2 - n6);
                textLineComponent.getJustificationInfos(glyphJustificationInfoArray, nArray[n5], n4, n3);
                if (n9 >= n2) break;
            }
            int n10 = n7;
            for (n5 = 0; n5 < n10 && glyphJustificationInfoArray[n5] == null; ++n5) {
            }
            while (n10 > n5 && glyphJustificationInfoArray[n10 - 1] == null) {
                --n10;
            }
            TextJustifier textJustifier = new TextJustifier(glyphJustificationInfoArray, n5, n10);
            float[] fArray = textJustifier.justify(f5);
            n4 = !bl ? 1 : 0;
            n3 = 0;
            boolean[] blArray = new boolean[1];
            n6 = 0;
            for (int i = 0; i < textLineComponentArray.length; ++i) {
                TextLineComponent textLineComponent = textLineComponentArray[i];
                int n11 = textLineComponent.getNumCharacters();
                int n12 = n6 + n11;
                if (n12 <= n) continue;
                int n13 = Math.max(0, n - n6);
                int n14 = Math.min(n11, n2 - n6);
                textLineComponentArray[i] = textLineComponent.applyJustificationDeltas(fArray, nArray[i] * 2, blArray);
                n3 |= blArray[0];
                if (n12 >= n2) continue block0;
            }
        } while (bl = n3 != 0 && !bl);
        return new TextLine(textLineComponentArray, this.fBaselineOffsets, this.fChars, this.fCharsStart, this.fCharsLimit, this.fCharLogicalOrder, this.fCharLevels, this.fIsDirectionLTR);
    }

    public static float getAdvanceBetween(TextLineComponent[] textLineComponentArray, int n, int n2) {
        float f = 0.0f;
        int n3 = 0;
        for (int i = 0; i < textLineComponentArray.length; ++i) {
            TextLineComponent textLineComponent = textLineComponentArray[i];
            int n4 = textLineComponent.getNumCharacters();
            int n5 = n3 + n4;
            if (n5 > n) {
                int n6 = Math.max(0, n - n3);
                int n7 = Math.min(n4, n2 - n3);
                f += textLineComponent.getAdvanceBetween(n6, n7);
                if (n5 >= n2) break;
            }
            n3 = n5;
        }
        return f;
    }

    private static abstract class Function {
        private Function() {
        }

        abstract float computeFunction(TextLine var1, int var2, int var3);
    }

    static final class TextLineMetrics {
        public final float ascent;
        public final float descent;
        public final float leading;
        public final float advance;

        public TextLineMetrics(float f, float f2, float f3, float f4) {
            this.ascent = f;
            this.descent = f2;
            this.leading = f3;
            this.advance = f4;
        }
    }
}

