/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.VolatileImage;

public abstract class GraphicsConfiguration {
    private static BufferCapabilities defaultBufferCaps;
    private static ImageCapabilities defaultImageCaps;

    protected GraphicsConfiguration() {
    }

    public abstract GraphicsDevice getDevice();

    public abstract BufferedImage createCompatibleImage(int var1, int var2);

    public abstract VolatileImage createCompatibleVolatileImage(int var1, int var2);

    public VolatileImage createCompatibleVolatileImage(int n, int n2, ImageCapabilities imageCapabilities) throws AWTException {
        return this.createCompatibleVolatileImage(n, n2);
    }

    public abstract BufferedImage createCompatibleImage(int var1, int var2, int var3);

    public abstract ColorModel getColorModel();

    public abstract ColorModel getColorModel(int var1);

    public abstract AffineTransform getDefaultTransform();

    public abstract AffineTransform getNormalizingTransform();

    public abstract Rectangle getBounds();

    public BufferCapabilities getBufferCapabilities() {
        if (defaultBufferCaps == null) {
            defaultBufferCaps = new DefaultBufferCapabilities(this.getImageCapabilities());
        }
        return defaultBufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        if (defaultImageCaps == null) {
            defaultImageCaps = new ImageCapabilities(false);
        }
        return defaultImageCaps;
    }

    private static class DefaultBufferCapabilities
    extends BufferCapabilities {
        public DefaultBufferCapabilities(ImageCapabilities imageCapabilities) {
            super(imageCapabilities, imageCapabilities, null);
        }
    }
}

