/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import sun.awt.NativeLibLoader;
import sun.awt.font.NativeFontWrapper;
import sun.awt.font.StandardGlyphVector;
import sun.java2d.FontSupport;
import sun.java2d.SunGraphicsEnvironment;

public class Font
implements Serializable {
    private Hashtable fRequestedAttributes;
    private static final Map EMPTY_MAP;
    private static final TransformAttribute IDENT_TX_ATTRIBUTE;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    protected String name;
    protected int style;
    protected int size;
    protected float pointSize;
    private transient FontPeer peer;
    private transient long pData;
    private transient long pNativeFont;
    private transient boolean createdFont = false;
    private transient int numGlyphs = -1;
    private transient int missingGlyph = -1;
    private transient int canRotate = -1;
    private transient double[] matrix;
    private transient boolean nonIdentityTx;
    private static final long serialVersionUID = -4206021311591459213L;
    private static SoftReference cacheRef;
    private int fontSerializedDataVersion = 1;
    private static double[] cachedMat;
    public static final int LAYOUT_LEFT_TO_RIGHT = 0;
    public static final int LAYOUT_RIGHT_TO_LEFT = 1;
    public static final int LAYOUT_NO_START_CONTEXT = 2;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 4;

    public FontPeer getPeer() {
        return this.getPeer_NoClientCode();
    }

    final FontPeer getPeer_NoClientCode() {
        if (this.peer == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.peer = toolkit.getFontPeer(this.name + "." + this.size, this.style);
        }
        return this.peer;
    }

    private void initializeFont(Hashtable hashtable) {
        Object object;
        if (this.name == null) {
            this.name = "Default";
        }
        if (hashtable == null) {
            this.fRequestedAttributes = new Hashtable(5, 0.9f);
            this.fRequestedAttributes.put(TextAttribute.TRANSFORM, IDENT_TX_ATTRIBUTE);
            this.fRequestedAttributes.put(TextAttribute.FAMILY, this.name);
            this.fRequestedAttributes.put(TextAttribute.SIZE, new Float(this.size));
            this.fRequestedAttributes.put(TextAttribute.WEIGHT, (this.style & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            this.fRequestedAttributes.put(TextAttribute.POSTURE, (this.style & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        } else {
            object = this.fRequestedAttributes.get(TextAttribute.TRANSFORM);
            if (object instanceof TransformAttribute) {
                this.nonIdentityTx = !((TransformAttribute)object).isIdentity();
            } else if (object instanceof AffineTransform) {
                this.nonIdentityTx = !((AffineTransform)object).isIdentity();
            }
        }
        object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String string = this.name;
        if (object instanceof FontSupport && !this.createdFont) {
            string = ((FontSupport)object).mapFontName(this.name, this.style);
        }
        NativeFontWrapper.initializeFont(this, string, this.style);
    }

    public Font(String string, int n, int n2) {
        this.name = string;
        this.style = (n & 0xFFFFFFFC) == 0 ? n : 0;
        this.size = n2;
        this.pointSize = n2;
        this.initializeFont(null);
    }

    private Font(String string, int n, int n2, boolean bl) {
        this.createdFont = bl;
        this.name = string;
        this.style = (n & 0xFFFFFFFC) == 0 ? n : 0;
        this.size = n2;
        this.pointSize = n2;
        this.initializeFont(null);
    }

    private Font(String string, int n, float f, boolean bl) {
        this.createdFont = bl;
        this.name = string;
        this.style = (n & 0xFFFFFFFC) == 0 ? n : 0;
        this.size = (int)((double)f + 0.5);
        this.pointSize = f;
        this.initializeFont(null);
    }

    public Font(Map map) {
        this.initFromMap(map);
    }

    private Font(Map map, boolean bl) {
        this.createdFont = bl;
        this.initFromMap(map);
    }

    private void initFromMap(Map map) {
        this.name = "Dialog";
        this.pointSize = 12.0f;
        this.size = 12;
        if (map != null && !((Object)map).equals(EMPTY_MAP)) {
            this.fRequestedAttributes = new Hashtable(map);
            Object v = map.get(TextAttribute.FAMILY);
            if (v != null) {
                this.name = (String)v;
            }
            if ((v = map.get(TextAttribute.WEIGHT)) != null && v.equals(TextAttribute.WEIGHT_BOLD)) {
                this.style |= 1;
            }
            if ((v = map.get(TextAttribute.POSTURE)) != null && v.equals(TextAttribute.POSTURE_OBLIQUE)) {
                this.style |= 2;
            }
            if ((v = map.get(TextAttribute.SIZE)) != null) {
                this.pointSize = ((Float)v).floatValue();
                this.size = (int)((double)this.pointSize + 0.5);
            }
        }
        this.initializeFont(this.fRequestedAttributes);
    }

    public static Font getFont(Map map) {
        Font font = (Font)map.get(TextAttribute.FONT);
        if (font != null) {
            return font;
        }
        return Font.get(new Key(map));
    }

    private static Font get(Key key) {
        Font font = null;
        HashMap<Key, Font> hashMap = (HashMap<Key, Font>)cacheRef.get();
        if (hashMap == null) {
            hashMap = new HashMap<Key, Font>();
            cacheRef = new SoftReference(hashMap);
        } else {
            font = (Font)hashMap.get(key);
        }
        if (font == null) {
            font = new Font(key.attrs);
            hashMap.put(key, font);
        }
        return font;
    }

    public static Font createFont(int n, InputStream inputStream) throws FontFormatException, IOException {
        if (n != 0) {
            throw new IllegalArgumentException("font format not recognized");
        }
        final File file = (File)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File file = null;
                try {
                    file = File.createTempFile("+~JF", ".tmp", null);
                    file.deleteOnExit();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return file;
            }
        });
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = new BufferedInputStream(inputStream);
        FileOutputStream fileOutputStream = (FileOutputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return fileOutputStream;
            }
        });
        int n2 = 0;
        int n3 = 8192;
        byte[] byArray = new byte[n3];
        while (n2 != -1) {
            n2 = bufferedInputStream.read(byArray, 0, n3);
            if (n2 == -1) continue;
            fileOutputStream.write(byArray, 0, n2);
        }
        bufferedInputStream.close();
        fileOutputStream.close();
        String string = SunGraphicsEnvironment.createFont(file);
        if (string == null) {
            throw new FontFormatException("Unable to create font - bad font data");
        }
        Font font = new Font(string, 0, 1, true);
        return font;
    }

    public AffineTransform getTransform() {
        Object object = this.fRequestedAttributes.get(TextAttribute.TRANSFORM);
        if (object != null) {
            if (object instanceof TransformAttribute) {
                return ((TransformAttribute)object).getTransform();
            }
            if (object instanceof AffineTransform) {
                return new AffineTransform((AffineTransform)object);
            }
        } else {
            object = new AffineTransform();
        }
        return (AffineTransform)object;
    }

    public String getFamily() {
        return this.getFamily_NoClientCode();
    }

    final String getFamily_NoClientCode() {
        return this.getFamily(Locale.getDefault());
    }

    public String getFamily(Locale locale) {
        if (SunGraphicsEnvironment.isLogicalFont(this.name)) {
            return this.name;
        }
        short s = NativeFontWrapper.getLCIDFromLocale(locale);
        return NativeFontWrapper.getFamilyName(this, s);
    }

    public String getPSName() {
        String string = NativeFontWrapper.getPostscriptName(this);
        return string == null ? this.getFontName() : string;
    }

    public String getName() {
        return new String(this.name);
    }

    public String getFontName() {
        return this.getFontName(Locale.getDefault());
    }

    public String getFontName(Locale locale) {
        if (SunGraphicsEnvironment.isLogicalFont(this.name)) {
            return this.name + "." + SunGraphicsEnvironment.styleStr(this.style);
        }
        short s = NativeFontWrapper.getLCIDFromLocale(locale);
        return NativeFontWrapper.getFullName(this, s);
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public float getSize2D() {
        return this.pointSize;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isTransformed() {
        return this.nonIdentityTx;
    }

    public static Font getFont(String string) {
        return Font.getFont(string, null);
    }

    public static Font decode(String string) {
        String string2 = string;
        int n = 12;
        int n2 = 0;
        if (string == null) {
            return new Font("dialog", n2, n);
        }
        int n3 = string.indexOf(45);
        if (n3 >= 0) {
            string2 = string.substring(0, n3);
            string = string.substring(n3 + 1);
            int n4 = (string = string.toLowerCase()).indexOf("bold-italic");
            if (n4 != -1) {
                n2 = 3;
            }
            if (n4 == -1 && (n4 = string.indexOf("bolditalic")) != -1) {
                n2 = 3;
            }
            if (n4 == -1 && (n4 = string.indexOf("bold")) != -1) {
                n2 = 1;
            }
            if (n4 == -1 && (n4 = string.indexOf("italic")) != -1) {
                n2 = 2;
            }
            if ((n4 = string.lastIndexOf("-")) != -1) {
                string = string.substring(n4 + 1);
            }
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n3 == -1) {
            n2 = 0;
            n = 12;
            int n5 = (string = string.toLowerCase()).indexOf("bolditalic");
            if (n5 != -1) {
                n2 = 3;
            }
            if (n5 == -1 && (n5 = string.indexOf("bold italic")) != -1) {
                n2 = 3;
            }
            if (n5 == -1 && (n5 = string.indexOf("bold")) != -1) {
                n2 = 1;
            }
            if (n5 == -1 && (n5 = string.indexOf("italic")) != -1) {
                n2 = 2;
            }
            if (n5 != -1) {
                string2 = string2.substring(0, n5);
                string2 = string2.trim();
            }
            if ((n5 = string.lastIndexOf(" ")) != -1) {
                String string3 = string.substring(n5);
                string3 = string3.trim();
                try {
                    n = Integer.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new Font(string2, n2, n);
    }

    public static Font getFont(String string, Font font) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 == null) {
            return font;
        }
        return Font.decode(string2);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.style ^ this.size;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            try {
                Font font = (Font)object;
                double[] dArray = this.getMatrix();
                double[] dArray2 = font.getMatrix();
                return this.size == font.size && this.pointSize == font.pointSize && this.style == font.style && this.name.equals(font.name) && dArray[0] == dArray2[0] && dArray[1] == dArray2[1] && dArray[2] == dArray2[2] && dArray[3] == dArray2[3];
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        String string = this.isBold() ? (this.isItalic() ? "bolditalic" : "bold") : (this.isItalic() ? "italic" : "plain");
        return this.getClass().getName() + "[family=" + this.getFamily() + ",name=" + this.name + ",style=" + string + ",size=" + this.size + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.pointSize == 0.0f) {
            this.pointSize = this.size;
        }
        this.initializeFont(this.fRequestedAttributes);
    }

    public int getNumGlyphs() {
        if (this.numGlyphs == -1) {
            this.numGlyphs = NativeFontWrapper.getNumGlyphs(this);
        }
        return this.numGlyphs;
    }

    public int getMissingGlyphCode() {
        if (this.missingGlyph == -1) {
            this.missingGlyph = NativeFontWrapper.getMissingGlyphCode(this);
        }
        return this.missingGlyph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getMatrix() {
        if (this.matrix == null) {
            double d = this.getSize2D();
            if (this.nonIdentityTx) {
                AffineTransform affineTransform = this.getTransform();
                affineTransform.scale(d, d);
                this.matrix = new double[]{affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY()};
            } else {
                Class clazz = Font.class;
                synchronized (clazz) {
                    double[] dArray = cachedMat;
                    if (dArray == null || dArray[0] != d) {
                        dArray = new double[]{d, 0.0, 0.0, d};
                        cachedMat = dArray;
                    }
                    this.matrix = dArray;
                }
            }
        }
        return this.matrix;
    }

    public byte getBaselineFor(char c) {
        return NativeFontWrapper.getBaselineFor(this, c);
    }

    public Map getAttributes() {
        return (Map)this.fRequestedAttributes.clone();
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        AttributedCharacterIterator.Attribute[] attributeArray = new AttributedCharacterIterator.Attribute[]{TextAttribute.FAMILY, TextAttribute.WEIGHT, TextAttribute.POSTURE, TextAttribute.SIZE, TextAttribute.TRANSFORM};
        return attributeArray;
    }

    public Font deriveFont(int n, float f) {
        Hashtable hashtable = (Hashtable)this.fRequestedAttributes.clone();
        Font.applyStyle(n, hashtable);
        Font.applySize(f, hashtable);
        return new Font(hashtable, this.createdFont);
    }

    public Font deriveFont(int n, AffineTransform affineTransform) {
        Hashtable hashtable = (Hashtable)this.fRequestedAttributes.clone();
        Font.applyStyle(n, hashtable);
        Font.applyTransform(affineTransform, hashtable);
        return new Font(hashtable, this.createdFont);
    }

    public Font deriveFont(float f) {
        Hashtable hashtable = (Hashtable)this.fRequestedAttributes.clone();
        Font.applySize(f, hashtable);
        return new Font(hashtable, this.createdFont);
    }

    public Font deriveFont(AffineTransform affineTransform) {
        Hashtable hashtable = (Hashtable)this.fRequestedAttributes.clone();
        Font.applyTransform(affineTransform, hashtable);
        return new Font(hashtable, this.createdFont);
    }

    public Font deriveFont(int n) {
        Hashtable hashtable = (Hashtable)this.fRequestedAttributes.clone();
        Font.applyStyle(n, hashtable);
        return new Font(hashtable, this.createdFont);
    }

    public Font deriveFont(Map map) {
        if (map == null || map.size() == 0) {
            return this;
        }
        Hashtable hashtable = new Hashtable(this.getAttributes());
        AttributedCharacterIterator.Attribute[] attributeArray = this.getAvailableAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            Object v = map.get(attributeArray[i]);
            if (v == null) continue;
            hashtable.put(attributeArray[i], v);
        }
        return new Font(hashtable, this.createdFont);
    }

    public boolean canDisplay(char c) {
        return NativeFontWrapper.canDisplay(this, c);
    }

    public int canDisplayUpTo(String string) {
        return this.canDisplayUpTo(new StringCharacterIterator(string), 0, string.length());
    }

    public int canDisplayUpTo(char[] cArray, int n, int n2) {
        while (n < n2 && this.canDisplay(cArray[n])) {
            ++n;
        }
        return n == n2 ? -1 : n;
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n, int n2) {
        int n3 = characterIterator.setIndex(n);
        while (characterIterator.getIndex() < n2 && this.canDisplay((char)n3)) {
            n3 = characterIterator.next();
        }
        n3 = characterIterator.getIndex();
        return n3 == n2 ? -1 : n3;
    }

    public float getItalicAngle() {
        double[] dArray = this.getMatrix();
        return NativeFontWrapper.getItalicAngle(this, dArray, false, false);
    }

    public boolean hasUniformLineMetrics() {
        return false;
    }

    private FontLineMetrics defaultLineMetrics(FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = new FontLineMetrics();
        double[] dArray = this.getMatrix();
        float[] fArray = new float[4];
        NativeFontWrapper.getFontMetrics(this, dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), fArray);
        fontLineMetrics.ascent = fArray[0];
        fontLineMetrics.descent = fArray[1];
        fontLineMetrics.leading = fArray[2];
        fontLineMetrics.height = fArray[0] + fArray[1] + fArray[2];
        fontLineMetrics.baselineIndex = 0;
        fontLineMetrics.baselineOffsets = new float[3];
        fontLineMetrics.baselineOffsets[0] = 0.0f;
        fontLineMetrics.strikethroughOffset = -(fontLineMetrics.ascent / 3.0f);
        fontLineMetrics.strikethroughThickness = this.pointSize / 12.0f;
        fontLineMetrics.underlineOffset = 0.0f;
        fontLineMetrics.underlineThickness = this.pointSize / 12.0f;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        fontLineMetrics.numchars = string.length();
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(String string, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext) {
        char[] cArray = string.toCharArray();
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getStringBounds(String string, int n, int n2, FontRenderContext fontRenderContext) {
        String string2 = string.substring(n, n2);
        return this.getStringBounds(string2, fontRenderContext);
    }

    public Rectangle2D getStringBounds(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginIndex: " + n);
        }
        if (n2 > cArray.length) {
            throw new IndexOutOfBoundsException("limit: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("range length: " + (n2 - n));
        }
        boolean bl = true;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (c < '\u0590' || c > '\u206f') continue;
            bl = false;
            break;
        }
        if (bl) {
            StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this, cArray, n, n2 - n, fontRenderContext);
            return ((GlyphVector)standardGlyphVector).getLogicalBounds();
        }
        String string = new String(cArray, n, n2 - n);
        TextLayout textLayout = new TextLayout(string, this, fontRenderContext);
        return new Rectangle2D.Float(0.0f, -textLayout.getAscent(), textLayout.getAdvance(), textLayout.getDescent() + textLayout.getLeading());
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        int n3 = characterIterator.getBeginIndex();
        int n4 = characterIterator.getEndIndex();
        if (n < n3) {
            throw new IndexOutOfBoundsException("beginIndex: " + n);
        }
        if (n2 > n4) {
            throw new IndexOutOfBoundsException("limit: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("range length: " + (n2 - n));
        }
        char[] cArray = new char[n2 - n];
        characterIterator.setIndex(n);
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = characterIterator.current();
            characterIterator.next();
        }
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext fontRenderContext) {
        double[] dArray = this.getMatrix();
        float[] fArray = new float[4];
        NativeFontWrapper.getFontMetrics(this, dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), fArray);
        return new Rectangle2D.Float(0.0f, -fArray[0], fArray[3], fArray[0] + fArray[1] + fArray[2]);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        return new StandardGlyphVector(this, string, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        return new StandardGlyphVector(this, cArray, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return new StandardGlyphVector(this, characterIterator, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray) {
        return new StandardGlyphVector(this, nArray, fontRenderContext);
    }

    public GlyphVector layoutGlyphVector(FontRenderContext fontRenderContext, char[] cArray, int n, int n2, int n3) {
        return new StandardGlyphVector(this, cArray, n, n2 - n, n3, fontRenderContext);
    }

    private static void applyTransform(AffineTransform affineTransform, Map map) {
        if (affineTransform == null) {
            throw new IllegalArgumentException("transform must not be null");
        }
        if (affineTransform.isIdentity()) {
            map.remove(TextAttribute.TRANSFORM);
        } else {
            map.put(TextAttribute.TRANSFORM, new TransformAttribute(affineTransform));
        }
    }

    private static void applyStyle(int n, Map map) {
        if ((n & 1) != 0) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            map.remove(TextAttribute.WEIGHT);
        }
        if ((n & 2) != 0) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            map.remove(TextAttribute.POSTURE);
        }
    }

    private static void applySize(float f, Map map) {
        map.put(TextAttribute.SIZE, new Float(f));
    }

    private static native void initIDs();

    private native void pDispose();

    protected void finalize() throws Throwable {
        if (this.peer != null) {
            this.pDispose();
        }
        super.finalize();
    }

    static {
        NativeLibLoader.loadLibraries();
        Font.initIDs();
        EMPTY_MAP = new Hashtable(5, 0.9f);
        IDENT_TX_ATTRIBUTE = new TransformAttribute(new AffineTransform());
        cacheRef = new SoftReference(new HashMap());
    }

    private final class FontLineMetrics
    extends LineMetrics {
        int numchars;
        float ascent;
        float descent;
        float leading;
        float height;
        int baselineIndex;
        float[] baselineOffsets;
        float strikethroughOffset;
        float strikethroughThickness;
        float underlineOffset;
        float underlineThickness;

        private FontLineMetrics() {
        }

        public final int getNumChars() {
            return this.numchars;
        }

        public final float getAscent() {
            return this.ascent;
        }

        public final float getDescent() {
            return this.descent;
        }

        public final float getLeading() {
            return this.leading;
        }

        public final float getHeight() {
            return this.height;
        }

        public final int getBaselineIndex() {
            return this.baselineIndex;
        }

        public final float[] getBaselineOffsets() {
            return this.baselineOffsets;
        }

        public final float getStrikethroughOffset() {
            return this.strikethroughOffset;
        }

        public final float getStrikethroughThickness() {
            return this.strikethroughThickness;
        }

        public final float getUnderlineOffset() {
            return this.underlineOffset;
        }

        public final float getUnderlineThickness() {
            return this.underlineThickness;
        }

        public final boolean equals(Object object) {
            if (object != null) {
                if (this == object) {
                    return true;
                }
                try {
                    FontLineMetrics fontLineMetrics = (FontLineMetrics)object;
                    return this.ascent == fontLineMetrics.ascent && this.descent == fontLineMetrics.descent && this.leading == fontLineMetrics.leading && this.baselineIndex == fontLineMetrics.baselineIndex && this.baselineOffsets[0] == fontLineMetrics.baselineOffsets[0] && this.baselineOffsets[1] == fontLineMetrics.baselineOffsets[1] && this.baselineOffsets[2] == fontLineMetrics.baselineOffsets[2] && this.strikethroughOffset == fontLineMetrics.strikethroughOffset && this.strikethroughThickness == fontLineMetrics.strikethroughThickness && this.underlineOffset == fontLineMetrics.underlineOffset && this.underlineThickness == fontLineMetrics.underlineThickness;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static class Key {
        String family = "Dialog";
        float weight = 1.0f;
        float posture = 0.0f;
        float size = 12.0f;
        double[] txdata = null;
        Map attrs;
        int hashCode = 0;

        Key(Map map) {
            float f;
            this.attrs = map;
            Object v = map.get(TextAttribute.FAMILY);
            if (v != null) {
                this.family = (String)v;
            }
            this.hashCode = this.family.hashCode();
            v = map.get(TextAttribute.WEIGHT);
            if (v != null && v != TextAttribute.WEIGHT_REGULAR && (f = ((Float)v).floatValue()) == TextAttribute.WEIGHT_BOLD.floatValue()) {
                this.weight = f;
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.weight);
            }
            if ((v = map.get(TextAttribute.POSTURE)) != null && v != TextAttribute.POSTURE_REGULAR && (f = ((Float)v).floatValue()) == TextAttribute.POSTURE_OBLIQUE.floatValue()) {
                this.posture = f;
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.posture);
            }
            if ((v = map.get(TextAttribute.SIZE)) != null) {
                this.size = ((Float)v).floatValue();
                if (this.size != 12.0f) {
                    this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.size);
                }
            }
            if ((v = map.get(TextAttribute.TRANSFORM)) != null) {
                AffineTransform affineTransform;
                AffineTransform affineTransform2 = null;
                if (v instanceof TransformAttribute) {
                    TransformAttribute transformAttribute = (TransformAttribute)v;
                    if (!transformAttribute.isIdentity()) {
                        affineTransform2 = transformAttribute.getTransform();
                    }
                } else if (v instanceof AffineTransform && !(affineTransform = (AffineTransform)v).isIdentity()) {
                    affineTransform2 = affineTransform;
                }
                if (affineTransform2 != null) {
                    this.txdata = new double[6];
                    affineTransform2.getMatrix(this.txdata);
                    this.hashCode = this.hashCode << 3 ^ new Double(this.txdata[0]).hashCode();
                }
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            Key key = (Key)object;
            if (this.hashCode == key.hashCode && this.size == key.size && this.weight == key.weight && this.posture == key.posture && this.family.equals(key.family) && this.txdata == null == (key.txdata == null)) {
                if (this.txdata != null) {
                    for (int i = 0; i < this.txdata.length; ++i) {
                        if (this.txdata[i] == key.txdata[i]) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

