/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.DirectAudioDeviceProvider;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

class DirectAudioDevice
extends AbstractMixer {
    private static final int CLIP_BUFFER_TIME = 1000;
    private static final int DEFAULT_LINE_BUFFER_TIME = 500;
    private int deviceCountOpened = 0;
    private int deviceCountStarted = 0;

    DirectAudioDevice(DirectAudioDeviceProvider.DirectAudioDeviceInfo directAudioDeviceInfo) {
        super(directAudioDeviceInfo, null, null, null);
        DataLine.Info info = this.createDataLineInfo(true);
        if (info != null) {
            this.sourceLineInfo = new Line.Info[2];
            this.sourceLineInfo[0] = info;
            this.sourceLineInfo[1] = new DirectDLI(Clip.class, info.getFormats(), 32, -1);
        } else {
            this.sourceLineInfo = new Line.Info[0];
        }
        DataLine.Info info2 = this.createDataLineInfo(false);
        if (info2 != null) {
            this.targetLineInfo = new Line.Info[1];
            this.targetLineInfo[0] = info2;
        } else {
            this.targetLineInfo = new Line.Info[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataLine.Info createDataLineInfo(boolean bl) {
        Vector vector = new Vector();
        AudioFormat[] audioFormatArray = null;
        Vector vector2 = vector;
        synchronized (vector2) {
            DirectAudioDevice.nGetFormats(this.getMixerIndex(), this.getDeviceID(), bl, vector);
            if (vector.size() > 0) {
                audioFormatArray = new AudioFormat[vector.size()];
                for (int i = 0; i < audioFormatArray.length; ++i) {
                    audioFormatArray[i] = (AudioFormat)vector.elementAt(i);
                }
            }
        }
        if (audioFormatArray != null) {
            Class clazz = bl ? SourceDataLine.class : TargetDataLine.class;
            return new DirectDLI(clazz, audioFormatArray, 32, -1);
        }
        return null;
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info2 instanceof DataLine.Info) {
            DataLine.Info info3 = (DataLine.Info)info;
            DataLine.Info info4 = (DataLine.Info)info2;
            if (info3.getLineClass().isAssignableFrom(DirectSDL.class)) {
                return new DirectSDL(info4, this);
            }
            if (info3.getLineClass().isAssignableFrom(DirectClip.class)) {
                return new DirectClip(info4, this);
            }
            if (info3.getLineClass().isAssignableFrom(DirectTDL.class)) {
                return new DirectTDL(info4, this);
            }
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof DataLine.Info) {
            return this.getMaxSimulLines();
        }
        return 0;
    }

    protected void implOpen() throws LineUnavailableException {
    }

    protected void implClose() {
    }

    protected void implStart() {
    }

    protected void implStop() {
    }

    int getMixerIndex() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getIndex();
    }

    int getDeviceID() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getDeviceID();
    }

    int getMaxSimulLines() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getMaxSimulLines();
    }

    private static void addFormat(Vector vector, int n, int n2, int n3, float f, int n4, boolean bl, boolean bl2) {
        AudioFormat.Encoding encoding = null;
        switch (n4) {
            case 0: {
                encoding = bl ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
                break;
            }
            case 1: {
                encoding = AudioFormat.Encoding.ULAW;
                if (n == 8) break;
                n = 8;
                n2 = n3;
                break;
            }
            case 2: {
                encoding = AudioFormat.Encoding.ALAW;
                if (n == 8) break;
                n = 8;
                n2 = n3;
            }
        }
        if (encoding == null) {
            return;
        }
        if (n2 <= 0) {
            n2 = (n + 7) / 8 * n3;
        }
        vector.add(new AudioFormat(encoding, f, n, n3, n2, f, bl2));
    }

    protected static AudioFormat getSignOrEndianChangedFormat(AudioFormat audioFormat) {
        boolean bl = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        boolean bl2 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
        if (audioFormat.getFrameSize() > 1 && bl) {
            return new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), !audioFormat.isBigEndian());
        }
        if (audioFormat.getFrameSize() == 1 && (bl || bl2)) {
            return new AudioFormat(bl ? AudioFormat.Encoding.PCM_UNSIGNED : AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian());
        }
        return null;
    }

    private static native void nGetFormats(int var0, int var1, boolean var2, Vector var3);

    private static native long nOpen(int var0, int var1, boolean var2, int var3, float var4, int var5, int var6, int var7, boolean var8, boolean var9, int var10) throws LineUnavailableException;

    private static native void nStart(long var0, boolean var2);

    private static native void nStop(long var0, boolean var2);

    private static native void nClose(long var0, boolean var2);

    private static native int nWrite(long var0, byte[] var2, int var3, int var4, int var5);

    private static native int nRead(long var0, byte[] var2, int var3, int var4, int var5);

    private static native int nGetBufferSize(long var0, boolean var2);

    private static native boolean nIsStillDraining(long var0, boolean var2);

    private static native void nFlush(long var0, boolean var2);

    private static native int nAvailable(long var0, boolean var2);

    private static native long nGetBytePosition(long var0, boolean var2, long var3);

    private static class DirectBAOS
    extends ByteArrayOutputStream {
        public byte[] getInternalBuffer() {
            return this.buf;
        }
    }

    private static class DirectClip
    extends DirectDL
    implements Clip,
    Runnable,
    AutoClosingClip {
        private Thread thread;
        private byte[] audioData = null;
        private int frameSize;
        private int m_lengthInFrames;
        private int loopCount;
        private int clipBytePosition;
        private int newFramePosition;
        private int loopStartFrame;
        private int loopEndFrame;
        private boolean autoclosing = false;

        private DirectClip(DataLine.Info info, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), true);
        }

        public void open(AudioFormat audioFormat, byte[] byArray, int n, int n2) throws LineUnavailableException {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.open(audioFormat, byArray, n2 / audioFormat.getFrameSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void open(AudioFormat audioFormat, byte[] byArray, int n) throws LineUnavailableException {
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                if (this.isOpen()) {
                    throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
                }
                this.audioData = byArray;
                this.frameSize = audioFormat.getFrameSize();
                this.m_lengthInFrames = n;
                this.bytePosition = 0L;
                this.clipBytePosition = 0;
                this.newFramePosition = -1;
                this.loopStartFrame = 0;
                this.loopEndFrame = n - 1;
                this.loopCount = 0;
                try {
                    this.open(audioFormat, (int)Toolkit.millis2bytes(audioFormat, 1000L));
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.audioData = null;
                    throw lineUnavailableException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.audioData = null;
                    throw illegalArgumentException;
                }
                if (this.autoclosing) {
                    this.getEventDispatcher().autoClosingClipOpened(this);
                }
                this.thread = new Thread((Runnable)this, "Direct Clip");
                try {
                    this.thread.setDaemon(true);
                    this.thread.setPriority(6);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                byte[] byArray = null;
                if (this.isOpen()) {
                    throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
                }
                int n = (int)audioInputStream.getFrameLength();
                int n2 = 0;
                if (n != -1) {
                    int n3 = n * audioInputStream.getFormat().getFrameSize();
                    byArray = new byte[n3];
                    int n4 = n3;
                    int n5 = 0;
                    while (n4 > 0 && n5 >= 0) {
                        n5 = audioInputStream.read(byArray, n2, n4);
                        if (n5 > 0) {
                            n2 += n5;
                            n4 -= n5;
                            continue;
                        }
                        if (n5 != 0) continue;
                        Thread.yield();
                    }
                } else {
                    int n6 = 16384;
                    DirectBAOS directBAOS = new DirectBAOS();
                    byte[] byArray2 = new byte[n6];
                    int n7 = 0;
                    while (n7 >= 0) {
                        n7 = audioInputStream.read(byArray2, 0, byArray2.length);
                        if (n7 > 0) {
                            directBAOS.write(byArray2, 0, n7);
                            n2 += n7;
                            continue;
                        }
                        if (n7 != 0) continue;
                        Thread.yield();
                    }
                    byArray = directBAOS.getInternalBuffer();
                }
                n = n2 / audioInputStream.getFormat().getFrameSize();
                this.open(audioInputStream.getFormat(), byArray, n);
            }
        }

        public int getFrameLength() {
            return this.m_lengthInFrames;
        }

        public long getMicrosecondLength() {
            return Toolkit.frames2micros(this.getFormat(), this.getFrameLength());
        }

        public void setFramePosition(int n) {
            if (n < 0) {
                n = 0;
            } else if (n >= this.getFrameLength()) {
                n = this.getFrameLength();
            }
            if (this.doIO) {
                this.newFramePosition = n;
            } else {
                this.bytePosition = n * this.frameSize;
            }
            this.flush();
        }

        public int getFramePosition() {
            return super.getFramePosition();
        }

        public synchronized void setMicrosecondPosition(long l) {
            long l2 = Toolkit.micros2frames(this.getFormat(), l);
            this.setFramePosition((int)l2);
        }

        public void setLoopPoints(int n, int n2) {
            if (n < 0) {
                throw new IllegalArgumentException("illegal value for start: " + n);
            }
            if (n2 >= this.getFrameLength()) {
                throw new IllegalArgumentException("illegal value for end: " + n2);
            }
            if (n2 == -1) {
                n2 = this.getFrameLength() - 1;
            }
            if (n2 < n) {
                throw new IllegalArgumentException("End position " + n2 + "  preceeds start position " + n);
            }
            this.loopStartFrame = n;
            this.loopEndFrame = n2;
        }

        public void loop(int n) {
            this.loopCount = n;
            this.start();
        }

        void implOpen(AudioFormat audioFormat, int n) throws LineUnavailableException {
            if (this.audioData == null) {
                throw new IllegalArgumentException("Illegal call to open() in interface Clip");
            }
            super.implOpen(audioFormat, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void implClose() {
            Thread thread = this.thread;
            this.thread = null;
            this.doIO = false;
            if (thread != null) {
                DirectClip directClip = this;
                synchronized (directClip) {
                    this.notifyAll();
                }
                try {
                    thread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.implClose();
            this.audioData = null;
            this.newFramePosition = -1;
            this.getEventDispatcher().autoClosingClipClosed(this);
        }

        void implStart() {
            super.implStart();
            if (this.thread != null && !this.thread.isAlive()) {
                this.thread.start();
            }
        }

        void implStop() {
            super.implStop();
            this.loopCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.thread != null) {
                if (!this.doIO) {
                    DirectClip directClip = this;
                    synchronized (directClip) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                while (this.doIO) {
                    long l;
                    int n;
                    int n2;
                    if (this.newFramePosition >= 0) {
                        this.clipBytePosition = this.newFramePosition * this.frameSize;
                        this.newFramePosition = -1;
                    }
                    int n3 = this.getFrameLength() - 1;
                    if (this.loopCount > 0 || this.loopCount == -1) {
                        n3 = this.loopEndFrame;
                    }
                    if ((n2 = (n = (int)((long)n3 - (l = (long)(this.clipBytePosition / this.frameSize)) + 1L)) * this.frameSize) > this.getBufferSize()) {
                        n2 = Toolkit.align(this.getBufferSize(), this.frameSize);
                    }
                    int n4 = this.write(this.audioData, this.clipBytePosition, n2);
                    if (!this.doIO || this.newFramePosition >= 0 || n4 < 0) continue;
                    this.clipBytePosition += n4;
                    l = this.clipBytePosition / this.frameSize;
                    if (l <= (long)n3) continue;
                    if (this.loopCount > 0 || this.loopCount == -1) {
                        --this.loopCount;
                        this.newFramePosition = this.loopStartFrame;
                        continue;
                    }
                    this.drain();
                    this.stop();
                }
            }
        }

        public synchronized boolean isAutoClosing() {
            return this.autoclosing;
        }

        public synchronized void setAutoClosing(boolean bl) {
            if (bl != this.autoclosing) {
                if (this.isOpen()) {
                    if (bl) {
                        this.getEventDispatcher().autoClosingClipOpened(this);
                    } else {
                        this.getEventDispatcher().autoClosingClipClosed(this);
                    }
                }
                this.autoclosing = bl;
            }
        }
    }

    private static class DirectTDL
    extends DirectDL
    implements TargetDataLine {
        private DirectTDL(DataLine.Info info, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) {
            this.flushing = false;
            if (n2 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("Illegal request to read non-integral number of frames (" + n2 + " bytes )");
            }
            if (!this.isActive() && this.doIO) {
                this.setActive(true);
                this.setStarted(true);
            }
            int n3 = 0;
            while (this.doIO && !this.flushing) {
                this.activeIO = true;
                int n4 = DirectAudioDevice.nRead(this.id, byArray, n, n2, this.softwareConversionSize);
                this.activeIO = false;
                if (n4 < 0) break;
                this.bytePosition += (long)n4;
                n3 += n4;
                if ((n2 -= n4) <= 0) break;
                n += n4;
                DirectTDL directTDL = this;
                synchronized (directTDL) {
                    try {
                        this.wait(this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return n3;
        }
    }

    private static class DirectSDL
    extends DirectDL
    implements SourceDataLine {
        private DirectSDL(DataLine.Info info, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), true);
        }
    }

    private static class DirectDL
    extends AbstractDataLine {
        protected int mixerIndex;
        protected int deviceID;
        protected long id;
        protected int waitTime;
        protected boolean flushing = false;
        protected boolean isSource;
        protected long bytePosition;
        protected boolean doIO = false;
        protected boolean activeIO = false;
        protected int softwareConversionSize = 0;
        protected AudioFormat hardwareFormat;
        private JSSecurity jsSecurity = null;

        protected DirectDL(DataLine.Info info, DirectAudioDevice directAudioDevice, int n, int n2, boolean bl) {
            super(info, (AbstractMixer)directAudioDevice, null);
            this.mixerIndex = n;
            this.deviceID = n2;
            this.waitTime = 10;
            this.isSource = bl;
            if (!bl) {
                this.jsSecurity = JSSecurityManager.getJSSecurity();
            }
        }

        void implOpen(AudioFormat audioFormat, int n) throws LineUnavailableException {
            AudioFormat audioFormat2;
            if (!this.isSource && this.jsSecurity != null) {
                this.jsSecurity.checkRecordPermission();
            }
            int n2 = 0;
            if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
                n2 = 1;
            } else if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
                n2 = 2;
            }
            if (n == -1) {
                n = (int)Toolkit.millis2bytes(audioFormat, 500L);
            }
            DirectDLI directDLI = null;
            if (this.info instanceof DirectDLI) {
                directDLI = (DirectDLI)this.info;
            }
            this.hardwareFormat = audioFormat;
            this.softwareConversionSize = 0;
            if (directDLI != null && !directDLI.isFormatSupportedInHardware(audioFormat) && directDLI.isFormatSupportedInHardware(audioFormat2 = DirectAudioDevice.getSignOrEndianChangedFormat(audioFormat))) {
                this.hardwareFormat = audioFormat2;
                this.softwareConversionSize = audioFormat.getFrameSize() / audioFormat.getChannels();
            }
            n = n / audioFormat.getFrameSize() * audioFormat.getFrameSize();
            this.id = DirectAudioDevice.nOpen(this.mixerIndex, this.deviceID, this.isSource, n2, this.hardwareFormat.getSampleRate(), this.hardwareFormat.getSampleSizeInBits(), this.hardwareFormat.getFrameSize(), this.hardwareFormat.getChannels(), this.hardwareFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED), this.hardwareFormat.isBigEndian(), n);
            if (this.id == 0L) {
                throw new LineUnavailableException("line with format " + audioFormat + " not supported.");
            }
            this.bufferSize = DirectAudioDevice.nGetBufferSize(this.id, this.isSource);
            if (this.bufferSize < 1) {
                this.bufferSize = n;
            }
            this.format = audioFormat;
            this.waitTime = (int)Toolkit.bytes2millis(audioFormat, this.bufferSize) / 4;
            if (this.waitTime < 1) {
                this.waitTime = 1;
            } else if (this.waitTime > 1000) {
                this.waitTime = 1000;
            }
            this.bytePosition = 0L;
            this.doIO = false;
        }

        void implStart() {
            if (!this.isSource && this.jsSecurity != null) {
                this.jsSecurity.checkRecordPermission();
            }
            DirectAudioDevice.nStart(this.id, this.isSource);
            this.doIO = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void implStop() {
            if (!this.isSource && this.jsSecurity != null) {
                this.jsSecurity.checkRecordPermission();
            }
            DirectAudioDevice.nStop(this.id, this.isSource);
            this.doIO = false;
            DirectDL directDL = this;
            synchronized (directDL) {
                this.notifyAll();
            }
            this.setActive(false);
            this.setStarted(false);
        }

        void implClose() {
            if (!this.isSource && this.jsSecurity != null) {
                this.jsSecurity.checkRecordPermission();
            }
            this.doIO = false;
            long l = this.id;
            this.id = 0L;
            while (this.activeIO) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            DirectAudioDevice.nClose(l, this.isSource);
            this.bytePosition = 0L;
            this.softwareConversionSize = 0;
        }

        public int available() {
            if (this.id == 0L) {
                return 0;
            }
            return DirectAudioDevice.nAvailable(this.id, this.isSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drain() {
            while (this.id != 0L && DirectAudioDevice.nIsStillDraining(this.id, this.isSource)) {
                DirectDL directDL = this;
                synchronized (directDL) {
                    try {
                        this.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            if (this.id != 0L) {
                this.flushing = true;
                DirectDL directDL = this;
                synchronized (directDL) {
                    this.notifyAll();
                }
                DirectAudioDevice.nFlush(this.id, this.isSource);
            }
        }

        public int getFramePosition() {
            long l = DirectAudioDevice.nGetBytePosition(this.id, this.isSource, this.bytePosition);
            if (l < 0L) {
                l = 0L;
            }
            return (int)(l / (long)this.getFormat().getFrameSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(byte[] byArray, int n, int n2) {
            this.flushing = false;
            if (n2 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + n2 + " bytes, " + "frameSize = " + this.getFormat().getFrameSize() + " bytes)");
            }
            if (!this.isActive() && this.doIO) {
                this.setActive(true);
                this.setStarted(true);
            }
            int n3 = 0;
            while (this.doIO && !this.flushing) {
                this.activeIO = true;
                int n4 = DirectAudioDevice.nWrite(this.id, byArray, n, n2, this.softwareConversionSize);
                this.activeIO = false;
                if (n4 < 0) break;
                this.bytePosition += (long)n4;
                n3 += n4;
                if ((n2 -= n4) <= 0) break;
                n += n4;
                DirectDL directDL = this;
                synchronized (directDL) {
                    try {
                        this.wait(this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return n3;
        }
    }

    private static class DirectDLI
    extends DataLine.Info {
        private DirectDLI(Class clazz, AudioFormat[] audioFormatArray, int n, int n2) {
            super(clazz, audioFormatArray, n, n2);
        }

        public boolean isFormatSupportedInHardware(AudioFormat audioFormat) {
            if (audioFormat == null) {
                return false;
            }
            return super.isFormatSupported(audioFormat);
        }

        public boolean isFormatSupported(AudioFormat audioFormat) {
            return this.isFormatSupportedInHardware(audioFormat) || this.isFormatSupportedInHardware(DirectAudioDevice.getSignOrEndianChangedFormat(audioFormat));
        }
    }
}

