/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AiffFileFormat;
import com.sun.media.sound.SunFileWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class AiffFileWriter
extends SunFileWriter {
    private static final AudioFileFormat.Type[] aiffTypes = new AudioFileFormat.Type[]{AudioFileFormat.Type.AIFF};

    public AiffFileWriter() {
        super(aiffTypes);
    }

    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        AudioFileFormat.Type[] typeArray = new AudioFileFormat.Type[this.types.length];
        System.arraycopy(this.types, 0, typeArray, 0, this.types.length);
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        if (encoding == AudioFormat.Encoding.ALAW || encoding == AudioFormat.Encoding.ULAW || encoding == AudioFormat.Encoding.PCM_SIGNED || encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            return typeArray;
        }
        return new AudioFileFormat.Type[0];
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        AiffFileFormat aiffFileFormat = (AiffFileFormat)this.getAudioFileFormat(type, audioInputStream);
        if (audioInputStream.getFrameLength() == -1L) {
            throw new IOException("stream length not specified");
        }
        int n = this.writeAiffFile(audioInputStream, aiffFileFormat, outputStream);
        return n;
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        AiffFileFormat aiffFileFormat = (AiffFileFormat)this.getAudioFileFormat(type, audioInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 4096);
        int n = this.writeAiffFile(audioInputStream, aiffFileFormat, bufferedOutputStream);
        bufferedOutputStream.close();
        if (aiffFileFormat.getByteLength() == -1) {
            int n2 = aiffFileFormat.getFormat().getChannels() * aiffFileFormat.getFormat().getSampleSizeInBits();
            int n3 = n;
            int n4 = n3 - aiffFileFormat.getHeaderSize() + 16;
            long l = n4 - 16;
            int n5 = (int)(l * 8L / (long)n2);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.skipBytes(4);
            randomAccessFile.writeInt(n3 - 8);
            randomAccessFile.skipBytes(4 + aiffFileFormat.getFverChunkSize() + 4 + 4 + 2);
            randomAccessFile.writeInt(n5);
            randomAccessFile.skipBytes(16);
            randomAccessFile.writeInt(n4 - 8);
            randomAccessFile.close();
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AudioFileFormat getAudioFileFormat(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        int n;
        AudioFormat audioFormat = null;
        AiffFileFormat aiffFileFormat = null;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat2.getEncoding();
        boolean bl = false;
        if (type != this.types[0]) {
            throw new IllegalArgumentException("File type " + type + " not supported.");
        }
        if (encoding2 == AudioFormat.Encoding.ALAW || encoding2 == AudioFormat.Encoding.ULAW) {
            if (audioFormat2.getSampleSizeInBits() != 8) throw new IllegalArgumentException("Encoding " + encoding2 + " supported only for 8-bit data.");
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            n = 16;
            bl = true;
        } else if (audioFormat2.getSampleSizeInBits() == 8) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
            n = 8;
        } else {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            n = audioFormat2.getSampleSizeInBits();
        }
        audioFormat = new AudioFormat(encoding, audioFormat2.getSampleRate(), n, audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), true);
        int n2 = audioInputStream.getFrameLength() != -1L ? (bl ? (int)audioInputStream.getFrameLength() * audioFormat2.getFrameSize() * 2 + 54 : (int)audioInputStream.getFrameLength() * audioFormat2.getFrameSize() + 54) : -1;
        return new AiffFileFormat(AudioFileFormat.Type.AIFF, n2, audioFormat, (int)audioInputStream.getFrameLength());
    }

    private int writeAiffFile(InputStream inputStream, AiffFileFormat aiffFileFormat, OutputStream outputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        InputStream inputStream2 = this.getFileStream(aiffFileFormat, inputStream);
        byte[] byArray = new byte[4096];
        int n3 = aiffFileFormat.getByteLength();
        while ((n = inputStream2.read(byArray)) >= 0) {
            if (n3 > 0) {
                if (n < n3) {
                    outputStream.write(byArray, 0, n);
                    n2 += n;
                    n3 -= n;
                    continue;
                }
                outputStream.write(byArray, 0, n3);
                n2 += n3;
                n3 = 0;
                break;
            }
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
        return n2;
    }

    private InputStream getFileStream(AiffFileFormat aiffFileFormat, InputStream inputStream) throws IOException {
        AudioFormat audioFormat = aiffFileFormat.getFormat();
        AudioFormat audioFormat2 = null;
        AudioFormat.Encoding encoding = null;
        int n = aiffFileFormat.getHeaderSize();
        int n2 = aiffFileFormat.getFverChunkSize();
        int n3 = aiffFileFormat.getCommChunkSize();
        int n4 = -1;
        int n5 = -1;
        int n6 = aiffFileFormat.getSsndChunkOffset();
        short s = (short)audioFormat.getChannels();
        short s2 = (short)audioFormat.getSampleSizeInBits();
        int n7 = s * s2;
        int n8 = aiffFileFormat.getFrameLength();
        long l = -1L;
        if (n8 != -1) {
            l = (long)n8 * (long)n7 / 8L;
            n5 = (int)l + 16;
            n4 = (int)l + n;
        }
        float f = audioFormat.getSampleRate();
        int n9 = 1313820229;
        byte[] byArray = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        SequenceInputStream sequenceInputStream = null;
        InputStream inputStream2 = inputStream;
        if (inputStream instanceof AudioInputStream) {
            audioFormat2 = ((AudioInputStream)inputStream).getFormat();
            encoding = audioFormat2.getEncoding();
            if (encoding == AudioFormat.Encoding.PCM_UNSIGNED || encoding == AudioFormat.Encoding.PCM_SIGNED && !audioFormat2.isBigEndian()) {
                inputStream2 = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat2.getSampleRate(), audioFormat2.getSampleSizeInBits(), audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), true), (AudioInputStream)inputStream);
            } else if (encoding == AudioFormat.Encoding.ULAW || encoding == AudioFormat.Encoding.ALAW) {
                if (audioFormat2.getSampleSizeInBits() != 8) {
                    throw new IllegalArgumentException("unsupported encoding");
                }
                inputStream2 = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat2.getSampleRate(), audioFormat2.getSampleSizeInBits() * 2, audioFormat2.getChannels(), audioFormat2.getFrameSize() * 2, audioFormat2.getFrameRate(), true), (AudioInputStream)inputStream);
            }
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(1179603533);
        dataOutputStream.writeInt(n4 - 8);
        dataOutputStream.writeInt(1095321158);
        dataOutputStream.writeInt(1129270605);
        dataOutputStream.writeInt(n3 - 8);
        dataOutputStream.writeShort(s);
        dataOutputStream.writeInt(n8);
        dataOutputStream.writeShort(s2);
        this.write_ieee_extended(dataOutputStream, f);
        dataOutputStream.writeInt(1397968452);
        dataOutputStream.writeInt(n5 - 8);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(0);
        dataOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream2);
        return sequenceInputStream;
    }

    private void write_ieee_extended(DataOutputStream dataOutputStream, double d) throws IOException {
        int n = 16398;
        double d2 = d;
        while (d2 < 44000.0) {
            d2 *= 2.0;
            --n;
        }
        dataOutputStream.writeShort(n);
        dataOutputStream.writeInt((int)d2 << 16);
        dataOutputStream.writeInt(0);
    }
}

