/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsInternalFrameTitlePane;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class WindowsDesktopIconUI
extends BasicDesktopIconUI {
    private int width;
    private JComponent windowsIconPane;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsDesktopIconUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.width = UIManager.getInt("DesktopIcon.width");
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(XPStyle.getXP() == null);
    }

    protected void installComponents() {
        this.windowsIconPane = new WindowsInternalFrameTitlePane(this.frame);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.windowsIconPane, "Center");
        if (XPStyle.getXP() != null) {
            this.desktopIcon.setBorder(null);
        }
    }

    protected void uninstallComponents() {
        this.desktopIcon.remove(this.windowsIconPane);
        this.desktopIcon.setLayout(null);
        this.windowsIconPane = null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = new Dimension(this.windowsIconPane.getMinimumSize());
        Border border = this.frame.getBorder();
        if (border != null) {
            dimension.height += border.getBorderInsets((Component)this.frame).bottom + border.getBorderInsets((Component)this.frame).top;
        }
        dimension.width = this.width;
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }
}

