/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

class SynthBorder
extends AbstractBorder
implements UIResource {
    private SynthUI ui;
    private Insets insets;
    static final /* synthetic */ boolean $assertionsDisabled;

    SynthBorder(SynthUI synthUI, Insets insets) {
        this.ui = synthUI;
        this.insets = insets;
    }

    SynthBorder(SynthUI synthUI) {
        this(synthUI, null);
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = (JComponent)component;
        SynthContext synthContext = this.ui.getContext(jComponent);
        SynthStyle synthStyle = synthContext.getStyle();
        if (synthStyle == null) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"SynthBorder is being used outside after the UI has been uninstalled");
            }
            return;
        }
        SynthPainter synthPainter = synthStyle.getBorderPainter(synthContext);
        if (synthPainter != null) {
            synthPainter.paint(synthContext, "border", graphics, n, n2, n3, n4);
        }
        synthContext.dispose();
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, null);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2;
        if (this.insets != null) {
            if (insets == null) {
                insets = new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            } else {
                insets.top = this.insets.top;
                insets.bottom = this.insets.bottom;
                insets.left = this.insets.left;
                insets.right = this.insets.left;
            }
        } else if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (component instanceof AbstractButton && (insets2 = ((AbstractButton)component).getMargin()) != null) {
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
            insets.left += insets2.left;
            insets.right += insets2.right;
        }
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    static {
        $assertionsDisabled = !SynthBorder.class.desiredAssertionStatus();
    }
}

