/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;

final class RSAPublicKey
extends X509Key
implements java.security.interfaces.RSAPublicKey,
Serializable {
    static final long serialVersionUID = -6195576206650062694L;
    private BigInteger modulus;
    private BigInteger publicExponent;

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(RSAPublicKey.a("h-\u0005\u0011J+,\u001f\t\u000eO\u0007\"]Ke!\u001f\u0019K1b") + iOException.getMessage());
        }
    }

    public RSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String toString() {
        return RSAPublicKey.a("B\u0000=7mNb\".o+\u0012\u0005\u001fBb!P6Krxz\u0010Ao7\u001c\b]1H") + this.modulus.toString() + "\n" + RSAPublicKey.a("{7\u0012\u0011Ghb\u0015\u0005^d,\u0015\u0013Z1H") + this.publicExponent.toString() + "\n";
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            this.modulus = derValueArray[0].getInteger();
            this.publicExponent = derValueArray[1].getInteger();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(RSAPublicKey.a("B,\u0006\u001cBb&P\u0016Krb\u0006\u001cB~'Pw") + exception.getMessage());
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 11;
                        break;
                    }
                    case 1: {
                        n5 = 66;
                        break;
                    }
                    case 2: {
                        n5 = 112;
                        break;
                    }
                    case 3: {
                        n5 = 125;
                        break;
                    }
                    default: {
                        n5 = 46;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

