/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;

final class RSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateKey,
Serializable {
    static final long serialVersionUID = -5387735831354112582L;
    private BigInteger modulus;
    private BigInteger privateExponent;

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.modulus = bigInteger;
        this.privateExponent = bigInteger2;
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(RSAPrivateKey.a(":\u0001\u0012[\u0000y\u0000\bCD\u001d+5\u0017\u00017\r\bS\u0001cN") + iOException.getMessage());
        }
    }

    public RSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public String toString() {
        return RSAPrivateKey.a("\u0010,*}'\u001cN5d%y>\u0015^\u00128\u001a\u0002\u0017/<\u0017]=\t6\n\u0012[\u0011*Tm") + this.modulus.toString() + "\n" + RSAPrivateKey.a(")\u001c\u000eA\u0005-\u000bGR\u001c)\u0001\tR\n-Tm") + this.privateExponent.toString() + "\n";
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.modulus = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(RSAPrivateKey.a("\u0010\u0000\u0011V\b0\nGe7\u0018>\u0015^\u00128\u001a\u0002|\u0001 N\u0002Y\u00076\n\u000eY\u0003uN\u0003V\u00108N\bA\u0001+\u001c\u0012Y"));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 89;
                        break;
                    }
                    case 1: {
                        n5 = 110;
                        break;
                    }
                    case 2: {
                        n5 = 103;
                        break;
                    }
                    case 3: {
                        n5 = 55;
                        break;
                    }
                    default: {
                        n5 = 100;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

