/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

class DHPrivateKey
implements PrivateKey,
javax.crypto.interfaces.DHPrivateKey,
Serializable {
    static final long serialVersionUID = 7885790631402109830L;
    private static final BigInteger PKCS8_VERSION = BigInteger.valueOf(0L);
    private BigInteger x;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    public DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.x = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(DHPrivateKey.a("$0N4\u001f\u0013qP(\u001f\u0003$C?P&\u0002ntAG4N9\u001f\u00038N="));
        }
    }

    public DHPrivateKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException(DHPrivateKey.a(",4Yz\u001e\b%\u0000;P4\u0014q\u000f5)\u0012e"));
            }
            BigInteger bigInteger = derValue.getData().getInteger();
            if (!bigInteger.equals(PKCS8_VERSION)) {
                throw new IOException(DHPrivateKey.a("\u00114R)\u0019\b?\u00007\u0019\u0014<A.\u0013\u000fk\u0000r\u0003\u0012!P5\u0002\u00134D`P") + PKCS8_VERSION + DHPrivateKey.a("KqP;\u0002\u00144D`P") + bigInteger);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException(DHPrivateKey.a("&=G\u0013\u0014G8Sz\u001e\b%\u0000;P4\u0014q\u000f5)\u0012e"));
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException(DHPrivateKey.a("70R;\u001d\u0002%E(\u0003G<I)\u0003\u000e?G"));
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException(DHPrivateKey.a(")$L6P\u00170R;\u001d\u0002%E(\u0003"));
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException(DHPrivateKey.a("70R;\u001d\u0002%E(\u0003G?O.P\u0006qs\u001f!2\u0014n\u00195"));
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException(DHPrivateKey.a("\")T(\u0011G!A(\u0011\n4T?\u0002G5A.\u0011"));
            }
            this.key = derValue.getData().getOctetString();
            this.a();
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException(DHPrivateKey.a("7#I,\u0011\u00134\r,\u0011\u000b$Ez\u001c\u0002?G.\u0018G%O5P\u00058G"));
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public String getFormat() {
        return DHPrivateKey.a("7\u001ac\tS_");
    }

    public String getAlgorithm() {
        return DHPrivateKey.a("#\u0019");
    }

    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(PKCS8_VERSION);
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putInteger(this.p);
                derOutputStream3.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream3.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream3.toByteArray());
                derOutputStream2.putDerValue(derValue);
                derOutputStream.write((byte)48, derOutputStream2);
                derOutputStream.putOctetString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public BigInteger getX() {
        return this.x;
    }

    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(DHPrivateKey.a(".\u0013m\u00103\"qd3\u0016\u00018Ew8\u0002=L7\u0011\tqp(\u0019\u00110T?P,4Y`z\u001fk*") + this.x.toString() + "\n" + DHPrivateKey.a("\u0017k*") + this.p.toString() + "\n" + DHPrivateKey.a("\u0000k*") + this.g.toString());
        if (this.l != 0) {
            stringBuffer.append(DHPrivateKey.a("m=\u001aPPGq\u0000") + this.l);
        }
        return stringBuffer.toString();
    }

    private void a() throws InvalidKeyException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        try {
            this.x = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 += byArray[i2] * i2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = ((PrivateKey)object).getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 103;
                        break;
                    }
                    case 1: {
                        n5 = 81;
                        break;
                    }
                    case 2: {
                        n5 = 32;
                        break;
                    }
                    case 3: {
                        n5 = 90;
                        break;
                    }
                    default: {
                        n5 = 112;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

