/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.infrastructure.java;

import com.ibm.connector.infrastructure.RASService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class JavaRASService
implements RASService {
    static final String copyright = "(c) Copyright IBM Corporation 1998.";
    private int traceLevel = 0;
    private OutputStream errorStream = System.err;
    private OutputStream outputStream = System.out;

    public OutputStream getErrorStream() {
        return this.errorStream;
    }

    public OutputStreamWriter getErrorStreamWriter() {
        return new OutputStreamWriter(this.errorStream);
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public OutputStream getTraceStream() {
        return this.outputStream;
    }

    public OutputStreamWriter getTraceStreamWriter() {
        return new OutputStreamWriter(this.outputStream);
    }

    public synchronized void logError(String value) {
        String tmp = String.valueOf(value) + "\n";
        try {
            this.errorStream.write(tmp.getBytes());
            this.errorStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("IOException during error log writing.");
        }
    }

    public synchronized void logTraceInfo(String value) {
        String tmp = String.valueOf(value) + "\n";
        try {
            this.outputStream.write(tmp.getBytes());
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("IOException during trace writing.");
        }
    }

    public void setErrorStream(OutputStream output) {
        if (output != null) {
            this.errorStream = output;
        }
    }

    public void setTraceLevel(int aTraceLevel) {
        if (aTraceLevel < 0 || aTraceLevel > 4) {
            System.out.println("Invalid RASService trace level, assuming defaults");
            this.traceLevel = 0;
            return;
        }
        this.traceLevel = aTraceLevel;
    }

    public void setTraceStream(OutputStream output) {
        if (output != null) {
            this.outputStream = output;
        }
    }
}

