/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.infrastructure;

import com.ibm.connector.infrastructure.Identifier;
import com.ibm.connector.infrastructure.RuntimeContext;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UniqueID
implements Identifier {
    static final String copyright = "(c) Copyright IBM Corporation 1998.";
    private byte[] fieldID;
    private static long counter = 0L;
    private static Object counterLock = new Object();
    private static byte[] fourByte = new byte[4];
    private static byte[] eightByte = new byte[8];

    public UniqueID() {
        byte[] currentTimeByte;
        byte[] currentSeedByte;
        byte[] host;
        block11: {
            long currentTime;
            long currentSeed;
            block10: {
                this.fieldID = new byte[20];
                currentSeed = 0L;
                currentTime = 0L;
                host = fourByte;
                currentSeedByte = eightByte;
                currentTimeByte = eightByte;
                try {
                    host = InetAddress.getLocalHost().getAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    if (!RuntimeContext.isCurrentSet() || RuntimeContext.getCurrent().getRASService().getTraceLevel() < 1) break block10;
                    RuntimeContext.getCurrent().getRASService().logTraceInfo("Cannot retrieve local host address: UniqueID cannot be guaranteed unique.");
                }
            }
            try {
                Object object = counterLock;
                synchronized (object) {
                    currentSeed = ++counter % Long.MAX_VALUE;
                    currentTime = System.currentTimeMillis();
                }
                currentSeedByte = this.convertToByte(currentSeed);
                currentTimeByte = this.convertToByte(currentTime);
            }
            catch (Throwable throwable) {
                if (!RuntimeContext.isCurrentSet() || RuntimeContext.getCurrent().getRASService().getTraceLevel() < 1) break block11;
                RuntimeContext.getCurrent().getRASService().logTraceInfo("Cannot retrieve current time: UniqueID cannot be guaranteed unique.");
            }
        }
        int i = 0;
        while (i < 4) {
            this.fieldID[i] = host[i];
            ++i;
        }
        i = 4;
        while (i < 12) {
            this.fieldID[i] = currentTimeByte[i - 4];
            ++i;
        }
        i = 12;
        while (i < 20) {
            this.fieldID[i] = currentSeedByte[i - 12];
            ++i;
        }
    }

    private byte[] convertToByte(long sb) {
        byte[] tb = new byte[]{(byte)((sb & 0xFF00000000000000L) >>> 56), (byte)((sb & 0xFF000000000000L) >>> 48), (byte)((sb & 0xFF0000000000L) >>> 40), (byte)((sb & 0xFF00000000L) >>> 32), (byte)((sb & 0xFF000000L) >>> 24), (byte)((sb & 0xFF0000L) >>> 16), (byte)((sb & 0xFF00L) >>> 8), (byte)(sb & 0xFFL)};
        return tb;
    }

    public byte[] toBytes() {
        return this.fieldID;
    }

    public String toString() {
        try {
            return new String(this.fieldID, "cp437");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(this.fieldID);
        }
    }
}

