/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.connectionmanager;

import com.ibm.connector.ConnectionSpec;
import com.ibm.connector.ConnectionSpecManagementProperties;
import com.ibm.connector.NoConnectionAvailableException;
import com.ibm.connector.connectionmanager.CConnectionOrganizer;
import com.ibm.connector.connectionmanager.ConnectionManagerResource;
import com.ibm.connector.connectionmanager.ConnectionTimestampAssociation;
import com.ibm.connector.connectionmanager.TaskTimer;
import com.ibm.connector.connectionmanager.UConnectionOrganizer;
import com.ibm.connector.connectionmanager.UserConnections;
import com.ibm.connector.connectionmanager.UserDataOrganizer;
import com.ibm.connector.infrastructure.Identifier;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.connector.internal.Managed;
import com.ibm.connector.internal.ManagedFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConnectionManager
implements com.ibm.connector.internal.ConnectionManager {
    static final String copyright = "(c) Copyright IBM Corporation 1998.";
    private Hashtable connectionNameTable = new Hashtable();
    private Object tableLock = new Object();
    static final String cmName = "com.ibm.connector.connectionmanager.ConnectionManager";

    private Managed addCoordinatedConnection(UConnectionOrganizer uncoordinatedHelper, CConnectionOrganizer coordinatedHelper, ConnectionSpec connectionSpec, ManagedFactory managedFactory) {
        UserDataOrganizer organizer;
        boolean countIncreased;
        boolean waited;
        Object userData;
        Class<?> connectionClass;
        ConnectionTimestampAssociation connectionTS;
        Managed connection;
        int currentTraceLevel;
        block59: {
            currentTraceLevel = RuntimeContext.getCurrent().getRASService().getTraceLevel();
            connection = null;
            connectionTS = null;
            RuntimeContext.getCurrent().getSessionID();
            long connectionTimeout = 0L;
            connectionClass = connectionSpec.getClass();
            userData = null;
            waited = false;
            boolean alreadySet = false;
            countIncreased = false;
            organizer = null;
            if (uncoordinatedHelper.getUserDataTable() != null) {
                organizer = new UserDataOrganizer(connectionSpec);
                try {
                    Method methodHashcode = connectionClass.getMethod("getUserDataHashCode", new Class[0]);
                    userData = methodHashcode.invoke((Object)connectionSpec, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            try {
                connectionTimeout = ((ConnectionSpecManagementProperties)((Object)connectionSpec)).getConnectionTimeout();
            }
            catch (ClassCastException classCastException) {}
            if (connectionTimeout == 0L) {
                if (uncoordinatedHelper.limitReached(connectionSpec, connectionClass)) {
                    if (!uncoordinatedHelper.existsUnused(connectionSpec, connectionClass) && !coordinatedHelper.existsUnused(connectionSpec, connectionClass)) {
                        RuntimeContext.getCurrent().getRASService().logError(new ConnectionManagerResource().getString("IVJC0052E"));
                        throw new NoConnectionAvailableException();
                    }
                } else {
                    countIncreased = true;
                }
            } else {
                if (connectionTimeout < 0L) {
                    while (true) {
                        if (!uncoordinatedHelper.limitReached(connectionSpec, connectionClass)) {
                            countIncreased = true;
                        } else if (!uncoordinatedHelper.existsUnused(connectionSpec, connectionClass) && !coordinatedHelper.existsUnused(connectionSpec, connectionClass)) {
                            try {
                                if (currentTraceLevel >= 3) {
                                    this.trace("     ConnectionManager.reserve(), waiting without timeout ");
                                }
                                if (!alreadySet) {
                                    coordinatedHelper.incWaitCounter();
                                    alreadySet = true;
                                    waited = true;
                                }
                                uncoordinatedHelper.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        break block59;
                        break;
                    }
                }
                long startTime = 0L;
                long waitTime = connectionTimeout;
                while (true) {
                    if (coordinatedHelper.existsUnused(connectionSpec, connectionClass)) {
                        connection = uncoordinatedHelper.getUserDataTable() != null ? (Managed)coordinatedHelper.removeUnused(connectionSpec, connectionClass) : (Managed)coordinatedHelper.removeUnused();
                        if (connection != null) {
                            if (countIncreased) {
                                uncoordinatedHelper.decreaseConnectionCount();
                            }
                            if (waited) {
                                coordinatedHelper.decWaitCounter();
                            }
                            coordinatedHelper.addUsed(connection);
                            return connection;
                        }
                        waitTime -= System.currentTimeMillis() - startTime;
                    }
                    if (uncoordinatedHelper.existsUnused(connectionSpec, connectionClass)) {
                        connectionTS = uncoordinatedHelper.getUserDataTable() != null ? (ConnectionTimestampAssociation)uncoordinatedHelper.removeUnused(connectionSpec, connectionClass) : (ConnectionTimestampAssociation)uncoordinatedHelper.removeUnused();
                        if (connectionTS != null) {
                            if (countIncreased) {
                                uncoordinatedHelper.decreaseConnectionCount();
                            }
                            connection = (Managed)connectionTS.getValue();
                            if (userData != null) {
                                if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                                    uncoordinatedHelper.removeUserConnection(organizer, connectionTS);
                                    uncoordinatedHelper.increaseUserConnectionCount(organizer);
                                } else if (currentTraceLevel >= 1) {
                                    this.trace("Error: userData hashcode:" + organizer.toString() + " does not exist in the table");
                                }
                            }
                            coordinatedHelper.addUsed(connection);
                            return connection;
                        }
                        waitTime -= System.currentTimeMillis() - startTime;
                        break;
                    }
                    if (!uncoordinatedHelper.limitReached(connectionSpec, connectionClass)) {
                        connection = managedFactory.createManaged(connectionSpec);
                        if (userData != null) {
                            if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                                uncoordinatedHelper.increaseUserConnectionCount(organizer);
                            } else {
                                UserConnections userConnections = new UserConnections();
                                uncoordinatedHelper.addUserDataAssociation(organizer, userConnections);
                            }
                        }
                        coordinatedHelper.addUsed(connection);
                        return connection;
                    }
                    if (waitTime <= 0L) {
                        coordinatedHelper.decWaitCounter();
                        if (currentTraceLevel >= 3) {
                            this.trace("     ConnectionManager.reserve(), timeout expired, throwing exception.");
                        }
                        RuntimeContext.getCurrent().getRASService().logError(new ConnectionManagerResource().getString("IVJC0052E"));
                        throw new NoConnectionAvailableException();
                    }
                    try {
                        if (currentTraceLevel >= 3) {
                            this.trace("     ConnectionManager.reserve() for coordinated connection, waiting with timeout: " + waitTime + "ms.");
                        }
                        startTime = System.currentTimeMillis();
                        if (!alreadySet) {
                            coordinatedHelper.incWaitCounter();
                            alreadySet = true;
                            waited = true;
                        }
                        uncoordinatedHelper.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {}
                    waitTime -= System.currentTimeMillis() - startTime;
                }
            }
        }
        if (waited) {
            coordinatedHelper.decWaitCounter();
        }
        if ((connection = uncoordinatedHelper.getUserDataTable() != null ? (Managed)coordinatedHelper.removeUnused(connectionSpec, connectionClass) : (Managed)coordinatedHelper.removeUnused()) == null) {
            connectionTS = uncoordinatedHelper.getUserDataTable() != null ? (ConnectionTimestampAssociation)uncoordinatedHelper.removeUnused(connectionSpec, connectionClass) : (ConnectionTimestampAssociation)uncoordinatedHelper.removeUnused();
            if (connectionTS == null) {
                connection = managedFactory.createManaged(connectionSpec);
                if (!countIncreased) {
                    uncoordinatedHelper.increaseConnectionCount();
                }
                if (userData != null) {
                    if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                        uncoordinatedHelper.increaseUserConnectionCount(organizer);
                    } else {
                        UserConnections userConnections = new UserConnections();
                        uncoordinatedHelper.addUserDataAssociation(organizer, userConnections);
                    }
                }
            } else {
                if (countIncreased) {
                    uncoordinatedHelper.decreaseConnectionCount();
                }
                connection = (Managed)connectionTS.getValue();
                if (userData != null) {
                    if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                        uncoordinatedHelper.removeUserConnection(organizer, connectionTS);
                        uncoordinatedHelper.increaseUserConnectionCount(organizer);
                    } else if (currentTraceLevel >= 1) {
                        this.trace("Error: userData hashcode:" + organizer.toString() + " does not exist in the table");
                    }
                }
            }
        } else if (countIncreased) {
            uncoordinatedHelper.decreaseConnectionCount();
        }
        coordinatedHelper.addUsed(connection);
        return connection;
    }

    private Managed addNewConnection(ManagedFactory managedFactory, ConnectionSpec connectionSpec, Hashtable connTable) {
        Managed connection = null;
        CConnectionOrganizer coordinatedHelper = null;
        UConnectionOrganizer uncoordinatedHelper = null;
        Identifier id = RuntimeContext.getCurrent().getSessionID();
        Class<?> connectionClass = connectionSpec.getClass();
        connection = managedFactory.createManaged(connectionSpec);
        try {
            uncoordinatedHelper = new UConnectionOrganizer((ConnectionSpecManagementProperties)((Object)connectionSpec), this);
        }
        catch (ClassCastException classCastException) {
            uncoordinatedHelper = new UConnectionOrganizer(null, this);
        }
        try {
            Method methodUserData = connectionClass.getMethod("getUseUserDataHashCode", new Class[0]);
            Object result = methodUserData.invoke((Object)connectionSpec, new Object[0]);
            if (((Boolean)result).booleanValue()) {
                uncoordinatedHelper.setUserDataTable();
                UserConnections userConnections = new UserConnections();
                uncoordinatedHelper.addUserDataAssociation(new UserDataOrganizer(connectionSpec), userConnections);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        this.setCollection(uncoordinatedHelper);
        if (this.isZeroID(id)) {
            uncoordinatedHelper.addUsed(connection);
        } else {
            coordinatedHelper = new CConnectionOrganizer();
            uncoordinatedHelper.setConnectionOrganizer(id, coordinatedHelper);
            coordinatedHelper.addUsed(connection);
        }
        uncoordinatedHelper.increaseConnectionCount();
        connTable.put(connectionSpec, uncoordinatedHelper);
        return connection;
    }

    private Managed addUncoordinatedConnection(UConnectionOrganizer uncoordinatedHelper, ConnectionSpec connectionSpec, ManagedFactory managedFactory) {
        boolean countIncreased;
        UserDataOrganizer organizer;
        Class<?> connectionClass;
        ConnectionTimestampAssociation connectionTS;
        Managed connection;
        int currentTraceLevel;
        block32: {
            currentTraceLevel = RuntimeContext.getCurrent().getRASService().getTraceLevel();
            connection = null;
            connectionTS = null;
            long connectionTimeout = 0L;
            connectionClass = connectionSpec.getClass();
            organizer = new UserDataOrganizer(connectionSpec);
            countIncreased = false;
            try {
                connectionTimeout = ((ConnectionSpecManagementProperties)((Object)connectionSpec)).getConnectionTimeout();
            }
            catch (ClassCastException classCastException) {}
            if (connectionTimeout == 0L) {
                if (uncoordinatedHelper.limitReached(connectionSpec, connectionClass)) {
                    if (!uncoordinatedHelper.existsUnused(connectionSpec, connectionClass)) {
                        RuntimeContext.getCurrent().getRASService().logError(new ConnectionManagerResource().getString("IVJC0051E"));
                        throw new NoConnectionAvailableException();
                    }
                } else {
                    countIncreased = true;
                }
            } else {
                if (connectionTimeout < 0L) {
                    while (true) {
                        if (!uncoordinatedHelper.limitReached(connectionSpec, connectionClass)) {
                            countIncreased = true;
                        } else if (!uncoordinatedHelper.existsUnused(connectionSpec, connectionClass)) {
                            try {
                                if (currentTraceLevel >= 3) {
                                    this.trace("     ConnectionManager.reserve(), waiting without timeout ");
                                }
                                uncoordinatedHelper.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        break block32;
                        break;
                    }
                }
                long startTime = 0L;
                long waitTime = connectionTimeout;
                while (true) {
                    if (!uncoordinatedHelper.limitReached(connectionSpec, connectionClass)) {
                        countIncreased = true;
                        break;
                    }
                    if (uncoordinatedHelper.existsUnused(connectionSpec, connectionClass)) break;
                    if (waitTime <= 0L) {
                        RuntimeContext.getCurrent().getRASService().logError(new ConnectionManagerResource().getString("IVJC0051E"));
                        throw new NoConnectionAvailableException();
                    }
                    try {
                        if (currentTraceLevel >= 3) {
                            this.trace("     ConnectionManager.reserve() for uncoordinated connection, waiting with timeout: " + waitTime + "ms.");
                        }
                        startTime = System.currentTimeMillis();
                        uncoordinatedHelper.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {}
                    waitTime -= System.currentTimeMillis() - startTime;
                }
            }
        }
        if ((connectionTS = uncoordinatedHelper.getUserDataTable() != null ? (ConnectionTimestampAssociation)uncoordinatedHelper.removeUnused(connectionSpec, connectionClass) : (ConnectionTimestampAssociation)uncoordinatedHelper.removeUnused()) == null) {
            connection = managedFactory.createManaged(connectionSpec);
            if (!countIncreased) {
                uncoordinatedHelper.increaseConnectionCount();
            }
            if (uncoordinatedHelper.getUserDataTable() != null) {
                if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                    uncoordinatedHelper.increaseUserConnectionCount(organizer);
                } else {
                    UserConnections userConnections = new UserConnections();
                    uncoordinatedHelper.addUserDataAssociation(organizer, userConnections);
                }
            }
        } else {
            if (countIncreased) {
                uncoordinatedHelper.decreaseConnectionCount();
            }
            connection = (Managed)connectionTS.getValue();
            if (uncoordinatedHelper.getUserDataTable() != null) {
                if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                    uncoordinatedHelper.removeUserConnection(organizer, connectionTS);
                    uncoordinatedHelper.increaseUserConnectionCount(organizer);
                } else if (currentTraceLevel >= 1) {
                    this.trace("Error: userData hashcode:" + organizer.toString() + " does not exist in the table");
                }
            }
        }
        uncoordinatedHelper.addUsed(connection);
        return connection;
    }

    /*
     * Unable to fully structure code
     */
    public void clearForSessionID(Identifier aIdentifier) {
        currentTraceLevel = RuntimeContext.getCurrent().getRASService().getTraceLevel();
        if (currentTraceLevel >= 2) {
            this.trace("->[com.ibm.connector.connectionmanager.ConnectionManager.clearForSessionID()]");
        }
        if (currentTraceLevel >= 3) {
            this.trace(this.toString());
        }
        uncoordinatedHelper = null;
        coordinatedHelper = null;
        elements = null;
        connElements = null;
        connTable = null;
        altered = new Vector<UConnectionOrganizer>();
        var9_9 = this.tableLock;
        synchronized (var9_9) {
            elements = this.connectionNameTable.elements();
            connection = null;
            while (elements.hasMoreElements()) {
                connTable = (Hashtable)elements.nextElement();
                connElements = connTable.elements();
                first = true;
lbl21:
                // 4 sources

                while (connElements.hasMoreElements()) {
                    var12_13 = uncoordinatedHelper = (UConnectionOrganizer)connElements.nextElement();
                    synchronized (var12_13) {
                        coordinatedHelper = uncoordinatedHelper.getConnectionOrganizer(aIdentifier);
                        if (coordinatedHelper == null) ** GOTO lbl21
                        if (coordinatedHelper.getUsedSize() == 0) ** GOTO lbl72
                        res = new ConnectionManagerResource();
                        RuntimeContext.getCurrent().getRASService().logError(res.getString("IVJC0050E"));
                        this.trace(uncoordinatedHelper.toString());
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            if (connection.isDirty()) {
                                connectionSpec = connection.getConnectionSpec();
                                connection.destroyManaged();
                                uncoordinatedHelper.decreaseConnectionCount();
                                if (uncoordinatedHelper.getUserDataTable() == null) continue;
                                organizer = new UserDataOrganizer(connectionSpec);
                                if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                                    if (!uncoordinatedHelper.decreaseUserConnectionCount(organizer)) continue;
                                    uncoordinatedHelper.removeUserDataAssociation(organizer);
                                    continue;
                                }
                                if (currentTraceLevel < 1) continue;
                                this.trace("Error: userData hashcode:" + organizer.toString() + " does not exist in the table");
                                continue;
                            }
                            connection.prepareManagedForReuse();
                            if (connection.isDirty()) {
                                connectionSpec = connection.getConnectionSpec();
                                connection.destroyManaged();
                                uncoordinatedHelper.decreaseConnectionCount();
                                if (uncoordinatedHelper.getUserDataTable() == null) continue;
                                organizer = new UserDataOrganizer(connectionSpec);
                                if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                                    if (!uncoordinatedHelper.decreaseUserConnectionCount(organizer)) continue;
                                    uncoordinatedHelper.removeUserDataAssociation(organizer);
                                    continue;
                                }
                                if (currentTraceLevel < 1) continue;
                                this.trace("Error: userData hashcode:" + organizer.toString() + " does not exist in the table");
                                continue;
                            }
                            unusedConnection = new ConnectionTimestampAssociation(connection);
                            uncoordinatedHelper.addUnused(unusedConnection);
                            if (first) {
                                altered.addElement(uncoordinatedHelper);
                                first = false;
                            }
                            if (uncoordinatedHelper.userDataTable == null) continue;
                            connectionSpec = connection.getConnectionSpec();
                            organizer = new UserDataOrganizer(connectionSpec);
                            if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                                uncoordinatedHelper.addUserConnection(organizer, unusedConnection);
                                continue;
                            }
                            if (currentTraceLevel < 1) continue;
                            this.trace("Error: userData hashcode:" + organizer.toString() + " does not exist in the table");
lbl72:
                            // 15 sources

                            ** while ((connection = (Managed)coordinatedHelper.removeUnused()) != null)
                        }
lbl73:
                        // 1 sources

                        uncoordinatedHelper.removeConnectionOrganizer(aIdentifier);
                    }
                }
            }
            helpers = altered.elements();
            while (helpers.hasMoreElements()) {
                uncoordinatedHelper = (UConnectionOrganizer)helpers.nextElement();
                this.notifyAllWaiting(uncoordinatedHelper);
            }
        }
        if (currentTraceLevel >= 3) {
            this.trace(this.toString());
        }
        if (currentTraceLevel >= 2) {
            this.trace("<-[com.ibm.connector.connectionmanager.ConnectionManager.clearForSessionID()]");
        }
    }

    private boolean isZeroID(Identifier arg) {
        byte[] zeroID = new byte[20];
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            this.trace("<->[com.ibm.connector.connectionmanager.ConnectionManager.isZeroID()]");
        }
        String stringZeroID = null;
        try {
            stringZeroID = new String(zeroID, "cp437");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            stringZeroID = new String(zeroID);
        }
        return arg.toString().equals(stringZeroID);
    }

    private void notifyAllWaiting(UConnectionOrganizer uncoordinatedHelper) {
        int currentTraceLevel = RuntimeContext.getCurrent().getRASService().getTraceLevel();
        Enumeration elements = uncoordinatedHelper.getCoordinatedTable().elements();
        if (elements == null) {
            return;
        }
        boolean threadIsWaiting = false;
        CConnectionOrganizer co = null;
        while (elements.hasMoreElements()) {
            co = (CConnectionOrganizer)elements.nextElement();
            if (co.getWaitCounter() <= 0) continue;
            threadIsWaiting = true;
            break;
        }
        if (threadIsWaiting) {
            UConnectionOrganizer uConnectionOrganizer = uncoordinatedHelper;
            synchronized (uConnectionOrganizer) {
                if (currentTraceLevel >= 3) {
                    this.trace(String.valueOf(this.getClass().getName()) + ".notifyAllWaiting(uncoordinatedHelper@" + uncoordinatedHelper.hashCode() + ")");
                }
                uncoordinatedHelper.notifyAll();
            }
        }
    }

    public void release(Managed managed) {
        Object methodGetSubpoolName;
        int currentTraceLevel = RuntimeContext.getCurrent().getRASService().getTraceLevel();
        if (currentTraceLevel >= 2) {
            this.trace("->[com.ibm.connector.connectionmanager.ConnectionManager@" + this.hashCode() + ".release()], Managed: " + managed.toString());
        }
        if (currentTraceLevel >= 3) {
            this.trace(this.toString());
        }
        ConnectionSpec connectionSpec = managed.getConnectionSpec();
        UConnectionOrganizer uncoordinatedHelper = null;
        CConnectionOrganizer coordinatedHelper = null;
        Identifier id = RuntimeContext.getCurrent().getSessionID();
        boolean connectionExists = false;
        boolean connectionNameExists = false;
        Hashtable connTable = null;
        Class<?> connectionClass = connectionSpec.getClass();
        String connectionName = connectionClass.getName();
        try {
            methodGetSubpoolName = connectionClass.getMethod("getSubpoolName", new Class[0]);
            Object result = ((Method)methodGetSubpoolName).invoke((Object)connectionSpec, new Object[0]);
            connectionName = String.valueOf(connectionName) + (String)result;
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        methodGetSubpoolName = this.tableLock;
        synchronized (methodGetSubpoolName) {
            connectionNameExists = this.connectionNameTable.containsKey(connectionName);
            if (connectionNameExists) {
                connTable = (Hashtable)this.connectionNameTable.get(connectionName);
                connectionExists = connTable.containsKey(connectionSpec);
            } else {
                ConnectionManagerResource res = new ConnectionManagerResource();
                RuntimeContext.getCurrent().getRASService().logError(res.getString("IVJC0053E"));
            }
        }
        if (connectionExists) {
            methodGetSubpoolName = this.tableLock;
            synchronized (methodGetSubpoolName) {
                uncoordinatedHelper = (UConnectionOrganizer)connTable.get(connectionSpec);
            }
            if (this.isZeroID(id)) {
                methodGetSubpoolName = uncoordinatedHelper;
                synchronized (methodGetSubpoolName) {
                    this.removeUncoordinatedConnection(managed, uncoordinatedHelper);
                    if (currentTraceLevel >= 3) {
                        this.trace("->[com.ibm.connector.connectionmanager.ConnectionManager@" + this.hashCode() + ".release()], uncoordinated connection. Notifying uncoordinatedHelper@" + uncoordinatedHelper.hashCode());
                    }
                    uncoordinatedHelper.notifyAll();
                }
            } else {
                methodGetSubpoolName = uncoordinatedHelper;
                synchronized (methodGetSubpoolName) {
                    coordinatedHelper = uncoordinatedHelper.getConnectionOrganizer(id);
                    coordinatedHelper.removeUsed(managed);
                    if (!managed.isDirty()) {
                        coordinatedHelper.addUnused(managed);
                    } else {
                        managed.destroyManaged();
                        uncoordinatedHelper.decreaseConnectionCount();
                        if (uncoordinatedHelper.getUserDataTable() != null) {
                            UserDataOrganizer organizer = new UserDataOrganizer(connectionSpec);
                            if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                                if (uncoordinatedHelper.decreaseUserConnectionCount(organizer)) {
                                    uncoordinatedHelper.removeUserDataAssociation(organizer);
                                }
                            } else if (currentTraceLevel >= 1) {
                                this.trace("Error: userData hashcode:" + organizer.toString() + " does not exist in the table");
                            }
                        }
                    }
                    if (currentTraceLevel >= 3) {
                        this.trace("->[com.ibm.connector.connectionmanager.ConnectionManager@" + this.hashCode() + ".release()], coordinated connection. Notifying uncoordinatedHelper@" + uncoordinatedHelper.hashCode());
                    }
                    uncoordinatedHelper.notify();
                }
            }
        } else {
            ConnectionManagerResource res = new ConnectionManagerResource();
            RuntimeContext.getCurrent().getRASService().logError(res.getString("IVJC0053E"));
        }
        if (currentTraceLevel >= 3) {
            this.trace("release()" + this.toString());
        }
        if (currentTraceLevel >= 2) {
            this.trace("<-[com.ibm.connector.connectionmanager.ConnectionManager@" + this.hashCode() + ".release()]");
        }
    }

    private void removeUncoordinatedConnection(Managed managed, UConnectionOrganizer uncoordinatedHelper) {
        int currentTraceLevel = RuntimeContext.getCurrent().getRASService().getTraceLevel();
        ConnectionSpec connectionSpec = managed.getConnectionSpec();
        Class<?> connectionClass = connectionSpec.getClass();
        Object userData = null;
        UserDataOrganizer organizer = null;
        if (uncoordinatedHelper.getUserDataTable() != null) {
            organizer = new UserDataOrganizer(connectionSpec);
            try {
                Method methodHashcode = connectionClass.getMethod("getUserDataHashCode", new Class[0]);
                userData = methodHashcode.invoke((Object)connectionSpec, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        uncoordinatedHelper.removeUsed(managed);
        if (!managed.isDirty()) {
            managed.prepareManagedForReuse();
            if (managed.isDirty()) {
                managed.destroyManaged();
                uncoordinatedHelper.decreaseConnectionCount();
                if (userData != null) {
                    if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                        if (uncoordinatedHelper.decreaseUserConnectionCount(organizer)) {
                            uncoordinatedHelper.removeUserDataAssociation(organizer);
                        }
                    } else if (currentTraceLevel >= 1) {
                        this.trace("Error: userData hashcode:" + organizer.toString() + " does not exist in the table");
                    }
                }
            }
            ConnectionTimestampAssociation unusedConnection = new ConnectionTimestampAssociation(managed);
            uncoordinatedHelper.addUnused(unusedConnection);
            if (userData != null) {
                if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                    uncoordinatedHelper.addUserConnection(organizer, unusedConnection);
                } else if (currentTraceLevel >= 1) {
                    this.trace("Error: userData hashcode:" + organizer.toString() + " does not exist in the table");
                }
            }
        } else {
            managed.destroyManaged();
            uncoordinatedHelper.decreaseConnectionCount();
            if (userData != null) {
                if (uncoordinatedHelper.existsUserDataAssociation(organizer)) {
                    if (uncoordinatedHelper.decreaseUserConnectionCount(organizer)) {
                        uncoordinatedHelper.removeUserDataAssociation(organizer);
                    }
                } else if (currentTraceLevel >= 1) {
                    this.trace("Error: userData hashcode:" + organizer.toString() + " does not exist in the table");
                }
            }
        }
    }

    public Managed reserve(ManagedFactory managedFactory, ConnectionSpec connectionSpec) throws NoConnectionAvailableException {
        int currentTraceLevel = RuntimeContext.getCurrent().getRASService().getTraceLevel();
        if (currentTraceLevel >= 2) {
            this.trace("->[com.ibm.connector.connectionmanager.ConnectionManager@" + this.hashCode() + ".reserve()]");
        }
        if (currentTraceLevel >= 3) {
            this.trace(this.toString());
        }
        Managed connection = null;
        CConnectionOrganizer coordinatedHelper = null;
        UConnectionOrganizer uncoordinatedHelper = null;
        Identifier id = RuntimeContext.getCurrent().getSessionID();
        boolean connectionExists = false;
        boolean connectionNameExists = false;
        Class<?> connectionClass = connectionSpec.getClass();
        String connectionName = connectionClass.getName();
        try {
            Method methodGetSubpoolName = connectionClass.getMethod("getSubpoolName", new Class[0]);
            Object result = methodGetSubpoolName.invoke((Object)connectionSpec, new Object[0]);
            connectionName = String.valueOf(connectionName) + (String)result;
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        Hashtable connTable = null;
        Object object = this.tableLock;
        synchronized (object) {
            connectionNameExists = this.connectionNameTable.containsKey(connectionName);
            if (connectionNameExists) {
                connTable = (Hashtable)this.connectionNameTable.get(connectionName);
                connectionExists = connTable.containsKey(connectionSpec);
            } else {
                connTable = new Hashtable();
                this.connectionNameTable.put(connectionName, connTable);
            }
            if (!connectionExists) {
                connection = this.addNewConnection(managedFactory, connectionSpec, connTable);
            }
        }
        if (connectionExists) {
            object = this.tableLock;
            synchronized (object) {
                uncoordinatedHelper = (UConnectionOrganizer)connTable.get(connectionSpec);
            }
            if (this.isZeroID(id)) {
                object = uncoordinatedHelper;
                synchronized (object) {
                    if (currentTraceLevel >= 3) {
                        this.trace("->[com.ibm.connector.connectionmanager.ConnectionManager@" + this.hashCode() + ".reserve()], uncoordinated connection. uncoordinatedHelper@" + uncoordinatedHelper.hashCode());
                    }
                    connection = this.addUncoordinatedConnection(uncoordinatedHelper, connectionSpec, managedFactory);
                }
            }
            object = uncoordinatedHelper;
            synchronized (object) {
                coordinatedHelper = uncoordinatedHelper.getConnectionOrganizer(id);
                if (coordinatedHelper == null) {
                    coordinatedHelper = new CConnectionOrganizer();
                    uncoordinatedHelper.setConnectionOrganizer(id, coordinatedHelper);
                }
                if (currentTraceLevel >= 3) {
                    this.trace("->[com.ibm.connector.connectionmanager.ConnectionManager@" + this.hashCode() + ".reserve()], coordinated connection. uncoordinatedHelper@" + uncoordinatedHelper.hashCode() + ", coordinatedHelper@" + coordinatedHelper.hashCode());
                }
                connection = this.addCoordinatedConnection(uncoordinatedHelper, coordinatedHelper, connectionSpec, managedFactory);
            }
        }
        if (currentTraceLevel >= 3) {
            this.trace("reserve():" + this.toString());
        }
        if (currentTraceLevel >= 2) {
            this.trace("<-[com.ibm.connector.connectionmanager.ConnectionManager@" + this.hashCode() + ".reserve()], Managed: " + connection.toString());
        }
        return connection;
    }

    private void setCollection(UConnectionOrganizer sh) {
        if (sh.csProperties == null) {
            return;
        }
        long reapTime = sh.csProperties.getReapTime();
        if (reapTime > 0L && sh.csProperties.getUnusedTimeout() > 0L) {
            TaskTimer t = new TaskTimer(reapTime, RuntimeContext.getCurrent());
            t.addTask(sh);
        }
    }

    public String toString() {
        String dumpString = "";
        try {
            StringWriter strwrtr = new StringWriter();
            if (strwrtr == null) {
                return dumpString;
            }
            PrintWriter pwrtr = new PrintWriter((Writer)strwrtr, true);
            if (pwrtr == null) {
                return dumpString;
            }
            pwrtr.println("[com.ibm.connector.connectionmanager.ConnectionManager]");
            pwrtr.println("  [connectionNameTable: ");
            if (this.connectionNameTable == null) {
                pwrtr.println("    [null]");
            } else {
                Enumeration elements = this.connectionNameTable.elements();
                Enumeration keys = this.connectionNameTable.keys();
                Hashtable connTable = null;
                String keyName = null;
                while (elements.hasMoreElements()) {
                    connTable = (Hashtable)elements.nextElement();
                    keyName = (String)keys.nextElement();
                    if (connTable == null) {
                        pwrtr.println("    [null]");
                        continue;
                    }
                    pwrtr.println("    " + keyName);
                    Enumeration connElements = connTable.elements();
                    UConnectionOrganizer helper = null;
                    while (connElements.hasMoreElements()) {
                        helper = (UConnectionOrganizer)connElements.nextElement();
                        if (helper == null) {
                            pwrtr.println("    null");
                            continue;
                        }
                        pwrtr.println("    [" + helper.toString() + "    ]");
                    }
                }
            }
            pwrtr.println("  ]");
            dumpString = strwrtr.toString();
        }
        catch (Exception exception) {
            return dumpString;
        }
        return dumpString;
    }

    protected synchronized void trace(String msg) {
        RuntimeContext.getCurrent().getRASService().logTraceInfo(msg);
    }
}

