/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;

public final class XSDUtil
extends XSDConstants {
    public static XSDSchema getSchemaForSchema(String schemaForSchemaURI) {
        return XSDSchemaImpl.getSchemaForSchema(schemaForSchemaURI);
    }

    public static class UsageCrossReferencer
    extends EcoreUtil.UsageCrossReferencer {
        protected Collection eObjectsOfInterest;

        protected UsageCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected UsageCrossReferencer(Resource resource) {
            super(resource);
        }

        protected UsageCrossReferencer(ResourceSet resourceSet) {
            super(resourceSet);
        }

        protected UsageCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return !eReference.isVolatile() && eReference.isChangeable() && this.eObjectsOfInterest.contains(crossReferencedEObject);
        }

        protected Collection findUsage(EObject eObject) {
            this.eObjectsOfInterest = Collections.singleton(eObject);
            this.crossReference();
            this.eObjectsOfInterest = null;
            this.done();
            return this.getCollection(eObject);
        }

        protected Map findAllUsage(Collection eObjectsOfInterest) {
            this.eObjectsOfInterest = eObjectsOfInterest;
            this.crossReference();
            this.eObjectsOfInterest = null;
            this.done();
            return this;
        }

        public static Collection find(EObject eObjectOfInterest, EObject eObject) {
            return new UsageCrossReferencer(eObject).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, Resource resource) {
            return new UsageCrossReferencer(resource).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, ResourceSet resourceSet) {
            return new UsageCrossReferencer(resourceSet).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, Collection emfObjectsToSearch) {
            return new UsageCrossReferencer(emfObjectsToSearch).findUsage(eObjectOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, EObject eObject) {
            return new UsageCrossReferencer(eObject).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, Resource resource) {
            return new UsageCrossReferencer(resource).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, ResourceSet resourceSet) {
            return new UsageCrossReferencer(resourceSet).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, Collection emfObjectsToSearch) {
            return new UsageCrossReferencer(emfObjectsToSearch).findAllUsage(eObjectsOfInterest);
        }
    }

    public static class XSDNamedComponentCrossReferencer
    extends EcoreUtil.CrossReferencer {
        protected XSDNamedComponentCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected XSDNamedComponentCrossReferencer(Resource resource) {
            super(resource);
        }

        protected XSDNamedComponentCrossReferencer(ResourceSet resourceSet) {
            super(resourceSet);
        }

        protected XSDNamedComponentCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean containment(EObject eObject) {
            if (eObject instanceof XSDNamedComponent) {
                this.getCollection(eObject);
            }
            return true;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return !eReference.isVolatile() && eReference.isChangeable() && crossReferencedEObject instanceof XSDNamedComponent;
        }

        public static Map find(EObject eObject) {
            XSDNamedComponentCrossReferencer result = new XSDNamedComponentCrossReferencer(eObject);
            result.crossReference();
            result.done();
            return result;
        }

        public static Map find(Resource resource) {
            XSDNamedComponentCrossReferencer result = new XSDNamedComponentCrossReferencer(resource);
            result.crossReference();
            result.done();
            return result;
        }

        public static Map find(ResourceSet resourceSet) {
            XSDNamedComponentCrossReferencer result = new XSDNamedComponentCrossReferencer(resourceSet);
            result.crossReference();
            result.done();
            return result;
        }
    }

    public static class URICrossReferencer
    extends EcoreUtil.CrossReferencer {
        protected String[] uris;

        protected URICrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected URICrossReferencer(Resource resource) {
            super(resource);
        }

        protected URICrossReferencer(ResourceSet resourceSet) {
            super(resourceSet);
        }

        protected URICrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean containment(EObject eObject) {
            if (eObject instanceof XSDNamedComponent) {
                XSDNamedComponent xsdNamedComponent = (XSDNamedComponent)eObject;
                int i = 0;
                while (i < this.uris.length) {
                    String uri = this.uris[i];
                    if (xsdNamedComponent.hasURI(uri)) {
                        this.getCollection(eObject);
                        break;
                    }
                    ++i;
                }
            }
            return true;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            if (crossReferencedEObject instanceof XSDNamedComponent && !eReference.isVolatile() && eReference.isChangeable()) {
                XSDNamedComponent xsdNamedComponent = (XSDNamedComponent)crossReferencedEObject;
                int i = 0;
                while (i < this.uris.length) {
                    String uri = this.uris[i];
                    if (xsdNamedComponent.hasURI(uri)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        protected Map findURI(String uri) {
            this.uris = new String[]{uri};
            this.crossReference();
            this.uris = null;
            this.done();
            return this;
        }

        protected Map findAllURI(Collection uris) {
            this.uris = uris.toArray(new String[uris.size()]);
            this.crossReference();
            uris = null;
            this.done();
            return this;
        }

        public static Map find(String uri, EObject eObject) {
            return new URICrossReferencer(eObject).findURI(uri);
        }

        public static Map find(String uri, Resource resource) {
            return new URICrossReferencer(resource).findURI(uri);
        }

        public static Map find(String uri, ResourceSet resourceSet) {
            return new URICrossReferencer(resourceSet).findURI(uri);
        }

        public static Map find(String uri, Collection emfObjectsToSearch) {
            return new URICrossReferencer(emfObjectsToSearch).findURI(uri);
        }

        public static Map findAll(Collection uris, EObject eObject) {
            return new URICrossReferencer(eObject).findAllURI(uris);
        }

        public static Map findAll(Collection uris, Resource resource) {
            return new URICrossReferencer(resource).findAllURI(uris);
        }

        public static Map findAll(Collection uris, ResourceSet resourceSet) {
            return new URICrossReferencer(resourceSet).findAllURI(uris);
        }

        public static Map findAll(Collection uris, Collection emfObjectsToSearch) {
            return new URICrossReferencer(emfObjectsToSearch).findAllURI(uris);
        }
    }

    public static interface ByteSequence {
        public byte[] getBytes();
    }
}

