/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDSchemaContentImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.w3c.dom.Element;

public abstract class XSDSchemaDirectiveImpl
extends XSDSchemaContentImpl
implements XSDSchemaDirective {
    protected static final String SCHEMA_LOCATION_EDEFAULT = null;
    protected String schemaLocation = SCHEMA_LOCATION_EDEFAULT;
    protected XSDSchema resolvedSchema = null;
    protected boolean resolved;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected XSDSchemaDirectiveImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDSchemaDirective();
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String newSchemaLocation) {
        String oldSchemaLocation = this.schemaLocation;
        this.schemaLocation = newSchemaLocation;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldSchemaLocation, (Object)this.schemaLocation));
        }
    }

    public XSDSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    public void setResolvedSchema(XSDSchema newResolvedSchema) {
        XSDSchema oldResolvedSchema = this.resolvedSchema;
        this.resolvedSchema = newResolvedSchema;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldResolvedSchema, (Object)this.resolvedSchema));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove(otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getSchemaLocation();
            }
            case 6: {
                return this.getResolvedSchema();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setSchemaLocation((String)newValue);
                return;
            }
            case 6: {
                this.setResolvedSchema((XSDSchema)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(XSDConcreteComponentImpl.ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setSchemaLocation(SCHEMA_LOCATION_EDEFAULT);
                return;
            }
            case 6: {
                this.setResolvedSchema(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return XSDConcreteComponentImpl.ELEMENT_EDEFAULT == null ? this.element != null : !XSDConcreteComponentImpl.ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return SCHEMA_LOCATION_EDEFAULT == null ? this.schemaLocation != null : !SCHEMA_LOCATION_EDEFAULT.equals(this.schemaLocation);
            }
            case 6: {
                return this.resolvedSchema != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (schemaLocation: ");
        result.append(this.schemaLocation);
        result.append(')');
        return result.toString();
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        String newSchemaLocation = null;
        if (changedElement.hasAttributeNS(null, "schemaLocation")) {
            newSchemaLocation = changedElement.getAttributeNS(null, "schemaLocation");
        }
        if (newSchemaLocation == null ? this.getSchemaLocation() != null : !newSchemaLocation.equals(this.getSchemaLocation())) {
            this.setSchemaLocation(newSchemaLocation);
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        Element theElement;
        if (this.resolved && this.getResolvedSchema() == null && eAttribute == XSDPackage.eINSTANCE.getXSDSchemaDirective_SchemaLocation()) {
            this.resolved = false;
        }
        if (this.isReconciling) {
            return;
        }
        super.changeAttribute(eAttribute);
        if ((eAttribute == null || eAttribute == XSDPackage.eINSTANCE.getXSDSchemaDirective_SchemaLocation()) && (theElement = this.getElement()) != null) {
            this.niceSetAttribute(theElement, "schemaLocation", this.getSchemaLocation());
        }
    }

    protected void resolve(String namespace, String schemaLocation) {
        ResourceSet resourceSet;
        Resource resource;
        XSDSchema xsdSchema;
        if (!(this.resolved || (xsdSchema = this.getSchema()) == null || xsdSchema.getSchemaLocation() == null && ((XSDSchemaImpl)xsdSchema).getPendingSchemaLocation() == null || (resource = xsdSchema.eResource()) == null || (resourceSet = resource.getResourceSet()) == null)) {
            XSDSchema resolvedSchema;
            if (namespace == null) {
                namespace = xsdSchema.getTargetNamespace();
            }
            String resolvedSchemaLocation = this.resolveSchemaLocation(xsdSchema, namespace, schemaLocation);
            if (schemaLocation == null) {
                if (XSDConstants.isXMLNamespace(resolvedSchemaLocation)) {
                    resolvedSchemaLocation = String.valueOf(XSDPlugin.INSTANCE.getBaseURL().toString()) + "cache/www.w3.org/2001/xml.xsd";
                } else if ("http://www.w3.org/2001/XMLSchema".equals(resolvedSchemaLocation)) {
                    resolvedSchemaLocation = String.valueOf(XSDPlugin.INSTANCE.getBaseURL().toString()) + "cache/www.w3.org/2001/XMLSchema.xsd";
                }
            }
            if ((resolvedSchema = this.locateSchema(xsdSchema, namespace, schemaLocation, resolvedSchemaLocation)) == null) {
                URI uri = URI.createURI(resolvedSchemaLocation);
                Resource resolvedResource = resourceSet.getResource(uri, false);
                if (resolvedResource == null) {
                    try {
                        InputStream inputStream = resourceSet.getURIConverter().createInputStream(uri);
                        resolvedResource = resourceSet.createResource(URI.createURI("*.xsd"));
                        resolvedResource.setURI(uri);
                        resolvedResource.load(inputStream, resourceSet.getLoadOptions());
                    }
                    catch (IOException iOException) {}
                }
                if (resolvedResource != null) {
                    resolvedSchema = resolvedResource instanceof XSDResourceImpl ? ((XSDResourceImpl)resolvedResource).getSchema() : XSDFactory.eINSTANCE.createXSDSchema();
                }
            }
            this.resolved = true;
            this.handleResolvedSchema(resolvedSchema);
        }
    }

    protected XSDSchema locateSchema(XSDSchema xsdSchema, String namespace, String rawSchemaLocation, String resolvedSchemaLocation) {
        XSDSchemaLocator xsdSchemaLocator;
        Resource resource = xsdSchema.eResource();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.xsd.util.XSDSchemaLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (xsdSchemaLocator = (XSDSchemaLocator)((Object)EcoreUtil.getRegisteredAdapter(resource, (Object)clazz))) == null ? null : xsdSchemaLocator.locateSchema(xsdSchema, namespace, rawSchemaLocation, resolvedSchemaLocation);
    }

    protected String resolveSchemaLocation(XSDSchema xsdSchema, String namespace, String schemaLocation) {
        do {
            XSDSchemaLocationResolver xsdSchemaLocationResolver;
            Class<?> clazz;
            if ((clazz = class$1) == null) {
                try {
                    clazz = Class.forName("org.eclipse.xsd.util.XSDSchemaLocationResolver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((xsdSchemaLocationResolver = (XSDSchemaLocationResolver)((Object)EcoreUtil.getRegisteredAdapter(xsdSchema, (Object)clazz))) == null) continue;
            return xsdSchemaLocationResolver.resolveSchemaLocation(xsdSchema, namespace, schemaLocation);
        } while (xsdSchema.getContainer() != null && (xsdSchema = xsdSchema.getContainer().getSchema()) != null);
        return XSDConstants.resolveSchemaLocation(xsdSchema.getSchemaLocation(), namespace, schemaLocation);
    }

    protected void handleResolvedSchema(XSDSchema xsdSchema) {
    }
}

