/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFixedFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDConstrainingFacetImpl;
import org.eclipse.xsd.impl.XSDFacetImpl;
import org.eclipse.xsd.impl.XSDFractionDigitsFacetImpl;
import org.eclipse.xsd.impl.XSDLengthFacetImpl;
import org.eclipse.xsd.impl.XSDMaxExclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDMaxInclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDMaxLengthFacetImpl;
import org.eclipse.xsd.impl.XSDMinExclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDMinInclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDMinLengthFacetImpl;
import org.eclipse.xsd.impl.XSDTotalDigitsFacetImpl;
import org.eclipse.xsd.impl.XSDWhiteSpaceFacetImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XSDFixedFacetImpl
extends XSDConstrainingFacetImpl
implements XSDFixedFacet {
    protected static final boolean FIXED_EDEFAULT = false;
    protected boolean fixed = false;
    protected boolean fixedESet = false;

    public static XSDFixedFacet createFixedFacet(Node node) {
        switch (XSDConstants.nodeType(node)) {
            case 15: {
                return XSDFractionDigitsFacetImpl.createFractionDigitsFacet(node);
            }
            case 21: {
                return XSDLengthFacetImpl.createLengthFacet(node);
            }
            case 23: {
                return XSDMaxExclusiveFacetImpl.createMaxExclusiveFacet(node);
            }
            case 24: {
                return XSDMaxInclusiveFacetImpl.createMaxInclusiveFacet(node);
            }
            case 25: {
                return XSDMaxLengthFacetImpl.createMaxLengthFacet(node);
            }
            case 26: {
                return XSDMinExclusiveFacetImpl.createMinExclusiveFacet(node);
            }
            case 27: {
                return XSDMinInclusiveFacetImpl.createMinInclusiveFacet(node);
            }
            case 28: {
                return XSDMinLengthFacetImpl.createMinLengthFacet(node);
            }
            case 38: {
                return XSDTotalDigitsFacetImpl.createTotalDigitsFacet(node);
            }
            case 41: {
                return XSDWhiteSpaceFacetImpl.createWhiteSpaceFacet(node);
            }
        }
        return null;
    }

    protected XSDFixedFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDFixedFacet();
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean newFixed) {
        boolean oldFixed = this.fixed;
        this.fixed = newFixed;
        boolean oldFixedESet = this.fixedESet;
        this.fixedESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 10, oldFixed, this.fixed, !oldFixedESet));
        }
    }

    public void unsetFixed() {
        boolean oldFixed = this.fixed;
        boolean oldFixedESet = this.fixedESet;
        this.fixed = false;
        this.fixedESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 10, oldFixed, false, oldFixedESet));
        }
    }

    public boolean isSetFixed() {
        return this.fixedESet;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove(otherEnd, msgs);
                }
                case 8: {
                    return this.basicSetAnnotation(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getLexicalValue();
            }
            case 6: {
                return this.getFacetName();
            }
            case 7: {
                return this.getEffectiveValue();
            }
            case 8: {
                return this.getAnnotation();
            }
            case 9: {
                return this.getSimpleTypeDefinition();
            }
            case 10: {
                return this.isFixed() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setLexicalValue((String)newValue);
                return;
            }
            case 8: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 10: {
                this.setFixed((Boolean)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(XSDConcreteComponentImpl.ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setLexicalValue(XSDFacetImpl.LEXICAL_VALUE_EDEFAULT);
                return;
            }
            case 8: {
                this.setAnnotation(null);
                return;
            }
            case 10: {
                this.unsetFixed();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return XSDConcreteComponentImpl.ELEMENT_EDEFAULT == null ? this.element != null : !XSDConcreteComponentImpl.ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return XSDFacetImpl.LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !XSDFacetImpl.LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 6: {
                return XSDFacetImpl.FACET_NAME_EDEFAULT == null ? this.getFacetName() != null : !XSDFacetImpl.FACET_NAME_EDEFAULT.equals(this.getFacetName());
            }
            case 7: {
                return XSDFacetImpl.EFFECTIVE_VALUE_EDEFAULT == null ? this.getEffectiveValue() != null : !XSDFacetImpl.EFFECTIVE_VALUE_EDEFAULT.equals(this.getEffectiveValue());
            }
            case 8: {
                return this.annotation != null;
            }
            case 9: {
                return this.getSimpleTypeDefinition() != null;
            }
            case 10: {
                return this.isSetFixed();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (fixed: ");
        if (this.fixedESet) {
            result.append(this.fixed);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public void validate() {
        XSDSimpleTypeDefinition baseTypeDefinition;
        super.validate();
        Element theElement = this.getElement();
        this.checkBuiltInTypeConstraint("boolean", null, "http://www.w3.org/TR/xmlschema-2/", "element-" + this.getFacetName(), theElement, "fixed", false);
        this.checkAttributes("http://www.w3.org/TR/xmlschema-2/", "element-" + this.getFacetName(), theElement, new String[]{"fixed", "value", "id"});
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getSimpleTypeDefinition();
        Iterator facets = xsdSimpleTypeDefinition.getFacetContents().iterator();
        while (facets.hasNext()) {
            XSDFacet xsdFacet = (XSDFacet)facets.next();
            if (xsdFacet == this) break;
            if (xsdFacet.eClass() != this.eClass()) continue;
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "src-single-facet-value", theElement, "value", new Object[]{this.getFacetName()});
            xsdDiagnostic.getComponents().add(xsdFacet);
            break;
        }
        if ((baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition()) != null) {
            Iterator facets2 = baseTypeDefinition.getFacets().iterator();
            while (facets2.hasNext()) {
                XSDConstrainingFacet xsdConstrainingFacet = (XSDConstrainingFacet)facets2.next();
                if (!(xsdConstrainingFacet instanceof XSDFixedFacet)) continue;
                XSDFixedFacet xsdFixedFacet = (XSDFixedFacet)xsdConstrainingFacet;
                if (this.eClass() == xsdFixedFacet.eClass() && xsdFixedFacet.isFixed() && !baseTypeDefinition.equalValues(this.getEffectiveValue(), xsdFixedFacet.getEffectiveValue())) {
                    XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "facet-fixed-valid-restriction", theElement, "value", new Object[]{this.getLexicalValue(), xsdFixedFacet.getLexicalValue(), this.getFacetName(), baseTypeDefinition.getURI()});
                    xsdDiagnostic.getComponents().add(xsdFixedFacet);
                    xsdDiagnostic.setAnnotationURI("http://www.w3.org/TR/xmlschema-2/#dc-" + this.getFacetName());
                    break;
                }
                if (!this.restrictionMatch(xsdFixedFacet)) continue;
                this.validateRestriction(xsdFixedFacet);
                break;
            }
        }
    }

    protected void validateValue() {
        this.checkBuiltInTypeConstraint("nonNegativeInteger", this.getLexicalValue(), "http://www.w3.org/TR/xmlschema-2/", "element" + this.getFacetName(), this.getElement(), "value", true);
    }

    protected boolean restrictionMatch(XSDFixedFacet xsdFixedFacet) {
        return xsdFixedFacet.eClass() == this.eClass();
    }

    protected void validateRestriction(XSDFixedFacet xsdFixedFacet) {
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement == this.getElement()) {
            if (changedElement.hasAttributeNS(null, "fixed")) {
                boolean newFixed = "true".equals(changedElement.getAttributeNS(null, "fixed"));
                if (!this.isSetFixed() || newFixed != this.isFixed()) {
                    this.setFixed(newFixed);
                }
            } else {
                this.unsetFixed();
            }
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        Element theElement;
        super.changeAttribute(eAttribute);
        if (!(this.isReconciling || eAttribute != null && eAttribute != XSDPackage.eINSTANCE.getXSDFixedFacet_Fixed() || (theElement = this.getElement()) == null)) {
            this.niceSetAttribute(theElement, "fixed", this.isSetFixed() ? (this.isFixed() ? "true" : "false") : null);
        }
    }
}

