/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.core.SerializationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class XmlUtility
implements Constants {
    private static boolean isJAXPAvailable = true;
    private static String encoding = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Writer;
    static /* synthetic */ Class class$org$w3c$dom$Document;

    public static String serialize(Document document) throws SerializationException {
        return XmlUtility.serialize(document, true);
    }

    public static String serialize(Document document, boolean bl) throws SerializationException {
        try {
            return new String(XmlUtility.serializeAsByteArray(document, bl), encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SerializationException(unsupportedEncodingException.getMessage());
        }
    }

    public static void serialize(Document document, File file) throws SerializationException {
        XmlUtility.serialize(document, file, true);
    }

    public static void serialize(Document document, File file, boolean bl) throws SerializationException {
        try {
            XmlUtility.serialize(document, new FileOutputStream(file), bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SerializationException(fileNotFoundException.getMessage());
        }
    }

    public static void serialize(Document document, OutputStream outputStream) throws SerializationException {
        XmlUtility.serialize(document, outputStream, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Document document, OutputStream outputStream, boolean bl) throws SerializationException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                outputStreamWriter = new OutputStreamWriter(outputStream, encoding);
                XmlUtility.serialize(document, outputStreamWriter, bl);
            }
            catch (Exception exception) {
                throw new SerializationException(exception.getMessage());
            }
            Object var6_4 = null;
            if (outputStreamWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (outputStreamWriter == null) throw throwable;
            try {
                ((Writer)outputStreamWriter).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((Writer)outputStreamWriter).close();
        return;
    }

    public static byte[] serializeAsByteArray(Document document) throws SerializationException {
        return XmlUtility.serializeAsByteArray(document, true);
    }

    public static byte[] serializeAsByteArray(Document document, boolean bl) throws SerializationException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlUtility.serialize(document, byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public static void serialize(Document document, Writer writer) throws SerializationException {
        XmlUtility.serialize(document, writer, true);
    }

    public static void serialize(Document document, Writer writer, boolean bl) throws SerializationException {
        if (isJAXPAvailable) {
            try {
                JAXPXMLSerializer.serialize(document, writer, bl);
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                isJAXPAvailable = false;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                isJAXPAvailable = false;
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                isJAXPAvailable = false;
            }
            catch (Exception exception) {
                throw new SerializationException(exception.toString());
            }
        }
        try {
            XercesXMLSerializer.serialize(document, writer, bl);
        }
        catch (Exception exception) {
            throw new SerializationException(exception.toString());
        }
    }

    public static String normalize(String string) {
        if (string == null) {
            return "null";
        }
        int n = string.length();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (c == '\t') {
                stringBuffer.append("&#x9;");
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("&#xA;");
                continue;
            }
            if (c == '\r') {
                stringBuffer.append("&#xD;");
                continue;
            }
            if (c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') {
                stringBuffer.append(c);
                continue;
            }
            if (c >= '\u0001' && c <= '\u0010' && i + 1 < n) {
                stringBuffer.append(c);
                stringBuffer.append(string.charAt(++i));
                continue;
            }
            stringBuffer.append('?');
        }
        return stringBuffer.toString();
    }

    public static String denormalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        int n = -1;
        String string2 = null;
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c == '&' && (n = string.indexOf(59, i + 1)) != -1) {
                string2 = string.substring(i + 1, n).trim();
                if (string2.equals("lt")) {
                    stringBuffer.append('<');
                } else if (string2.equals("gt")) {
                    stringBuffer.append('>');
                } else if (string2.equals("amp")) {
                    stringBuffer.append('&');
                } else if (string2.equals("quot")) {
                    stringBuffer.append('\"');
                } else if (string2.equals("apos")) {
                    stringBuffer.append('\'');
                } else if (string2.equals("#x9") || string2.equals("#09")) {
                    stringBuffer.append('\t');
                } else if (string2.equals("#xA") || string2.equals("#10")) {
                    stringBuffer.append('\n');
                } else if (string2.equals("#xD") || string2.equals("#13")) {
                    stringBuffer.append('\r');
                } else {
                    stringBuffer.append('&');
                    stringBuffer.append(string2);
                    stringBuffer.append(';');
                }
                i = n;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static void removeIgnorableWhitespace(Node node) {
        if (node != null) {
            Object object;
            if (node.getNodeType() == 3 && (object = node.getNodeValue()) != null && ((String)object).trim().length() == 0) {
                node.setNodeValue(((String)object).trim());
            }
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                XmlUtility.removeIgnorableWhitespace((Node)object);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        encoding = Constants.OS_NAME.equals("z/OS") || Constants.OS_NAME.equals("OS/390") ? "IBM-1047" : "UTF-8";
    }

    private static class XercesXMLSerializer
    implements Constants {
        private static Object outputFormat = null;
        private static String xmlDeclaration = null;

        private XercesXMLSerializer() {
        }

        private static void serialize(Document document, Writer writer, boolean bl) throws Exception {
            Object object;
            String string;
            Object object2;
            Object object3;
            if (outputFormat == null) {
                object3 = Class.forName("org.apache.xml.serialize.OutputFormat");
                outputFormat = ((Class)object3).newInstance();
                ((Class)object3).getMethod("setMethod", class$java$lang$String == null ? (class$java$lang$String = XmlUtility.class$("java.lang.String")) : class$java$lang$String).invoke(outputFormat, "xml");
                ((Class)object3).getMethod("setOmitXMLDeclaration", Boolean.TYPE).invoke(outputFormat, Boolean.TRUE);
                ((Class)object3).getMethod("setOmitDocumentType", Boolean.TYPE).invoke(outputFormat, Boolean.TRUE);
                ((Class)object3).getMethod("setLineWidth", Integer.TYPE).invoke(outputFormat, new Integer(0));
                ((Class)object3).getMethod("setLineSeparator", class$java$lang$String == null ? (class$java$lang$String = XmlUtility.class$("java.lang.String")) : class$java$lang$String).invoke(outputFormat, Constants.LINE_SEPARATOR);
                xmlDeclaration = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
                ((Class)object3).getMethod("setEncoding", class$java$lang$String == null ? (class$java$lang$String = XmlUtility.class$("java.lang.String")) : class$java$lang$String).invoke(outputFormat, encoding);
            }
            writer.write(xmlDeclaration);
            writer.flush();
            if (bl) {
                writer.write(Constants.LINE_SEPARATOR);
                writer.flush();
            }
            if ((object3 = document.getDoctype()) != null) {
                object2 = object3.getSystemId();
                string = object3.getInternalSubset();
                if (object2 != null || string != null) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("<!DOCTYPE ");
                    ((StringBuffer)object).append(object3.getName());
                    if (object2 != null) {
                        String string2 = object3.getPublicId();
                        if (string2 != null) {
                            ((StringBuffer)object).append(" PUBLIC \"");
                            ((StringBuffer)object).append(string2);
                            ((StringBuffer)object).append("\" \"");
                        } else {
                            ((StringBuffer)object).append(" SYSTEM \"");
                        }
                        ((StringBuffer)object).append((String)object2);
                        ((StringBuffer)object).append("\">");
                    } else {
                        ((StringBuffer)object).append(" [");
                        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "\n\r\f");
                        if (bl) {
                            ((StringBuffer)object).append(Constants.LINE_SEPARATOR);
                            while (stringTokenizer.hasMoreTokens()) {
                                ((StringBuffer)object).append("  ");
                                ((StringBuffer)object).append(stringTokenizer.nextToken().trim());
                                ((StringBuffer)object).append(Constants.LINE_SEPARATOR);
                            }
                        } else {
                            while (stringTokenizer.hasMoreTokens()) {
                                ((StringBuffer)object).append(stringTokenizer.nextToken().trim());
                            }
                        }
                        ((StringBuffer)object).append("]>");
                    }
                    if (bl) {
                        ((StringBuffer)object).append(Constants.LINE_SEPARATOR);
                    }
                    writer.write(((StringBuffer)object).toString());
                    writer.flush();
                }
            }
            outputFormat.getClass().getMethod("setIndent", Integer.TYPE).invoke(outputFormat, new Integer(bl ? 2 : 0));
            object2 = Class.forName("org.apache.xml.serialize.XMLSerializer");
            string = ((Class)object2).getConstructor(class$java$io$Writer == null ? (class$java$io$Writer = XmlUtility.class$("java.io.Writer")) : class$java$io$Writer, outputFormat.getClass()).newInstance(writer, outputFormat);
            if (bl) {
                ((Class)object2).getMethod("serialize", class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = XmlUtility.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document).invoke((Object)string, document);
            } else {
                object = document.cloneNode(true);
                XmlUtility.removeIgnorableWhitespace((Node)object);
                ((Class)object2).getMethod("serialize", class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = XmlUtility.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document).invoke((Object)string, object);
            }
        }
    }

    private static class JAXPXMLSerializer
    implements Constants {
        private static String xmlDeclaration = null;
        private static Transformer transformer = null;

        private JAXPXMLSerializer() {
        }

        private static void serialize(Document document, Writer writer, boolean bl) throws Exception {
            Object object;
            DocumentType documentType;
            if (transformer == null) {
                transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                xmlDeclaration = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
                transformer.setOutputProperty("encoding", encoding);
            }
            writer.write(xmlDeclaration);
            writer.flush();
            if (bl) {
                writer.write(Constants.LINE_SEPARATOR);
                writer.flush();
            }
            if ((documentType = document.getDoctype()) != null) {
                object = documentType.getSystemId();
                String string = documentType.getInternalSubset();
                if (object != null || string != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("<!DOCTYPE ");
                    stringBuffer.append(documentType.getName());
                    if (object != null) {
                        String string2 = documentType.getPublicId();
                        if (string2 != null) {
                            stringBuffer.append(" PUBLIC \"");
                            stringBuffer.append(string2);
                            stringBuffer.append("\" \"");
                        } else {
                            stringBuffer.append(" SYSTEM \"");
                        }
                        stringBuffer.append((String)object);
                        stringBuffer.append("\">");
                    } else {
                        stringBuffer.append(" [");
                        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "\n\r\f");
                        if (bl) {
                            stringBuffer.append(Constants.LINE_SEPARATOR);
                            while (stringTokenizer.hasMoreTokens()) {
                                stringBuffer.append("  ");
                                stringBuffer.append(stringTokenizer.nextToken().trim());
                                stringBuffer.append(Constants.LINE_SEPARATOR);
                            }
                        } else {
                            while (stringTokenizer.hasMoreTokens()) {
                                stringBuffer.append(stringTokenizer.nextToken().trim());
                            }
                        }
                        stringBuffer.append("]>");
                    }
                    if (bl) {
                        stringBuffer.append(Constants.LINE_SEPARATOR);
                    }
                    writer.write(stringBuffer.toString());
                    writer.flush();
                }
            }
            if (bl) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", String.valueOf("  ".length()));
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf("  ".length()));
                transformer.transform(new DOMSource(document), new StreamResult(writer));
            } else {
                transformer.setOutputProperty("indent", "no");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "0");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "0");
                object = document.cloneNode(true);
                XmlUtility.removeIgnorableWhitespace((Node)object);
                transformer.transform(new DOMSource((Node)object), new StreamResult(writer));
            }
        }
    }
}

