/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.RABinaryArray;
import org.eclipse.hyades.internal.execution.local.common.RAInetAddress;
import org.eclipse.hyades.internal.execution.local.common.RAString;

public class Message
implements Constants {
    protected long _version = 256L;
    protected long _type = 0L;
    protected long _ticket = 0L;

    public int getSize() {
        return 16;
    }

    public long getTicket() {
        return this._ticket;
    }

    public long getType() {
        return this._type;
    }

    public long getVersion() {
        return this._version;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        Message.readRALongFromBuffer(buffer, offset);
        this._version = Message.readRALongFromBuffer(buffer, offset += 4);
        this._type = Message.readRALongFromBuffer(buffer, offset += 4);
        this._ticket = Message.readRALongFromBuffer(buffer, offset += 4);
        return offset += 4;
    }

    public static long readRALongFromBuffer(byte[] buffer, int offset) {
        return (long)(buffer[0 + offset] << 24 & 0xFF000000) | (long)(buffer[1 + offset] << 16 & 0xFF0000) | (long)(buffer[2 + offset] << 8 & 0xFF00) | (long)(buffer[3 + offset] & 0xFF);
    }

    public static int readRAStringFromBuffer(byte[] buffer, int offset, RAString rastring) {
        String data;
        long length = Message.readRALongFromBuffer(buffer, offset);
        try {
            data = new String(buffer, offset + 4, (int)length, "UTF-8");
        }
        catch (Throwable e) {
            data = new String(buffer, 0, offset + 4, (int)length);
        }
        rastring.setData(data);
        return offset + rastring.getSize();
    }

    public static int readRABinaryArrayFromBuffer(byte[] buffer, int offset, RABinaryArray raarray) {
        long length = Message.readRALongFromBuffer(buffer, offset);
        raarray.setData(buffer, offset + 4, (int)length);
        return offset + raarray.getSize();
    }

    public static int readRAInetAddressFromBuffer(byte[] buffer, int offset, RAInetAddress ipaddr) {
        int length = buffer[0 + offset];
        byte[] address = new byte[length];
        for (int i = 0; i < length; ++i) {
            address[i] = buffer[1 + i];
        }
        ipaddr.setLength(length);
        ipaddr.setData(address);
        return offset + 1 + length;
    }

    public void setTicket(long ticket) {
        this._ticket = ticket;
    }

    public void setVersion(long version) {
        this._version = version;
    }

    public static int writeRALongToBuffer(byte[] buffer, int offset, long ralong) {
        buffer[0 + offset] = (byte)(ralong >> 24 & 0xFFL);
        buffer[1 + offset] = (byte)(ralong >> 16 & 0xFFL);
        buffer[2 + offset] = (byte)(ralong >> 8 & 0xFFL);
        buffer[3 + offset] = (byte)ralong;
        return offset + 4;
    }

    public static int writeRAStringToBuffer(byte[] buffer, int offset, RAString rastring) {
        byte[] strData;
        try {
            strData = rastring.getData().getBytes("UTF-8");
        }
        catch (Throwable e) {
            strData = rastring.getData().getBytes();
        }
        Message.writeRALongToBuffer(buffer, offset, strData.length);
        System.arraycopy(strData, 0, buffer, offset + 4, strData.length);
        return offset + rastring.getSize();
    }

    public static int writeRABinaryArrayToBuffer(byte[] buffer, int offset, RABinaryArray raarray) {
        if (raarray == null) {
            Message.writeRALongToBuffer(buffer, offset, 0L);
            return offset + 4;
        }
        byte[] data = raarray.getData();
        Message.writeRALongToBuffer(buffer, offset, data.length);
        System.arraycopy(data, 0, buffer, offset + 4, data.length);
        return offset + raarray.getSize();
    }

    public static int writeRAInetAddressToBuffer(byte[] buffer, int offset, RAInetAddress addr) {
        if (addr == null) {
            buffer[offset] = 0;
            return offset + 1;
        }
        try {
            InetAddress address = addr.getAddress();
            if (address == null) {
                buffer[offset] = 0;
                return offset + 1;
            }
            byte[] bytes = address.getAddress();
            buffer[offset + 0] = (byte)bytes.length;
            for (int i = 0; i < bytes.length; ++i) {
                buffer[offset + i + 1] = bytes[i];
            }
            return offset + 1 + bytes.length;
        }
        catch (UnknownHostException e) {
            buffer[offset] = 0;
            return offset + 1;
        }
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = offset;
        current = Message.writeRALongToBuffer(buffer, current, -2107283584L);
        current = Message.writeRALongToBuffer(buffer, current, 256L);
        current = Message.writeRALongToBuffer(buffer, current, this._type);
        current = Message.writeRALongToBuffer(buffer, current, this._ticket);
        return current;
    }
}

