/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.URIConverter;

class URIMappingRegistryReader
extends RegistryReader {
    static final String TAG_MAPPING = "mapping";
    static final String ATT_SOURCE = "source";
    static final String ATT_TARGET = "target";

    public URIMappingRegistryReader() {
        super(Platform.getExtensionRegistry(), EcorePlugin.getPlugin().getBundle().getSymbolicName(), "uri_mapping");
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_MAPPING)) {
            String sourceURIValue = element.getAttribute(ATT_SOURCE);
            if (sourceURIValue == null) {
                this.logMissingAttribute(element, ATT_SOURCE);
            } else {
                String targetURIValue = element.getAttribute(ATT_TARGET);
                if (targetURIValue == null) {
                    this.logMissingAttribute(element, ATT_TARGET);
                } else {
                    URI sourceURI = URI.createURI(sourceURIValue);
                    URI targetURI = URI.createURI(targetURIValue);
                    if (targetURI.isRelative() && targetURI.hasRelativePath()) {
                        targetURI = targetURI.resolve(URI.createURI(Platform.getBundle((String)element.getDeclaringExtension().getNamespace()).getEntry("/").toString()));
                    }
                    URIConverter.URI_MAP.put(sourceURI, targetURI);
                    return true;
                }
            }
        }
        return false;
    }
}

