/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import [Ljava.lang.String;;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.bootstrap.NlvPrintStream;
import com.ibm.ws.bootstrap.StopWatch;
import com.ibm.ws.bootstrap.TimeBomb;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class WSLauncher
implements Runnable {
    public static boolean debug = Boolean.getBoolean("ws.ext.debug");
    public static PrintStream out = System.out;
    private static final StopWatch stopwatch = StopWatch.instance();
    private static ExtClassLoader extClassLoader = null;
    private static ResourceBundle bundle = null;
    private static Thread shutdownHook = new OnExit();
    private static final boolean isZOS;
    private static final boolean isIseries;
    private static Object[] handlers;
    private static String[] args;

    public static void main(String[] stringArray) {
        args = stringArray;
        Thread thread = new Thread(new WSLauncher());
        thread.start();
    }

    public void run() {
        Object object;
        String string;
        block16: {
            if (args.length < 1) {
                out.println("usage: WSLauncher <className>");
                System.exit(-1);
            }
            stopwatch.start(args[0]);
            String string2 = System.getProperty("ws.output.encoding");
            if (string2 != null && !string2.equals("file")) {
                if (string2.equals("console")) {
                    string = System.getProperty("file.encoding");
                    string2 = string.equalsIgnoreCase("Cp1252") ? "Cp850" : null;
                }
                if (string2 != null) {
                    try {
                        System.setOut(new NlvPrintStream((OutputStream)System.out, true, string2));
                        System.setErr(new NlvPrintStream((OutputStream)System.err, true, string2));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (!debug) break block16;
                        unsupportedEncodingException.printStackTrace();
                    }
                }
            }
        }
        out = System.out;
        string = System.getProperty("ws.ext.dirs");
        extClassLoader = new ExtClassLoader(string);
        if (debug) {
            out.println("ws.ext.dirs=" + string);
            object = extClassLoader._getURLs();
            for (int i = 0; i < ((URL[])object).length; ++i) {
                out.println("ws.ext.classpath[" + i + "]=" + object[i]);
            }
        }
        Thread.currentThread().setContextClassLoader(extClassLoader);
        if (!(WSLauncher.isISeries() || WSLauncher.isZOS() || TimeBomb.checkLicense(true) || args[0].indexOf("WsServerStop") >= 0)) {
            System.exit(-1);
        }
        WSLauncher.doPreload(args, extClassLoader);
        object = null;
        try {
            if (debug) {
                out.println("ws.ext.main.class=" + args[0]);
            }
            object = extClassLoader.loadClass(args[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace(out);
            System.exit(-1);
        }
        String[] stringArray = new String[args.length - 1];
        System.arraycopy(args, 1, stringArray, 0, stringArray.length);
        if (debug) {
            for (int i = 0; i < stringArray.length; ++i) {
                out.println("ws.ext.mains.args[" + i + "]=" + stringArray[i]);
            }
        }
        Method method = null;
        Object object2 = null;
        try {
            method = ((Class)object).getMethod("main", String;.class);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            stringArray = WSLauncher.preInvoke(args[0], stringArray, extClassLoader);
            stringArray = WSLauncher.removeProfileName(args[0], stringArray);
            object2 = method.invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            exception.printStackTrace(out);
        }
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
        WSLauncher.onExit();
    }

    public static boolean isZOS() {
        return isZOS;
    }

    public static boolean isISeries() {
        return isIseries;
    }

    public static void doPreload(String[] stringArray, ExtClassLoader extClassLoader) {
        stopwatch.start("Preload");
        if (Boolean.getBoolean("ibm.websphere.preload.classes")) {
            String string = WSLauncher.determinePreloadFile(stringArray);
            if (string != null) {
                WSLauncher.debug("Preloading classes using: " + string);
                extClassLoader.enablePreloadRecording(string);
                extClassLoader.preloadClasses();
            } else {
                WSLauncher.debug("We couldn't determine the preload file, so not preloading.");
            }
        } else {
            WSLauncher.debug("Preload disabled");
        }
        stopwatch.stop();
    }

    private static String determinePreloadFile(String[] stringArray) {
        String string = null;
        if (stringArray[0].equals("com.ibm.ws.runtime.WsServer")) {
            string = stringArray[2] + "." + stringArray[3] + "." + stringArray[4] + ".preload";
        } else {
            int n = stringArray[0].lastIndexOf(46);
            if (n != -1) {
                string = stringArray[0].substring(n + 1) + ".preload";
            }
        }
        String string2 = System.getProperty("ibm.websphere.preload.file");
        if (string2 != null) {
            File file = new File(string2);
            if (!file.exists()) {
                if (string2.trim().endsWith(File.separator)) {
                    file.mkdirs();
                    File file2 = new File(file, string);
                    try {
                        file2.createNewFile();
                        string2 = file2.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string2 = null;
                    }
                } else {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException iOException) {
                        string2 = null;
                    }
                }
            } else if (file.isDirectory()) {
                File file3 = new File(file, string);
                try {
                    file3.createNewFile();
                    string2 = file3.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = null;
                }
            }
        } else {
            String string3 = System.getProperty("user.install.root");
            String[] stringArray2 = new String[]{string3, "logs", "preload", string};
            string2 = WSLauncher.fileExists(stringArray2);
            if (string2 == null) {
                string2 = WSLauncher.fileCanExist(stringArray2);
            }
        }
        return string2;
    }

    private static String fileExists(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                return null;
            }
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(File.separator);
        }
        File file = new File(stringBuffer.toString());
        if (file.exists() && file.isFile()) {
            return stringBuffer.toString();
        }
        return null;
    }

    private static String fileCanExist(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (stringArray[i] == null) {
                return null;
            }
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(File.separator);
        }
        File file = new File(stringBuffer.toString());
        if (!file.exists() && !file.mkdirs()) {
            return null;
        }
        if (file.exists() && file.isDirectory() && file.canWrite()) {
            File file2 = new File(file, stringArray[stringArray.length - 1]);
            try {
                if (file2.createNewFile()) {
                    return stringBuffer.toString() + File.separator + stringArray[stringArray.length - 1];
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void debug(String string) {
        if (debug) {
            out.println("[Debug]: " + string);
        }
    }

    protected static void trace(String string) {
        WSLauncher.trace(string, null);
    }

    protected static void trace(String string, Object object) {
        WSLauncher.trace(string, new Object[]{object});
    }

    protected static void trace(String string, Object[] objectArray) {
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("com.ibm.ws.bootstrap.bootstrap");
        }
        try {
            String string2 = bundle.getString(string);
            if (string2 != null) {
                string2 = MessageFormat.format(string2, objectArray);
                out.println(string2);
                return;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        out.println(string);
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            out.println(objectArray[i]);
        }
    }

    static void onExit() {
        WSLauncher.exitPreload();
        WSLauncher.postInvoke();
    }

    static void exitPreload() {
        extClassLoader.disablePreloadRecording();
        stopwatch.stop();
    }

    private static String[] preInvoke(String string, String[] stringArray, ClassLoader classLoader) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("was.install.root"));
        stringBuffer.append(File.separator);
        stringBuffer.append("bin");
        stringBuffer.append(File.separator);
        stringBuffer.append("boot");
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        stringBuffer.append(".boot");
        File file = new File(stringBuffer.toString());
        if (!file.exists()) {
            return stringArray;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            vector.add(string2.trim());
        }
        bufferedReader.close();
        handlers = new Object[vector.size()];
        Class[] classArray = new Class[]{string.getClass(), stringArray.getClass()};
        for (int i = 0; i < handlers.length; ++i) {
            Class<?> clazz = classLoader.loadClass((String)vector.get(i));
            try {
                Constructor<?> constructor = clazz.getConstructor(null);
                WSLauncher.handlers[i] = constructor.newInstance(null);
                Method method = clazz.getMethod("preInvoke", classArray);
                stringArray = (String[])method.invoke(handlers[i], string, stringArray);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return stringArray;
    }

    private static void postInvoke() {
        if (handlers == null) {
            return;
        }
        for (int i = handlers.length - 1; i >= 0; --i) {
            if (handlers[i] == null) continue;
            Method method = null;
            try {
                method = handlers[i].getClass().getMethod("postInvoke", null);
                method.invoke(handlers[i], null);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String[] removeProfileName(String string, String[] stringArray) {
        String[] stringArray2 = stringArray;
        if (!string.equals("com.ibm.ws.profile.WSProfileCLI") && !Boolean.getBoolean("KeepProfileName")) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("-profileName")) continue;
                int n = 1;
                if (i < stringArray.length - 1 && !stringArray[i + 1].startsWith("-")) {
                    n = 2;
                }
                stringArray2 = new String[stringArray.length - n];
                System.arraycopy(stringArray, 0, stringArray2, 0, i);
                System.arraycopy(stringArray, i + n, stringArray2, i, stringArray2.length - i);
                break;
            }
        }
        return stringArray2;
    }

    static {
        handlers = null;
        args = null;
        boolean bl = Boolean.getBoolean("com.ibm.websphere.zos.forcedist");
        String string = System.getProperty("os.name").trim();
        isZOS = (string.equals("OS/390") || string.equals("z/OS")) && !bl;
        isIseries = string.equals("OS/400");
    }

    private static class OnExit
    extends Thread {
        private OnExit() {
        }

        public void run() {
            WSLauncher.onExit();
        }
    }
}

