/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.PreloadFile;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Manifest;

public class ExtClassLoader
extends URLClassLoader
implements WsClassLoader {
    protected ArrayList containedPaths = new ArrayList();
    protected ArrayList nativePaths = new ArrayList();
    String classpath = null;
    String nativepath = null;
    private PreloadFile preloadFile = new PreloadFile(this);
    private boolean accumulatingPreloadCodeSources = true;
    private boolean accumulatingPreloadClasses = false;

    public ExtClassLoader(String string) {
        this(string, Thread.currentThread().getContextClassLoader());
    }

    public ExtClassLoader(ClassLoader classLoader) {
        this((String)null, classLoader);
    }

    public ExtClassLoader(String string, ClassLoader classLoader) {
        super(new URL[0], classLoader);
        if (string != null) {
            this.addPath(string);
        }
        this.processPreloadProperties("preload.properties");
        this.removeJVMClassLoaderPath();
        this.accumulatingPreloadCodeSources = false;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = super.findClass(string);
        if (WSLauncher.debug) {
            WSLauncher.out.println("[Loaded " + string + " by ExtClassLoader]");
        }
        if (this.accumulatingPreloadClasses) {
            this.preloadFile.recordClassLoad(string);
        }
        return clazz;
    }

    protected String findLibrary(String string) {
        String string2;
        if (WSLauncher.debug) {
            WSLauncher.out.println("looking for library on nativepath: " + string);
        }
        if ((string2 = this.findLibrary0(string, this.nativePaths)) == null) {
            if (WSLauncher.debug) {
                WSLauncher.out.println("looking for library on classpath: " + string);
            }
            string2 = this.findLibrary0(string, this.containedPaths);
        }
        return string2;
    }

    protected String findLibrary0(String string, ArrayList arrayList) {
        final String string2 = System.mapLibraryName(string);
        final ArrayList arrayList2 = arrayList;
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        URL uRL = (URL)arrayList2.get(i);
                        File file = new File(uRL.getFile());
                        if (!file.isDirectory()) continue;
                        File file2 = new File(file, string2);
                        if (WSLauncher.debug) {
                            WSLauncher.out.println("File: " + file2.getPath() + (file2.isFile() ? " is a file" : " is not a file"));
                            WSLauncher.out.println("File: " + file2.getPath() + (file2.exists() ? " exists" : " does not exist"));
                        }
                        if (!file2.exists()) continue;
                        if (WSLauncher.debug) {
                            WSLauncher.out.println("library found: " + file2.getPath());
                        }
                        return file2.getPath();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public void addPath(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                Object[] objectArray;
                File file = new File(stringTokenizer.nextToken());
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (file.isDirectory() && file.list().length == 0) continue;
                try {
                    objectArray = file.toURL();
                    this.addURL((URL)objectArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!file.isDirectory()) continue;
                if (WSLauncher.debug) {
                    WSLauncher.out.println("Adding jar and zip files from " + file.getPath());
                }
                if ((objectArray = file.list()) == null) continue;
                Arrays.sort(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = ((String)objectArray[i]).toLowerCase();
                    if (WSLauncher.debug) {
                        WSLauncher.out.println("Checking file " + string2);
                    }
                    if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) continue;
                    File file2 = new File(file, (String)objectArray[i]);
                    try {
                        this.addURL(file2.toURL());
                        if (!this.accumulatingPreloadCodeSources) continue;
                        this.preloadFile.addLiveCodeSourceInfo(file2.toURL().toExternalForm());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void addURL(URL uRL) {
        if (!this.containedPaths.contains(uRL)) {
            this.containedPaths.add(uRL);
            super.addURL(uRL);
            this.classpath = null;
        }
    }

    public String getClassPath() {
        if (this.classpath == null) {
            StringBuffer stringBuffer = new StringBuffer();
            URL[] uRLArray = super.getURLs();
            for (int i = 0; i < uRLArray.length; ++i) {
                try {
                    File file = new File(uRLArray[i].getFile());
                    stringBuffer.append(file.getCanonicalPath());
                    stringBuffer.append(File.pathSeparator);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stringBuffer.append(System.getProperty("java.class.path"));
            this.classpath = stringBuffer.toString();
        }
        return this.classpath;
    }

    public URL[] getURLs() {
        return null;
    }

    public URL[] _getURLs() {
        return super.getURLs();
    }

    public void addNativePath(String string) {
        if (string == null) {
            if (WSLauncher.debug) {
                WSLauncher.out.println("Native path not added: invalid path argument (null)");
            }
        } else {
            File file = null;
            Exception exception = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    file = new File(stringTokenizer.nextToken()).getCanonicalFile();
                    this.nativePaths.add(file.toURL());
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                if (WSLauncher.debug) {
                    if (exception != null) {
                        WSLauncher.out.println("An error occurred adding native path \"" + (file == null ? "null" : file.toString()) + "\": " + exception);
                    } else if (!file.exists()) {
                        WSLauncher.out.println("Native path \"" + file.getPath() + "\" does not exist! Specify a directory containing a native library.");
                    } else if (!file.isDirectory()) {
                        WSLauncher.out.println("Native path \"" + file.getPath() + "\" is not a directory! Specify a directory containing a native library.");
                    } else {
                        String[] stringArray = file.list();
                        if (stringArray == null || stringArray.length == 0) {
                            WSLauncher.out.println("Native path \"" + file.getPath() + "\" is empty! Specify a directory containing a native library.");
                        } else {
                            boolean bl = false;
                            boolean bl2 = false;
                            String string2 = null;
                            for (int i = stringArray.length - 1; i >= 0; --i) {
                                if (stringArray[i] == null) continue;
                                string2 = stringArray[i].toLowerCase();
                                bl |= string2.endsWith(".dll") || string2.endsWith(".so") || string2.endsWith(".a");
                                bl2 |= string2.endsWith(".jar") || string2.endsWith(".zip") || string2.endsWith(".class");
                            }
                            if (!bl) {
                                WSLauncher.out.println("Native path \"" + file.getPath() + "\" contains no native libraries! Specify a directory containing a native library.");
                            }
                            if (bl2) {
                                WSLauncher.out.println("Native path \"" + file.getPath() + "\" contains JAR/Zip/class files. Should path be in classpath also/instead?");
                            }
                        }
                    }
                }
                file = null;
                exception = null;
            }
        }
    }

    public String getNativePath() {
        if (this.nativepath == null) {
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = this.nativePaths.toArray();
            for (int i = 0; i < this.nativePaths.size(); ++i) {
                try {
                    File file = new File(((URL)objectArray[i]).getFile());
                    stringBuffer.append(file.getCanonicalPath());
                    stringBuffer.append(File.pathSeparator);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.nativepath = stringBuffer.toString();
        }
        return this.nativepath;
    }

    public void enablePreloadRecording(String string) {
        this.preloadFile.setPreloadPath(string);
        this.accumulatingPreloadClasses = true;
    }

    public void disablePreloadRecording() {
        if (this.accumulatingPreloadClasses) {
            this.accumulatingPreloadClasses = false;
            try {
                this.preloadFile.rollUpChanges();
            }
            catch (Exception exception) {
                exception.printStackTrace(WSLauncher.out);
            }
        }
    }

    public void preloadClasses() {
        int n = 0;
        PreloadFile.ClassData classData = new PreloadFile.ClassData();
        long l = System.currentTimeMillis();
        try {
            this.preloadFile.lock();
        }
        catch (Exception exception) {
            WSLauncher.out.println("Exception trying to lock preload file.  Don't preload");
            exception.printStackTrace(WSLauncher.out);
            return;
        }
        if (this.preloadFile.checkCRC()) {
            while ((classData = this.preloadFile.getNextPreloadClass(classData)) != null) {
                if (this.findLoadedClass(classData.className) != null) continue;
                try {
                    byte[] byArray;
                    int n2 = classData.className.lastIndexOf(46);
                    if (n2 == -1 || (byArray = classData.getByteCodes()) == null) continue;
                    String string = classData.className.substring(0, n2);
                    Package package_ = this.getPackage(string);
                    CodeSource codeSource = classData.codeSourceInfo.getCodeSource();
                    if (package_ == null) {
                        Manifest manifest = this.preloadFile.getCurrentManifest();
                        if (manifest != null) {
                            this.definePackage(string, manifest, codeSource.getLocation());
                        } else {
                            this.definePackage(string, null, null, null, null, null, null, null);
                        }
                    }
                    this.defineClass(classData.className, byArray, 0, classData.size, codeSource);
                    ++n;
                }
                catch (Throwable throwable) {
                    this.preloadFile.recordFailedClassLoad(classData.className);
                }
            }
        }
        this.preloadFile.unlock();
        long l2 = System.currentTimeMillis();
        WSLauncher.debug("Preloaded " + n + " classes in " + (l2 - l) + " milliseconds.");
    }

    private void processPreloadProperties(final String string) {
        try {
            final Properties properties = new Properties();
            final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    InputStream inputStream = classLoader.getResourceAsStream(string);
                    properties.load(inputStream);
                    inputStream.close();
                    return null;
                }
            });
            this.processPreloadPaths(properties.getProperty("preload.additional.codesources"), true);
            this.processPreloadPaths(properties.getProperty("preload.removed.codesoures"), false);
            String string2 = System.getProperty("ibm.websphere.preload.removed.codesources");
            if (string2 != null) {
                this.processPreloadPaths(string2.replace(';', ' '), false);
            }
            this.processPrePreloadClasses(properties.getProperty("preload.prepreload.classes"));
        }
        catch (Throwable throwable) {
            System.err.println("Unable to read required resource: " + string);
            throwable.printStackTrace();
        }
    }

    private void processPreloadPaths(String string, boolean bl) {
        if (string == null) {
            return;
        }
        String string2 = System.getProperty("was.install.root");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.startsWith("/")) {
                string3 = string2 + File.separator + string3;
            }
            this.processPreloadPath(string3, bl);
        }
    }

    private void processPreloadPath(String string, boolean bl) {
        block9: {
            File file;
            block8: {
                if (string == null) {
                    return;
                }
                file = new File(string);
                if (!file.isDirectory()) break block8;
                String[] stringArray = file.list();
                if (stringArray == null) break block9;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].toLowerCase();
                    if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) continue;
                    File file2 = new File(file, stringArray[i]);
                    if (!this.accumulatingPreloadCodeSources) continue;
                    try {
                        if (bl) {
                            this.preloadFile.addLiveCodeSourceInfo(file2.toURL().toExternalForm());
                            continue;
                        }
                        this.preloadFile.removeLiveCodeSourceInfo(file2.toURL().toExternalForm());
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                break block9;
            }
            if (!file.exists()) break block9;
            try {
                if (bl) {
                    this.preloadFile.addLiveCodeSourceInfo(file.toURL().toExternalForm().toLowerCase());
                }
                this.preloadFile.removeLiveCodeSourceInfo(file.toURL().toExternalForm().toLowerCase());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private void removeJVMClassLoaderPath() {
        String string = System.getProperty("java.class.path");
        if (string != null) {
            String[] stringArray = string.split(File.pathSeparator);
            for (int i = stringArray.length - 1; i >= 0; --i) {
                this.processPreloadPath(stringArray[i], false);
            }
        }
    }

    private void processPrePreloadClasses(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Class.forName(stringArray[i], true, this);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

