/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.util;

import com.ibm.ejs.models.base.resources.url.URLProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil;
import com.ibm.ws.runtime.util.utilHandlerClass;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;

public class URLHandlerFactory
implements URLStreamHandlerFactory {
    private static final TraceComponent tc = Tr.register((Class)URLHandlerFactory.class, (String)"Runtime", (String)"com.ibm.ws.runtime.runtime");
    private Map streamHandlerTable;

    public URLHandlerFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"URLHandlerFactory ctor");
        }
        this.streamHandlerTable = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"URLHandlerFactory ctor");
        }
    }

    public void registerProvider(URLProvider uRLProvider) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("registerProvider " + uRLProvider));
        }
        String string = uRLProvider.getProtocol();
        String string2 = uRLProvider.getStreamHandlerClassName();
        String string3 = URLHandlerFactory.getProviderClasspath(uRLProvider.getClasspath());
        if (string != null && string2 != null) {
            this.streamHandlerTable.put(string, new utilHandlerClass(string2, string3));
        } else {
            Tr.warning((TraceComponent)tc, (String)"WSVR0051W", (Object)uRLProvider.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerProvider");
        }
    }

    public void registerProvider(URLProvider uRLProvider, String string) {
        String string2 = uRLProvider.getProtocol();
        String string3 = uRLProvider.getStreamHandlerClassName();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("registerProvider " + string2 + " : " + string3));
        }
        if (string2 != null && string3 != null) {
            this.streamHandlerTable.put(string2, new utilHandlerClass(string3, string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerProvider(provider,class)");
        }
    }

    public void registerProvider(String string, String string2) {
        String string3 = URLHandlerFactory.getClassName(string2);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("registerProvider " + string + " : " + string3));
        }
        if (string != null && string3 != null) {
            this.streamHandlerTable.put(string, new utilHandlerClass(string3, string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerProvider(provider,class)");
        }
    }

    public void deregisterProvider(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deregisterProvider");
        }
        if (string != null) {
            this.streamHandlerTable.remove(string);
        } else {
            Tr.info((TraceComponent)tc, (String)"WSVR0052");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deregisterProvider");
        }
    }

    public boolean queryProvider(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"queryProvider");
        }
        boolean bl = false;
        if (string != null) {
            bl = this.streamHandlerTable.containsKey(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"queryProvider");
        }
        return bl;
    }

    public URLStreamHandler createURLStreamHandler(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createURLStreamHandler for protocol=" + string));
        }
        URLStreamHandler uRLStreamHandler = null;
        if (string != null && string.length() > 0) {
            string = string.toLowerCase();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("streamHandlerTable=" + this.streamHandlerTable));
            }
            utilHandlerClass utilHandlerClass2 = (utilHandlerClass)this.streamHandlerTable.get(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("handler class " + utilHandlerClass2 + " retrieved from streamHandlerTable"));
            }
            if (utilHandlerClass2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found a handlerClass object for " + string));
                }
                if (utilHandlerClass2.getClassname() != null) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("attempting to get a class loader for " + utilHandlerClass2.getClasspath()));
                        }
                        ClassLoader classLoader = URLHandlerFactory.getResourceClassLoader(tc, utilHandlerClass2.getClasspath(), null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Attempting to load " + utilHandlerClass2.getClassname()));
                        }
                        Class<?> clazz = classLoader.loadClass(utilHandlerClass2.getClassname());
                        uRLStreamHandler = (URLStreamHandler)clazz.newInstance();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Found streamHandlerClass " + utilHandlerClass2.getClassname() + " for protocol " + string));
                        }
                    }
                    catch (Throwable throwable) {
                        String[] stringArray = new String[]{utilHandlerClass2.getClassname(), string};
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("URLStreamHandlerError " + throwable.toString() + " " + utilHandlerClass2.getClassname() + " " + string));
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Could not find streamHandlerClass for: " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createURLStreamHandler returning handler:" + uRLStreamHandler));
        }
        return uRLStreamHandler;
    }

    public static String getProviderClasspath(EList eList) {
        ListIterator listIterator = eList.listIterator();
        String string = new String();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            string = URLHandlerFactory.appendClasspathStrings(string, string2);
        }
        return string;
    }

    public static String getClassName(String string) {
        String string2 = new String(string);
        string2 = string2.replace(File.pathSeparatorChar, '.');
        return string2;
    }

    public static ClassLoader getResourceClassLoader(TraceComponent traceComponent, String string, ClassLoader classLoader) throws MalformedURLException {
        ClassLoader classLoader2 = null;
        if (traceComponent.isEntryEnabled()) {
            Tr.entry((TraceComponent)traceComponent, (String)("getResourceClassLoader " + string + " : " + classLoader));
        }
        if (string == null || string.equalsIgnoreCase("")) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 == null) {
                classLoader2 = ClassLoader.getSystemClassLoader();
            }
        } else {
            URL[] uRLArray;
            if (traceComponent.isDebugEnabled()) {
                Tr.debug((TraceComponent)traceComponent, (String)("parsing urls classpath=" + string));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), File.pathSeparator);
            ArrayList<URL[]> arrayList = new ArrayList<URL[]>();
            while (stringTokenizer.hasMoreTokens()) {
                uRLArray = stringTokenizer.nextToken().trim();
                if (uRLArray.equals("")) continue;
                arrayList.add(uRLArray);
            }
            uRLArray = ArchiveUtil.toLocalURLs(arrayList, (String)File.separator);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < uRLArray.length; ++i) {
                stringBuffer.append("\n       " + uRLArray[i]);
            }
            if (traceComponent.isDebugEnabled()) {
                Tr.debug((TraceComponent)traceComponent, (String)("loadingurls: " + stringBuffer.toString()));
            }
            classLoader2 = classLoader == null ? new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader()) : new URLClassLoader(uRLArray, classLoader);
        }
        return classLoader2;
    }

    public static String appendClasspathStrings(String string, String string2) {
        if (!URLHandlerFactory.isStringEmpty(string)) {
            string = string.trim();
        }
        if (!URLHandlerFactory.isStringEmpty(string2)) {
            string2 = string2.trim();
        }
        if (!URLHandlerFactory.isStringEmpty(string2)) {
            if (URLHandlerFactory.isStringEmpty(string)) {
                return string2;
            }
            if (string.endsWith(File.pathSeparator)) {
                return string + string2;
            }
            return string + File.pathSeparator + string2;
        }
        return string;
    }

    public static boolean isStringEmpty(String string) {
        return string == null || string.length() <= 0;
    }
}

