/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.StopWatch;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.AsynchronousInitializer;
import com.ibm.ws.runtime.component.Component;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.config.ConfigLocator;
import com.ibm.ws.runtime.config.ContainerConfigFactory;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.runtime.service.ServiceProvider;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.EObject;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ContainerImpl
extends ComponentImpl
implements BeanContextServices {
    private static final TraceComponent tc = Tr.register((Class)ContainerImpl.class, (String)"Runtime", (String)"com.ibm.ws.runtime.runtime");
    protected List components = Collections.EMPTY_LIST;
    protected ArrayList bcmListeners;
    protected ArrayList children;
    protected ArrayList bcsListeners;
    protected HashMap services;
    protected Map componentStartupData = new HashMap();

    public ContainerImpl() {
        this.children = new ArrayList(3);
        this.bcmListeners = new ArrayList(1);
        this.bcsListeners = new ArrayList(1);
        this.services = new HashMap(3);
    }

    protected BeanContextServices getOuterBCS() {
        return this.getBeanContextServices();
    }

    public Object instantiateChild(String string) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public InputStream getResourceAsStream(String string, BeanContextChild beanContextChild) throws IllegalArgumentException {
        return beanContextChild.getClass().getClassLoader().getResourceAsStream(string);
    }

    public URL getResource(String string, BeanContextChild beanContextChild) throws IllegalArgumentException {
        return beanContextChild.getClass().getClassLoader().getResource(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            if (!this.bcmListeners.contains(beanContextMembershipListener)) {
                this.bcmListeners.add(beanContextMembershipListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        BeanContextMembershipListener beanContextMembershipListener2 = beanContextMembershipListener;
        synchronized (beanContextMembershipListener2) {
            this.bcmListeners.remove(beanContextMembershipListener);
        }
    }

    public void revokeService(Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl) {
        Object v = this.services.remove(clazz);
        if (v != null) {
            this.fireServiceRevoked(new BeanContextServiceRevokedEvent(this, clazz, bl));
        }
    }

    public boolean hasService(Class clazz) {
        if (this.services.get(clazz) == null) {
            BeanContextServices beanContextServices = this.getBeanContextServices();
            return beanContextServices == null ? false : beanContextServices.hasService(clazz);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(BeanContextChild beanContextChild, Object object, Class clazz, Object object2, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException {
        BeanContextServiceProvider beanContextServiceProvider = null;
        Object object3 = this.services;
        synchronized (object3) {
            beanContextServiceProvider = (BeanContextServiceProvider)this.services.get(clazz);
        }
        if (beanContextServiceProvider != null) {
            return beanContextServiceProvider.getService(this, object, clazz, object2);
        }
        object3 = this.getBeanContextServices();
        if (object3 != null) {
            return object3.getService(this, object, clazz, object2, beanContextServiceRevokedListener);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addService(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
        BeanContextServiceProvider beanContextServiceProvider2 = null;
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            beanContextServiceProvider2 = this.services.put(clazz, beanContextServiceProvider);
            if (beanContextServiceProvider2 != null) {
                this.services.put(clazz, beanContextServiceProvider2);
            }
        }
        return beanContextServiceProvider2 == null;
    }

    public void releaseService(BeanContextChild beanContextChild, Object object, Object object2) {
        BeanContextServices beanContextServices;
        if (this.services.get(object2) == null && (beanContextServices = this.getBeanContextServices()) != null) {
            beanContextServices.releaseService(this, object, object2);
        }
    }

    public Iterator getCurrentServiceClasses() {
        return this.services.keySet().iterator();
    }

    public Iterator getCurrentServiceSelectors(Class clazz) {
        BeanContextServiceProvider beanContextServiceProvider = (BeanContextServiceProvider)this.services.get(clazz);
        return beanContextServiceProvider == null ? null : beanContextServiceProvider.getCurrentServiceSelectors(this, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (!this.bcsListeners.contains(beanContextServicesListener)) {
                this.bcsListeners.add(beanContextServicesListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            this.bcsListeners.remove(beanContextServicesListener);
        }
    }

    public void serviceAvailable(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        if (this.services.containsKey(beanContextServiceAvailableEvent.getServiceClass())) {
            return;
        }
        this.fireServiceAdded(beanContextServiceAvailableEvent);
        for (int i = 0; i < this.children.size(); ++i) {
            Object e = this.children.get(i);
            if (!(e instanceof BeanContextServicesListener)) continue;
            ((BeanContextServicesListener)e).serviceAvailable(beanContextServiceAvailableEvent);
        }
    }

    public void serviceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        if (this.services.containsKey(beanContextServiceRevokedEvent.getServiceClass())) {
            return;
        }
        this.fireServiceRevoked(beanContextServiceRevokedEvent);
        for (int i = 0; i < this.children.size(); ++i) {
            Object e = this.children.get(i);
            if (!(e instanceof BeanContextServicesListener)) continue;
            ((BeanContextServicesListener)e).serviceRevoked(beanContextServiceRevokedEvent);
        }
    }

    public boolean needsGui() {
        return false;
    }

    public void dontUseGui() {
    }

    public void okToUseGui() {
    }

    public boolean avoidingGui() {
        return true;
    }

    public void setDesignTime(boolean bl) {
    }

    public boolean isDesignTime() {
        return false;
    }

    public int size() {
        return this.children.size();
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public boolean contains(Object object) {
        return this.children.contains(object);
    }

    public Iterator iterator() {
        return this.children.iterator();
    }

    public Object[] toArray() {
        return this.children.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.children.toArray(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        Object object2 = this.children;
        synchronized (object2) {
            if (this.children.contains(object)) {
                return false;
            }
            this.children.add(object);
        }
        if (object instanceof BeanContextChild) {
            object2 = (BeanContextChild)object;
            try {
                object2.setBeanContext(this);
            }
            catch (PropertyVetoException propertyVetoException) {
                ArrayList arrayList = this.children;
                synchronized (arrayList) {
                    this.children.remove(object);
                }
                throw new IllegalStateException();
            }
        }
        this.fireChildrenAdded(new BeanContextMembershipEvent((BeanContext)this, new Object[]{object}));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        Object object2 = this.children;
        synchronized (object2) {
            if (!this.children.contains(object)) {
                return false;
            }
        }
        if (object instanceof BeanContextChild) {
            object2 = (BeanContextChild)object;
            try {
                object2.setBeanContext(null);
            }
            catch (PropertyVetoException propertyVetoException) {
                throw new IllegalStateException();
            }
        }
        object2 = this.children;
        synchronized (object2) {
            this.children.remove(object);
        }
        this.fireChildrenRemoved(new BeanContextMembershipEvent((BeanContext)this, new Object[]{object}));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            return this.children.containsAll(collection);
        }
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    protected void fireServiceAdded(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        BeanContextServicesListener[] beanContextServicesListenerArray = new BeanContextServicesListener[this.bcsListeners.size()];
        this.bcsListeners.toArray(beanContextServicesListenerArray);
        for (int i = 0; i < beanContextServicesListenerArray.length; ++i) {
            beanContextServicesListenerArray[i].serviceAvailable(beanContextServiceAvailableEvent);
        }
    }

    protected void fireServiceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        BeanContextServicesListener[] beanContextServicesListenerArray = new BeanContextServicesListener[this.bcsListeners.size()];
        this.bcsListeners.toArray(beanContextServicesListenerArray);
        for (int i = 0; i < beanContextServicesListenerArray.length; ++i) {
            beanContextServicesListenerArray[i].serviceRevoked(beanContextServiceRevokedEvent);
        }
    }

    protected void fireChildrenAdded(BeanContextMembershipEvent beanContextMembershipEvent) {
        BeanContextMembershipListener[] beanContextMembershipListenerArray = new BeanContextMembershipListener[this.bcmListeners.size()];
        this.bcmListeners.toArray(beanContextMembershipListenerArray);
        for (int i = 0; i < beanContextMembershipListenerArray.length; ++i) {
            beanContextMembershipListenerArray[i].childrenAdded(beanContextMembershipEvent);
        }
    }

    protected void fireChildrenRemoved(BeanContextMembershipEvent beanContextMembershipEvent) {
        BeanContextMembershipListener[] beanContextMembershipListenerArray = new BeanContextMembershipListener[this.bcmListeners.size()];
        this.bcmListeners.toArray(beanContextMembershipListenerArray);
        for (int i = 0; i < beanContextMembershipListenerArray.length; ++i) {
            beanContextMembershipListenerArray[i].childrenRemoved(beanContextMembershipEvent);
        }
    }

    public void destroy() {
        this.destroyComponents();
    }

    public void start() throws RuntimeError, RuntimeWarning {
        this.startComponents();
        this.componentStartupData.clear();
    }

    public void stop() {
        this.stopComponents();
    }

    protected List loadComponents(String string) throws ConfigurationError {
        Object object;
        Enumeration<URL> enumeration;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"loadComponents", (Object)this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Loading resources from: " + string));
        }
        try {
            enumeration = Thread.currentThread().getContextClassLoader().getResources(string);
        }
        catch (IOException iOException) {
            throw new ConfigurationError(iOException);
        }
        XMLReader xMLReader = null;
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            xMLReader = ((SAXParserFactory)object).newSAXParser().getXMLReader();
        }
        catch (SAXException sAXException) {
            throw new ConfigurationError(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfigurationError(parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ConfigurationError(factoryConfigurationError);
        }
        object = new StartupHandler();
        xMLReader.setContentHandler((ContentHandler)object);
        xMLReader.setDTDHandler((DTDHandler)object);
        xMLReader.setEntityResolver((EntityResolver)object);
        xMLReader.setErrorHandler((ErrorHandler)object);
        List<ComponentStartup> list = Collections.synchronizedList(new ArrayList());
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"parsing", (Object)uRL);
            }
            try {
                xMLReader.parse(uRL.toExternalForm());
                List list2 = ((StartupHandler)object).getComponents();
                for (int i = 0; i < list2.size(); ++i) {
                    ComponentStartup componentStartup = (ComponentStartup)list2.get(i);
                    if (list.contains(componentStartup)) {
                        Tr.warning((TraceComponent)tc, (String)"WSVR0107W", (Object)new Object[]{componentStartup.getName(), uRL});
                        continue;
                    }
                    list.add(componentStartup);
                }
            }
            catch (SAXParseException sAXParseException) {
                FFDCFilter.processException((Throwable)sAXParseException, (String)this.getClass().getName(), (String)"462");
                Tr.error((TraceComponent)tc, (String)"WSVR0500E", (Object)new Object[]{uRL.getFile(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException});
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException((Throwable)sAXException, (String)this.getClass().getName(), (String)"467");
                Exception exception = sAXException.getException();
                if (exception == null) {
                    exception = sAXException;
                }
                Tr.error((TraceComponent)tc, (String)"WSVR0500E", (Object)new Object[]{uRL.getFile(), "?", "?", exception});
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)this.getClass().getName(), (String)"467");
                Tr.error((TraceComponent)tc, (String)"WSVR0500E", (Object)new Object[]{uRL.getFile(), "?", "?", iOException});
            }
        }
        Collections.sort(list, new StartupCompartor());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("loadedComponents " + list.size()), (Object)this);
            for (int i = 0; i < list.size(); ++i) {
                Tr.debug((TraceComponent)tc, (String)(" component " + i), list.get(i));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startComponents() throws RuntimeWarning, RuntimeError {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("startComponents " + this.components.size()), (Object)this);
        }
        StopWatch stopWatch = StopWatch.instance();
        try {
            stopWatch.start("ContainerImpl.startComponents() " + this);
            RuntimeWarning runtimeWarning = null;
            for (int i = 0; i < this.components.size(); ++i) {
                Component component = (Component)this.components.get(i);
                try {
                    ComponentStartup componentStartup;
                    stopWatch.start("ContainerImpl : start " + component);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("starting " + i), (Object)component);
                    }
                    if ((componentStartup = (ComponentStartup)this.componentStartupData.get(component)) != null && componentStartup.asyncStart && !componentStartup.inhibitAsynchronousBehavior) {
                        this.runAsynchronousInitializer(new AsynchComponentSupport(1, component, null, null));
                        continue;
                    }
                    component.start();
                    continue;
                }
                catch (RuntimeWarning runtimeWarning2) {
                    runtimeWarning = runtimeWarning2;
                    Tr.error((TraceComponent)tc, (String)"WSVR0501E", (Object)new Object[]{component, runtimeWarning2});
                    continue;
                }
                catch (RuntimeError runtimeError) {
                    throw runtimeError;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"546");
                    Tr.error((TraceComponent)tc, (String)"WSVR0501E", (Object)new Object[]{component, throwable});
                    runtimeWarning = new RuntimeWarning(throwable);
                    continue;
                }
                finally {
                    stopWatch.stop();
                }
            }
            if (runtimeWarning != null) {
                throw runtimeWarning;
            }
        }
        finally {
            stopWatch.stop();
        }
    }

    protected void stopComponents() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("stopComponents " + this.components.size()), (Object)this);
        }
        for (int i = this.components.size() - 1; i >= 0; --i) {
            Component component = (Component)this.components.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("stopping " + i), (Object)component);
                }
                component.stop();
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"572");
                Tr.error((TraceComponent)tc, (String)"WSVR0102E", (Object)new Object[]{component, throwable});
            }
        }
    }

    protected void destroyComponents() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroyComponents " + this.components.size()), (Object)this);
        }
        for (int i = this.components.size() - 1; i >= 0; --i) {
            Component component = (Component)this.components.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("destroying " + i), (Object)component);
                }
                component.destroy();
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"597");
                Tr.error((TraceComponent)tc, (String)"WSVR0103E", (Object)new Object[]{component, throwable});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeComponents(EObject eObject, ConfigLocator[] configLocatorArray) throws ConfigurationWarning, ConfigurationError {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"initializeComponents", (Object)this);
        }
        StopWatch stopWatch = StopWatch.instance();
        ConfigurationWarning configurationWarning = null;
        try {
            stopWatch.start("ContainerImpl.initializeComponents() : " + (eObject != null ? eObject.getClass() : null));
            ComponentManager componentManager = null;
            List list = Collections.synchronizedList(new ArrayList());
            HashMap hashMap = new HashMap();
            try {
                componentManager = (ComponentManager)this.getService(ComponentManager.class);
                for (int i = 0; i < this.components.size(); ++i) {
                    ComponentStartup componentStartup = (ComponentStartup)this.components.get(i);
                    stopWatch.start("ContainerImpl : init " + componentStartup);
                    try {
                        if (bl) {
                            Tr.debug((TraceComponent)tc, (String)"processing", (Object)componentStartup);
                        }
                        if (componentStartup.clazz != null && componentStartup.type == null) {
                            this.initializeComponent(componentStartup.clazz, null, componentManager, hashMap, list, configLocatorArray, componentStartup);
                            continue;
                        }
                        Object object = null;
                        for (int j = 0; object == null && j < configLocatorArray.length; ++j) {
                            object = configLocatorArray[j].getConfig(eObject, componentStartup.type);
                            if (!bl || object == null) continue;
                            Tr.debug((TraceComponent)tc, (String)("config object " + object + " found by locator " + configLocatorArray[j]));
                        }
                        if (object != null) {
                            if (object instanceof List) {
                                List list2 = (List)object;
                                for (int j = 0; j < list2.size(); ++j) {
                                    EObject eObject2 = (EObject)list2.get(j);
                                    this.initializeComponent(null, (Object)eObject2, componentManager, hashMap, list, configLocatorArray, componentStartup);
                                }
                                continue;
                            }
                            EObject eObject3 = (EObject)object;
                            this.initializeComponent(componentStartup.type, (Object)eObject3, componentManager, hashMap, list, configLocatorArray, componentStartup);
                            continue;
                        }
                        if (bl) {
                            Tr.debug((TraceComponent)tc, (String)"config object not found!");
                        }
                        if (componentStartup.configrationDataRequired) continue;
                        this.initializeComponent(componentStartup.clazz, null, componentManager, hashMap, list, configLocatorArray);
                        throw new ConfigurationWarning("configuration data missing for " + componentStartup);
                    }
                    catch (ConfigurationWarning configurationWarning2) {
                        configurationWarning = configurationWarning2;
                        continue;
                    }
                    finally {
                        stopWatch.stop();
                    }
                }
            }
            catch (Throwable throwable) {
                this.releaseService(componentManager);
                this.components = list;
                throw throwable;
            }
            this.releaseService(componentManager);
            this.components = list;
        }
        finally {
            stopWatch.stop();
        }
        if (configurationWarning != null) {
            FFDCFilter.processException(configurationWarning, (String)this.getClass().getName(), (String)"717");
            throw configurationWarning;
        }
    }

    protected void initializeComponent(String string, Object object, EObject eObject, ComponentManager componentManager, Map map, List list, ConfigLocator[] configLocatorArray) throws ConfigurationWarning, ConfigurationError {
        this.initializeComponent(string, object, componentManager, map, list, configLocatorArray);
    }

    protected void initializeComponent(String string, Object object, ComponentManager componentManager, Map map, List list, ConfigLocator[] configLocatorArray) throws ConfigurationWarning, ConfigurationError {
        this.initializeComponent(string, object, componentManager, map, list, configLocatorArray, null);
    }

    protected void initializeComponent(String string, Object object, ComponentManager componentManager, Map map, List list, ConfigLocator[] configLocatorArray, ComponentStartup componentStartup) throws ConfigurationWarning, ConfigurationError {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"initializeComponent", (Object)new Object[]{string, object});
        }
        if (object == null) {
            object = string;
        }
        if (map.get(object) != null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"component already loaded");
            }
            return;
        }
        map.put(object, object);
        Object object2 = componentManager.getInstance(object);
        if (componentStartup != null && componentStartup.inhibitAsynchronousBehavior && object2 instanceof ComponentImpl) {
            ((ComponentImpl)object2).inhibitAsynchBehavior();
        }
        if (object2 instanceof Component) {
            boolean bl2;
            ConfigurationWarning configurationWarning = null;
            Component component = (Component)object2;
            this.componentStartupData.put(component, componentStartup);
            boolean bl3 = bl2 = componentStartup != null && componentStartup.asyncInitialize && !componentStartup.inhibitAsynchronousBehavior;
            if (this.add(component)) {
                try {
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)"initializing", (Object)component);
                    }
                    if (object2 instanceof ContainerImpl) {
                        object = ContainerConfigFactory.createContainerConfig(object, configLocatorArray);
                    }
                    if (bl2) {
                        list.add(component);
                        this.runAsynchronousInitializer(new AsynchComponentSupport(0, component, object, list));
                    } else {
                        component.initialize(object);
                    }
                }
                catch (ComponentDisabledException componentDisabledException) {
                    component = null;
                }
                catch (ConfigurationWarning configurationWarning2) {
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)("Component, " + component + " failed to initialize"), (Object)((Object)configurationWarning2));
                    }
                    configurationWarning = configurationWarning2;
                    if (configurationWarning2.getCause() instanceof ComponentDisabledException) {
                        component = null;
                        configurationWarning = new ConfigurationWarning(configurationWarning2.getMessage(), (Throwable)((Object)configurationWarning2));
                    }
                }
                catch (ConfigurationError configurationError) {
                    throw configurationError;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"707");
                    component = null;
                    configurationWarning = new ConfigurationWarning("Exception caught when initializing component", throwable);
                    Tr.error((TraceComponent)tc, (String)"WSVR0501E", (Object)new Object[]{string, throwable});
                }
                if (component != null) {
                    if (!bl2) {
                        list.add(component);
                    }
                } else {
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)("Component, " + object2 + " is disabled"));
                    }
                    this.remove(object2);
                }
                if (configurationWarning != null) {
                    throw configurationWarning;
                }
            }
        } else if (object2 instanceof ServiceProvider) {
            ((ServiceProvider)object2).initialize(this.getBeanContextServices());
        } else if (bl) {
            Tr.debug((TraceComponent)tc, (String)("component ignored: " + (object2 != null ? object2.getClass().getName() : "<null>")));
        }
    }

    static class StartupCompartor
    implements Comparator {
        StartupCompartor() {
        }

        public int compare(Object object, Object object2) {
            ComponentStartup componentStartup = (ComponentStartup)object;
            ComponentStartup componentStartup2 = (ComponentStartup)object2;
            return componentStartup.order - componentStartup2.order;
        }
    }

    static class StartupHandler
    extends DefaultHandler {
        static final String DISTRIBUTED = "distributed";
        static final String ZSERIES = "zos";
        static final String ISERIES = "os400";
        static final String ALL = "all";
        static final String COMPONENT = "component";
        static final String PLATFORM = "platform";
        static final String CLASS = "class";
        static final String TYPE = "type";
        static final String STARTUP = "startup";
        static final String OVERRIDE = "override";
        static final String CONFIG_DATA_REQUIRED = "configurationDataRequired";
        static final String ASYNC_INIT = "asynchronousInit";
        static final String ASYNC_START = "asynchronousStart";
        static final String INHIBIT_MULTI_THREAD = "inhibitMultiThreadedBehavior";
        static final String ZOSPROCESSTYPE = "zOSprocesstype";
        static final String SERVANT = "servant";
        static final String ADJUNCT = "adjunct";
        private Locator locator = null;
        URL documentURL = null;
        private List components = new ArrayList();
        private ComponentStartup currentComponent = null;
        private StringBuffer value = new StringBuffer();
        private boolean overriding = false;
        private boolean ignoring = false;
        private static String actualPlatformString = null;
        private static String actualZOSProcessType = "unknown";

        StartupHandler() {
        }

        public List getComponents() {
            return this.components;
        }

        public void startDocument() throws SAXException {
            this.components.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            this.value.setLength(0);
            if (string3.equals(COMPONENT)) {
                this.currentComponent = new ComponentStartup();
                this.currentComponent.platforms = this.getStringAttribute(attributes, PLATFORM, null);
                this.currentComponent.zosprocesstypes = this.getStringAttribute(attributes, ZOSPROCESSTYPE, null);
                this.currentComponent.configrationDataRequired = this.getBooleanAttribute(attributes, CONFIG_DATA_REQUIRED, true);
                this.currentComponent.asyncInitialize = this.getBooleanAttribute(attributes, ASYNC_INIT, false);
                this.currentComponent.asyncStart = this.getBooleanAttribute(attributes, ASYNC_START, false);
                this.currentComponent.inhibitAsynchronousBehavior = this.getBooleanAttribute(attributes, INHIBIT_MULTI_THREAD, false);
            } else if (string3.equals(OVERRIDE) && (string4 = this.getStringAttribute(attributes, PLATFORM, null)) != null) {
                String string5 = this.getStringAttribute(attributes, ZOSPROCESSTYPE, null);
                if (this.validOn(string4, string5)) {
                    this.overriding = true;
                    this.currentComponent.configrationDataRequired = this.getBooleanAttribute(attributes, CONFIG_DATA_REQUIRED, this.currentComponent.configrationDataRequired);
                    this.currentComponent.asyncInitialize = this.getBooleanAttribute(attributes, ASYNC_INIT, this.currentComponent.asyncInitialize);
                    this.currentComponent.asyncStart = this.getBooleanAttribute(attributes, ASYNC_START, this.currentComponent.asyncStart);
                    this.currentComponent.inhibitAsynchronousBehavior = this.getBooleanAttribute(attributes, INHIBIT_MULTI_THREAD, this.currentComponent.inhibitAsynchronousBehavior);
                } else {
                    this.ignoring = true;
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.currentComponent == null) {
                return;
            }
            if (COMPONENT.equals(string3)) {
                this.endComponent();
            } else if (CLASS.equals(string3)) {
                this.endClass();
            } else if (TYPE.equals(string3)) {
                this.endType();
            } else if (STARTUP.equals(string3)) {
                this.endStartup();
            } else if (OVERRIDE.equals(string3)) {
                this.overriding = false;
                this.ignoring = false;
            } else {
                this.parsingError("Invalid tag: " + string3);
            }
            this.value.setLength(0);
        }

        private void parsingError(String string) throws SAXException {
            throw new SAXException(string + "[" + this.documentURL + ", line:" + this.locator.getLineNumber() + ", col:" + this.locator.getColumnNumber() + "]");
        }

        private void endComponent() throws SAXException {
            if (this.currentComponent.type == null && this.currentComponent.clazz == null) {
                Tr.error((TraceComponent)tc, (String)"WSVR0104E", (Object)new Object[]{this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
            } else if (this.currentComponent.type != null && this.currentComponent.clazz != null && this.currentComponent.configrationDataRequired) {
                Tr.error((TraceComponent)tc, (String)"WSVR0105E", (Object)new Object[]{this.currentComponent.type, this.currentComponent.clazz, this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
            } else if (this.validOn(this.currentComponent.platforms, this.currentComponent.zosprocesstypes)) {
                this.components.add(this.currentComponent);
            }
            this.currentComponent = null;
        }

        private void endClass() throws SAXException {
            if (!this.ignoring) {
                if (this.overriding || this.currentComponent.clazz == null) {
                    this.currentComponent.clazz = this.value.toString();
                } else {
                    this.parsingError("<class> already defined");
                }
            }
        }

        private void endType() throws SAXException {
            if (!this.ignoring) {
                if (this.currentComponent.type == null || this.overriding) {
                    this.currentComponent.type = this.value.toString();
                } else {
                    this.parsingError("<type> already defined");
                }
            }
        }

        private void endStartup() throws SAXException {
            if (this.ignoring) {
                return;
            }
            try {
                int n;
                this.currentComponent.order = n = Integer.parseInt(this.value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                Tr.error((TraceComponent)tc, (String)"WSVR0106E", (Object)new Object[]{this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
            }
        }

        private boolean validOn(String string, String string2) {
            boolean bl;
            block6: {
                String string3;
                StringTokenizer stringTokenizer;
                block7: {
                    bl = false;
                    if (string == null) {
                        bl = true;
                    } else {
                        stringTokenizer = new StringTokenizer(string, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken().trim().toLowerCase();
                            if (string3.equals(ALL)) {
                                bl = true;
                                break;
                            }
                            if (!string3.equals(actualPlatformString)) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl || !actualPlatformString.equals(ZSERIES)) break block6;
                    bl = false;
                    if (string2 != null) break block7;
                    if (actualZOSProcessType.equals(ADJUNCT)) break block6;
                    bl = true;
                    break block6;
                }
                stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken().trim().toLowerCase();
                    if (string3.equals(ALL)) {
                        bl = true;
                        break;
                    }
                    if (!string3.equals(actualZOSProcessType)) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.currentComponent = null;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.currentComponent = null;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.components.clear();
            this.currentComponent = null;
            throw sAXParseException;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.value.append(cArray, n, n2);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private String getStringAttribute(Attributes attributes, String string, String string2) {
            String string3 = attributes.getValue(string);
            return string3 != null ? string3 : string2;
        }

        private boolean getBooleanAttribute(Attributes attributes, String string, boolean bl) {
            String string2 = attributes.getValue(string);
            return string2 != null ? Boolean.valueOf(string2) : bl;
        }

        static {
            actualPlatformString = DISTRIBUTED;
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper.isZOS()) {
                actualPlatformString = ZSERIES;
                if (platformHelper.isCRAJvm()) {
                    actualZOSProcessType = ADJUNCT;
                } else if (platformHelper.isServantJvm()) {
                    actualZOSProcessType = SERVANT;
                }
            } else if (platformHelper.isOS400()) {
                actualPlatformString = ISERIES;
            }
        }
    }

    protected static class ComponentStartup {
        public int order = Integer.MAX_VALUE;
        public String type = null;
        public String clazz = null;
        public String platforms = null;
        public String zosprocesstypes = null;
        boolean configrationDataRequired = true;
        boolean asyncStart = false;
        boolean asyncInitialize = false;
        boolean inhibitAsynchronousBehavior = false;

        protected ComponentStartup() {
        }

        public String toString() {
            String string = (this.type != null ? this.type : this.clazz) + " [" + this.order + "]" + (this.asyncInitialize ? " asynch-init" : "") + (this.asyncStart ? " asynch-start" : "");
            if (this.platforms != null) {
                string = string + " [" + this.platforms.toString() + "]";
            }
            return string;
        }

        public boolean equals(Object object) {
            if (object instanceof ComponentStartup) {
                boolean bl;
                boolean bl2;
                ComponentStartup componentStartup = (ComponentStartup)object;
                boolean bl3 = this.type == null ? this.type == componentStartup.type : (bl2 = this.type.equals(componentStartup.type));
                boolean bl4 = this.clazz == null ? this.clazz == componentStartup.clazz : (bl = this.clazz.equals(componentStartup.clazz));
                boolean bl5 = this.platforms == null ? this.platforms == componentStartup.platforms : this.platforms.equals(componentStartup.platforms);
                return bl2 && bl && bl5;
            }
            return false;
        }

        public String getName() {
            return this.type != null ? this.type : this.clazz;
        }
    }

    private class AsynchComponentSupport
    implements AsynchronousInitializer {
        static final int INIT_ = 0;
        static final int START_ = 1;
        final int operation;
        final Component component;
        final Object configurationData;
        final List componentsList;

        AsynchComponentSupport(int n, Component component, Object object, List list) {
            this.operation = n;
            this.component = component;
            this.configurationData = object;
            this.componentsList = list;
        }

        public void run() throws ConfigurationWarning, ConfigurationError, RuntimeWarning, RuntimeError {
            switch (this.operation) {
                case 0: {
                    try {
                        this.component.initialize(this.configurationData);
                        break;
                    }
                    catch (ComponentDisabledException componentDisabledException) {
                        this.componentsList.remove(this.component);
                        break;
                    }
                    catch (ConfigurationWarning configurationWarning) {
                        throw configurationWarning;
                    }
                }
                case 1: {
                    this.component.start();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported operation : " + this.operation);
                }
            }
        }
    }
}

