/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.cert.CertificateFactoryImpl;
import com.ibm.security.cert.CompositeCRL;
import com.ibm.security.cert.IBMCertPathHelper;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CRLReasonCodeExtension;
import com.ibm.security.x509.DeltaCRLIndicatorExtension;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.IssuingDistributionPointExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.ReasonFlags;
import com.ibm.security.x509.X509CRLEntryImpl;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;

public class CRSChecker {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    static final String[] myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.CRLDistributionPoints").toString()};
    static final String[] deltaCRLAttrIDArray = new String[]{"deltaRevocationList"};
    static final String[] baseCRLAttrIDArray = new String[]{"certificateRevocationList"};
    static final String[] baseARLAttrIDArray = new String[]{"authorityRevocationList"};
    static final String[] allCRLAttrIDArray = new String[]{"authorityRevocationList", "authorityRevocationList;binary", "certificateRevocationList", "certificateRevocationList;binary", "deltaRevocationList", "deltaRevocationList;binary"};
    private CertPath certPath;
    private Collection certStores;
    private boolean trustCertPathForCRLs;
    private boolean useDeltas;
    private Set trustBaseSet;
    private Date validationDate;
    private int numberOfCertsInCertPath;
    private String sigProvider;
    private Collection ibmCollectionCertStores = null;
    private int currentCertIndex;
    private Vector willBeTrustedCollection;
    private Hashtable CRLCache = new Hashtable();
    private boolean[] userReasons = new boolean[]{false, true, true, true, true, true, true};
    private TrustAnchor trustAnchor;
    private static final int CHECK_INTERVAL = 30000;

    public CRSChecker(CertPath certPath, Collection collection, boolean bl, boolean bl2, Set set, Date date, boolean bl3, String string) throws CertPathValidatorException {
        this.certPath = certPath;
        this.certStores = collection;
        this.trustCertPathForCRLs = bl;
        this.useDeltas = bl2;
        this.trustBaseSet = set;
        this.validationDate = date;
        this.sigProvider = string;
        List<? extends Certificate> list = certPath.getCertificates();
        this.numberOfCertsInCertPath = list.size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
        this.willBeTrustedCollection = new Vector();
        this.ibmCollectionCertStores = this.getIBMCollectionCertStores(collection);
        this.CRLCache = this.setCRLCache(collection);
        X509Certificate x509Certificate = null;
        if (this.numberOfCertsInCertPath > 0) {
            x509Certificate = (X509Certificate)list.get(this.numberOfCertsInCertPath - 1);
        }
        if (x509Certificate != null) {
            this.trustAnchor = null;
            try {
                this.trustAnchor = CertPathUtil.findIssuer(x509Certificate, set, string);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("The certificate issued by " + ((Object)x509Certificate.getIssuerDN()).toString() + " is not trusted", (Throwable)certPathValidatorException, certPath, this.numberOfCertsInCertPath - 1);
            }
        }
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("The direction of forward is not supported");
        }
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        DistributionPoint[] distributionPointArray;
        Object var4_3 = null;
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
            try {
                this.trustAnchor = new TrustAnchor(x509Certificate, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CertPathValidatorException("Fail to instantiate trust anchor for certificate revocation status processing", (Throwable)illegalArgumentException, this.certPath, this.currentCertIndex);
            }
            --this.currentCertIndex;
            return;
        }
        boolean bl = true;
        Object[] objectArray = CertPathUtil.getBasicConstraints(x509Certificate);
        bl = (Boolean)objectArray[1];
        int n = 2001;
        n = this.checkCRLCache(x509Certificate, this.trustAnchor, bl);
        if (n == 2001) {
            if (this.checkCRLDPEnabled()) {
                if (debug != null) {
                    System.out.println("CERTPATH: check distribution points in certificate:" + x509Certificate.toString());
                }
                if ((distributionPointArray = CertPathUtil.getCRLDistributionPoints(x509Certificate)) != null) {
                    if (debug != null) {
                        System.out.println("CERTPATH: get distribution points");
                    }
                    n = this.processDistributionPoints(distributionPointArray, x509Certificate, this.willBeTrustedCollection, this.certStores, this.useDeltas, this.trustBaseSet, bl, this.validationDate, this.userReasons, this.sigProvider);
                }
            } else if (debug != null) {
                System.out.println("CERTPATH: CRL distribution point extension check is disabled");
            }
        }
        distributionPointArray = ((Object)x509Certificate.getSubjectDN()).toString();
        String string = null;
        switch (n) {
            case 1000: {
                string = "The certificate with subject (" + (String)distributionPointArray + ") has been revoked for an unspecified reason.";
                break;
            }
            case 1001: {
                string = "The certificate with subject (" + (String)distributionPointArray + ") has been revoked because the key has been compromised.";
                break;
            }
            case 1002: {
                string = "The certificate with subject (" + (String)distributionPointArray + ") has been revoked because the CA key has been compromised.";
                break;
            }
            case 1003: {
                string = "The certificate with subject (" + (String)distributionPointArray + ") has been revoked because the owner's affiliation has changed.";
                break;
            }
            case 1004: {
                string = "The certificate with subject (" + (String)distributionPointArray + ") has been revoked because is is superseded.";
                break;
            }
            case 1005: {
                string = "The certificate with subject (" + (String)distributionPointArray + ") has been revoked because of cessation of operation.";
                break;
            }
            case 1006: {
                string = "The certificate with subject (" + (String)distributionPointArray + ") has been put on hold.";
                break;
            }
            case 2000: {
                break;
            }
            case 2001: {
                string = "The revocation status of the certificate with subject (" + (String)distributionPointArray + ") could not be determined.";
                break;
            }
            case 2002: {
                string = "The certificate with subject (" + (String)distributionPointArray + ") has been revoked, revocation reason unknown.";
                break;
            }
            default: {
                string = "An internal error has occurred in processing the certificate:" + n;
            }
        }
        if (string != null) {
            throw new CertPathValidatorException(string, null, this.certPath, this.currentCertIndex);
        }
        try {
            this.trustAnchor = new TrustAnchor(x509Certificate, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Fail to instantiate trust anchor for certificate revocation status processing", (Throwable)illegalArgumentException, this.certPath, this.currentCertIndex);
        }
        --this.currentCertIndex;
        if (this.trustCertPathForCRLs) {
            this.willBeTrustedCollection.add(x509Certificate);
        }
    }

    int checkCRLCache(X509Certificate x509Certificate, TrustAnchor trustAnchor, boolean bl) throws CertPathValidatorException {
        Object object = null;
        PublicKey publicKey = null;
        X509Certificate x509Certificate2 = null;
        boolean[] blArray = CertPathUtil.getKeyUsage(x509Certificate);
        if (this.currentCertIndex != 0 && bl && blArray != null && !blArray[6]) {
            if (debug != null) {
                System.out.println("CERTPATH: This certificate is not for CRL signing, serial number=" + x509Certificate.getSerialNumber());
            }
            return 2001;
        }
        x509Certificate2 = trustAnchor.getTrustedCert();
        if (x509Certificate2 != null) {
            if (!(x509Certificate2 instanceof X509CertImpl)) {
                try {
                    x509Certificate2 = new X509CertImpl(x509Certificate2.getEncoded());
                }
                catch (CertificateException certificateException) {
                    throw new CertPathValidatorException(certificateException.getMessage());
                }
            }
            object = x509Certificate2.getSubjectDN();
            publicKey = x509Certificate2.getPublicKey();
        } else {
            object = IBMCertPathHelper.getCA(trustAnchor);
            publicKey = trustAnchor.getCAPublicKey();
        }
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        ArrayList arrayList = null;
        int n = 2001;
        boolean bl2 = false;
        arrayList = this.getCRLCache((Principal)object);
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                X509CRL x509CRL;
                block30: {
                    DerValue derValue;
                    Object object2;
                    DerValue derValue2;
                    Object object3;
                    block29: {
                        x509CRL = (X509CRL)iterator.next();
                        Date date = x509CRL.getNextUpdate();
                        if (date != null && date.before((Date)(object3 = new Date()))) {
                            if (debug == null) continue;
                            System.out.println("CERTPATH: We can't use this crl, nextUpdate is earlier than current time");
                            continue;
                        }
                        try {
                            x509CRL.verify(publicKey);
                            if (bl2) break block29;
                            bl2 = true;
                        }
                        catch (Exception exception) {
                            if (debug == null) continue;
                            System.out.println("CERTPATH: Unable to verify CRL signature" + exception.toString() + "CRL issuer=" + x509CRL.getIssuerDN().getName());
                            continue;
                        }
                    }
                    object3 = x509CRL.getExtensionValue("2.5.29.28");
                    if (object3 != null) {
                        try {
                            derValue2 = new DerValue((byte[])object3);
                            object3 = derValue2.getOctetString();
                            object2 = new IssuingDistributionPointExtension((byte[])object3);
                            if (bl) {
                                if (((Boolean)object2.get("user_certs_only")).booleanValue()) {
                                    bl2 = false;
                                    continue;
                                }
                            } else if (((Boolean)object2.get("ca_certs_only")).booleanValue()) {
                                bl2 = false;
                                continue;
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    derValue2 = null;
                    derValue2 = (X509CRLEntryImpl)x509CRL.getRevokedCertificate(bigInteger);
                    if (derValue2 != null) {
                        object2 = derValue2.getExtensionValue("2.5.29.21");
                        if (object2 != null) {
                            try {
                                derValue = new CRLReasonCodeExtension(Boolean.FALSE, object2);
                                int n2 = (Integer)derValue.get("reason");
                                n = 1000 + n2;
                            }
                            catch (IOException iOException) {
                                n = 2002;
                            }
                        } else {
                            n = 2002;
                        }
                        return n;
                    }
                    object2 = x509CRL.getExtensionValue("2.5.29.27");
                    if (object2 == null) continue;
                    try {
                        derValue = new DerValue(object2);
                        object2 = derValue.getOctetString();
                        DeltaCRLIndicatorExtension deltaCRLIndicatorExtension = new DeltaCRLIndicatorExtension(Boolean.TRUE, object2);
                    }
                    catch (IOException iOException) {
                        if (debug == null) break block30;
                        System.out.println("CERTPATH: Failed to construct DeltaCRLIndicatorExtension" + iOException.toString());
                    }
                }
                if (debug != null) {
                    System.out.println("CERTPATH: Delta crl: " + x509CRL.getIssuerDN().getName());
                }
                bl2 = false;
            }
            if (bl2) {
                n = 2000;
            }
            if (debug != null) {
                System.out.println("CERTPATH: Verify crl in memory cache, result=" + n);
            }
        }
        return n;
    }

    ArrayList getCRLCache(Principal principal) {
        ArrayList arrayList = null;
        arrayList = (ArrayList)this.CRLCache.get(principal);
        if (arrayList == null) {
            Enumeration enumeration = this.CRLCache.keys();
            while (enumeration.hasMoreElements()) {
                Principal principal2 = (Principal)enumeration.nextElement();
                if (!((Object)principal2).equals(principal)) continue;
                arrayList = (ArrayList)this.CRLCache.get(principal2);
                break;
            }
        }
        if (debug != null) {
            if (arrayList == null) {
                System.out.println("CERTPATH: Inside memory cache, cannot find crl with issuer " + principal.getName());
            } else {
                System.out.println("CERTPATH: Found crl with issuer " + principal.getName() + " in memory cache");
            }
        }
        return arrayList;
    }

    int processDistributionPoints(DistributionPoint[] distributionPointArray, X509Certificate x509Certificate, Collection collection, Collection collection2, boolean bl, Collection collection3, boolean bl2, Date date, boolean[] blArray, String string) throws CertPathValidatorException {
        CompositeCRL compositeCRL = null;
        Object var12_12 = null;
        boolean[] blArray2 = null;
        boolean[] blArray3 = null;
        int n = 2000;
        boolean bl3 = false;
        for (int i = 0; i < distributionPointArray.length; ++i) {
            Object object;
            ReasonFlags reasonFlags;
            try {
                reasonFlags = distributionPointArray[i].getReasons();
                if (reasonFlags == null) {
                    blArray3 = null;
                } else {
                    object = reasonFlags.getReasonFlags();
                    blArray3 = object.toBooleanArray();
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    System.out.println("CERTPATH: Exception in processing distribution points" + iOException.toString());
                }
                throw new CertPathValidatorException("An internal error has occurred in processing the certificate.", iOException);
            }
            compositeCRL = this.getCompositeCRLFromDP(distributionPointArray[i], x509Certificate, collection, collection2, bl, collection3, bl2, date, blArray3, string);
            if (compositeCRL == null) continue;
            blArray2 = compositeCRL.getReasons();
            if (blArray2 == null || blArray3 == null) {
                bl3 = true;
            } else if (!bl3) {
                bl3 = this.intersectReasons(blArray2, blArray3);
            }
            try {
                reasonFlags = distributionPointArray[i].getIssuer();
                object = CertPathUtil.findDNCRLIssuer((GeneralNames)reasonFlags);
                if (!(object != null ? object.equals(compositeCRL.getIssuerName()) : ((Object)x509Certificate.getIssuerDN()).equals(compositeCRL.getIssuerName()))) continue;
                n = compositeCRL.getStatus(x509Certificate.getSerialNumber(), date);
                if (n != 2000 && n != 2001) break;
                continue;
            }
            catch (IOException iOException) {
                if (debug == null) continue;
                System.out.println("CERTPATH: Error occurs when processing distribution points " + iOException.toString());
                continue;
            }
            catch (GeneralNamesException generalNamesException) {
                if (debug == null) continue;
                System.out.println("CERTPATH: Error occurs when processing distribution points " + generalNamesException.toString());
            }
        }
        if (n == 2000 && !bl3) {
            n = 2001;
        }
        return n;
    }

    CompositeCRL getCompositeCRLFromDP(DistributionPoint distributionPoint, X509Certificate x509Certificate, Collection collection, Collection collection2, boolean bl, Collection collection3, boolean bl2, Date date, boolean[] blArray, String string) throws CertPathValidatorException {
        Object object;
        CompositeCRL compositeCRL = null;
        GeneralNames generalNames = null;
        try {
            generalNames = distributionPoint.getIssuer();
        }
        catch (IOException iOException) {
        }
        catch (GeneralNamesException generalNamesException) {
            // empty catch block
        }
        Principal principal = CertPathUtil.findDNCRLIssuer(generalNames);
        if (principal == null) {
            principal = x509Certificate.getIssuerDN();
        }
        GeneralName generalName = null;
        try {
            object = (GeneralNames)distributionPoint.getName();
            generalName = CertPathUtil.getSupportedNameObjectFromGeneralNames(object);
        }
        catch (IOException iOException) {
        }
        catch (GeneralNamesException generalNamesException) {
            // empty catch block
        }
        if (generalName != null) {
            if (generalName.getType() == 6) {
                boolean bl3;
                object = CertPathUtil.stripJunk(generalName.toString());
                if (debug != null) {
                    System.out.println("CERTPATH: Get a URI from distribution point: " + (String)object);
                }
                if ((compositeCRL = this.getCompositeCRLByDPName((String)object, principal, collection2, bl, collection, collection3, bl2, date, string)) != null && !(bl3 = this.isIssuerTrusted(compositeCRL.getIssuerCertificate(), collection, collection3, string))) {
                    compositeCRL = null;
                }
            } else if (generalName.getType() == 4) {
                object = generalName.toString();
                compositeCRL = this.getCompositeCRLByIssuerName((String)object, date, collection2, blArray, false, bl2, collection, collection3, bl, string);
            }
        }
        return compositeCRL;
    }

    CompositeCRL getCompositeCRLByDPName(String string, Principal principal, Collection collection, boolean bl, Collection collection2, Collection collection3, boolean bl2, Date date, String string2) throws CertPathValidatorException {
        Hashtable hashtable = null;
        hashtable = bl2 ? CompositeCRL.CAcompositeCRLHashtable : CompositeCRL.EEcompositeCRLHashtable;
        String string3 = string;
        CompositeCRL compositeCRL = (CompositeCRL)hashtable.get(string3);
        CompositeCRL[] compositeCRLArray = null;
        URLConnection uRLConnection = null;
        long l = -1L;
        boolean bl3 = false;
        if (CertPathUtil.isHTTPURI(string)) {
            Object object;
            block43: {
                try {
                    object = new URL(string);
                    uRLConnection = ((URL)object).openConnection();
                    l = uRLConnection.getLastModified();
                    bl3 = true;
                }
                catch (MalformedURLException malformedURLException) {
                    if (debug != null) {
                        System.out.println("CERTPATH: exception thrown when trying to connect to " + string + ":" + malformedURLException.toString());
                    }
                }
                catch (IOException iOException) {
                    if (debug == null) break block43;
                    System.out.println("CERTPATH: exception thrown when trying to connect to " + string + ":" + iOException.toString());
                }
            }
            if (compositeCRL != null) {
                if (debug != null) {
                    System.out.println("CERTPATH: found a comp crl in the cache");
                }
                if (bl3 && l != compositeCRL.getModifiedTime()) {
                    int n = 0;
                    if (debug != null) {
                        System.out.println("CERTPATH: current lastModified=" + l + ", last lastModified=" + compositeCRL.getModifiedTime());
                        System.out.println("CERTPATH: refresh it");
                    }
                    if (uRLConnection instanceof HttpURLConnection) {
                        X509CRL x509CRL = this.getCRLWithHttp((HttpURLConnection)uRLConnection);
                        if (x509CRL != null) {
                            n = compositeCRL.update(x509CRL, date, string2, l);
                        }
                    } else {
                        throw new CertPathValidatorException("distribution point name error");
                    }
                    if (n != 1003) {
                        compositeCRL = null;
                    }
                } else if (compositeCRL.getNextUpdate().getTime() < date.getTime()) {
                    compositeCRL = null;
                }
            } else if (bl3) {
                compositeCRLArray = new CompositeCRL[2];
                object = this.getCRLWithHttp((HttpURLConnection)uRLConnection);
                if (object != null) {
                    compositeCRL = new CompositeCRL(null);
                    compositeCRL.update((X509CRL)object);
                    if (debug != null) {
                        System.out.println("CERTPATH: Set lastmodified=" + l);
                    }
                    compositeCRL.setModifiedTime(l);
                    X509Certificate x509Certificate = null;
                    try {
                        x509Certificate = CertPathUtil.findIssuerOfCRL((X509CRL)object, collection2, collection3, collection, string2);
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        x509Certificate = null;
                    }
                    if (x509Certificate == null) {
                        compositeCRL = null;
                    } else {
                        compositeCRL.setIssuerCertificate(x509Certificate);
                        boolean bl4 = this.isIssuerTrusted(x509Certificate, collection2, collection3, string2);
                        if (bl4) {
                            compositeCRLArray[0] = compositeCRL;
                            compositeCRLArray[1] = compositeCRL;
                        }
                    }
                }
                if (compositeCRLArray[0] != null && bl2) {
                    CompositeCRL.CAcompositeCRLHashtable.put(string3, compositeCRLArray[0]);
                }
                if (compositeCRLArray[1] != null && !bl2) {
                    CompositeCRL.EEcompositeCRLHashtable.put(string3, compositeCRLArray[1]);
                }
                if (bl2) {
                    compositeCRL = compositeCRLArray[0];
                } else if (!bl2) {
                    compositeCRL = compositeCRLArray[1];
                }
            }
        } else if (CertPathUtil.isLDAPURI(string)) {
            long l2 = System.currentTimeMillis();
            if (compositeCRL != null) {
                if (l2 - compositeCRL.getModifiedTime() < 30000L) {
                    if (debug != null) {
                        System.out.println("CERTPATH: reuse the crl in cache within interval time");
                    }
                } else {
                    compositeCRL = null;
                }
            }
            if (compositeCRL == null) {
                if (debug != null) {
                    System.out.println("CERTPATH: fetch a crl from LDAP");
                }
                if ((compositeCRLArray = this.createCompositeCRLWithDPName(string, collection2, collection, string2))[0] != null) {
                    if (bl2) {
                        CompositeCRL.CAcompositeCRLHashtable.put(string3, compositeCRLArray[0]);
                    } else {
                        CompositeCRL.EEcompositeCRLHashtable.put(string3, compositeCRLArray[0]);
                    }
                    compositeCRL = compositeCRLArray[0];
                    compositeCRL.setModifiedTime(l2);
                }
                if (compositeCRLArray[1] != null) {
                    if (bl2) {
                        CompositeCRL.CAcompositeCRLHashtable.put(string3, compositeCRLArray[1]);
                    } else {
                        CompositeCRL.EEcompositeCRLHashtable.put(string3, compositeCRLArray[1]);
                    }
                    compositeCRL = compositeCRLArray[1];
                    compositeCRL.setModifiedTime(l2);
                }
            }
        }
        return compositeCRL;
    }

    CompositeCRL[] createCompositeCRLWithDPName(String string, Collection collection, Collection collection2, String string2) throws CertPathValidatorException {
        DirContext dirContext;
        CompositeCRL[] compositeCRLArray = new CompositeCRL[2];
        String[] stringArray = this.getLDAPURLAndDN(string);
        if (stringArray[0] != null & stringArray[1] != null && (dirContext = CertPathUtil.getDirContext(stringArray[0])) != null) {
            X509CRLImpl[] x509CRLImplArray = CertPathUtil.retrieveCRLs(dirContext, stringArray[1], allCRLAttrIDArray);
            X509CRLImpl x509CRLImpl = x509CRLImplArray[0];
            X509Certificate x509Certificate = null;
            CompositeCRL compositeCRL = this.createOneCompositeCRL(stringArray[1], collection, collection2, x509CRLImpl, x509Certificate, string2);
            X509CRLImpl x509CRLImpl2 = x509CRLImplArray[1];
            CompositeCRL compositeCRL2 = this.createOneCompositeCRL(stringArray[1], collection, collection2, x509CRLImpl2, x509Certificate, string2);
            compositeCRLArray[0] = compositeCRL;
            compositeCRLArray[1] = compositeCRL2;
            if (x509CRLImplArray[2] != null && compositeCRLArray[1] != null) {
                compositeCRLArray[1].refresh((X509CRL)x509CRLImplArray[2]);
            }
        }
        return compositeCRLArray;
    }

    X509CRL getCRLWithHttp(HttpURLConnection httpURLConnection) {
        X509CRL x509CRL;
        block6: {
            x509CRL = null;
            try {
                CertificateFactoryImpl certificateFactoryImpl = new CertificateFactoryImpl();
                InputStream inputStream = httpURLConnection.getInputStream();
                x509CRL = (X509CRL)certificateFactoryImpl.engineGenerateCRL(inputStream);
            }
            catch (MalformedURLException malformedURLException) {
                if (debug != null) {
                    System.out.println("CERTPATH: Failed to retrieve CRL from " + httpURLConnection.getURL());
                    malformedURLException.printStackTrace();
                }
            }
            catch (CRLException cRLException) {
                if (debug != null) {
                    System.out.println("CERTPATH: Failed to retrieve CRL from " + httpURLConnection.getURL());
                    cRLException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                if (debug == null) break block6;
                System.out.println("CERTPATH: Failed to retrieve CRL from " + httpURLConnection.getURL());
                iOException.printStackTrace();
            }
        }
        return x509CRL;
    }

    CompositeCRL createOneCompositeCRL(String string, Collection collection, Collection collection2, X509CRLImpl x509CRLImpl, X509Certificate x509Certificate, String string2) throws CertPathValidatorException {
        X509Certificate x509Certificate2 = null;
        CompositeCRL compositeCRL = null;
        if (x509CRLImpl != null) {
            if (debug != null) {
                System.out.println("CERTPATH: CRSChecker.createOneCompositeCRL crl found");
            }
            if (x509Certificate != null) {
                int n;
                if (!(x509Certificate instanceof X509CertImpl)) {
                    try {
                        x509Certificate = new X509CertImpl(x509Certificate.getEncoded());
                    }
                    catch (CertificateException certificateException) {
                        throw new CertPathValidatorException(certificateException.getMessage());
                    }
                }
                try {
                    n = CertPathUtil.verifyCRLIssuer((X509CRL)x509CRLImpl, x509Certificate.getPublicKey(), x509Certificate.getIssuerDN(), string2);
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    n = Integer.MAX_VALUE;
                }
                if (n == 0) {
                    x509Certificate2 = x509Certificate;
                }
            }
            if (x509Certificate2 == null) {
                if (debug != null) {
                    System.out.println("CERTPATH: crl issuer null");
                }
                try {
                    x509Certificate2 = CertPathUtil.findIssuerOfCRL((X509CRL)x509CRLImpl, collection, this.trustBaseSet, collection2, string2);
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    if (debug != null) {
                        System.out.println("CERTPATH: CRSChecker.createOneCompositeCRL" + certificateNotYetValidException.getMessage());
                    }
                    x509Certificate2 = null;
                }
            }
            if (x509Certificate2 != null) {
                if (debug != null) {
                    System.out.println("CERTPATH: componsiteCRL is created");
                }
                compositeCRL = new CompositeCRL(string);
                compositeCRL.update((X509CRL)x509CRLImpl);
                compositeCRL.setIssuerCertificate(x509Certificate2);
            }
        }
        return compositeCRL;
    }

    int updateCompositeCRL(String string, CompositeCRL compositeCRL, boolean bl, boolean bl2, Date date, String string2) throws CertPathValidatorException {
        int n = 0;
        String[] stringArray = this.getLDAPURLAndDN(string);
        if (stringArray[0] != null & stringArray[1] != null) {
            DirContext dirContext = CertPathUtil.getDirContext(stringArray[0]);
            if (bl2) {
                n = this.retrieveBaseCRL(compositeCRL, dirContext, stringArray[1], baseARLAttrIDArray, date, string2);
            } else if (!bl2) {
                if (bl) {
                    n = this.retrieveDeltaCRL(compositeCRL, dirContext, stringArray[1], deltaCRLAttrIDArray, date, string2);
                    if (n != 1001 && n != 1001) {
                        n = this.retrieveBaseCRL(compositeCRL, dirContext, stringArray[1], baseCRLAttrIDArray, date, string2);
                    }
                } else {
                    n = this.retrieveBaseCRL(compositeCRL, dirContext, stringArray[1], baseCRLAttrIDArray, date, string2);
                }
            }
        }
        return n;
    }

    CompositeCRL getCompositeCRLByIssuerName(String string, Date date, Collection collection, boolean[] blArray, boolean bl, boolean bl2, Collection collection2, Collection collection3, boolean bl3, String string2) throws CertPathValidatorException {
        CompositeCRL compositeCRL = this.getFirstFindFromCache(string, blArray, bl2);
        if (compositeCRL != null) {
            Object[] objectArray = this.getStatusFromCertStores(string, bl2, date, collection, blArray, true, collection2, collection3, bl3, string2);
            compositeCRL = this.getFirstFindFromCache(string, blArray, bl2);
        }
        return compositeCRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompositeCRL getFirstFindFromCache(String string, boolean[] blArray, boolean bl) {
        Hashtable hashtable = null;
        CompositeCRL compositeCRL = null;
        hashtable = bl ? (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(string) : (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(string);
        if (hashtable != null) {
            Hashtable hashtable2 = hashtable;
            synchronized (hashtable2) {
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements() && !CertPathUtil.minimalUserReasonsSatisfied(blArray, (compositeCRL = (CompositeCRL)enumeration.nextElement()).getReasons())) {
                    compositeCRL = null;
                }
            }
        }
        return compositeCRL;
    }

    int processIssuerName(X509Certificate x509Certificate, Collection collection, Collection collection2, boolean bl, Collection collection3, boolean bl2, Date date, boolean[] blArray, String string) throws CertPathValidatorException {
        Hashtable hashtable = null;
        String string2 = ((Object)x509Certificate.getIssuerDN()).toString();
        int n = 2001;
        hashtable = bl2 ? (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(string2) : (Hashtable)CompositeCRL.EEcompositeCRLHashtable.get(string2);
        if (hashtable != null) {
            n = this.getCRSFromCache(hashtable, date, x509Certificate.getSerialNumber(), blArray);
        }
        if (n == 2001) {
            Object[] objectArray = this.getStatusFromCertStores(string2, bl2, date, collection2, blArray, true, collection, collection3, bl, string);
            hashtable = bl2 ? (Hashtable)objectArray[0] : (Hashtable)objectArray[1];
            n = this.getCRSFromCache(hashtable, date, x509Certificate.getSerialNumber(), blArray);
        }
        return n;
    }

    int getCRSFromCache(Hashtable hashtable, Date date, BigInteger bigInteger, boolean[] blArray) throws CertPathValidatorException {
        boolean[] blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false};
        int n = 2001;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            CompositeCRL compositeCRL = (CompositeCRL)enumeration.nextElement();
            n = compositeCRL.getStatus(bigInteger, date);
            if (n != 2001 && n != 2000) continue;
            CertPathUtil.unionReasons(blArray2, compositeCRL.getReasons());
            if (!CertPathUtil.allUserReasonsSatisfied(blArray, blArray2)) continue;
            break;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getStatusFromCertStores(String string, boolean bl, Date date, Collection collection, boolean[] blArray, boolean bl2, Collection collection2, Collection collection3, boolean bl3, String string2) throws CertPathValidatorException {
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Object[] objectArray = CompositeCRL.CAcompositeCRLHashtable;
        synchronized (CompositeCRL.CAcompositeCRLHashtable) {
            hashtable = (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(string);
            if (hashtable == null) {
                hashtable = new Hashtable();
                CompositeCRL.CAcompositeCRLHashtable.put(string, hashtable);
            }
            // ** MonitorExit[var13_13] (shouldn't be in output)
            objectArray = CompositeCRL.EEcompositeCRLHashtable;
            synchronized (objectArray) {
                hashtable2 = (Hashtable)CompositeCRL.EEcompositeCRLHashtable.get(string);
                if (hashtable2 == null) {
                    hashtable2 = new Hashtable();
                    CompositeCRL.EEcompositeCRLHashtable.put(string, hashtable2);
                }
            }
            this.updateCachesFromCertStores(string, bl, date, collection, hashtable, hashtable2, blArray, bl2, collection2, collection3, bl3, string2);
            objectArray = new Object[]{hashtable, hashtable2};
            return objectArray;
        }
    }

    void updateCachesFromCertStores(String string, boolean bl, Date date, Collection collection, Hashtable hashtable, Hashtable hashtable2, boolean[] blArray, boolean bl2, Collection collection2, Collection collection3, boolean bl3, String string2) throws CertPathValidatorException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean[] blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false};
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            x509CRLSelector.addIssuerName(string);
        }
        catch (IOException iOException) {
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = collection.iterator();
        block4: while (iterator.hasNext()) {
            object4 = (CertStore)iterator.next();
            object3 = null;
            try {
                object3 = ((CertStore)object4).getCRLs(x509CRLSelector);
            }
            catch (CertStoreException certStoreException) {
                // empty catch block
            }
            if (object3 == null) continue;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (X509CRL)object2.next();
                if (CompositeCRL.isDeltaCRL((X509CRL)object)) {
                    vector.add(object);
                    continue;
                }
                CompositeCRL compositeCRL = this.createCompositeCRL(hashtable2, hashtable, (X509CRL)object, collection, collection2, collection3, string2);
                if (compositeCRL == null || (!bl || !compositeCRL.isTypeCA()) && (bl || !compositeCRL.isTypeEE())) continue;
                CertPathUtil.unionReasons(blArray2, compositeCRL.getReasons());
                if (bl2) {
                    if (!CertPathUtil.allUserReasonsSatisfied(blArray, blArray2)) continue;
                    Date date2 = compositeCRL.getNextUpdate();
                    int n = date2.compareTo(date);
                    if (n > 0) break block4;
                    if (n > 0) continue;
                    continue;
                }
                if (!CertPathUtil.minimalUserReasonsSatisfied(blArray, blArray2)) continue;
            }
        }
        object4 = bl ? hashtable : hashtable2;
        object3 = vector.iterator();
        while (object3.hasNext()) {
            object2 = (X509CRL)object3.next();
            object = (CompositeCRL)((Hashtable)object4).get(CompositeCRL.getCRLNumber((X509CRL)object2));
            if (object == null) continue;
            ((CompositeCRL)object).refresh((X509CRL)object2);
        }
    }

    CompositeCRL createCompositeCRL(Hashtable hashtable, Hashtable hashtable2, X509CRL x509CRL, Collection collection, Collection collection2, Collection collection3, String string) throws CertPathValidatorException {
        Object object;
        CompositeCRL compositeCRL = null;
        CompositeCRL compositeCRL2 = new CompositeCRL(null);
        compositeCRL2.update(x509CRL);
        BigInteger bigInteger = compositeCRL2.getNumber();
        boolean bl = false;
        boolean bl2 = false;
        if (compositeCRL2.isTypeEE() && (object = hashtable.get(bigInteger)) == null) {
            bl = true;
        }
        if (compositeCRL2.isTypeCA() && (object = hashtable2.get(bigInteger)) == null) {
            bl2 = true;
        }
        if (bl || bl2) {
            object = null;
            try {
                object = CertPathUtil.findIssuerOfCRL(x509CRL, collection2, collection3, collection, string);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                object = null;
            }
            if (object != null) {
                compositeCRL2.setIssuerCertificate((X509Certificate)object);
                boolean bl3 = this.isIssuerTrusted((X509Certificate)object, collection2, collection3, string);
                compositeCRL = compositeCRL2;
                if (bl3) {
                    if (bl) {
                        hashtable.put(bigInteger, compositeCRL2);
                    }
                    if (bl2) {
                        hashtable2.put(bigInteger, compositeCRL2);
                    }
                }
            }
        }
        return compositeCRL;
    }

    boolean isIssuerTrusted(X509Certificate x509Certificate, Collection collection, Collection collection2, String string) {
        TrustAnchor trustAnchor = null;
        boolean bl = CertPathUtil.findIssuerForCRSCheck(x509Certificate, collection, string);
        if (!bl) {
            try {
                trustAnchor = CertPathUtil.findIssuer(x509Certificate, collection2, string);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                trustAnchor = null;
            }
            if (trustAnchor != null) {
                bl = true;
            }
        }
        return bl;
    }

    int retrieveBaseCRL(CompositeCRL compositeCRL, DirContext dirContext, String string, String[] stringArray, Date date, String string2) throws CertPathValidatorException {
        int n = 0;
        X509CRLImpl[] x509CRLImplArray = CertPathUtil.retrieveCRLs(dirContext, string, stringArray);
        n = compositeCRL.updateBase((X509CRL)x509CRLImplArray[0], date, string2);
        return n;
    }

    int retrieveDeltaCRL(CompositeCRL compositeCRL, DirContext dirContext, String string, String[] stringArray, Date date, String string2) throws CertPathValidatorException {
        int n = 0;
        X509CRLImpl[] x509CRLImplArray = CertPathUtil.retrieveCRLs(dirContext, string, stringArray);
        n = compositeCRL.updateDelta((X509CRL)x509CRLImplArray[0], date, string2);
        return n;
    }

    String[] getLDAPURLAndDN(String string) {
        String[] stringArray;
        block12: {
            stringArray = new String[2];
            try {
                CompositeName compositeName = new CompositeName(string);
                stringArray[0] = compositeName.get(0) + "//" + compositeName.get(2);
                String string2 = compositeName.getSuffix(3).toString();
                int n = string2.indexOf("?");
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (string2.indexOf("%") >= 0) {
                    for (int i = 0; i < string2.length(); ++i) {
                        if (string2.charAt(i) != '%') {
                            stringBuffer.append(string2.charAt(i));
                            continue;
                        }
                        if (i < string2.length() - 2) {
                            StringBuffer stringBuffer2 = new StringBuffer();
                            stringBuffer2.append(string2.charAt(i + 1));
                            stringBuffer2.append(string2.charAt(i + 2));
                            try {
                                Integer n2 = Integer.valueOf(stringBuffer2.toString(), 16);
                                i += 2;
                                stringBuffer.append((char)n2.intValue());
                            }
                            catch (NumberFormatException numberFormatException) {
                                stringBuffer.append(string2.charAt(i));
                            }
                            continue;
                        }
                        stringBuffer.append(string2.charAt(i));
                    }
                    stringArray[1] = stringBuffer.toString();
                } else {
                    stringArray[1] = string2;
                }
            }
            catch (InvalidNameException invalidNameException) {
                if (debug != null) {
                    System.out.println("CERTPATH: Failed to retrieve CRL from " + string);
                    invalidNameException.printStackTrace();
                }
            }
            catch (NamingException namingException) {
                if (debug == null) break block12;
                System.out.println("CERTPATH: Failed to retrieve CRL from " + string);
                namingException.printStackTrace();
            }
        }
        return stringArray;
    }

    private Collection getIBMCollectionCertStores(Collection collection) {
        Vector<CertStore> vector = new Vector<CertStore>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            if (!certStore.getType().equals("Collection")) continue;
            vector.add(certStore);
        }
        if (vector.size() <= 0) {
            vector = null;
        }
        return vector;
    }

    private Hashtable setCRLCache(Collection collection) {
        if (!collection.isEmpty()) {
            Object object;
            ArrayList<Object> arrayList;
            Collection<? extends CRL> collection2;
            CertStore certStore = null;
            Object object2 = collection.iterator();
            while (object2.hasNext()) {
                Object object3;
                Object object4;
                collection2 = null;
                certStore = (CertStore)object2.next();
                if (certStore.getType().equals("Collection")) {
                    try {
                        collection2 = certStore.getCRLs(null);
                    }
                    catch (CertStoreException certStoreException) {
                        collection2 = null;
                    }
                } else if (certStore.getType().equals("LDAP") && !(arrayList = this.certPath.getCertificates()).isEmpty()) {
                    object4 = new X509CRLSelector();
                    object = null;
                    object3 = null;
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        object = (X509Certificate)iterator.next();
                        object3 = ((Object)((X509Certificate)object).getIssuerDN()).toString();
                        try {
                            ((X509CRLSelector)object4).addIssuerName((String)object3);
                        }
                        catch (IOException iOException) {}
                    }
                    try {
                        collection2 = certStore.getCRLs((CRLSelector)object4);
                    }
                    catch (CertStoreException certStoreException) {
                        collection2 = null;
                    }
                }
                if (collection2 == null) continue;
                arrayList = null;
                object4 = null;
                object = null;
                object3 = collection2.iterator();
                while (object3.hasNext()) {
                    object4 = (X509CRL)object3.next();
                    if (!(object4 instanceof X509CRLImpl)) {
                        try {
                            object4 = new X509CRLImpl(((X509CRL)object4).getEncoded());
                        }
                        catch (CRLException cRLException) {
                            continue;
                        }
                    }
                    object = ((X509CRL)object4).getIssuerDN();
                    arrayList = (ArrayList)this.CRLCache.get(object);
                    if (arrayList != null) {
                        arrayList.add(object4);
                        this.CRLCache.put(object, arrayList);
                        continue;
                    }
                    arrayList = new ArrayList<Object>();
                    arrayList.add(object4);
                    this.CRLCache.put(object, arrayList);
                }
            }
            if (debug != null) {
                System.out.println("CERTPATH: The list of CRLs in memory cache:");
                object2 = this.CRLCache.keys();
                while (object2.hasMoreElements()) {
                    collection2 = (Collection<? extends CRL>)object2.nextElement();
                    arrayList = (ArrayList<Object>)this.CRLCache.get(collection2);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object = (X509CRL)arrayList.get(i);
                        System.out.println("\n" + ((X509CRL)object).getIssuerDN().getName() + ", " + ((X509CRL)object).getThisUpdate().toString());
                    }
                }
                System.out.println("End of list");
            }
        }
        return this.CRLCache;
    }

    private boolean intersectReasons(boolean[] blArray, boolean[] blArray2) {
        int n = Math.min(blArray.length, blArray2.length);
        for (int i = 0; i < n; ++i) {
            if (blArray[i] != blArray2[i]) continue;
            return true;
        }
        return false;
    }

    private boolean checkCRLDPEnabled() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.enableCRLDP");
            }
        });
        return new Boolean(string);
    }
}

