/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.eval;

import com.ibm.ObjectQuery.IObjectQueryServiceImpl;
import com.ibm.ObjectQuery.IQueryLogger;
import com.ibm.websphere.ejbquery.QueryException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EDataObject;

class ResultSetProcessor {
    private HashMap dataObjectMap;
    private ArrayList attrName;
    private ArrayList structuralFea;
    private Object[] attrValues;
    private String classAsnName;
    private ArrayList pkValues;
    private EClass schema;
    private EPackage pack;
    private EFactory fac;
    private EClass sdoClass;
    private int pattern = 0;
    private EDataObject root = null;
    private EDataObject rootForPatA = null;
    private String refName = null;
    private HashMap rootRefMap = null;
    private EStructuralFeature referenceFeature = null;
    protected static IQueryLogger queryLogger = null;
    private static String theClassName;

    protected void setSchema(EClass eClass) {
        this.schema = eClass;
        this.pack = this.schema.getEPackage();
        this.fac = this.pack.getEFactoryInstance();
    }

    protected void setEClass(EClass eClass) throws QueryException {
        this.sdoClass = eClass;
        this.setEStructuralFeatures();
    }

    protected EClass getEClass() {
        return this.sdoClass;
    }

    protected void process() throws QueryException {
        EDataObject eDataObject = null;
        if (this.attrValues == null) {
            return;
        }
        try {
            if (!this.dataObjectMap.containsKey(this.pkValues)) {
                eDataObject = this.rootForPatA != null ? this.root : (EDataObject)this.fac.create(this.sdoClass);
                for (int i = 0; i < this.attrName.size(); ++i) {
                    Object object = this.attrValues[i];
                    if (object instanceof Calendar) {
                        object = ((Calendar)object).getTime();
                    }
                    if (object instanceof BigInteger) {
                        object = object.toString();
                    }
                    eDataObject.eSet((EStructuralFeature)this.structuralFea.get(i), object);
                }
                if (this.pattern == 0 || this.pattern == 1 && this.referenceFeature != null) {
                    List list = (List)this.root.eGet(this.referenceFeature);
                    list.add(eDataObject);
                }
                this.dataObjectMap.put(this.pkValues, eDataObject);
            }
        }
        catch (Exception exception) {
            String string = queryLogger.message(4L, theClassName, "process", "MRTIE", new Object[]{exception.toString()});
            throw new QueryException(string, exception, new Object[]{theClassName, "process"});
        }
    }

    protected void setNewValues(Object[] objectArray, ArrayList arrayList) {
        this.attrValues = objectArray;
        this.pkValues = arrayList;
    }

    protected void setEStructuralFeatures() throws QueryException {
        String string = null;
        EStructuralFeature eStructuralFeature = null;
        for (int i = 0; i < this.attrName.size(); ++i) {
            string = (String)this.attrName.get(i);
            eStructuralFeature = this.sdoClass.getEStructuralFeature(string);
            if (eStructuralFeature == null) {
                String string2 = queryLogger.message(4L, theClassName, "setEStructuralFeature", "CDNHF", new Object[]{this.sdoClass.getName(), string});
                throw new QueryException(string2, null, new Object[]{theClassName, "setEStructuralFeature"});
            }
            this.structuralFea.add(i, eStructuralFeature);
        }
    }

    protected ResultSetProcessor(ArrayList arrayList, HashMap hashMap) {
        this.attrName = arrayList;
        this.dataObjectMap = hashMap;
        this.structuralFea = new ArrayList();
    }

    protected void setPattern(int n) {
        this.pattern = n;
    }

    protected void setRoot(EDataObject eDataObject) {
        this.root = eDataObject;
        if (this.pattern == 0 || this.pattern == 1 && this.refName != null) {
            this.referenceFeature = this.root.eClass().getEStructuralFeature(this.refName);
        }
    }

    protected void setRootRefMap(HashMap hashMap) {
        this.rootRefMap = hashMap;
        this.refName = this.rootRefMap != null && this.rootRefMap.size() > 0 ? (String)this.rootRefMap.get(this.sdoClass.getName()) : this.sdoClass.getName();
    }

    protected void setRootForPatA(EDataObject eDataObject) {
        this.rootForPatA = eDataObject;
    }

    static {
        try {
            queryLogger = IObjectQueryServiceImpl.getConfiguration().getLogger();
        }
        catch (Exception exception) {
            // empty catch block
        }
        theClassName = "ResultSetProcessor";
    }
}

