/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.engine;

import com.ibm.ObjectQuery.engine.OqgmCore;
import com.ibm.ObjectQuery.engine.TSDVars;
import com.ibm.ObjectQuery.java_cup.runtime.Scanner;
import com.ibm.ObjectQuery.java_cup.runtime.Symbol;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

class OSQLLexer
implements Scanner {
    private final int YY_BUFFER_SIZE = 8192;
    private final int YY_F = -1;
    private final int YY_NO_STATE = -1;
    private final int YY_NOT_ACCEPT = 0;
    private final int YY_START = 1;
    private final int YY_END = 2;
    private final int YY_NO_ANCHOR = 4;
    private final int YY_BOL = 65536;
    private final int YY_EOF = 65537;
    private static final String[] csi_key_words = new String[]{"_bigint", "_binteger", "_bit", "_char1", "_character", "_date", "_decimal", "_float", "_integer", "_link", "_lvarbinary", "_numeric", "_real", "_smallint", "_this", "_time", "_timestamp", "_tinyint", "_varbinary", "_varchar", "abs", "all", "and", "any", "as", "asc", "avg", "between", "bigint", "bit", "blob", "bo", "boolean", "by", "calendar", "cast", "char", "clob", "concat", "count", "data", "date", "day", "days", "decimal", "default", "define", "desc", "describe", "digits", "distinct", "double", "empty", "escape", "eur", "exists", "explain", "false", "float", "for", "foreign", "from", "group", "having", "hour", "in", "integer", "is", "iso", "jis", "key", "lcase", "length", "like", "locate", "lower", "max", "member", "microsecond", "min", "minute", "mod", "month", "nest", "not", "null", "object", "of", "off", "on", "only", "or", "outer", "precision", "primary", "quit", "real", "references", "remote", "second", "select", "set", "setunion", "smallint", "some", "sqrt", "substring", "sum", "table", "time", "timestamp", "treat", "true", "type", "ucase", "upper", "usa", "view", "where", "with", "year"};
    private static final int[] csi_key_tokens = new int[]{14, 15, 17, 16, 25, 37, 41, 59, 71, 166, 28, 19, 114, 129, 145, 149, 151, 18, 27, 156, 105, 3, 4, 5, 7, 8, 9, 10, 13, 11, 12, 131, 20, 21, 152, 23, 24, 30, 104, 34, 35, 36, 38, 39, 40, 42, 44, 45, 46, 47, 48, 51, 52, 54, 55, 56, 57, 133, 58, 60, 61, 62, 64, 66, 67, 69, 70, 73, 74, 76, 77, 83, 80, 81, 103, 83, 86, 87, 88, 89, 90, 164, 91, 93, 94, 95, 118, 96, 97, 98, 99, 101, 163, 107, 108, 109, 113, 119, 136, 121, 122, 124, 125, 128, 130, 106, 140, 143, 144, 148, 150, 115, 141, 158, 154, 154, 155, 157, 159, 160, 161};
    public static final int MBMAXLEN = 4;
    public static final int MAX_KEY_WORD_LENGTH = 256;
    TSDVars gv;
    String yytext2;
    public static int[] sql_key_chars = new int[]{100, 92, 63, 65, 79, 85, 50, 6, 134, 135, 139, 127, 84, 120, 78, 112, 32, 49, 123, 110, 31};
    private BufferedReader yy_reader;
    private int yy_buffer_index = 0;
    private int yy_buffer_read = 0;
    private int yy_buffer_start = 0;
    private int yy_buffer_end = 0;
    private char[] yy_buffer;
    private boolean yy_at_bol = true;
    private int yy_lexical_state = 0;
    private boolean yy_eof_done = false;
    private final int YYINITIAL = 0;
    private final int[] yy_state_dtrans = new int[]{0};
    private boolean yy_last_was_cr = false;
    private final int YY_E_INTERNAL = 0;
    private final int YY_E_MATCH = 1;
    private String[] yy_error_string = new String[]{"Error: Internal error.\n", "Error: Unmatched input.\n"};
    private int[] yy_acpt = new int[]{0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 4, 4, 4, 4, 0, 4, 4, 0, 4, 0, 4, 0, 4, 0, 4, 0, 4, 0, 4, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] yy_cmap = OSQLLexer.unpackFromString(1, 65538, "26:9,4,1,26:2,36,26:18,4,26,37,26:2,3,26,35,48,49,46,34,50,2,32,47,28,30:9,51,27,23,45,24,38,3,15,19,5,43,33,41,26:2,39,26:2,21,26:2,40,26:2,42,22,26:5,44,26:2,3,26:2,14,26,17,31,9,43,8,41,20,26,11,26:2,7,26,12,6,26:2,16,13,10,26,25,26,29,18,26,3,26,3,26:65410,0:2")[0];
    private static final int[] yy_rmap = OSQLLexer.unpackFromString(1, 106, "0,1,2,3,1,4,5,6,1,7,8,1,9,1:7,10,1:4,11,1:3,9,12,13,1:2,14:4,1,14:3,15,16,17,18,19,20,21,22,13,23,16,24,21,25,26,27,28,29,12,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,14,73")[0];
    private static final int[][] yy_nxt = OSQLLexer.unpackFromString(74, 52, "1,2,3,4,2,5,89,104:4,66,104:2,105,104:8,6,7,104:2,8,9,104,45,104,10,104,11,43,2,48,12,66,90,104:4,13,14,15,16,17,18,19,-1:53,2,-1:2,2,-1:31,2,-1:17,20,-1:21,21,-1:32,104,100,104:16,-1:2,104:7,-1,104,-1:5,104:6,-1:15,42,-1:15,22,-1:20,23,-1:51,24,-1:14,47,-1:19,45,50,45,-1,25,47,-1:50,26,-1:47,29,-1,29,-1:23,20:34,-1,20:15,-1:8,47,-1:19,25,-1,25,-1:2,47,-1:46,30,-1,30,-1:26,31,-1:2,31:2,-1:5,31,-1,31,-1,31,-1:8,31,-1,31:2,-1,31,-1:7,31,-1,31,-1:13,104:18,-1:2,104:7,-1,104,-1:5,104:6,-1:13,58,-1:46,27,52:33,46,52:16,-1,56,-1:2,56,104:18,-1:2,104:7,-1,104,-1:2,56,-1:2,104:6,-1:15,47,-1:19,45,-1,45,-1,25,47,-1:53,52,-1:18,60,-1:25,30,-1,30,-1:3,60,-1:18,28,54:35,28,54:14,-1:5,104:15,34,104:2,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:5,35,104:12,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:5,36,104:12,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:13,37,104:4,-1:2,104:7,-1,104,-1:5,104:6,-1:8,56,-1:2,56,-1,62,-1:29,56,-1:3,62,-1:16,104:7,39,104:10,-1:2,104:7,-1,104,-1:5,104:6,-1:17,63,-1:46,104:11,40,104:6,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:7,41,104:10,-1:2,104:7,-1,104,-1:5,104:6,-1:48,32,-1:34,33,-1:28,64,-1:2,64,-1:14,65,-1:11,65,-1:4,64,-1:33,38,-1:25,38,-1:12,104:8,44,104:8,44,-1:2,104:7,-1,104,-1:5,104:6,-1:8,64,-1:2,64,104:18,-1:2,104:7,-1,104,-1:2,64,-1:2,104:6,-1:12,104:12,49,104:5,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:3,51,104:14,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:11,67,104:6,-1:2,104:7,-1,104,-1:5,104:3,67,104:2,-1:12,104:8,53,104:9,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:12,55,104:5,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104,57,104:16,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:3,59,104:14,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104,61,104:16,-1:2,104:7,-1,104,-1:5,104:6,-1:12,102,104:9,85,104:3,68,104,78,69,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:3,70,104:14,-1:2,104:7,-1,70,-1:5,104:6,-1:12,104:6,71,104:11,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:11,72,104:6,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:6,73,104:11,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:5,74,104:12,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:6,75,104:11,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:9,76,104:8,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:18,-1:2,104:7,-1,104,-1:5,104:4,77,104,-1:12,104:11,79,104:6,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:5,80,104:12,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:11,81,104:6,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:5,82,104:12,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:8,83,104:2,84,104:6,-1:2,104:7,-1,104,-1:5,104:3,84,104:2,-1:12,104:11,84,104:6,-1:2,104:7,-1,104,-1:5,104:3,84,104:2,-1:12,104:4,86,104:13,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:3,87,104:14,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:4,88,104:13,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:3,91,104:14,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:18,-1:2,92,104:6,-1,104,-1:5,104:6,-1:12,104:3,93,104:14,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:2,94,104:15,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:7,95,104:10,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:2,96,104:15,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:2,97,104:15,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104,98,104:16,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104,103,104:16,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:2,99,104:15,-1:2,104:7,-1,104,-1:5,104:6,-1:12,104:4,101,104:13,-1:2,104:7,-1,104,-1:5,104:6,-1:7");

    public OSQLLexer(TSDVars tSDVars) {
        this();
        this.gv = tSDVars;
        if (this.gv == null || null == this.gv.sql_in_text) {
            throw new Error("Error: Bad input stream initializer.");
        }
        this.yy_reader = new BufferedReader(new StringReader(this.gv.sql_in_text));
    }

    public static boolean isOSQLKeyword(int n) {
        int n2 = 1;
        int n3 = csi_key_tokens.length;
        int n4 = 0;
        do {
            if (csi_key_tokens[(n4 = (n2 + n3) / 2) - 1] < n) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        } while (csi_key_tokens[n4 - 1] != n && n2 <= n3);
        if (csi_key_tokens[n4 - 1] == n) {
            return true;
        }
        for (n2 = 0; n2 < sql_key_chars.length; ++n2) {
            if (sql_key_chars[n2] != n) continue;
            return true;
        }
        return false;
    }

    OSQLLexer(Reader reader) {
        this();
        if (null == reader) {
            throw new Error("Error: Bad input stream initializer.");
        }
        this.yy_reader = new BufferedReader(reader);
    }

    OSQLLexer(InputStream inputStream) {
        this();
        if (null == inputStream) {
            throw new Error("Error: Bad input stream initializer.");
        }
        this.yy_reader = new BufferedReader(new InputStreamReader(inputStream));
    }

    private OSQLLexer() {
        this.yy_buffer = new char[8192];
    }

    private void yybegin(int n) {
        this.yy_lexical_state = n;
    }

    private int yy_advance() throws IOException {
        int n;
        if (this.yy_buffer_index < this.yy_buffer_read) {
            return this.yy_buffer[this.yy_buffer_index++];
        }
        if (0 != this.yy_buffer_start) {
            int n2 = this.yy_buffer_start;
            int n3 = 0;
            while (n2 < this.yy_buffer_read) {
                this.yy_buffer[n3] = this.yy_buffer[n2];
                ++n2;
                ++n3;
            }
            this.yy_buffer_end -= this.yy_buffer_start;
            this.yy_buffer_start = 0;
            this.yy_buffer_read = n3;
            this.yy_buffer_index = n3;
            n = this.yy_reader.read(this.yy_buffer, this.yy_buffer_read, this.yy_buffer.length - this.yy_buffer_read);
            if (-1 == n) {
                return 65537;
            }
            this.yy_buffer_read += n;
        }
        while (this.yy_buffer_index >= this.yy_buffer_read) {
            if (this.yy_buffer_index >= this.yy_buffer.length) {
                this.yy_buffer = this.yy_double(this.yy_buffer);
            }
            if (-1 == (n = this.yy_reader.read(this.yy_buffer, this.yy_buffer_read, this.yy_buffer.length - this.yy_buffer_read))) {
                return 65537;
            }
            this.yy_buffer_read += n;
        }
        return this.yy_buffer[this.yy_buffer_index++];
    }

    private void yy_move_end() {
        if (this.yy_buffer_end > this.yy_buffer_start && '\n' == this.yy_buffer[this.yy_buffer_end - 1]) {
            --this.yy_buffer_end;
        }
        if (this.yy_buffer_end > this.yy_buffer_start && '\r' == this.yy_buffer[this.yy_buffer_end - 1]) {
            --this.yy_buffer_end;
        }
    }

    private void yy_mark_start() {
        this.yy_buffer_start = this.yy_buffer_index;
    }

    private void yy_mark_end() {
        this.yy_buffer_end = this.yy_buffer_index;
    }

    private void yy_to_mark() {
        this.yy_buffer_index = this.yy_buffer_end;
        this.yy_at_bol = this.yy_buffer_end > this.yy_buffer_start && ('\r' == this.yy_buffer[this.yy_buffer_end - 1] || '\n' == this.yy_buffer[this.yy_buffer_end - 1] || '\u07ec' == this.yy_buffer[this.yy_buffer_end - 1] || '\u07ed' == this.yy_buffer[this.yy_buffer_end - 1]);
    }

    private String yytext() {
        return new String(this.yy_buffer, this.yy_buffer_start, this.yy_buffer_end - this.yy_buffer_start);
    }

    private int yylength() {
        return this.yy_buffer_end - this.yy_buffer_start;
    }

    private char[] yy_double(char[] cArray) {
        char[] cArray2 = new char[2 * cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            cArray2[i] = cArray[i];
        }
        return cArray2;
    }

    private void yy_error(int n, boolean bl) {
        System.out.print(this.yy_error_string[n]);
        System.out.flush();
        if (bl) {
            throw new Error("Fatal Error.\n");
        }
    }

    private static int[][] unpackFromString(int n, int n2, String string) {
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int[][] nArray = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (n4 != 0) {
                    nArray[i][j] = n5;
                    --n4;
                    continue;
                }
                int n6 = string.indexOf(44);
                String string2 = n6 == -1 ? string : string.substring(0, n6);
                string = string.substring(n6 + 1);
                n3 = string2.indexOf(58);
                if (n3 == -1) {
                    nArray[i][j] = Integer.parseInt(string2);
                    continue;
                }
                String string3 = string2.substring(n3 + 1);
                n4 = Integer.parseInt(string3);
                string2 = string2.substring(0, n3);
                nArray[i][j] = n5 = Integer.parseInt(string2);
                --n4;
            }
        }
        return nArray;
    }

    public Symbol next_token() throws IOException {
        int n = 4;
        int n2 = this.yy_state_dtrans[this.yy_lexical_state];
        int n3 = -1;
        int n4 = -1;
        boolean bl = true;
        this.yy_mark_start();
        int n5 = this.yy_acpt[n2];
        if (0 != n5) {
            n4 = n2;
            this.yy_mark_end();
        }
        while (true) {
            int n6 = bl && this.yy_at_bol ? 65536 : this.yy_advance();
            n3 = -1;
            n3 = yy_nxt[yy_rmap[n2]][yy_cmap[n6]];
            if (65537 == n6 && bl) {
                return null;
            }
            if (-1 != n3) {
                n2 = n3;
                bl = false;
                n5 = this.yy_acpt[n2];
                if (0 == n5) continue;
                n4 = n2;
                this.yy_mark_end();
                continue;
            }
            if (-1 == n4) {
                throw new Error("Lexical Error: Unmatched Input.");
            }
            n = this.yy_acpt[n4];
            if (0 != (2 & n)) {
                this.yy_move_end();
            }
            this.yy_to_mark();
            switch (n4) {
                case -2: 
                case 1: {
                    break;
                }
                case 2: {
                    int n7;
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + " ";
                    }
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    for (n7 = 0; n7 < this.gv.sql_leng; ++n7) {
                        if (this.gv.sql_text.charAt(n7) == '\n') {
                            this.gv.osqlTokenpos = 0;
                            ++this.gv.osqlLineNo;
                            continue;
                        }
                        ++this.gv.osqlTokenpos;
                    }
                }
                case -3: {
                    break;
                }
                case 3: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(134);
                }
                case -4: {
                    break;
                }
                case 4: {
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                    return new Symbol(9000);
                }
                case -5: {
                    break;
                }
                case 5: {
                    int n8;
                    int n7;
                    boolean bl2 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl2 = false;
                    }
                    for (n7 = 1; bl2 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl2 = false;
                    }
                    if (!bl2) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n9 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n8 = (n7 + n9) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n8 + 1;
                            continue;
                        }
                        n9 = n8 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n8 - 1]) != 0 && n7 <= n9);
                    if (this.yytext2.equals(csi_key_words[n8 - 1])) {
                        return new Symbol(csi_key_tokens[n8 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -6: {
                    break;
                }
                case 6: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(85);
                }
                case -7: {
                    break;
                }
                case 7: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(65);
                }
                case -8: {
                    break;
                }
                case 8: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(123);
                }
                case -9: {
                    break;
                }
                case 9: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    int n7 = 0;
                    Integer n10 = null;
                    Long l = null;
                    try {
                        n10 = new Integer(this.yytext());
                    }
                    catch (NumberFormatException numberFormatException) {
                        ++n7;
                    }
                    if (n7 == 1) {
                        try {
                            l = new Long(this.yytext());
                        }
                        catch (NumberFormatException numberFormatException) {
                            OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "NTB", new Object[]{this.yytext()});
                            return new Symbol(1);
                        }
                        return new Symbol(22, l);
                    }
                    return new Symbol(72, n10);
                }
                case -10: {
                    break;
                }
                case 10: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(49);
                }
                case -11: {
                    break;
                }
                case 11: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(135);
                }
                case -12: {
                    break;
                }
                case 12: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(110);
                }
                case -13: {
                    break;
                }
                case 13: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(100);
                }
                case -14: {
                    break;
                }
                case 14: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(139);
                }
                case -15: {
                    break;
                }
                case 15: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(127);
                }
                case -16: {
                    break;
                }
                case 16: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(84);
                }
                case -17: {
                    break;
                }
                case 17: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(120);
                }
                case -18: {
                    break;
                }
                case 18: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(32);
                }
                case -19: {
                    break;
                }
                case 19: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(31);
                }
                case -20: {
                    break;
                }
                case -21: 
                case 20: {
                    break;
                }
                case 21: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(6);
                }
                case -22: {
                    break;
                }
                case 22: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(92);
                }
                case -23: {
                    break;
                }
                case 23: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(79);
                }
                case -24: {
                    break;
                }
                case 24: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(63);
                }
                case -25: {
                    break;
                }
                case 25: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(116, new String(this.yytext()));
                }
                case -26: {
                    break;
                }
                case 26: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(50);
                }
                case -27: {
                    break;
                }
                case 27: {
                    String string = this.yytext().substring(1, this.yylength() - 1);
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yytext().length();
                    this.gv.sql_text = string;
                    this.gv.sql_leng = string.length();
                    return new Symbol(142, new String(string));
                }
                case -28: {
                    break;
                }
                case 28: {
                    String string = this.yytext().substring(1, this.yylength() - 1);
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yytext().length();
                    this.gv.sql_text = string;
                    this.gv.sql_leng = string.length();
                    return new Symbol(68, this.gv.symTable.install_id(string));
                }
                case -29: {
                    break;
                }
                case 29: {
                    String string = this.yytext().substring(1);
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(111, new Integer(string));
                }
                case -30: {
                    break;
                }
                case 30: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(117, new String(this.yytext()));
                }
                case -31: {
                    break;
                }
                case 31: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(2, this.gv.symTable.install_id(this.yytext()));
                }
                case -32: {
                    break;
                }
                case 32: {
                    int n7;
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + "is of";
                    }
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    for (n7 = 0; n7 < this.gv.sql_leng; ++n7) {
                        if (this.gv.sql_text.charAt(n7) == '\n') {
                            this.gv.osqlTokenpos = 0;
                            ++this.gv.osqlLineNo;
                            continue;
                        }
                        ++this.gv.osqlTokenpos;
                    }
                    return new Symbol(75);
                }
                case -33: {
                    break;
                }
                case 33: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(53);
                }
                case -34: {
                    break;
                }
                case 34: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(82);
                }
                case -35: {
                    break;
                }
                case 35: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(126);
                }
                case -36: {
                    break;
                }
                case 36: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(82);
                }
                case -37: {
                    break;
                }
                case 37: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(82);
                }
                case -38: {
                    break;
                }
                case 38: {
                    int n7;
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + "order by";
                    }
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    for (n7 = 0; n7 < this.gv.sql_leng; ++n7) {
                        if (this.gv.sql_text.charAt(n7) == '\n') {
                            this.gv.osqlTokenpos = 0;
                            ++this.gv.osqlLineNo;
                            continue;
                        }
                        ++this.gv.osqlTokenpos;
                    }
                    return new Symbol(102);
                }
                case -39: {
                    break;
                }
                case 39: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(82);
                }
                case -40: {
                    break;
                }
                case 40: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(33);
                }
                case -41: {
                    break;
                }
                case 41: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    return new Symbol(82);
                }
                case -42: {
                    break;
                }
                case 43: {
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                    return new Symbol(9000);
                }
                case -43: {
                    break;
                }
                case 44: {
                    int n11;
                    int n7;
                    boolean bl3 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl3 = false;
                    }
                    for (n7 = 1; bl3 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl3 = false;
                    }
                    if (!bl3) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n12 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n11 = (n7 + n12) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n11 + 1;
                            continue;
                        }
                        n12 = n11 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n11 - 1]) != 0 && n7 <= n12);
                    if (this.yytext2.equals(csi_key_words[n11 - 1])) {
                        return new Symbol(csi_key_tokens[n11 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -44: {
                    break;
                }
                case 45: {
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    int n7 = 0;
                    Integer n13 = null;
                    Long l = null;
                    try {
                        n13 = new Integer(this.yytext());
                    }
                    catch (NumberFormatException numberFormatException) {
                        ++n7;
                    }
                    if (n7 == 1) {
                        try {
                            l = new Long(this.yytext());
                        }
                        catch (NumberFormatException numberFormatException) {
                            OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "NTB", new Object[]{this.yytext()});
                            return new Symbol(1);
                        }
                        return new Symbol(22, l);
                    }
                    return new Symbol(72, n13);
                }
                case -45: {
                    break;
                }
                case 46: {
                    String string = this.yytext().substring(1, this.yylength() - 1);
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yytext().length();
                    this.gv.sql_text = string;
                    this.gv.sql_leng = string.length();
                    return new Symbol(142, new String(string));
                }
                case -46: {
                    break;
                }
                case 48: {
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                    return new Symbol(9000);
                }
                case -47: {
                    break;
                }
                case 49: {
                    int n14;
                    int n7;
                    boolean bl4 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl4 = false;
                    }
                    for (n7 = 1; bl4 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl4 = false;
                    }
                    if (!bl4) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n15 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n14 = (n7 + n15) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n14 + 1;
                            continue;
                        }
                        n15 = n14 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n14 - 1]) != 0 && n7 <= n15);
                    if (this.yytext2.equals(csi_key_words[n14 - 1])) {
                        return new Symbol(csi_key_tokens[n14 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -48: {
                    break;
                }
                case 51: {
                    int n16;
                    int n7;
                    boolean bl5 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl5 = false;
                    }
                    for (n7 = 1; bl5 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl5 = false;
                    }
                    if (!bl5) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n17 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n16 = (n7 + n17) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n16 + 1;
                            continue;
                        }
                        n17 = n16 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n16 - 1]) != 0 && n7 <= n17);
                    if (this.yytext2.equals(csi_key_words[n16 - 1])) {
                        return new Symbol(csi_key_tokens[n16 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -49: {
                    break;
                }
                case 53: {
                    int n18;
                    int n7;
                    boolean bl6 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl6 = false;
                    }
                    for (n7 = 1; bl6 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl6 = false;
                    }
                    if (!bl6) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n19 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n18 = (n7 + n19) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n18 + 1;
                            continue;
                        }
                        n19 = n18 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n18 - 1]) != 0 && n7 <= n19);
                    if (this.yytext2.equals(csi_key_words[n18 - 1])) {
                        return new Symbol(csi_key_tokens[n18 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -50: {
                    break;
                }
                case 55: {
                    int n20;
                    int n7;
                    boolean bl7 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl7 = false;
                    }
                    for (n7 = 1; bl7 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl7 = false;
                    }
                    if (!bl7) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n21 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n20 = (n7 + n21) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n20 + 1;
                            continue;
                        }
                        n21 = n20 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n20 - 1]) != 0 && n7 <= n21);
                    if (this.yytext2.equals(csi_key_words[n20 - 1])) {
                        return new Symbol(csi_key_tokens[n20 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -51: {
                    break;
                }
                case 57: {
                    int n22;
                    int n7;
                    boolean bl8 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl8 = false;
                    }
                    for (n7 = 1; bl8 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl8 = false;
                    }
                    if (!bl8) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n23 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n22 = (n7 + n23) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n22 + 1;
                            continue;
                        }
                        n23 = n22 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n22 - 1]) != 0 && n7 <= n23);
                    if (this.yytext2.equals(csi_key_words[n22 - 1])) {
                        return new Symbol(csi_key_tokens[n22 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -52: {
                    break;
                }
                case 59: {
                    int n24;
                    int n7;
                    boolean bl9 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl9 = false;
                    }
                    for (n7 = 1; bl9 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl9 = false;
                    }
                    if (!bl9) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n25 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n24 = (n7 + n25) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n24 + 1;
                            continue;
                        }
                        n25 = n24 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n24 - 1]) != 0 && n7 <= n25);
                    if (this.yytext2.equals(csi_key_words[n24 - 1])) {
                        return new Symbol(csi_key_tokens[n24 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -53: {
                    break;
                }
                case 61: {
                    int n26;
                    int n7;
                    boolean bl10 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl10 = false;
                    }
                    for (n7 = 1; bl10 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl10 = false;
                    }
                    if (!bl10) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n27 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n26 = (n7 + n27) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n26 + 1;
                            continue;
                        }
                        n27 = n26 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n26 - 1]) != 0 && n7 <= n27);
                    if (this.yytext2.equals(csi_key_words[n26 - 1])) {
                        return new Symbol(csi_key_tokens[n26 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -54: {
                    break;
                }
                case 66: {
                    int n28;
                    int n7;
                    boolean bl11 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl11 = false;
                    }
                    for (n7 = 1; bl11 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl11 = false;
                    }
                    if (!bl11) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n29 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n28 = (n7 + n29) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n28 + 1;
                            continue;
                        }
                        n29 = n28 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n28 - 1]) != 0 && n7 <= n29);
                    if (this.yytext2.equals(csi_key_words[n28 - 1])) {
                        return new Symbol(csi_key_tokens[n28 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -55: {
                    break;
                }
                case 67: {
                    int n30;
                    int n7;
                    boolean bl12 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl12 = false;
                    }
                    for (n7 = 1; bl12 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl12 = false;
                    }
                    if (!bl12) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n31 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n30 = (n7 + n31) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n30 + 1;
                            continue;
                        }
                        n31 = n30 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n30 - 1]) != 0 && n7 <= n31);
                    if (this.yytext2.equals(csi_key_words[n30 - 1])) {
                        return new Symbol(csi_key_tokens[n30 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -56: {
                    break;
                }
                case 68: {
                    int n32;
                    int n7;
                    boolean bl13 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl13 = false;
                    }
                    for (n7 = 1; bl13 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl13 = false;
                    }
                    if (!bl13) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n33 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n32 = (n7 + n33) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n32 + 1;
                            continue;
                        }
                        n33 = n32 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n32 - 1]) != 0 && n7 <= n33);
                    if (this.yytext2.equals(csi_key_words[n32 - 1])) {
                        return new Symbol(csi_key_tokens[n32 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -57: {
                    break;
                }
                case 69: {
                    int n34;
                    int n7;
                    boolean bl14 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl14 = false;
                    }
                    for (n7 = 1; bl14 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl14 = false;
                    }
                    if (!bl14) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n35 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n34 = (n7 + n35) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n34 + 1;
                            continue;
                        }
                        n35 = n34 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n34 - 1]) != 0 && n7 <= n35);
                    if (this.yytext2.equals(csi_key_words[n34 - 1])) {
                        return new Symbol(csi_key_tokens[n34 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -58: {
                    break;
                }
                case 70: {
                    int n36;
                    int n7;
                    boolean bl15 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl15 = false;
                    }
                    for (n7 = 1; bl15 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl15 = false;
                    }
                    if (!bl15) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n37 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n36 = (n7 + n37) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n36 + 1;
                            continue;
                        }
                        n37 = n36 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n36 - 1]) != 0 && n7 <= n37);
                    if (this.yytext2.equals(csi_key_words[n36 - 1])) {
                        return new Symbol(csi_key_tokens[n36 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -59: {
                    break;
                }
                case 71: {
                    int n38;
                    int n7;
                    boolean bl16 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl16 = false;
                    }
                    for (n7 = 1; bl16 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl16 = false;
                    }
                    if (!bl16) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n39 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n38 = (n7 + n39) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n38 + 1;
                            continue;
                        }
                        n39 = n38 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n38 - 1]) != 0 && n7 <= n39);
                    if (this.yytext2.equals(csi_key_words[n38 - 1])) {
                        return new Symbol(csi_key_tokens[n38 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -60: {
                    break;
                }
                case 72: {
                    int n40;
                    int n7;
                    boolean bl17 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl17 = false;
                    }
                    for (n7 = 1; bl17 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl17 = false;
                    }
                    if (!bl17) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n41 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n40 = (n7 + n41) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n40 + 1;
                            continue;
                        }
                        n41 = n40 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n40 - 1]) != 0 && n7 <= n41);
                    if (this.yytext2.equals(csi_key_words[n40 - 1])) {
                        return new Symbol(csi_key_tokens[n40 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -61: {
                    break;
                }
                case 73: {
                    int n42;
                    int n7;
                    boolean bl18 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl18 = false;
                    }
                    for (n7 = 1; bl18 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl18 = false;
                    }
                    if (!bl18) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n43 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n42 = (n7 + n43) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n42 + 1;
                            continue;
                        }
                        n43 = n42 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n42 - 1]) != 0 && n7 <= n43);
                    if (this.yytext2.equals(csi_key_words[n42 - 1])) {
                        return new Symbol(csi_key_tokens[n42 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -62: {
                    break;
                }
                case 74: {
                    int n44;
                    int n7;
                    boolean bl19 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl19 = false;
                    }
                    for (n7 = 1; bl19 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl19 = false;
                    }
                    if (!bl19) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n45 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n44 = (n7 + n45) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n44 + 1;
                            continue;
                        }
                        n45 = n44 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n44 - 1]) != 0 && n7 <= n45);
                    if (this.yytext2.equals(csi_key_words[n44 - 1])) {
                        return new Symbol(csi_key_tokens[n44 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -63: {
                    break;
                }
                case 75: {
                    int n46;
                    int n7;
                    boolean bl20 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl20 = false;
                    }
                    for (n7 = 1; bl20 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl20 = false;
                    }
                    if (!bl20) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n47 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n46 = (n7 + n47) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n46 + 1;
                            continue;
                        }
                        n47 = n46 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n46 - 1]) != 0 && n7 <= n47);
                    if (this.yytext2.equals(csi_key_words[n46 - 1])) {
                        return new Symbol(csi_key_tokens[n46 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -64: {
                    break;
                }
                case 76: {
                    int n48;
                    int n7;
                    boolean bl21 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl21 = false;
                    }
                    for (n7 = 1; bl21 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl21 = false;
                    }
                    if (!bl21) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n49 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n48 = (n7 + n49) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n48 + 1;
                            continue;
                        }
                        n49 = n48 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n48 - 1]) != 0 && n7 <= n49);
                    if (this.yytext2.equals(csi_key_words[n48 - 1])) {
                        return new Symbol(csi_key_tokens[n48 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -65: {
                    break;
                }
                case 77: {
                    int n50;
                    int n7;
                    boolean bl22 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl22 = false;
                    }
                    for (n7 = 1; bl22 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl22 = false;
                    }
                    if (!bl22) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n51 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n50 = (n7 + n51) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n50 + 1;
                            continue;
                        }
                        n51 = n50 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n50 - 1]) != 0 && n7 <= n51);
                    if (this.yytext2.equals(csi_key_words[n50 - 1])) {
                        return new Symbol(csi_key_tokens[n50 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -66: {
                    break;
                }
                case 78: {
                    int n52;
                    int n7;
                    boolean bl23 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl23 = false;
                    }
                    for (n7 = 1; bl23 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl23 = false;
                    }
                    if (!bl23) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n53 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n52 = (n7 + n53) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n52 + 1;
                            continue;
                        }
                        n53 = n52 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n52 - 1]) != 0 && n7 <= n53);
                    if (this.yytext2.equals(csi_key_words[n52 - 1])) {
                        return new Symbol(csi_key_tokens[n52 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -67: {
                    break;
                }
                case 79: {
                    int n54;
                    int n7;
                    boolean bl24 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl24 = false;
                    }
                    for (n7 = 1; bl24 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl24 = false;
                    }
                    if (!bl24) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n55 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n54 = (n7 + n55) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n54 + 1;
                            continue;
                        }
                        n55 = n54 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n54 - 1]) != 0 && n7 <= n55);
                    if (this.yytext2.equals(csi_key_words[n54 - 1])) {
                        return new Symbol(csi_key_tokens[n54 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -68: {
                    break;
                }
                case 80: {
                    int n56;
                    int n7;
                    boolean bl25 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl25 = false;
                    }
                    for (n7 = 1; bl25 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl25 = false;
                    }
                    if (!bl25) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n57 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n56 = (n7 + n57) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n56 + 1;
                            continue;
                        }
                        n57 = n56 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n56 - 1]) != 0 && n7 <= n57);
                    if (this.yytext2.equals(csi_key_words[n56 - 1])) {
                        return new Symbol(csi_key_tokens[n56 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -69: {
                    break;
                }
                case 81: {
                    int n58;
                    int n7;
                    boolean bl26 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl26 = false;
                    }
                    for (n7 = 1; bl26 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl26 = false;
                    }
                    if (!bl26) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n59 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n58 = (n7 + n59) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n58 + 1;
                            continue;
                        }
                        n59 = n58 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n58 - 1]) != 0 && n7 <= n59);
                    if (this.yytext2.equals(csi_key_words[n58 - 1])) {
                        return new Symbol(csi_key_tokens[n58 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -70: {
                    break;
                }
                case 82: {
                    int n60;
                    int n7;
                    boolean bl27 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl27 = false;
                    }
                    for (n7 = 1; bl27 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl27 = false;
                    }
                    if (!bl27) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n61 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n60 = (n7 + n61) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n60 + 1;
                            continue;
                        }
                        n61 = n60 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n60 - 1]) != 0 && n7 <= n61);
                    if (this.yytext2.equals(csi_key_words[n60 - 1])) {
                        return new Symbol(csi_key_tokens[n60 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -71: {
                    break;
                }
                case 83: {
                    int n62;
                    int n7;
                    boolean bl28 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl28 = false;
                    }
                    for (n7 = 1; bl28 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl28 = false;
                    }
                    if (!bl28) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n63 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n62 = (n7 + n63) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n62 + 1;
                            continue;
                        }
                        n63 = n62 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n62 - 1]) != 0 && n7 <= n63);
                    if (this.yytext2.equals(csi_key_words[n62 - 1])) {
                        return new Symbol(csi_key_tokens[n62 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -72: {
                    break;
                }
                case 84: {
                    int n64;
                    int n7;
                    boolean bl29 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl29 = false;
                    }
                    for (n7 = 1; bl29 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl29 = false;
                    }
                    if (!bl29) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n65 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n64 = (n7 + n65) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n64 + 1;
                            continue;
                        }
                        n65 = n64 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n64 - 1]) != 0 && n7 <= n65);
                    if (this.yytext2.equals(csi_key_words[n64 - 1])) {
                        return new Symbol(csi_key_tokens[n64 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -73: {
                    break;
                }
                case 85: {
                    int n66;
                    int n7;
                    boolean bl30 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl30 = false;
                    }
                    for (n7 = 1; bl30 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl30 = false;
                    }
                    if (!bl30) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n67 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n66 = (n7 + n67) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n66 + 1;
                            continue;
                        }
                        n67 = n66 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n66 - 1]) != 0 && n7 <= n67);
                    if (this.yytext2.equals(csi_key_words[n66 - 1])) {
                        return new Symbol(csi_key_tokens[n66 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -74: {
                    break;
                }
                case 86: {
                    int n68;
                    int n7;
                    boolean bl31 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl31 = false;
                    }
                    for (n7 = 1; bl31 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl31 = false;
                    }
                    if (!bl31) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n69 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n68 = (n7 + n69) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n68 + 1;
                            continue;
                        }
                        n69 = n68 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n68 - 1]) != 0 && n7 <= n69);
                    if (this.yytext2.equals(csi_key_words[n68 - 1])) {
                        return new Symbol(csi_key_tokens[n68 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -75: {
                    break;
                }
                case 87: {
                    int n70;
                    int n7;
                    boolean bl32 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl32 = false;
                    }
                    for (n7 = 1; bl32 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl32 = false;
                    }
                    if (!bl32) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n71 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n70 = (n7 + n71) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n70 + 1;
                            continue;
                        }
                        n71 = n70 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n70 - 1]) != 0 && n7 <= n71);
                    if (this.yytext2.equals(csi_key_words[n70 - 1])) {
                        return new Symbol(csi_key_tokens[n70 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -76: {
                    break;
                }
                case 88: {
                    int n72;
                    int n7;
                    boolean bl33 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl33 = false;
                    }
                    for (n7 = 1; bl33 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl33 = false;
                    }
                    if (!bl33) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n73 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n72 = (n7 + n73) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n72 + 1;
                            continue;
                        }
                        n73 = n72 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n72 - 1]) != 0 && n7 <= n73);
                    if (this.yytext2.equals(csi_key_words[n72 - 1])) {
                        return new Symbol(csi_key_tokens[n72 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -77: {
                    break;
                }
                case 89: {
                    int n74;
                    int n7;
                    boolean bl34 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl34 = false;
                    }
                    for (n7 = 1; bl34 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl34 = false;
                    }
                    if (!bl34) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n75 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n74 = (n7 + n75) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n74 + 1;
                            continue;
                        }
                        n75 = n74 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n74 - 1]) != 0 && n7 <= n75);
                    if (this.yytext2.equals(csi_key_words[n74 - 1])) {
                        return new Symbol(csi_key_tokens[n74 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -78: {
                    break;
                }
                case 90: {
                    int n76;
                    int n7;
                    boolean bl35 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl35 = false;
                    }
                    for (n7 = 1; bl35 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl35 = false;
                    }
                    if (!bl35) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n77 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n76 = (n7 + n77) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n76 + 1;
                            continue;
                        }
                        n77 = n76 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n76 - 1]) != 0 && n7 <= n77);
                    if (this.yytext2.equals(csi_key_words[n76 - 1])) {
                        return new Symbol(csi_key_tokens[n76 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -79: {
                    break;
                }
                case 91: {
                    int n78;
                    int n7;
                    boolean bl36 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl36 = false;
                    }
                    for (n7 = 1; bl36 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl36 = false;
                    }
                    if (!bl36) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n79 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n78 = (n7 + n79) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n78 + 1;
                            continue;
                        }
                        n79 = n78 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n78 - 1]) != 0 && n7 <= n79);
                    if (this.yytext2.equals(csi_key_words[n78 - 1])) {
                        return new Symbol(csi_key_tokens[n78 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -80: {
                    break;
                }
                case 92: {
                    int n80;
                    int n7;
                    boolean bl37 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl37 = false;
                    }
                    for (n7 = 1; bl37 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl37 = false;
                    }
                    if (!bl37) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n81 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n80 = (n7 + n81) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n80 + 1;
                            continue;
                        }
                        n81 = n80 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n80 - 1]) != 0 && n7 <= n81);
                    if (this.yytext2.equals(csi_key_words[n80 - 1])) {
                        return new Symbol(csi_key_tokens[n80 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -81: {
                    break;
                }
                case 93: {
                    int n82;
                    int n7;
                    boolean bl38 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl38 = false;
                    }
                    for (n7 = 1; bl38 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl38 = false;
                    }
                    if (!bl38) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n83 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n82 = (n7 + n83) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n82 + 1;
                            continue;
                        }
                        n83 = n82 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n82 - 1]) != 0 && n7 <= n83);
                    if (this.yytext2.equals(csi_key_words[n82 - 1])) {
                        return new Symbol(csi_key_tokens[n82 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -82: {
                    break;
                }
                case 94: {
                    int n84;
                    int n7;
                    boolean bl39 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl39 = false;
                    }
                    for (n7 = 1; bl39 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl39 = false;
                    }
                    if (!bl39) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n85 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n84 = (n7 + n85) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n84 + 1;
                            continue;
                        }
                        n85 = n84 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n84 - 1]) != 0 && n7 <= n85);
                    if (this.yytext2.equals(csi_key_words[n84 - 1])) {
                        return new Symbol(csi_key_tokens[n84 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -83: {
                    break;
                }
                case 95: {
                    int n86;
                    int n7;
                    boolean bl40 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl40 = false;
                    }
                    for (n7 = 1; bl40 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl40 = false;
                    }
                    if (!bl40) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n87 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n86 = (n7 + n87) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n86 + 1;
                            continue;
                        }
                        n87 = n86 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n86 - 1]) != 0 && n7 <= n87);
                    if (this.yytext2.equals(csi_key_words[n86 - 1])) {
                        return new Symbol(csi_key_tokens[n86 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -84: {
                    break;
                }
                case 96: {
                    int n88;
                    int n7;
                    boolean bl41 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl41 = false;
                    }
                    for (n7 = 1; bl41 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl41 = false;
                    }
                    if (!bl41) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n89 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n88 = (n7 + n89) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n88 + 1;
                            continue;
                        }
                        n89 = n88 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n88 - 1]) != 0 && n7 <= n89);
                    if (this.yytext2.equals(csi_key_words[n88 - 1])) {
                        return new Symbol(csi_key_tokens[n88 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -85: {
                    break;
                }
                case 97: {
                    int n90;
                    int n7;
                    boolean bl42 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl42 = false;
                    }
                    for (n7 = 1; bl42 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl42 = false;
                    }
                    if (!bl42) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n91 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n90 = (n7 + n91) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n90 + 1;
                            continue;
                        }
                        n91 = n90 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n90 - 1]) != 0 && n7 <= n91);
                    if (this.yytext2.equals(csi_key_words[n90 - 1])) {
                        return new Symbol(csi_key_tokens[n90 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -86: {
                    break;
                }
                case 98: {
                    int n92;
                    int n7;
                    boolean bl43 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl43 = false;
                    }
                    for (n7 = 1; bl43 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl43 = false;
                    }
                    if (!bl43) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n93 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n92 = (n7 + n93) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n92 + 1;
                            continue;
                        }
                        n93 = n92 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n92 - 1]) != 0 && n7 <= n93);
                    if (this.yytext2.equals(csi_key_words[n92 - 1])) {
                        return new Symbol(csi_key_tokens[n92 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -87: {
                    break;
                }
                case 99: {
                    int n94;
                    int n7;
                    boolean bl44 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl44 = false;
                    }
                    for (n7 = 1; bl44 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl44 = false;
                    }
                    if (!bl44) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n95 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n94 = (n7 + n95) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n94 + 1;
                            continue;
                        }
                        n95 = n94 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n94 - 1]) != 0 && n7 <= n95);
                    if (this.yytext2.equals(csi_key_words[n94 - 1])) {
                        return new Symbol(csi_key_tokens[n94 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -88: {
                    break;
                }
                case 100: {
                    int n96;
                    int n7;
                    boolean bl45 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl45 = false;
                    }
                    for (n7 = 1; bl45 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl45 = false;
                    }
                    if (!bl45) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n97 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n96 = (n7 + n97) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n96 + 1;
                            continue;
                        }
                        n97 = n96 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n96 - 1]) != 0 && n7 <= n97);
                    if (this.yytext2.equals(csi_key_words[n96 - 1])) {
                        return new Symbol(csi_key_tokens[n96 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -89: {
                    break;
                }
                case 101: {
                    int n98;
                    int n7;
                    boolean bl46 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl46 = false;
                    }
                    for (n7 = 1; bl46 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl46 = false;
                    }
                    if (!bl46) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n99 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n98 = (n7 + n99) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n98 + 1;
                            continue;
                        }
                        n99 = n98 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n98 - 1]) != 0 && n7 <= n99);
                    if (this.yytext2.equals(csi_key_words[n98 - 1])) {
                        return new Symbol(csi_key_tokens[n98 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -90: {
                    break;
                }
                case 102: {
                    int n100;
                    int n7;
                    boolean bl47 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl47 = false;
                    }
                    for (n7 = 1; bl47 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl47 = false;
                    }
                    if (!bl47) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n101 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n100 = (n7 + n101) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n100 + 1;
                            continue;
                        }
                        n101 = n100 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n100 - 1]) != 0 && n7 <= n101);
                    if (this.yytext2.equals(csi_key_words[n100 - 1])) {
                        return new Symbol(csi_key_tokens[n100 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -91: {
                    break;
                }
                case 103: {
                    int n102;
                    int n7;
                    boolean bl48 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl48 = false;
                    }
                    for (n7 = 1; bl48 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl48 = false;
                    }
                    if (!bl48) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n103 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n102 = (n7 + n103) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n102 + 1;
                            continue;
                        }
                        n103 = n102 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n102 - 1]) != 0 && n7 <= n103);
                    if (this.yytext2.equals(csi_key_words[n102 - 1])) {
                        return new Symbol(csi_key_tokens[n102 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -92: {
                    break;
                }
                case 104: {
                    int n104;
                    int n7;
                    boolean bl49 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl49 = false;
                    }
                    for (n7 = 1; bl49 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl49 = false;
                    }
                    if (!bl49) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n105 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n104 = (n7 + n105) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n104 + 1;
                            continue;
                        }
                        n105 = n104 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n104 - 1]) != 0 && n7 <= n105);
                    if (this.yytext2.equals(csi_key_words[n104 - 1])) {
                        return new Symbol(csi_key_tokens[n104 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -93: {
                    break;
                }
                case 105: {
                    int n106;
                    int n7;
                    boolean bl50 = true;
                    String string = this.yytext();
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        bl50 = false;
                    }
                    for (n7 = 1; bl50 && n7 < string.length(); ++n7) {
                        if (Character.isJavaIdentifierPart(string.charAt(n7))) continue;
                        bl50 = false;
                    }
                    if (!bl50) {
                        OqgmCore.sql_yerror("OSQLLexer", "OSQLLexer", "ICIS", null);
                        return new Symbol(9000);
                    }
                    if (this.gv.save_query) {
                        this.gv.qbuf = this.gv.qbuf + this.yytext();
                    }
                    this.gv.osqlTokenpos += this.yylength();
                    this.gv.sql_text = this.yytext();
                    this.gv.sql_leng = this.yylength();
                    if (this.yytext().length() >= 256) {
                        return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                    }
                    this.yytext2 = this.yytext().toLowerCase();
                    n7 = 1;
                    int n107 = csi_key_tokens.length;
                    do {
                        if (csi_key_words[(n106 = (n7 + n107) / 2) - 1].compareTo(this.yytext2) < 0) {
                            n7 = n106 + 1;
                            continue;
                        }
                        n107 = n106 - 1;
                    } while (this.yytext2.compareTo(csi_key_words[n106 - 1]) != 0 && n7 <= n107);
                    if (this.yytext2.equals(csi_key_words[n106 - 1])) {
                        return new Symbol(csi_key_tokens[n106 - 1], this.gv.symTable.install_id(this.yytext()));
                    }
                    return new Symbol(68, this.gv.symTable.install_id(this.yytext()));
                }
                case -94: {
                    break;
                }
                default: {
                    this.yy_error(0, false);
                }
                case -1: 
            }
            bl = true;
            n2 = this.yy_state_dtrans[this.yy_lexical_state];
            n3 = -1;
            n4 = -1;
            this.yy_mark_start();
            n5 = this.yy_acpt[n2];
            if (0 == n5) continue;
            n4 = n2;
            this.yy_mark_end();
        }
    }
}

