/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery;

import com.ibm.ObjectQuery.IObjectQueryServiceConfiguration;
import com.ibm.ObjectQuery.IObjectQueryServiceImpl;
import com.ibm.ObjectQuery.IQueryLogger;
import com.ibm.ObjectQuery.WDOQuery;
import com.ibm.ObjectQuery.engine.GlbThreadLocal;
import com.ibm.ObjectQuery.engine.WDOChgHashMap;
import com.ibm.ObjectQuery.update.GraphChanges;
import com.ibm.websphere.eexquery.EEXConfig;
import com.ibm.websphere.ejbquery.QueryException;
import com.ibm.websphere.sdo.mediator.ejb.Mediator;
import com.ibm.websphere.sdo.mediator.ejb.MediatorAdapter;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EReferenceImpl;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EDataObject;

public class MediatorImpl
implements Mediator {
    protected static IQueryLogger queryLogger = null;
    public EDataGraph dataGraph = null;
    private HashMap rootReferenceMap = new HashMap();
    private EClass schema = null;
    public String plan = null;
    protected IObjectQueryServiceImpl queryService_ = null;
    public Object[] Wdoparms = null;
    public WDOQuery wdoQryObj = null;
    private static String theClassName = "MediatorImpl";
    private String[] wdoqrys = null;
    private int pattern = 0;
    private WDOChgHashMap chghandlers = null;

    private void initialize(Map map) throws QueryException {
        EEXConfig eEXConfig = EEXConfig.getInstance();
        try {
            this.queryService_ = IObjectQueryServiceImpl.getInstance((IObjectQueryServiceConfiguration)eEXConfig);
            queryLogger = IObjectQueryServiceImpl.getConfiguration().getLogger();
            this.wdoQryObj = new WDOQuery();
            this.wdoQryObj.setQryStmts(this.wdoqrys);
            this.wdoQryObj.setQryPmObjs(this.Wdoparms);
            if (map != null) {
                this.wdoQryObj.setNameMap(map);
            }
            this.plan = (String)this.queryService_.prepareWdoQuery(this.wdoQryObj);
            this.chghandlers = this.wdoQryObj.getChgHandlers();
            if (this.schema != null && this.pattern != 2) {
                this.createRootReferenceMap();
            }
        }
        catch (QueryException queryException) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, queryException.getClassname(), queryException.getMethodname(), queryException);
            }
            throw queryException;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "initialize", exception);
            }
            String string = queryLogger.message(4L, theClassName, "initialize", "RTAEWIWDOQ", new Object[]{exception.toString(), this.wdoqrys});
            throw new QueryException(string, exception, new Object[]{theClassName, "initialize"});
        }
    }

    public EClass getSchema() throws QueryException {
        if (this.schema != null) {
            return this.schema;
        }
        return ((EDataObject)this.dataGraph.getRootObject()).eClass();
    }

    public MediatorImpl(String[] stringArray, Object[] objectArray) throws QueryException {
        this.wdoqrys = stringArray;
        this.Wdoparms = objectArray;
        this.initialize(null);
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "MediatorImpl", new Object[]{stringArray, objectArray});
        }
    }

    public MediatorImpl(String[] stringArray, Object[] objectArray, EClass eClass) throws QueryException {
        this.wdoqrys = stringArray;
        this.Wdoparms = objectArray;
        this.schema = eClass;
        this.initialize(null);
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "MediatorImpl", new Object[]{stringArray, objectArray});
        }
    }

    public MediatorImpl(String[] stringArray, Object[] objectArray, EClass eClass, Map map, int n) throws QueryException {
        this.wdoqrys = stringArray;
        this.Wdoparms = objectArray;
        this.schema = eClass;
        this.pattern = n;
        this.initialize(map);
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "MediatorImpl", new Object[]{stringArray, objectArray});
        }
    }

    public DataObject getGraph() throws QueryException {
        try {
            this.dataGraph = this.schema == null ? this.queryService_.executeWdoQueryPlan(this.plan, this.Wdoparms, 0, -1, null, this.chghandlers, this.pattern, this.rootReferenceMap) : this.queryService_.executeWdoQueryPlan(this.plan, this.Wdoparms, 0, -1, this.schema, this.chghandlers, this.pattern, this.rootReferenceMap);
            this.freeHlpObj();
            return this.dataGraph.getRootObject();
        }
        catch (QueryException queryException) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, queryException.getClassname(), queryException.getMethodname(), queryException);
            }
            this.freeHlpObj();
            throw queryException;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "getGraph", exception);
            }
            String string = queryLogger.message(4L, theClassName, "getGraph", "RTFEOWEWDOQ", new Object[]{exception.toString(), this.wdoqrys, this.Wdoparms});
            this.freeHlpObj();
            throw new QueryException(string, exception, new Object[]{theClassName, "getGraph"});
        }
    }

    public DataObject getGraph(Object[] objectArray) throws QueryException {
        try {
            this.dataGraph = this.schema == null ? this.queryService_.executeWdoQueryPlan(this.plan, objectArray, 0, -1, null, this.chghandlers, this.pattern, this.rootReferenceMap) : this.queryService_.executeWdoQueryPlan(this.plan, objectArray, 0, -1, this.schema, this.chghandlers, this.pattern, this.rootReferenceMap);
            this.freeHlpObj();
            return this.dataGraph.getRootObject();
        }
        catch (QueryException queryException) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, queryException.getClassname(), queryException.getMethodname(), queryException);
            }
            this.freeHlpObj();
            throw queryException;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "getGraph(parms)", exception);
            }
            String string = queryLogger.message(4L, theClassName, "getGraph(parms)", "RTFEOWEWDOQ", new Object[]{exception.toString(), this.wdoqrys, objectArray});
            this.freeHlpObj();
            throw new QueryException(string, exception, new Object[]{theClassName, "getGraph(parms)"});
        }
    }

    public void applyChanges(DataObject dataObject) throws QueryException {
        ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
        GraphChanges graphChanges = new GraphChanges(changeSummary, this.chghandlers, this.pattern, dataObject.getDataGraph().getRootObject());
        try {
            graphChanges.applyChanges();
            this.freeHlpObj();
        }
        catch (QueryException queryException) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, queryException.getClassname(), queryException.getMethodname(), queryException);
            }
            queryLogger.stackTrace((Exception)((Object)queryException), 4L, queryException.getClassname(), queryException.getMethodname());
            this.freeHlpObj();
            throw queryException;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "applyChanges", exception);
            }
            queryLogger.stackTrace(exception, 4L, theClassName, "applyChanges");
            String string = queryLogger.message(4L, theClassName, "applyChanges", "RTAEOWPCFCD", new Object[]{exception.toString()});
            this.freeHlpObj();
            throw new QueryException(string, exception, new Object[]{theClassName, "applyChanges"});
        }
    }

    public void applyChanges(DataObject dataObject, MediatorAdapter mediatorAdapter) throws QueryException {
        ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
        GraphChanges graphChanges = new GraphChanges(changeSummary, this.chghandlers, this.pattern, dataObject.getDataGraph().getRootObject());
        try {
            graphChanges.applyChangesToEJB(mediatorAdapter);
            this.freeHlpObj();
        }
        catch (QueryException queryException) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, queryException.getClassname(), queryException.getMethodname(), queryException);
            }
            queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
            this.freeHlpObj();
            throw queryException;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "applyChanges", exception);
            }
            String string = queryLogger.message(4L, theClassName, "applyChanges", "RTAEOWPCFCD", new Object[]{exception.toString()});
            this.freeHlpObj();
            throw new QueryException(string, exception, new Object[]{theClassName, "applyChanges"});
        }
    }

    private void freeHlpObj() throws QueryException {
        Object object = GlbThreadLocal.get();
        GlbThreadLocal.set(null);
        if (object != null) {
            IObjectQueryServiceImpl.getConfiguration().returnQueryHelper(object);
        }
    }

    private void createRootReferenceMap() {
        EReferenceImpl eReferenceImpl = null;
        EList eList = ((EClassImpl)this.schema).getEAllStructuralFeatures();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            eReferenceImpl = (EReferenceImpl)iterator.next();
            this.rootReferenceMap.put(eReferenceImpl.getEReferenceType().getName(), eReferenceImpl.getName());
        }
    }
}

