/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery;

import com.ibm.ObjectQuery.EjbQuery;
import com.ibm.ObjectQuery.IObjectQueryServiceConfiguration;
import com.ibm.ObjectQuery.IPreparedQuery;
import com.ibm.ObjectQuery.IQueryLogger;
import com.ibm.ObjectQuery.QueryTuple;
import com.ibm.ObjectQuery.WDOQuery;
import com.ibm.ObjectQuery.engine.GlbThreadLocal;
import com.ibm.ObjectQuery.engine.OSQLTypeMapper;
import com.ibm.ObjectQuery.engine.QueryProcessor;
import com.ibm.ObjectQuery.engine.QurContext;
import com.ibm.ObjectQuery.engine.WDOChgHashMap;
import com.ibm.ObjectQuery.engine.WDOInputTn;
import com.ibm.ObjectQuery.eval.DataEnumerator;
import com.ibm.ObjectQuery.eval.Plan;
import com.ibm.ObjectQuery.eval.PlanCursor;
import com.ibm.ObjectQuery.eval.PlanProcessor;
import com.ibm.ObjectQuery.eval.Row;
import com.ibm.websphere.ejbquery.QueryException;
import com.ibm.websphere.ejbquery.QueryIterator;
import com.ibm.websphere.ejbquery.QueryLocalIterator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.xml.sax.InputSource;

public class IObjectQueryServiceImpl {
    private static IObjectQueryServiceConfiguration currentConfig_ = null;
    private static IObjectQueryServiceImpl instance = null;
    private static String theClassName = IObjectQueryServiceImpl.class.getName();

    private IObjectQueryServiceImpl() throws RemoteException {
    }

    public QueryLocalIterator executeQueryPlan(String string, Object[] objectArray) throws QueryException {
        PlanCursor planCursor = null;
        Plan plan = null;
        try {
            QurContext qurContext = QurContext.getQurContext();
            if (qurContext == null) {
                QueryProcessor queryProcessor = new QueryProcessor();
                queryProcessor.initContext(null, null);
            }
            plan = PlanProcessor.buildPlan(string, false, objectArray);
            planCursor = PlanProcessor.evaluatePlan(plan);
        }
        catch (QueryException queryException) {
            if (plan != null) {
                plan.closeconnection();
            }
            throw queryException;
        }
        catch (Exception exception) {
            if (plan != null) {
                plan.closeconnection();
            }
            throw new QueryException(exception.toString());
        }
        return new QueryLocalIterator((DataEnumerator)planCursor, planCursor.getHeadings());
    }

    public QueryIterator executeQueryPlan(String string, Object[] objectArray, int n, int n2) throws QueryException {
        QueryTuple[] queryTupleArray;
        ArrayList<Object> arrayList = null;
        boolean bl = true;
        PlanCursor planCursor = null;
        Plan plan = null;
        ArrayList arrayList2 = null;
        arrayList = n2 > 0 && n2 < Short.MAX_VALUE ? new ArrayList(n2) : new ArrayList<QueryTuple>(Short.MAX_VALUE);
        try {
            int n3;
            queryTupleArray = QurContext.getQurContext();
            if (queryTupleArray == null) {
                QueryProcessor queryProcessor = new QueryProcessor();
                queryProcessor.initContext(null, null);
            }
            plan = PlanProcessor.buildPlan(string, true, objectArray);
            planCursor = PlanProcessor.evaluatePlan(plan);
            for (n3 = 1; n3 <= n && planCursor.hasNext(); ++n3) {
                planCursor.next();
            }
            for (n3 = 1; n3 <= n2 && planCursor.hasNext(); ++n3) {
                arrayList.add(new QueryTuple((Row)planCursor.next()));
            }
            bl = !planCursor.hasNext();
        }
        catch (QueryException queryException) {
            if (plan != null) {
                plan.closeconnection();
            }
            throw queryException;
        }
        catch (Exception exception) {
            if (plan != null) {
                plan.closeconnection();
            }
            throw new QueryException(exception.toString());
        }
        queryTupleArray = new QueryTuple[arrayList.size()];
        arrayList.toArray(queryTupleArray);
        if (planCursor != null) {
            arrayList2 = planCursor.getHeadings();
            if (!bl) {
                planCursor.close();
            }
            planCursor = null;
        }
        return new QueryIterator(queryTupleArray, bl, arrayList2);
    }

    public static IObjectQueryServiceConfiguration getConfiguration() {
        return currentConfig_;
    }

    public static synchronized IObjectQueryServiceImpl getInstance(IObjectQueryServiceConfiguration iObjectQueryServiceConfiguration) throws QueryException, RemoteException {
        if (instance == null) {
            instance = new IObjectQueryServiceImpl();
            IObjectQueryServiceImpl.setConfiguration(iObjectQueryServiceConfiguration);
        }
        return instance;
    }

    public String inputqrys2ejbqry(String[] stringArray) throws QueryException {
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        WDOInputTn wDOInputTn = null;
        WDOInputTn wDOInputTn2 = null;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            if (string == null) continue;
            if (wDOInputTn == null) {
                wDOInputTn = new WDOInputTn(string);
                continue;
            }
            wDOInputTn2 = new WDOInputTn(string, wDOInputTn);
        }
        wDOInputTn.printnode(stringBuffer);
        return stringBuffer.toString();
    }

    public void invalidateMetadata(String string) throws QueryException {
    }

    public boolean isValidQuery(String string, String[] stringArray) throws QueryException {
        QueryProcessor queryProcessor = new QueryProcessor();
        boolean bl = false;
        bl = queryProcessor.validateQuery(string, null, stringArray);
        return bl;
    }

    private static void loadMetadata(InputSource inputSource) {
    }

    protected String[] objs2types(Object[] objectArray) throws QueryException {
        String[] stringArray = null;
        if (objectArray != null) {
            int n = objectArray.length;
            String[] stringArray2 = new String[n];
            stringArray = new String[n];
            String string = null;
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = objectArray[i].getClass().getName();
                if (objectArray[i] instanceof Collection) {
                    stringArray[i] = stringArray2[i];
                    continue;
                }
                string = OSQLTypeMapper.getOSQLType(stringArray2[i]);
                if (string != null) {
                    stringArray[i] = string;
                    continue;
                }
                if (IObjectQueryServiceImpl.getConfiguration() != null) {
                    IQueryLogger iQueryLogger = IObjectQueryServiceImpl.getConfiguration().getLogger();
                    if (iQueryLogger == null) continue;
                    String string2 = iQueryLogger.message(4L, theClassName, "objs2types", "NS", new Object[]{stringArray2[i]});
                    throw new QueryException(string2);
                }
                System.out.println("Parameter: " + stringArray2[i] + " is not supported.");
                throw new QueryException("Parameter: " + stringArray2[i] + " is not supported.");
            }
        }
        return stringArray;
    }

    public IPreparedQuery prepareQuery(EjbQuery ejbQuery) throws QueryException {
        QueryProcessor queryProcessor = new QueryProcessor();
        IPreparedQuery iPreparedQuery = new IPreparedQuery();
        queryProcessor.processQuery(ejbQuery);
        iPreparedQuery.completePushdown = queryProcessor.isCompletePushdown();
        iPreparedQuery.queryPlan = queryProcessor.getPlan();
        iPreparedQuery.sqlStatements = queryProcessor.getSQLStatements();
        iPreparedQuery.parmOrderList = queryProcessor.getParmMarkerList();
        iPreparedQuery.sortedResult = queryProcessor.isSortedResult();
        iPreparedQuery.extWarningMsgs = queryProcessor.getExtWarningMsgs();
        iPreparedQuery.selectedCMP = queryProcessor.getSelectedCMP();
        iPreparedQuery.ASN4selected = queryProcessor.getASN4selected();
        iPreparedQuery.converterUsed = queryProcessor.getConverterUsed();
        iPreparedQuery.forUpdateFlag = queryProcessor.getForUpdateFlag();
        iPreparedQuery.beanNamesInQry = queryProcessor.getBeanNamesInQry();
        iPreparedQuery.converters4InputParm = queryProcessor.getConverters4InputParm();
        iPreparedQuery.aggFunc = queryProcessor.getAggFunc();
        return iPreparedQuery;
    }

    public IPreparedQuery prepareQuery(String string, Boolean bl, String[] stringArray) throws QueryException {
        QueryProcessor queryProcessor = new QueryProcessor();
        IPreparedQuery iPreparedQuery = new IPreparedQuery();
        queryProcessor.processQuery(string, null, null, bl, stringArray);
        iPreparedQuery.completePushdown = queryProcessor.isCompletePushdown();
        iPreparedQuery.queryPlan = queryProcessor.getPlan();
        iPreparedQuery.sqlStatements = queryProcessor.getSQLStatements();
        iPreparedQuery.parmOrderList = queryProcessor.getParmMarkerList();
        iPreparedQuery.sortedResult = queryProcessor.isSortedResult();
        iPreparedQuery.extWarningMsgs = queryProcessor.getExtWarningMsgs();
        iPreparedQuery.selectedCMP = queryProcessor.getSelectedCMP();
        iPreparedQuery.ASN4selected = queryProcessor.getASN4selected();
        iPreparedQuery.converterUsed = queryProcessor.getConverterUsed();
        iPreparedQuery.aggFunc = queryProcessor.getAggFunc();
        return iPreparedQuery;
    }

    public static synchronized void releaseInstance() {
        instance = null;
    }

    private static void setConfiguration(IObjectQueryServiceConfiguration iObjectQueryServiceConfiguration) throws QueryException {
        if (currentConfig_ != null) {
            // empty if block
        }
        if ((currentConfig_ = iObjectQueryServiceConfiguration).getAppMetadataStream() != null && currentConfig_.getAppMetadataStream() instanceof InputSource) {
            IObjectQueryServiceImpl.loadMetadata((InputSource)currentConfig_.getAppMetadataStream());
        }
    }

    public EDataGraph executeWdoQueryPlan(String string, Object[] objectArray, int n, int n2, EClass eClass, WDOChgHashMap wDOChgHashMap, int n3, HashMap hashMap) throws QueryException {
        ArrayList arrayList = null;
        Plan plan = null;
        arrayList = n2 > 0 && n2 < Short.MAX_VALUE ? new ArrayList(n2) : new ArrayList(Short.MAX_VALUE);
        try {
            QurContext qurContext = QurContext.getQurContext();
            if (qurContext == null) {
                QueryProcessor queryProcessor = new QueryProcessor();
                queryProcessor.initContext(null, null);
            }
            plan = PlanProcessor.buildPlan(string, false, objectArray);
            if (eClass != null) {
                plan.setStaticSchema(eClass);
            }
            plan.setChgHandlers(wDOChgHashMap);
            plan.setPattern(n3);
            if (hashMap != null) {
                plan.setRootReferenceMap(hashMap);
            }
            PlanProcessor.evaluatePlan(plan);
            plan.cleanUp();
            return plan.getGraph();
        }
        catch (QueryException queryException) {
            if (plan != null) {
                plan.closeconnection();
                plan.cleanUp();
            }
            this.freeHlpObj();
            throw queryException;
        }
        catch (Exception exception) {
            if (plan != null) {
                plan.closeconnection();
                plan.cleanUp();
            }
            this.freeHlpObj();
            throw new QueryException(exception.toString());
        }
    }

    public Object prepareWdoQuery(WDOQuery wDOQuery) throws QueryException {
        if (wDOQuery == null) {
            this.freeHlpObj();
            throw new QueryException("Input to executeQuery is null.");
        }
        try {
            String string = this.inputqrys2ejbqry(wDOQuery.getQryStmts());
            wDOQuery.setParmTypes(this.objs2types(wDOQuery.getQryPmObjs()));
            wDOQuery.setEjbQryStmt(string);
            wDOQuery.setReturnwdo(true);
            IPreparedQuery iPreparedQuery = this.prepareQuery(wDOQuery);
            return iPreparedQuery.getQueryPlan();
        }
        catch (QueryException queryException) {
            this.freeHlpObj();
            throw queryException;
        }
        catch (Exception exception) {
            this.freeHlpObj();
            throw new QueryException(exception.toString());
        }
    }

    private void freeHlpObj() throws QueryException {
        Object object = GlbThreadLocal.get();
        GlbThreadLocal.set(null);
        if (object != null) {
            IObjectQueryServiceImpl.getConfiguration().returnQueryHelper(object);
        }
    }
}

