/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionKey;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.Transport;
import com.ibm.rmi.iiop.ORB;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class ConnectionTableImpl
implements ConnectionTable {
    protected ORB orb;
    protected Hashtable connectionCache = new Hashtable();
    protected Transport transport;
    protected int lowWaterMark;
    protected int highWaterMark;
    private static final int NCLEAN = 5;

    public ConnectionTableImpl(ORB oRB, Transport transport) {
        this.orb = oRB;
        this.transport = transport;
        this.highWaterMark = oRB.getHighWaterMark();
        this.lowWaterMark = oRB.getLowWaterMark();
    }

    public void shutdown() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "shutdown:119");
        }
        while (!this.connectionCache.isEmpty()) {
            Enumeration enumeration = this.connectionCache.keys();
            while (enumeration.hasMoreElements()) {
                ConnectionKey connectionKey = null;
                try {
                    connectionKey = (ConnectionKey)enumeration.nextElement();
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!ORBRas.isTrcLogging) break;
                    ORBRas.orbTrcLogger.trace(4112L, this, "shutdown:150", noSuchElementException.toString());
                    break;
                }
                if (connectionKey == null) break;
                ORBConnection oRBConnection = (ORBConnection)this.connectionCache.get(connectionKey);
                if (oRBConnection == null || oRBConnection.isBusy()) continue;
                try {
                    this.connectionCache.remove(connectionKey);
                    oRBConnection.cleanUp();
                }
                catch (Exception exception) {
                    if (!ORBRas.isTrcLogging) continue;
                    ORBRas.orbTrcLogger.trace(4112L, this, "shutdown:155", exception.toString());
                }
            }
            if (this.connectionCache.isEmpty()) continue;
            Thread.yield();
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "shutdown:167");
        }
    }

    public boolean cleanUp() {
        int n = this.orb.getState();
        if (n != 1 && n != 2) {
            this.shutdown();
            return true;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "cleanUp:190", (Object)("lowWaterMark=" + this.lowWaterMark + " highWaterMark=" + this.highWaterMark + " size=" + this.connectionCache.size()));
        }
        if (this.connectionCache.size() < this.lowWaterMark) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            Enumeration enumeration = this.connectionCache.keys();
            ConnectionKey connectionKey = null;
            ORBConnection oRBConnection = null;
            while (enumeration.hasMoreElements()) {
                ConnectionKey connectionKey2 = (ConnectionKey)enumeration.nextElement();
                ORBConnection oRBConnection2 = (ORBConnection)this.connectionCache.get(connectionKey2);
                if (oRBConnection2.isBusy() || !oRBConnection2.isMoreStaleThan(oRBConnection)) continue;
                oRBConnection = oRBConnection2;
                connectionKey = connectionKey2;
            }
            if (oRBConnection == null) {
                return false;
            }
            this.connectionCache.remove(connectionKey);
            try {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "cleanUp:235", "just before calling cleanUp on connection " + oRBConnection);
                }
                oRBConnection.cleanUp();
                continue;
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "cleanUp:249", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "cleanUp:258");
        }
        return true;
    }

    public void checkConnectionTable() {
        if (this.connectionCache.size() > this.highWaterMark) {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string = this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
        ConnectionTableImpl connectionTableImpl = this;
        synchronized (connectionTableImpl) {
            string = string + " size=" + this.connectionCache.size();
            Enumeration enumeration = this.connectionCache.elements();
            while (enumeration.hasMoreElements()) {
                string = string + "\n";
                string = string + enumeration.nextElement().toString();
            }
        }
        return string;
    }

    public void addConnection(ConnectionKey connectionKey, ORBConnection oRBConnection) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "addConnection:306", (Object)connectionKey, (Object)oRBConnection);
        }
        this.connectionCache.put(connectionKey, oRBConnection);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "addConnection:314", (Object)("cache size is " + this.connectionCache.size()));
        }
    }

    public void removeConnection(ConnectionKey connectionKey) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "removeConnection:325", (Object)connectionKey);
        }
        this.connectionCache.remove(connectionKey);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "removeConnection:333", (Object)("cache size is " + this.connectionCache.size()));
        }
    }

    public ORBConnection getConnection(ConnectionKey connectionKey) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "getConnection:343", (Object)connectionKey);
        }
        ORBConnection oRBConnection = (ORBConnection)this.connectionCache.get(connectionKey);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "getConnection:351", (Object)oRBConnection);
        }
        return oRBConnection;
    }
}

