/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.CancelRequestMessage;
import com.ibm.rmi.iiop.GIOPVersionException;
import com.ibm.rmi.iiop.LocateReplyMessage;
import com.ibm.rmi.iiop.LocateRequestMessage;
import com.ibm.rmi.iiop.ReplyMessage;
import com.ibm.rmi.iiop.RequestMessage;
import com.ibm.rmi.util.Utility;
import com.ibm.rmi.util.buffer.ByteBuffer;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;

public class Message
implements com.ibm.CORBA.iiop.Message {
    protected static final boolean debug = false;
    static final int defaultBufferSize = 1024;
    static final int GIOPBigEndian = 0;
    static final int GIOPLittleEndian = 1;
    static final int FragHdrLength = 4;
    static final int GIOPBigMagic = 1195986768;
    static final int GIOPLittleMagic = 1347373383;
    public static final int KeyAddr = 0;
    public static final int ProfileAddr = 1;
    public static final int ReferenceAddr = 2;
    public static final byte HighestGIOPMajor = 1;
    public static final byte HighestGIOPMinor = 2;
    private static final byte BYTE_ORDER_MASK = 1;
    private static final byte FRAG_MASK = 2;
    private static final byte INV_FRAG_MASK = -3;
    private int magic;
    private byte byteOrder = 0;
    private byte flags = 0;
    private boolean fragToFollow = false;
    private byte type;
    private int size = 0;
    private final byte GIOPMajor;
    private final byte GIOPMinor;
    private final boolean isPreGIOP12;
    private ByteBuffer.Position flagsPosition = null;
    private ByteBuffer.Position typePosition = null;
    private ByteBuffer.Position sizePosition = null;
    private CDROutputStream cdrOutputStream = null;
    private boolean hdrWritten = false;
    protected int requestId;

    public Message(byte by, byte by2) {
        this.GIOPMajor = by;
        this.GIOPMinor = by2;
        this.isPreGIOP12 = by == 1 && by2 <= 1;
    }

    public boolean preGIOP12() {
        return this.isPreGIOP12;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setRequestId(int n) {
        this.requestId = n;
    }

    public final int getType() {
        return this.type;
    }

    void setType(int n) {
        this.type = (byte)n;
        if (this.typePosition != null) {
            this.cdrOutputStream.write_octet(this.type, this.typePosition);
        }
    }

    protected void setHeaderWritten(boolean bl) {
        this.hdrWritten = bl;
    }

    protected boolean headerWritten() {
        return this.hdrWritten;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isFragmentToFollow() {
        return this.fragToFollow;
    }

    public boolean isLittleEndian() {
        return this.byteOrder == 1;
    }

    byte getByteOrder() {
        return this.byteOrder;
    }

    public byte getGIOPMajor() {
        return this.GIOPMajor;
    }

    public byte getGIOPMinor() {
        return this.GIOPMinor;
    }

    void setSize(int n) {
        this.size = n - 12;
        if (this.sizePosition != null) {
            this.cdrOutputStream.write_long(this.size, this.sizePosition);
        }
    }

    void setFragmentToFollow(boolean bl) {
        this.fragToFollow = bl;
        this.flags = bl ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
        if (this.flagsPosition != null) {
            this.cdrOutputStream.write_octet(this.flags, this.flagsPosition);
        }
    }

    private void initializeData(int n, byte by, byte by2, int n2, int n3) {
        this.magic = n;
        this.flags = by;
        this.byteOrder = (byte)(by & 1);
        this.fragToFollow = (by & 2) == 2;
        this.type = by2;
        this.size = n2;
        this.requestId = n3;
    }

    static Message createMessage(byte by, byte by2, byte by3) {
        Message message = null;
        switch (by3) {
            case 0: {
                message = new RequestMessage(by, by2);
                break;
            }
            case 3: {
                message = new LocateRequestMessage(by, by2);
                break;
            }
            case 2: {
                message = new CancelRequestMessage(by, by2);
                break;
            }
            case 1: {
                message = new ReplyMessage(by, by2);
                break;
            }
            case 4: {
                message = new LocateReplyMessage(by, by2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                message = new Message(by, by2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad message type: " + by3);
            }
        }
        return message;
    }

    Message createAssociatedMessage(byte by) {
        Message message = null;
        if (this.type == 7 && by == 7) {
            this.resetPositions();
            message = this;
        } else {
            message = Message.createMessage(this.GIOPMajor, this.GIOPMinor, by);
            message.initializeData(this.magic, this.flags, by, 0, this.requestId);
        }
        message.setFragmentToFollow(false);
        return message;
    }

    public static Message createMessage(byte[] byArray, int n) throws SystemException, IOException, GIOPVersionException {
        int n2;
        int n3;
        int n4;
        int n5;
        Message message = null;
        if (byArray.length < 12) {
            throw new GIOPVersionException("0x" + Utility.bytesToHexString(byArray));
        }
        byte by = byArray[n + 7];
        int n6 = byArray[n + 0] << 24 & 0xFF000000 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] << 0 & 0xFF;
        if (n6 != 1195986768 && n6 != 1347373383) {
            throw new GIOPVersionException("0x" + Integer.toHexString(n6));
        }
        byte by2 = byArray[n + 4];
        byte by3 = byArray[n + 5];
        if (by2 != 1 || by2 == 1 && by3 > 2) {
            throw new GIOPVersionException(by2 + "." + by3);
        }
        try {
            message = Message.createMessage(by2, by3, by);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new INTERNAL("Bad GIOP request:" + by, 1229125003, CompletionStatus.COMPLETED_NO);
        }
        byte by4 = byArray[n + 6];
        if ((by4 & 1) == 0) {
            n5 = byArray[n + 8] << 24 & 0xFF000000;
            n4 = byArray[n + 9] << 16 & 0xFF0000;
            n3 = byArray[n + 10] << 8 & 0xFF00;
            n2 = byArray[n + 11] << 0 & 0xFF;
        } else {
            n5 = byArray[n + 11] << 24 & 0xFF000000;
            n4 = byArray[n + 10] << 16 & 0xFF0000;
            n3 = byArray[n + 9] << 8 & 0xFF00;
            n2 = byArray[n + 8] << 0 & 0xFF;
        }
        int n7 = (n5 | n4 | n3 | n2) + 12;
        message.initializeData(n6, by4, by, n7, 0);
        return message;
    }

    public static void readFully(java.io.InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = 0;
            int n4 = 0;
            while (true) {
                try {
                    n3 = inputStream.read(byArray, n + i, n2 - i);
                }
                catch (IOException iOException) {
                    if (n4++ < 5) continue;
                    throw iOException;
                }
                break;
            }
            if (n3 >= 0) continue;
            throw new IOException();
        }
    }

    public void write(CDROutputStream cDROutputStream) throws SystemException {
        if (this.cdrOutputStream != cDROutputStream) {
            if (this.cdrOutputStream != null) {
                throw new IllegalStateException("CDROutputStream already set for message");
            }
            this.cdrOutputStream = cDROutputStream;
        }
        cDROutputStream.write_long(1195986768);
        cDROutputStream.write_octet(this.GIOPMajor);
        cDROutputStream.write_octet(this.GIOPMinor);
        this.flagsPosition = cDROutputStream.write_octet(this.flags, true);
        this.typePosition = cDROutputStream.write_octet(this.type, true);
        this.sizePosition = cDROutputStream.write_long(this.size, false, true);
    }

    public void read(InputStream inputStream) throws SystemException {
    }

    public String getTypeName() {
        String string;
        switch (this.type) {
            case 3: {
                string = "GIOPLocateRequest";
                break;
            }
            case 0: {
                string = "GIOPRequest";
                break;
            }
            case 1: {
                string = "GIOPReply";
                break;
            }
            case 4: {
                string = "GIOPLocateReply";
                break;
            }
            case 2: {
                string = "GIOPCancelRequest";
                break;
            }
            case 5: {
                string = "GIOPCloseConnection";
                break;
            }
            case 6: {
                string = "GIOPMessageError";
                break;
            }
            case 7: {
                string = "GIOPFragment";
                break;
            }
            default: {
                string = "UNKNOWN MESSAGE TYPE";
            }
        }
        return string;
    }

    void resetPositions() {
        this.sizePosition = null;
        this.typePosition = null;
        this.flagsPosition = null;
        this.cdrOutputStream = null;
    }
}

