/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.ras.Trace;
import com.ibm.rmi.ras.Utility;
import java.io.IOException;
import java.util.LinkedList;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.InputStream;

public class IIOPInputStream
extends CDRInputStream
implements com.ibm.CORBA.iiop.IIOPInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    protected Connection conn;
    protected Message msg;
    boolean firstFragment = true;
    boolean dumpBuffer = true;
    boolean dumpMsgHeader = true;
    private int markOffset;
    private int markStart;
    private int markIndex;
    private int markSize;
    private Message markMsg;
    private boolean markFirstFragment;
    private byte[] markBuf;
    private CDRInputStream is;
    private int fragmentCount;
    private int markFragmentCount;
    private long markBlockLength;
    private LinkedList peekedStream;
    private boolean markSet;
    private boolean resetCalled;
    private int peeksWhenMarked;

    public IIOPInputStream() {
    }

    public IIOPInputStream(ORB oRB, Connection connection) {
        super((org.omg.CORBA.ORB)oRB, null, 0);
        this.conn = connection;
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n, boolean bl, Message message) {
        super((org.omg.CORBA.ORB)oRB, byArray, n, bl);
        this.msg = message;
        this.setGIOPVersion(message.getGIOPMajor(), message.getGIOPMinor(), true);
        this.logCommTrace(byArray, n, 0);
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n, boolean bl) {
        super((org.omg.CORBA.ORB)oRB, byArray, n, bl);
        this.logCommTrace(byArray, n, 0);
    }

    public IIOPInputStream(Connection connection, byte[] byArray, Message message, int n) throws IOException {
        this(connection.getORB(), connection);
        this.buf = byArray;
        this.markBuf = byArray;
        this.msg = message;
        this.setGIOPVersion(this.msg.getGIOPMajor(), this.msg.getGIOPMinor(), true);
        this.littleEndian = this.msg.isLittleEndian();
        int n2 = this.msg.getType();
        this.size = this.msg.getSize() + n;
        this.start = n;
        this.index = n + 12;
        if (!(this.msg.preGIOP12() || n2 != 0 && n2 != 3 && n2 != 1 && n2 != 4 && n2 != 7)) {
            this.msg.setRequestId(this.read_long());
            if (!this.msg.isFragmentToFollow() && n2 != 7) {
                this.msg.read((InputStream)this);
            } else if (n2 != 7) {
                this.dumpMsgHeader = false;
            }
        } else {
            this.msg.read((InputStream)this);
        }
        connection.updateTimeStamp();
        this.logCommTrace(byArray, this.size, n);
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final void setConnection(Connection connection) {
        this.conn = connection;
        this.orb = connection.getORB();
    }

    public final com.ibm.CORBA.iiop.Message getMessage() {
        return this.msg;
    }

    protected boolean isFirstFragment() {
        return this.firstFragment;
    }

    public void getNextBuffer() {
        this.offset += this.index - this.start;
        this.offset -= 16;
        if (this.resetCalled && this.peekedStream.size() > 0) {
            this.is = (CDRInputStream)this.peekedStream.removeFirst();
            if (this.peekedStream.size() == 0) {
                this.resetCalled = false;
            }
        } else if (this.markSet && ++this.peeksWhenMarked < this.peekedStream.size()) {
            this.is = (CDRInputStream)this.peekedStream.get(this.peeksWhenMarked);
        } else if (null != this.conn) {
            this.is = this.conn.getNextFragment(this.msg.getRequestId(), this.msg.getType());
            if (this.markSet) {
                this.peekedStream.add(this.is);
            }
        } else {
            INTERNAL iNTERNAL = new INTERNAL("ClientResponse without connection details", 1229125052, CompletionStatus.COMPLETED_NO);
            ORBRas.orbTrcLogger.exception(4104L, this, "getNextBuffer:209", (Exception)((Object)iNTERNAL));
            throw iNTERNAL;
        }
        ++this.fragmentCount;
        this.firstFragment = false;
        this.msg = ((IIOPInputStream)this.is).msg;
        this.buf = this.is.buf;
        this.start = this.is.start;
        this.index = this.is.start + 12 + 4;
        this.size = this.is.size;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "getNextBuffer:231", "reqId " + this.msg.getRequestId() + " new fragment offset_hex " + Integer.toHexString(this.get_offset()));
        }
    }

    public int mark() {
        this.markOffset = this.offset;
        this.markStart = this.start;
        this.markIndex = this.index;
        this.markSize = this.size;
        this.markMsg = this.msg;
        this.markFirstFragment = this.firstFragment;
        this.markBuf = this.buf;
        this.markFragmentCount = this.fragmentCount;
        this.markBlockLength = this.blockLength;
        if (this.peekedStream == null) {
            this.peekedStream = new LinkedList();
            this.peekedStream.add(this.is);
        } else if (this.markSet) {
            int n = -1;
            int n2 = this.peekedStream.size() - 1;
            while (n2 >= 0) {
                if (this.is != (CDRInputStream)this.peekedStream.get(n2)) continue;
                n = n2;
                break;
            }
            for (int i = 0; i < n; ++i) {
                this.peekedStream.removeFirst();
                --this.peeksWhenMarked;
            }
        } else {
            this.peekedStream.addFirst(this.is);
        }
        this.resetCalled = false;
        this.markSet = true;
        return this.index;
    }

    public void reset(int n) {
        if (n != this.markIndex || !this.markSet) {
            throw new MARSHAL("Stream reset error", 1229125823, CompletionStatus.COMPLETED_NO);
        }
        this.buf = this.markBuf;
        this.offset = this.markOffset;
        this.start = this.markStart;
        this.index = this.markIndex;
        this.size = this.markSize;
        this.msg = this.markMsg;
        this.firstFragment = this.markFirstFragment;
        this.fragmentCount = this.markFragmentCount;
        this.is = (CDRInputStream)this.peekedStream.removeFirst();
        this.blockLength = this.markBlockLength;
        this.markSet = false;
        this.peeksWhenMarked = 0;
        this.resetCalled = true;
    }

    public void reset() {
        this.reset(this.markIndex);
    }

    protected void grow(int n, int n2) {
        throw new MARSHAL("Read beyond end of input stream", 1229125844, CompletionStatus.COMPLETED_MAYBE);
    }

    protected void logCommTrace() {
        this.dumpBuffer = false;
        this.dumpMsgHeader = true;
        this.logCommTrace(this.buf, this.size, this.start);
    }

    private void logCommTrace(byte[] byArray, int n, int n2) {
        if (((ORB)this.orb).CommTraceIsEnabled()) {
            Trace.dump(Utility.getMessage("Trace.inComing"), this.dumpMsgHeader, this.dumpBuffer, byArray, n, n2, (com.ibm.CORBA.iiop.ORB)this.orb, this.conn.getTransportConnection());
        }
    }
}

