/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.cbe;

import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class CBEHelper {
    private static final Vector RESERVEDEXTENSIONNAMES;
    private static final int MAX_CHARS_PER_EDE_VALUE = 500;
    private static final String svLineSeparatorTab;

    public static final byte[] getExtendedDataElementByteArray(CommonBaseEvent commonBaseEvent, String string) {
        ExtendedDataElement extendedDataElement;
        EList eList = commonBaseEvent.getExtendedDataElements(string);
        if (eList != null && !eList.isEmpty() && (extendedDataElement = (ExtendedDataElement)eList.get(0)) != null) {
            return extendedDataElement.getValuesAsByteArray();
        }
        return null;
    }

    public static final int getExtendedDataElementInt(CommonBaseEvent commonBaseEvent, String string, int n) {
        ExtendedDataElement extendedDataElement;
        EList eList = commonBaseEvent.getExtendedDataElements(string);
        if (eList != null && !eList.isEmpty() && (extendedDataElement = (ExtendedDataElement)eList.get(0)) != null) {
            return extendedDataElement.getValuesAsInt();
        }
        return n;
    }

    public static final String getExtendedDataElementString(CommonBaseEvent commonBaseEvent, String string) {
        ExtendedDataElement extendedDataElement;
        EList eList = commonBaseEvent.getExtendedDataElements(string);
        if (eList != null && !eList.isEmpty() && (extendedDataElement = (ExtendedDataElement)eList.get(0)) != null) {
            return extendedDataElement.getValuesAsString();
        }
        return null;
    }

    public static final String getExtendedDataElementLargeString(CommonBaseEvent commonBaseEvent, String string) {
        String[] stringArray;
        ExtendedDataElement extendedDataElement;
        EList eList = commonBaseEvent.getExtendedDataElements(string);
        if (eList != null && !eList.isEmpty() && (extendedDataElement = (ExtendedDataElement)eList.get(0)) != null && (stringArray = extendedDataElement.getValuesAsStringArray()) != null && stringArray.length > 0) {
            return CBEHelper.mergeStringArray(stringArray);
        }
        return null;
    }

    public static final String getFormattedMessage(CommonBaseEvent commonBaseEvent) {
        return commonBaseEvent.getMsg();
    }

    public static final int getLocalizable(CommonBaseEvent commonBaseEvent) {
        return CBEHelper.convertLocalizableToInt(CBEHelper.getExtendedDataElementString(commonBaseEvent, "localizable"));
    }

    public static final String getMessageLocale(CommonBaseEvent commonBaseEvent) {
        MsgDataElement msgDataElement = commonBaseEvent.getMsgDataElement();
        if (msgDataElement == null) {
            return null;
        }
        return msgDataElement.getMsgLocale();
    }

    public static final Object[] getParameters(CommonBaseEvent commonBaseEvent) {
        Object[] objectArray;
        MsgDataElement msgDataElement = commonBaseEvent.getMsgDataElement();
        if (msgDataElement != null && (objectArray = msgDataElement.getMsgCatalogTokensAsStrings()) != null && objectArray.length > 0) {
            return objectArray;
        }
        return null;
    }

    public static final boolean requiresNoLocalization(CommonBaseEvent commonBaseEvent) {
        return CBEHelper.getLocalizable(commonBaseEvent) == 2;
    }

    public static final String getFlatStackTrace(CommonBaseEvent commonBaseEvent) {
        return CBEHelper.getExtendedDataElementLargeString(commonBaseEvent, "flatStackTrace");
    }

    public static final String getStackTrace(CommonBaseEvent commonBaseEvent) {
        ExtendedDataElement extendedDataElement;
        StringBuffer stringBuffer = null;
        EList eList = commonBaseEvent.getExtendedDataElements(CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_THROWN);
        if (eList != null && !eList.isEmpty() && (extendedDataElement = (ExtendedDataElement)eList.get(0)) != null) {
            stringBuffer = new StringBuffer(extendedDataElement.getValuesAsString());
            int n = 1;
            EList eList2 = extendedDataElement.getChildren(CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_THROWN_STACK_FRAME + String.valueOf(n));
            while (eList2 != null && !eList2.isEmpty()) {
                ExtendedDataElement extendedDataElement2 = (ExtendedDataElement)eList2.get(0);
                if (extendedDataElement2 != null) {
                    stringBuffer.append(svLineSeparatorTab).append(extendedDataElement2.getValuesAsString());
                }
                eList2 = extendedDataElement.getChildren(CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_THROWN_STACK_FRAME + String.valueOf(++n));
            }
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return null;
    }

    public static final void setExtendedDataElementByteArray(EventFactory eventFactory, CommonBaseEvent commonBaseEvent, String string, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        commonBaseEvent.removeExtendedDataElements(string);
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        extendedDataElement.setName(string);
        extendedDataElement.setValuesAsByteArray(byArray);
        commonBaseEvent.addExtendedDataElement(extendedDataElement);
    }

    public static final void setExtendedDataElementInt(EventFactory eventFactory, CommonBaseEvent commonBaseEvent, String string, int n) {
        commonBaseEvent.removeExtendedDataElements(string);
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        extendedDataElement.setName(string);
        extendedDataElement.setValuesAsInt(n);
        commonBaseEvent.addExtendedDataElement(extendedDataElement);
    }

    public static final void setExtendedDataElementString(EventFactory eventFactory, CommonBaseEvent commonBaseEvent, String string, String string2) {
        if (string2 == null) {
            return;
        }
        commonBaseEvent.removeExtendedDataElements(string);
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        extendedDataElement.setName(string);
        extendedDataElement.setValuesAsString(string2);
        commonBaseEvent.addExtendedDataElement(extendedDataElement);
    }

    public static final void setExtendedDataElementLargeString(EventFactory eventFactory, CommonBaseEvent commonBaseEvent, String string, String string2) {
        if (string2 == null) {
            return;
        }
        commonBaseEvent.removeExtendedDataElements(string);
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        extendedDataElement.setName(string);
        extendedDataElement.setValuesAsStringArray(CBEHelper.chunkString(string2, 500));
        commonBaseEvent.addExtendedDataElement(extendedDataElement);
    }

    public static final void setFormattedMessage(CommonBaseEvent commonBaseEvent, String string) {
        commonBaseEvent.setMsg(string);
    }

    public static final void setLocalizable(EventFactory eventFactory, CommonBaseEvent commonBaseEvent, int n) {
        String string = CBEHelper.convertLocalizableToString(n);
        CBEHelper.setExtendedDataElementString(eventFactory, commonBaseEvent, "localizable", string);
    }

    public static final void setMessageLocale(EventFactory eventFactory, CommonBaseEvent commonBaseEvent, String string) {
        MsgDataElement msgDataElement = commonBaseEvent.getMsgDataElement();
        if (msgDataElement == null) {
            msgDataElement = eventFactory.createMsgDataElement();
            commonBaseEvent.setMsgDataElement(msgDataElement);
        }
        msgDataElement.setMsgLocale(string);
    }

    public static final void setMsgId(EventFactory eventFactory, CommonBaseEvent commonBaseEvent, String string) {
        MsgDataElement msgDataElement = commonBaseEvent.getMsgDataElement();
        if (msgDataElement == null) {
            msgDataElement = eventFactory.createMsgDataElement();
            commonBaseEvent.setMsgDataElement(msgDataElement);
        }
        msgDataElement.setMsgId(string);
    }

    private static String[] chunkString(String string, int n) {
        if (string == null || n <= 0) {
            return null;
        }
        int n2 = string.length();
        if (n > n2) {
            return new String[]{string};
        }
        int n3 = 0;
        int n4 = n3 + n;
        int n5 = (n2 + n - 1) / n;
        String[] stringArray = new String[n5];
        for (int i = 0; i < n5; ++i) {
            stringArray[i] = string.substring(n3, n4);
            n3 += n;
            if ((n4 += n) <= n2) continue;
            n4 = n2;
        }
        return stringArray;
    }

    private static String mergeStringArray(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return new String(stringBuffer);
    }

    private static String getSystemProperty(String string) {
        final String string2 = string;
        try {
            String string3 = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string2);
                }
            });
            return string3;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private static final String convertLocalizableToString(int n) {
        switch (n) {
            case 1: {
                return "yes";
            }
            case 2: {
                return "no";
            }
        }
        return "default";
    }

    private static final int convertLocalizableToInt(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equals("yes")) {
            return 1;
        }
        if (string.equals("no")) {
            return 2;
        }
        return 0;
    }

    public static void populateMsgId(CommonBaseEvent commonBaseEvent, String string) {
        String[] stringArray;
        MsgDataElement msgDataElement = commonBaseEvent.getMsgDataElement();
        if (msgDataElement != null && msgDataElement.getMsgId() == null && (stringArray = CBEHelper.detectMsgIdInfo(string))[0] != null) {
            msgDataElement.setMsgIdType(stringArray[0]);
            msgDataElement.setMsgId(stringArray[1]);
        }
    }

    static String[] detectMsgIdInfo(String string) {
        char[] cArray;
        String[] stringArray = new String[2];
        if (string.length() >= 11) {
            cArray = new char[11];
            string.getChars(0, 11, cArray, 0);
            if (cArray[10] == ':' && (cArray[9] == 'E' || cArray[9] == 'W' || cArray[9] == 'I') && cArray[8] >= '0' && cArray[8] <= '9' && cArray[7] >= '0' && cArray[7] <= '9' && cArray[6] >= '0' && cArray[6] <= '9' && cArray[5] >= '0' && cArray[5] <= '9' && cArray[4] >= 'A' && cArray[4] <= 'Z' && cArray[3] >= 'A' && cArray[3] <= 'Z' && cArray[2] >= 'A' && cArray[2] <= 'Z' && cArray[1] >= 'A' && cArray[1] <= 'Z' && cArray[0] >= 'A' && cArray[0] <= 'Z') {
                stringArray[0] = "IBM5.4.1";
                stringArray[1] = string.substring(0, 10);
            }
        }
        if (stringArray[0] == null && string.length() >= 10) {
            cArray = new char[10];
            string.getChars(0, 10, cArray, 0);
            if (cArray[9] == ':' && (cArray[8] == 'E' || cArray[8] == 'W' || cArray[8] == 'I') && cArray[7] >= '0' && cArray[7] <= '9' && cArray[6] >= '0' && cArray[6] <= '9' && cArray[5] >= '0' && cArray[5] <= '9' && cArray[4] >= '0' && cArray[4] <= '9' && cArray[3] >= 'A' && cArray[3] <= 'Z' && cArray[2] >= 'A' && cArray[2] <= 'Z' && cArray[1] >= 'A' && cArray[1] <= 'Z' && cArray[0] >= 'A' && cArray[0] <= 'Z') {
                stringArray[0] = "IBM4.4.1";
                stringArray[1] = string.substring(0, 9);
            }
        }
        return stringArray;
    }

    public static String getAlreadyFormattedMessage(CommonBaseEvent commonBaseEvent, Locale locale) {
        String string;
        String string2 = CBEHelper.getMessageLocale(commonBaseEvent);
        if (string2 != null && string2.equals(locale.toString()) && (string = CBEHelper.getFormattedMessage(commonBaseEvent)) != null) {
            return string;
        }
        return null;
    }

    public static Vector getReservedExtenionNames() {
        return RESERVEDEXTENSIONNAMES;
    }

    static {
        svLineSeparatorTab = CBEHelper.getSystemProperty("line.separator") + "\t";
        RESERVEDEXTENSIONNAMES = new Vector();
        RESERVEDEXTENSIONNAMES.add("correlationId");
        RESERVEDEXTENSIONNAMES.add("organization");
        RESERVEDEXTENSIONNAMES.add(CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_THROWN);
        RESERVEDEXTENSIONNAMES.add("version");
        RESERVEDEXTENSIONNAMES.add("localizable");
        RESERVEDEXTENSIONNAMES.add("rawData");
        RESERVEDEXTENSIONNAMES.add("component");
        RESERVEDEXTENSIONNAMES.add("processId");
        RESERVEDEXTENSIONNAMES.add("processName");
        RESERVEDEXTENSIONNAMES.add("product");
        RESERVEDEXTENSIONNAMES.add("flatStackTrace");
        RESERVEDEXTENSIONNAMES.add("addressSpaceId");
        RESERVEDEXTENSIONNAMES.add("jobName");
        RESERVEDEXTENSIONNAMES.add("serverName");
        RESERVEDEXTENSIONNAMES.add("jobId");
        RESERVEDEXTENSIONNAMES.add("systemName");
        RESERVEDEXTENSIONNAMES.add("tcbAddress");
        RESERVEDEXTENSIONNAMES.add("pthreadId");
        RESERVEDEXTENSIONNAMES.add("ORBRequestId");
    }
}

