/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.logging.WsLogger;
import com.ibm.ws.logging.cbe.EventFactoryHelper;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class WsLoggerConfigurator {
    static final String CLASSNAME = "com.ibm.ws.logging.WsLoggerConfigurator";
    private static final String[] CONFIGURATION_RESOURCE_NAMES = new String[]{"META-INF/Logger.properties", "Logger.properties"};
    private static final String ATTRIBUTE_NAME_ORGANIZATION = "organization";
    private static final String ATTRIBUTE_NAME_PRODUCT = "product";
    private static final String ATTRIBUTE_NAME_COMPONENT = "component";
    private static final String ATTRIBUTE_NAME_MINIMUM_LOCALIZATION_LEVEL = "minimum_localization_level";
    private static final String ATTRIBUTE_NAME_GROUP = "group";
    private static final String ATTRIBUTE_NAME_ASYNC = "async";
    private static final String ATTRIBUTE_NAME_EVENTFACTORY = "eventfactory";
    private static WsLoggerConfigurator singleton = new WsLoggerConfigurator();
    private WeakHashMap ivLoggingConfigurations = null;
    private Logger ivLogger = null;
    private Vector ivLoggingQueue = null;

    private WsLoggerConfigurator() {
    }

    static WsLoggerConfigurator getInstance() {
        return singleton;
    }

    private HashMap getLoggerConfiguration(Logger logger) {
        HashMap hashMap = null;
        HashMap hashMap2 = this.getCurrentLoggingConfiguration();
        if (hashMap2 != null && hashMap2.size() > 0) {
            hashMap = new HashMap();
            Iterator iterator = hashMap2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                int n = string.lastIndexOf(46);
                if (n == -1 || n >= string.length() - 1 || !logger.getName().startsWith(string.substring(0, n))) continue;
                hashMap.put(string.substring(n + 1), entry.getValue());
            }
        }
        return hashMap;
    }

    private HashMap getCurrentLoggingConfiguration() {
        String string = "getCurrentLoggingConfiguration";
        HashMap hashMap = null;
        ClassLoader classLoader = this.getContextClassLoader();
        if (classLoader != null) {
            if (this.ivLoggingConfigurations != null) {
                hashMap = (HashMap)this.ivLoggingConfigurations.get(classLoader);
            } else {
                this.ivLoggingConfigurations = new WeakHashMap();
            }
            if (hashMap == null) {
                hashMap = new HashMap();
                for (int i = 0; i < CONFIGURATION_RESOURCE_NAMES.length; ++i) {
                    Vector vector = this.getResources(classLoader, CONFIGURATION_RESOURCE_NAMES[i]);
                    for (int j = 0; j < vector.size(); ++j) {
                        this.addProperties(hashMap, this.getPropertiesFromURL((URL)vector.elementAt(j)));
                    }
                }
                this.ivLoggingConfigurations.put(classLoader, hashMap);
            }
        } else {
            this.logMessage(Level.WARNING, string, "Obtained context class loader is null.", null);
        }
        return hashMap;
    }

    void configureLogger(Logger logger) {
        String string = "configureLogger";
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to configureLogger must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to configureLogger must be a named logger");
        }
        HashMap hashMap = this.getLoggerConfiguration(logger);
        String string2 = null;
        if (hashMap != null && !hashMap.isEmpty()) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                boolean bl = false;
                if (!(k instanceof String)) {
                    this.logMessage(Level.WARNING, string, "Supplied Map key " + k.toString() + " is of type " + k.getClass().getName() + ".  Keys must be String typed.  Ignoring key value pair.", null);
                }
                if (!(v instanceof String)) {
                    this.logMessage(Level.WARNING, string, "Supplied Map value " + v.toString() + " is of type " + k.getClass().getName() + ".  Values must be String typed.  Ignoring key value pair.", null);
                } else if (((String)k).equals(ATTRIBUTE_NAME_PRODUCT)) {
                    ((WsLogger)logger).setProduct((String)v);
                } else if (((String)k).equals(ATTRIBUTE_NAME_COMPONENT)) {
                    ((WsLogger)logger).setComponent((String)v);
                } else if (((String)k).equals(ATTRIBUTE_NAME_ORGANIZATION)) {
                    ((WsLogger)logger).setOrganization((String)v);
                } else if (((String)k).equals(ATTRIBUTE_NAME_MINIMUM_LOCALIZATION_LEVEL)) {
                    ((WsLogger)logger).setMinimumLocalizationLevel(Level.parse((String)v));
                } else if (((String)k).equals(ATTRIBUTE_NAME_GROUP)) {
                    LoggerHelper.addLoggerToGroup(logger, (String)v);
                } else if (((String)k).equals(ATTRIBUTE_NAME_ASYNC)) {
                    ((WsLogger)logger).setAsync(((String)v).equalsIgnoreCase("true"));
                } else if (((String)k).equals(ATTRIBUTE_NAME_EVENTFACTORY)) {
                    string2 = (String)v;
                } else {
                    bl = true;
                }
                if (bl) continue;
                iterator.remove();
            }
            if (!hashMap.isEmpty()) {
                LoggerHelper.addExtensions(logger, hashMap);
            }
        }
        ((WsLogger)logger).setEventFactory(EventFactoryHelper.getEventFactory(string2));
    }

    protected ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (Exception exception) {
            this.logMessage(Level.WARNING, "getContextClassLoader", "Exception caught while obtainaing context classloader: " + exception, null);
            classLoader = null;
        }
        return classLoader;
    }

    protected Vector getResources(final ClassLoader classLoader, final String string) {
        final Vector vector = new Vector();
        try {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    Enumeration<URL> enumeration = null;
                    try {
                        enumeration = classLoader != null ? classLoader.getResources(string) : ClassLoader.getSystemResources(string);
                    }
                    catch (IOException iOException) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getResources", "Exception caught while obtaining resources named " + string, new Object[]{iOException});
                    }
                    if (enumeration != null && enumeration.hasMoreElements()) {
                        while (enumeration.hasMoreElements()) {
                            vector.add(enumeration.nextElement());
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            this.logMessage(Level.WARNING, "getResources", "Exception caught while obtaining resources named " + string, new Object[]{exception});
        }
        return vector;
    }

    private void addProperties(HashMap hashMap, Properties properties) {
        if (properties != null && properties.size() > 0) {
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
            }
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashMap.put(string, properties.get(string));
            }
        }
    }

    private Properties getPropertiesFromURL(final URL uRL) {
        final Properties properties = new Properties();
        try {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    InputStream inputStream = null;
                    try {
                        inputStream = uRL.openStream();
                    }
                    catch (IOException iOException) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getPropertiesFromURL", "Exception caught when opening stream for resouce " + uRL.toString(), null);
                    }
                    if (inputStream != null) {
                        try {
                            properties.load(inputStream);
                        }
                        catch (IOException iOException) {
                            WsLoggerConfigurator.this.logMessage(Level.WARNING, "getPropertiesFromURL", "Exception caught when loading properties from stream for resouce " + uRL.toString(), null);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            this.logMessage(Level.WARNING, "getPropertiesFromURL", "Exception caught from doPrivileged block loading properties frome resource " + uRL.toString(), null);
        }
        return properties;
    }

    private void logMessage(Level level, String string, String string2, Object[] objectArray) {
        if (this.ivLogger != null) {
            if (this.ivLoggingQueue != null) {
                while (!this.ivLoggingQueue.isEmpty()) {
                    this.ivLogger.log((LogRecord)this.ivLoggingQueue.elementAt(0));
                    this.ivLoggingQueue.remove(0);
                }
            }
            this.ivLogger.logp(level, CLASSNAME, string, string2, objectArray);
        } else {
            LogRecord logRecord = new LogRecord(level, string2);
            logRecord.setLoggerName(CLASSNAME);
            logRecord.setSourceClassName(CLASSNAME);
            logRecord.setSourceMethodName(string);
            logRecord.setParameters(objectArray);
            if (this.ivLoggingQueue == null) {
                this.ivLoggingQueue = new Vector();
            }
            this.ivLoggingQueue.add(logRecord);
        }
    }

    void setInternalLogger(Logger logger) {
        if (this.ivLogger == null) {
            this.ivLogger = logger;
            this.logMessage(Level.FINEST, "setInternalLogger", "Internal logger initialized.", null);
        }
    }
}

