/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.FormatSet;
import com.ibm.ws.logging.FormattedMessageAndStackTrace;
import com.ibm.ws.logging.cbe.CBEFormatHelper;
import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.core.ISerializableAsXml;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class TraceLogFormatter
extends Formatter {
    private static final int svBasicFormatMaxNameLength = 13;
    private static final String svBasicPadding = "                                 ";
    private static final String svAdvancedPadding = "          ";
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String nullParamString = "null";
    private static final String badParamString = "<malformed parameter>";
    private static final String svLineSeparatorPlusBasicPadding = lineSeparator + "                                 ";
    private static final String svLineSeparatorPlusBasicPaddingPlusNullParamString = svLineSeparatorPlusBasicPadding + "null";
    private static final String svLineSeparatorPlusAdvancedPadding = lineSeparator + "          ";
    private static final String svEmptyString = "";
    private static final String svEmptyStringReplacement = "\"\"";
    public static final int UNUSED_PARM_HANDLING_DISCARD = 0;
    public static final int UNUSED_PARM_HANDLING_APPEND_WITH_SPACES = 1;
    public static final int UNUSED_PARM_HANDLING_APPEND_WITH_NEWLINE = 2;
    public static final int UNUSED_PARM_HANDLING_APPEND_WITH_PARM_LABELS = 3;
    public static final int UNUSED_PARM_HANDLING_APPEND_WITH_SEMICOLON_AND_COMMAS = 4;

    public String format(LogRecord logRecord) {
        return null;
    }

    private static void formatTimeAndThread(LogRecord logRecord, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        FormatSet formatSet = FormatSet.getFormatSet();
        stringBuffer.append('[');
        long l = 0L;
        try {
            final LogRecord logRecord2 = logRecord;
            l = (Long)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() {
                    return new Long(logRecord2.getMillis());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        formatSet.ivDate.setTime(l);
        formatSet.ivFormatter.format(formatSet.ivDate, stringBuffer, formatSet.ivFieldPos);
        FormatSet.returnFormatSet(formatSet);
        stringBuffer.append("] ");
        stringBuffer.append(RasHelper.getThreadId(logRecord));
        stringBuffer.append(' ');
    }

    private static String mapLevelToType(LogRecord logRecord) {
        Level level = logRecord.getLevel();
        if (level == WsLevel.FATAL) {
            return " F ";
        }
        if (level == Level.SEVERE) {
            return " E ";
        }
        if (level == Level.WARNING) {
            return " W ";
        }
        if (level == WsLevel.AUDIT) {
            return " A ";
        }
        if (level == Level.INFO) {
            return " I ";
        }
        if (level == Level.CONFIG) {
            return " C ";
        }
        if (level == WsLevel.DETAIL) {
            return " D ";
        }
        if (level == Level.FINE) {
            String string = logRecord.getLoggerName();
            if (string != null) {
                if (string.equals("SystemOut")) {
                    return " O ";
                }
                if (string.equals("SystemErr")) {
                    return " R ";
                }
            }
            return " 1 ";
        }
        if (level == Level.FINER) {
            String string = logRecord.getMessage();
            if (string != null) {
                if (string.indexOf("Entry") != -1 || string.indexOf("ENTRY") != -1) {
                    return " > ";
                }
                if (string.indexOf("Exit") != -1 || string.indexOf("RETURN") != -1) {
                    return " < ";
                }
            }
            return " 2 ";
        }
        if (level == Level.FINEST) {
            return " 3 ";
        }
        return " Z ";
    }

    static void formatHeaderBasic(LogRecord logRecord, StringBuffer stringBuffer) {
        int n;
        int n2;
        TraceLogFormatter.formatTimeAndThread(logRecord, stringBuffer);
        String string = logRecord.getLoggerName();
        if (string == null) {
            string = svEmptyString;
        }
        string = (n2 = string.lastIndexOf(46) + 1) + 13 >= string.length() ? string.substring(n2) : string.substring(n2, n2 + 13);
        stringBuffer.append(string);
        for (int i = n = 13 - string.length(); i > 0; --i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(TraceLogFormatter.mapLevelToType(logRecord));
        String string2 = logRecord.getSourceClassName();
        String string3 = logRecord.getSourceMethodName();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(' ');
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        stringBuffer.append(' ');
    }

    static void formatHeaderAdvanced(LogRecord logRecord, StringBuffer stringBuffer) {
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
        TraceLogFormatter.formatTimeAndThread(logRecord, stringBuffer);
        stringBuffer.append(TraceLogFormatter.mapLevelToType(logRecord));
        stringBuffer.append("UOW=");
        if (wsLogRecord != null) {
            stringBuffer.append(wsLogRecord.getCorrelationId());
        }
        stringBuffer.append(" source=");
        stringBuffer.append(logRecord.getLoggerName());
        String string = logRecord.getSourceClassName();
        if (string != null) {
            stringBuffer.append(" class=");
            stringBuffer.append(string);
        }
        if ((string = logRecord.getSourceMethodName()) != null) {
            stringBuffer.append(" method=");
            stringBuffer.append(string);
        }
        if (wsLogRecord != null) {
            stringBuffer.append(" org=");
            stringBuffer.append(wsLogRecord.getOrganization());
            stringBuffer.append(" prod=");
            stringBuffer.append(wsLogRecord.getProduct());
            stringBuffer.append(" component=");
            stringBuffer.append(wsLogRecord.getComponent());
            string = wsLogRecord.getReporterOrSourceThreadName();
            if (string != null) {
                stringBuffer.append(" thread=[");
                stringBuffer.append(string);
                stringBuffer.append("]");
            }
        }
    }

    public static String formatMessage(LogRecord logRecord, Locale locale, int n) {
        FormattedMessageAndStackTrace formattedMessageAndStackTrace = TraceLogFormatter.getFormattedMessageAndStackTrace(logRecord, locale, n);
        return formattedMessageAndStackTrace.formattedMessage;
    }

    public static String formatMessageLR(LogRecord logRecord, Locale locale, int n) {
        return TraceLogFormatter.formatLocalized(logRecord, null);
    }

    public static String formatMessageWSLR(WsLogRecord wsLogRecord, Locale locale, int n) {
        String string;
        String string2;
        if (wsLogRecord.getLocalizable() == 2) {
            String string3 = wsLogRecord.getMessage();
            Object[] objectArray = wsLogRecord.getParameters();
            return TraceLogFormatter.formatUnlocalized(string3, objectArray, n);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string2 = wsLogRecord.getMessageLocale()) != null && string2.equals(locale.toString()) && (string = wsLogRecord.getFormattedMessage()) != null) {
            return string;
        }
        string = TraceLogFormatter.formatLocalized(wsLogRecord.getImpl(), null);
        if (wsLogRecord != null) {
            wsLogRecord.setMessageLocale(locale.toString());
            wsLogRecord.setFormattedMessage(string);
        }
        return string;
    }

    public static String formatMessageCBELR(CommonBaseEventLogRecord commonBaseEventLogRecord, Locale locale, int n) {
        CommonBaseEvent commonBaseEvent = commonBaseEventLogRecord.getCommonBaseEvent();
        if (CBEHelper.requiresNoLocalization(commonBaseEvent)) {
            String string = commonBaseEvent.getMsg();
            if (string == null) {
                string = commonBaseEventLogRecord.getMessage();
            }
            Object[] objectArray = commonBaseEventLogRecord.getParameters();
            return TraceLogFormatter.formatUnlocalized(string, objectArray, n);
        }
        CBEFormatHelper cBEFormatHelper = new CBEFormatHelper();
        return cBEFormatHelper.getFormattedMessage(commonBaseEvent, commonBaseEventLogRecord.getResourceBundle(), commonBaseEventLogRecord.getResourceBundleName(), locale);
    }

    public static String formatBasic(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        TraceLogFormatter.formatHeaderBasic(logRecord, stringBuffer);
        FormattedMessageAndStackTrace formattedMessageAndStackTrace = TraceLogFormatter.getFormattedMessageAndStackTrace(logRecord, null, 2);
        String string = formattedMessageAndStackTrace.formattedMessage;
        String string2 = formattedMessageAndStackTrace.stackTrace;
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(svLineSeparatorPlusBasicPadding);
            stringBuffer.append(string2);
        }
        return new String(stringBuffer);
    }

    public static String formatAdvanced(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        TraceLogFormatter.formatHeaderAdvanced(logRecord, stringBuffer);
        stringBuffer.append(lineSeparator);
        stringBuffer.append(svAdvancedPadding);
        FormattedMessageAndStackTrace formattedMessageAndStackTrace = TraceLogFormatter.getFormattedMessageAndStackTrace(logRecord, null, 3);
        String string = formattedMessageAndStackTrace.formattedMessage;
        String string2 = formattedMessageAndStackTrace.stackTrace;
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(svLineSeparatorPlusAdvancedPadding);
            stringBuffer.append(string2);
        }
        return new String(stringBuffer);
    }

    public static String formatCBEXML101(CommonBaseEvent commonBaseEvent, ResourceBundle resourceBundle, String string, Locale locale) {
        if (commonBaseEvent == null) {
            return null;
        }
        CBEFormatHelper cBEFormatHelper = new CBEFormatHelper();
        cBEFormatHelper.localize(commonBaseEvent, resourceBundle, string, locale);
        return ((ISerializableAsXml)commonBaseEvent).externalizeCanonicalXmlString();
    }

    public static Object[] convertParameters(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i] instanceof String && ((String)objectArray[i]).equals(svEmptyString) ? svEmptyStringReplacement : objectArray[i];
        }
        return objectArray2;
    }

    private static String formatUnlocalized(String string, Object[] objectArray, int n) {
        if (n == 0) {
            return string;
        }
        Object[] objectArray2 = TraceLogFormatter.convertParameters(objectArray);
        if (objectArray2 == null) {
            return string;
        }
        String string2 = string.indexOf(123) >= 0 ? TraceNLS.getFormattedMessageFromLocalizedMessage(string, objectArray2, true) : string;
        if (string2.equals(string)) {
            return TraceLogFormatter.appendUnusedParms(string, objectArray2, n);
        }
        return string2;
    }

    private static String formatLocalized(LogRecord logRecord, Locale locale) {
        Object[] objectArray;
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string2 = null;
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        String string3 = logRecord.getResourceBundleName();
        if (string3 != null) {
            string = logRecord.getMessage();
            objectArray = string.replace(' ', '.');
            string2 = TraceNLS.getStringFromBundle(resourceBundle, string3, (String)objectArray, locale, string);
        }
        if (string2 == null) {
            string2 = logRecord.getMessage();
        }
        if (string2 == null) {
            string2 = "<Null Message>";
        }
        string = string2.indexOf(123) >= 0 ? ((objectArray = TraceLogFormatter.convertParameters(logRecord.getParameters())) == null ? string2 : TraceNLS.getFormattedMessageFromLocalizedMessage(string2, objectArray, true)) : string2;
        return string;
    }

    private static String appendUnusedParms(String string, Object[] objectArray, int n) {
        String string2 = string;
        switch (n) {
            case 2: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) {
                        stringBuffer.append(svLineSeparatorPlusBasicPaddingPlusNullParamString);
                        continue;
                    }
                    stringBuffer.append(svLineSeparatorPlusBasicPadding);
                    stringBuffer.append(objectArray[i].toString());
                }
                string2 = string2.concat(stringBuffer.toString());
                break;
            }
            case 3: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(" parm");
                    stringBuffer.append(i);
                    stringBuffer.append("=");
                    if (objectArray[i] == null) {
                        stringBuffer.append(nullParamString);
                        continue;
                    }
                    stringBuffer.append(objectArray[i].toString());
                }
                string2 = string2.concat(stringBuffer.toString());
                break;
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(" ").append(objectArray[i].toString());
                }
                string2 = string2.concat(stringBuffer.toString());
                break;
            }
            case 4: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i == 0) {
                        stringBuffer.append("; ");
                    } else {
                        stringBuffer.append(", ");
                    }
                    if (objectArray[i] == null) {
                        stringBuffer.append(nullParamString);
                        continue;
                    }
                    stringBuffer.append(objectArray[i].toString());
                }
                string2 = string2.concat(stringBuffer.toString());
                break;
            }
        }
        return string2;
    }

    private static FormattedMessageAndStackTrace getFormattedMessageAndStackTrace(LogRecord logRecord, Locale locale, int n) {
        String string;
        String string2;
        CommonBaseEvent commonBaseEvent;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        CommonBaseEventLogRecord commonBaseEventLogRecord = logRecord instanceof CommonBaseEventLogRecord ? (CommonBaseEventLogRecord)logRecord : null;
        CommonBaseEvent commonBaseEvent2 = commonBaseEvent = commonBaseEventLogRecord != null ? commonBaseEventLogRecord.getCommonBaseEvent() : null;
        if (commonBaseEvent != null) {
            string2 = TraceLogFormatter.formatMessageCBELR(commonBaseEventLogRecord, locale, n);
            string = CBEHelper.getFlatStackTrace(commonBaseEvent);
            if (string == null) {
                string = CBEHelper.getStackTrace(commonBaseEvent);
            }
        } else {
            WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
            if (wsLogRecord != null) {
                string2 = TraceLogFormatter.formatMessageWSLR(wsLogRecord, locale, n);
                string = wsLogRecord.getStackTrace();
            } else {
                string2 = TraceLogFormatter.formatMessageLR(logRecord, locale, n);
                Throwable throwable = logRecord.getThrown();
                string = throwable == null ? null : RasHelper.throwableToString(throwable);
            }
        }
        return new FormattedMessageAndStackTrace(string2, string);
    }
}

