/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class RASMessageCatalog {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final String PROP_FILE = "/RASMessageCatalog/catalog.properties";
    private static final String KEY_DEBUG = "debug";
    private boolean debug = false;
    private Locale locale = Locale.getDefault();
    private MessageFormat msgFormatter = new MessageFormat("");
    private ResourceBundle msgBundle;
    private String baseName = null;

    public RASMessageCatalog(String string) throws MissingResourceException {
        this(string, (Locale)null);
    }

    public RASMessageCatalog(String string, Locale locale) throws MissingResourceException {
        this.baseName = string;
        this.setLocale(locale);
        this.msgBundle = ResourceBundle.getBundle(string, this.getLocale());
        this.checkDebugOverride();
    }

    public RASMessageCatalog(ResourceBundle resourceBundle) {
        this.msgBundle = resourceBundle;
        this.checkDebugOverride();
    }

    public RASMessageCatalog(ResourceBundle resourceBundle, Locale locale) {
        this(resourceBundle);
        this.setLocale(locale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
            this.msgFormatter.setLocale(this.locale);
            if (this.baseName != null) {
                this.msgBundle = ResourceBundle.getBundle(this.baseName, this.getLocale());
            }
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    private void checkDebugOverride() {
        InputStream inputStream = this.getClass().getResourceAsStream(PROP_FILE);
        if (inputStream != null) {
            try {
                Properties properties = new Properties();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                properties.load(bufferedInputStream);
                bufferedInputStream.close();
                String string = properties.getProperty(KEY_DEBUG);
                if (string.equals("true")) {
                    this.setDebug(true);
                } else if (string.equals("false")) {
                    this.setDebug(false);
                }
            }
            catch (Exception exception) {
                RASUtil.rasMsgs.getMessage("ERR_DEBUG_PROP", PROP_FILE);
                exception.printStackTrace();
            }
        }
    }

    public String getMessage(String string) throws MissingResourceException {
        return this.getMessage(string, null);
    }

    public String getMessage(String string, Object object) throws MissingResourceException {
        Object[] objectArray = new Object[]{object};
        return this.getMessage(string, objectArray);
    }

    public String getMessage(String string, Object object, Object object2) throws MissingResourceException {
        Object[] objectArray = new Object[]{object, object2};
        return this.getMessage(string, objectArray);
    }

    public String getMessage(String string, Object[] objectArray) throws MissingResourceException {
        String string2 = this.msgBundle.getString(string);
        if (objectArray != null) {
            this.msgFormatter.applyPattern(string2);
            objectArray = RASUtil.checkNullObjects(objectArray);
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer = this.msgFormatter.format(objectArray, stringBuffer, (FieldPosition)null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] instanceof Number || objectArray[i] instanceof Date) continue;
                    objectArray[i] = objectArray[i].toString();
                }
                stringBuffer = new StringBuffer();
                try {
                    stringBuffer = this.msgFormatter.format(objectArray, stringBuffer, (FieldPosition)null);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string2);
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuffer.append(", p" + (i + 1) + "=" + objectArray[i].toString());
                    }
                }
            }
            string2 = stringBuffer.toString();
        }
        if (this.isDebug()) {
            string2 = "[" + string2 + "]";
        }
        return string2;
    }

    public String getMsg(String string, Object[] objectArray) {
        StringBuffer stringBuffer;
        block8: {
            stringBuffer = new StringBuffer(256);
            try {
                stringBuffer.append(this.getMessage(string, objectArray));
            }
            catch (MissingResourceException missingResourceException) {
                if (this.isDebug()) {
                    stringBuffer.append("[");
                }
                if (this.baseName == null) {
                    stringBuffer.append(RASUtil.rasMsgs.getMessage("ERR_MISSING_KEY_NO_FILE", string));
                } else {
                    stringBuffer.append(RASUtil.rasMsgs.getMessage("ERR_MISSING_KEY", string, this.baseName));
                }
                if (objectArray == null) {
                    stringBuffer.append(".");
                } else {
                    objectArray = RASUtil.checkNullObjects(objectArray);
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuffer.append(", p" + (i + 1) + "=" + objectArray[i].toString());
                    }
                }
                if (!this.isDebug()) break block8;
                stringBuffer.append("]");
            }
        }
        return stringBuffer.toString();
    }

    public char getChar(String string) {
        String string2 = this.getMessage(string);
        char c = this.isDebug() ? string2.charAt(1) : string2.charAt(0);
        return c;
    }
}

