/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.ejs.util.cache.CacheElementEnumerator;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.EvictionStrategy;
import com.ibm.ejs.util.cache.SimpleLimitStrategy;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class SweepLruEvictionStrategy
extends Thread
implements EvictionStrategy,
AlarmListener {
    private static final TraceComponent tc = Tr.register((Class)SweepLruEvictionStrategy.class, (String)"EJBCache", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.cache.SweepLruEvictionStrategy";
    private final Cache ivCache;
    private long ivSweepInterval;
    private final long ivMaxSweepInterval;
    private long ivDiscardThreshold = 20L;
    private long ivMaxDiscardThreshold;
    private long ivMinDiscardThreshold;
    private long ivUpperLimit;
    private long ivNumBelowSoftLimit = 0L;
    private CacheElementEnumerator ivElements;
    private Enumeration ivVictims;
    private final long MINIMUM_SWEEP_INTERVAL = 1000L;
    private final long MAXIMUM_SWEEP_INTERVAL = 12000L;
    private final long SWEEP_INTERVAL_ADJUST = 500L;
    private final long MINIMUM_ADJUSTED_INTERVAL = 3000L;
    private final long MAX_THRESHOLD_MULTIPLIER = 60000L;
    private final long MIN_THRESHOLD_MULTIPLIER = 9000L;

    public SweepLruEvictionStrategy(Cache cache, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> : " + cache.getName() + " size = " + cache.getConfigSize() + ", sweep = " + l));
        }
        this.ivCache = cache;
        this.ivSweepInterval = l < 1000L ? 1000L : (l > 12000L ? 12000L : l);
        this.ivMaxSweepInterval = this.ivSweepInterval;
        this.ivUpperLimit = this.ivCache.numBuckets * 3;
        if (this.ivSweepInterval * this.ivDiscardThreshold > 60000L) {
            this.ivDiscardThreshold = 60000L / this.ivSweepInterval;
            if (this.ivDiscardThreshold < 2L) {
                this.ivDiscardThreshold = 2L;
            }
        }
        this.ivMaxDiscardThreshold = this.ivDiscardThreshold;
        this.ivMinDiscardThreshold = 9000L / this.ivSweepInterval;
        if (this.ivMinDiscardThreshold < 2L) {
            this.ivMinDiscardThreshold = 2L;
        }
        this.ivElements = (CacheElementEnumerator)this.ivCache.enumerateElements();
        this.ivVictims = null;
        this.setDaemon(true);
        this.setName("SweepLruEvictionStrategy");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : " + cache.getName() + " size = " + cache.getConfigSize() + ", sweep = " + this.ivSweepInterval + ", threshold = " + this.ivDiscardThreshold));
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        if (this.ivSweepInterval >= 1000L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SweepLruEvictionStrategy using Alarms");
            }
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SweepLruEvictionStrategy running as background thread");
        }
        while (true) {
            try {
                while (true) {
                    SweepLruEvictionStrategy.sleep(this.ivSweepInterval);
                    this.alarm(null);
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.run", (String)"310", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"LRU_THREAD_INTERRUPTED_CNTR0052W", (Object)new Object[]{interruptedException});
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.run", (String)"315", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"LRU_THREAD_CAUGHT_EXCEPTION_CNTR0053W", (Object)new Object[]{this, exception});
                continue;
            }
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void alarm(Object object) {
        try {
            block13: {
                try {
                    if (this.ivNumBelowSoftLimit > this.ivMaxDiscardThreshold) {
                        if (this.ivDiscardThreshold < this.ivMaxDiscardThreshold) {
                            ++this.ivDiscardThreshold;
                        } else if (this.ivSweepInterval < this.ivMaxSweepInterval) {
                            this.ivSweepInterval += 500L;
                        }
                        this.ivNumBelowSoftLimit = 0L;
                    }
                    this.ivCache.numSweeps = this.ivCache.numSweeps == Long.MAX_VALUE ? 1L : ++this.ivCache.numSweeps;
                    if (this.ivCache.limitStrategy.softLimitReached(this.ivCache)) {
                        this.sweep();
                        if (this.ivCache.limitStrategy.softLimitReached(this.ivCache)) {
                            this.ivNumBelowSoftLimit = 0L;
                            if ((long)this.ivCache.numObjects <= this.ivUpperLimit) break block13;
                            if (this.ivSweepInterval > 3000L) {
                                this.ivSweepInterval -= 500L;
                                break block13;
                            }
                            if (this.ivDiscardThreshold > this.ivMinDiscardThreshold) {
                                --this.ivDiscardThreshold;
                                this.sweep();
                            }
                            break block13;
                        }
                        ++this.ivNumBelowSoftLimit;
                        break block13;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + "," + this.ivSweepInterval + ")" + " - Cache limit not reached : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize()));
                    }
                    ++this.ivNumBelowSoftLimit;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.alarm", (String)"424", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"LRU_THREAD_CAUGHT_EXCEPTION_CNTR0053W", (Object)new Object[]{this, exception});
                    Object var4_3 = null;
                    if (this.ivSweepInterval < 1000L) return;
                    AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
                    return;
                }
            }
            Object var4_2 = null;
            if (this.ivSweepInterval < 1000L) return;
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.ivSweepInterval < 1000L) throw throwable;
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            throw throwable;
        }
    }

    private void sweep() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + "," + this.ivSweepInterval + ")" + " - Cache limit exceeded : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize()));
        }
        int n = 0;
        long l = 0L;
        this.ivElements.reset();
        try {
            while (this.ivElements.hasMoreElements()) {
                Element element = (Element)this.ivElements.nextElement();
                l = element.accessedSweep <= this.ivCache.numSweeps ? this.ivCache.numSweeps - element.accessedSweep : Long.MAX_VALUE - element.accessedSweep + this.ivCache.numSweeps;
                if (element.pinned != 0 || l <= this.ivDiscardThreshold || !this.ivCache.evictObject(element.key)) continue;
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            FFDCFilter.processException((Throwable)noSuchElementException, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.sweep", (String)"499", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + "," + this.ivSweepInterval + ")" + " - Evicted = " + n + " : " + this.ivCache.getSize() + " : NoSuchElementException"));
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + "," + this.ivSweepInterval + ")" + " - Evicted = " + n + " : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize()));
        }
    }

    public synchronized Object getVictim(Cache cache) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getVictim");
        }
        Element element = null;
        Element element2 = null;
        boolean bl = false;
        while (element == null) {
            if (this.ivVictims == null || !this.ivVictims.hasMoreElements()) {
                if (bl) break;
                this.ivVictims = this.ivCache.enumerateElements();
                bl = true;
            }
            try {
                element2 = (Element)this.ivVictims.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                FFDCFilter.processException((Throwable)noSuchElementException, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.getVictim", (String)"573", (Object)this);
                continue;
            }
            if (!this.canBeDiscarded(element2)) continue;
            element = element2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getVictim : " + element));
        }
        return element;
    }

    public boolean canBeDiscarded(Element element) {
        long l = 0L;
        l = element.accessedSweep <= this.ivCache.numSweeps ? this.ivCache.numSweeps - element.accessedSweep : Long.MAX_VALUE - element.accessedSweep + this.ivCache.numSweeps;
        return l > this.ivDiscardThreshold;
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            String string2;
            int n;
            Cache cache = new Cache("TestCache", 9, false);
            cache.setLimitStrategy(new SimpleLimitStrategy(2, 2));
            SweepLruEvictionStrategy sweepLruEvictionStrategy = new SweepLruEvictionStrategy(cache, 10000L);
            cache.setEvictionStrategy(sweepLruEvictionStrategy);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSSS");
            for (n = 0; n < 15; ++n) {
                string2 = Integer.toString(n);
                string = simpleDateFormat.format(new Date());
                System.out.println("Inserting (" + string2 + ", " + string + ")");
                cache.insert(string2, string);
                cache.unpin(string2);
            }
            System.out.println("---- There are " + cache.getSize() + " elements in the cache");
            for (n = 14; n >= 0; --n) {
                string2 = Integer.toString(n);
                string = (String)cache.find(string2);
                System.out.println("Found (" + string2 + ", " + string + ")");
                cache.unpin(string2);
            }
            System.out.println("---- There are still " + cache.getSize() + " elements in the cache");
            for (n = 29; n >= 15; --n) {
                string2 = Integer.toString(n);
                string = (String)cache.find(string2);
                System.out.println("Found (" + string2 + ", " + string + ")");
            }
            System.out.println("---- There are still " + cache.getSize() + " elements in the cache");
            for (n = 15; n < 30; ++n) {
                string2 = Integer.toString(n);
                string = simpleDateFormat.format(new Date());
                try {
                    System.out.println("Inserting (" + string2 + ", " + string + ")");
                    cache.insert(string2, string);
                    cache.unpin(string2);
                    continue;
                }
                catch (InsufficientCacheSpaceException insufficientCacheSpaceException) {
                    FFDCFilter.processException((Throwable)insufficientCacheSpaceException, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.main", (String)"686");
                    System.out.println("!!!! Cache is full");
                    break;
                }
            }
            System.out.println("---- There are now " + cache.getSize() + " elements in the cache");
            sweepLruEvictionStrategy.start();
            try {
                do {
                    System.out.println("Sleeping...");
                    SweepLruEvictionStrategy.sleep(1000L);
                    System.out.println(">>>> There are now " + cache.getSize() + " elements in the cache");
                } while (cache.getSize() > 2);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.main", (String)"713");
                System.out.println(interruptedException);
            }
            for (int i = 0; i < 30; ++i) {
                string2 = Integer.toString(i);
                string = (String)cache.find(string2);
                System.out.println("Found (" + string2 + ", " + string + ")");
            }
            System.out.println("---- There are " + cache.getSize() + " elements in the cache");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.main", (String)"734");
            System.out.println(exception);
        }
    }
}

