/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.cm.portability.PortabilityLayerExt;
import com.ibm.ejs.cm.portability.PortableConnection;
import com.ibm.ejs.cm.portability.PortableDataSource;
import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.ContainerManagedBeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.util.BuzzHash;
import com.ibm.ejs.container.util.NameUtil;
import com.ibm.ejs.j2c.HandleList;
import com.ibm.ejs.persistence.EJSPersistenceException;
import com.ibm.ejs.persistence.EJSPersister;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.cpi.JDBCPersisterMetaData;
import com.ibm.websphere.cpi.PersisterHome;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.DataStoreHelperMetaData;
import com.ibm.ws.LocalTransaction.InconsistentLocalTranException;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.threadContext.ConnectionHandleAccessorImpl;
import com.ibm.ws.threadContext.ThreadContext;
import com.ibm.ws.util.WSThreadLocal;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.resource.ResourceException;
import javax.sql.DataSource;

public abstract class EJSJDBCPersister
implements EJSPersister {
    private static final TraceComponent tc = Tr.register((Class)EJSJDBCPersister.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.EJSJDBCPersister";
    private static final TraceComponent tc2 = Tr.register((String)"com.ibm.ejs.persistence.EJSJDBCPersister$DataStoreHelper", (String)"EJBContainer", (String)"com.ibm.ejs.resources.CONMMessages");
    private boolean ivCMPAutoCommitWarningLogged = false;
    private boolean ivCMPWarningLogged = false;
    private static final WSThreadLocal cvThreadLocal = new WSThreadLocal();
    protected PersisterHome home = null;
    protected String schemaName;
    protected WSJdbcDataSource jdbcDataSource = null;
    protected PortableDataSource dataSource = null;
    protected String dbUser = null;
    protected String dbPassword = null;
    private boolean newDataSource = false;
    private DataStoreHelper dshelper = null;
    private DataStoreHelperMetaData dshelperMetadata = null;
    private InternalDataStoreHelper intDSHelper = null;
    private boolean supportsSelectForUpdate;
    private boolean supportsKeepUpdateLocks;

    public static EJSJDBCPersister create(JDBCPersisterMetaData jDBCPersisterMetaData) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"create(MetaData)");
        }
        Class clazz = EJSJDBCPersister.getPersisterClass(jDBCPersisterMetaData);
        EJSJDBCPersister eJSJDBCPersister = (EJSJDBCPersister)clazz.newInstance();
        Properties properties = jDBCPersisterMetaData.getPersisterConfigData().getProperties();
        eJSJDBCPersister.initialize(jDBCPersisterMetaData.getDataSource(), (String)properties.get("DBUser"), (String)properties.get("DBPassword"), (String)properties.get("DBSchema"));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"create(MetaData)");
        }
        return eJSJDBCPersister;
    }

    private static Class getPersisterClass(JDBCPersisterMetaData jDBCPersisterMetaData) throws Exception {
        String string;
        Class<?> clazz;
        block10: {
            String string2;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getPersisterClass");
            }
            clazz = null;
            ClassLoader classLoader = jDBCPersisterMetaData.getClassLoader();
            EnterpriseBean enterpriseBean = jDBCPersisterMetaData.getEnterpriseBean();
            string = string2 = NameUtil.getDeployedPersisterClassName((EnterpriseBean)enterpriseBean);
            try {
                string = string + "_" + BuzzHash.computeHashStringMid32Bit((String)NameUtil.getHashStr((EnterpriseBean)enterpriseBean));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getPersisterClass(): Ejb module 2.0 - Loading Persister = " + string));
                }
                clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                string = NameUtil.updateFilenameHashCode((EnterpriseBean)enterpriseBean, (String)string);
                if (string != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getPersisterClass(): Failed Loading version 2 class, try modified BuzzHash version=" + string));
                    }
                    try {
                        clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        // empty catch block
                    }
                }
                if (clazz != null) break block10;
                string = string2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getPersisterClass(): Ejb module 1.0 - Loading Persister = " + string));
                }
                Class<?> clazz2 = clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPersisterClass Loaded " + string));
        }
        return clazz;
    }

    public EJSJDBCPersister() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public void setHome(PersisterHome persisterHome) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setHome", (Object)persisterHome);
        }
        this.home = persisterHome;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setHome");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void initialize(DataSource dataSource, String string, String string2, String string3) throws EJSPersistenceException {
        block59: {
            PortableConnection portableConnection;
            block63: {
                block65: {
                    ThreadContext threadContext;
                    LocalTransactionCoordinator localTransactionCoordinator;
                    LocalTransactionCoordinator localTransactionCoordinator2;
                    LocalTransactionCurrent localTransactionCurrent;
                    Connection connection;
                    block58: {
                        if (tc.isEntryEnabled()) {
                            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)this);
                        }
                        if (!(dataSource instanceof WSJdbcDataSource)) break block65;
                        this.newDataSource = true;
                        this.jdbcDataSource = (WSJdbcDataSource)dataSource;
                        this.dshelper = this.jdbcDataSource.getDataStoreHelper();
                        this.intDSHelper = this.jdbcDataSource.getInternalDataStoreHelper();
                        this.dshelperMetadata = this.dshelper.getMetaData();
                        connection = null;
                        localTransactionCurrent = null;
                        localTransactionCoordinator2 = null;
                        localTransactionCoordinator = null;
                        threadContext = null;
                        threadContext = ConnectionHandleAccessorImpl.getConnectionHandleAccessor().getThreadContext();
                        threadContext.beginContext((Object)new HandleList());
                        localTransactionCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
                        localTransactionCoordinator = localTransactionCurrent.suspend();
                        localTransactionCurrent.begin();
                        localTransactionCoordinator2 = localTransactionCurrent.getLocalTranCoord();
                        connection = this.jdbcDataSource.getConnection(string, string2);
                        this.supportsSelectForUpdate = this.dshelperMetadata.supportsSelectForUpdate();
                        this.supportsKeepUpdateLocks = this.dshelperMetadata.supportsExtendedForUpdate();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Connection supports Extended for Update:" + this.supportsKeepUpdateLocks));
                            Tr.debug((TraceComponent)tc, (String)("Connection supports Select   for Update:" + this.supportsSelectForUpdate));
                        }
                        this.schemaName = string3;
                        this.dbUser = string;
                        this.dbPassword = string2;
                        Object var12_13 = null;
                        try {
                            block57: {
                                if (connection != null) {
                                    connection.close();
                                }
                                if (localTransactionCoordinator2 == null) break block57;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"rolling back local tran that was started.");
                                }
                                localTransactionCoordinator2.complete(1);
                            }
                            Object var15_15 = null;
                            if (localTransactionCoordinator == null) break block58;
                        }
                        catch (Throwable throwable) {
                            Object var15_19 = null;
                            if (localTransactionCoordinator != null) {
                                localTransactionCurrent.resume(localTransactionCoordinator);
                            }
                            if (null != threadContext) {
                                threadContext.endContext();
                            }
                            throw throwable;
                        }
                        localTransactionCurrent.resume(localTransactionCoordinator);
                    }
                    if (null != threadContext) {
                        threadContext.endContext();
                    }
                    break block59;
                    {
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"221", (Object)this);
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Failed to close connection", (Object)sQLException);
                            }
                            Object var15_16 = null;
                            if (localTransactionCoordinator != null) {
                                localTransactionCurrent.resume(localTransactionCoordinator);
                            }
                            if (null != threadContext) {
                                threadContext.endContext();
                            }
                            break block59;
                        }
                        catch (InconsistentLocalTranException inconsistentLocalTranException) {
                            FFDCFilter.processException((Throwable)inconsistentLocalTranException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"314", (Object)this);
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Tolerating InconsistentLocalTranException on rollback request", (Object)((Object)inconsistentLocalTranException));
                            }
                            Object var15_17 = null;
                            if (localTransactionCoordinator != null) {
                                localTransactionCurrent.resume(localTransactionCoordinator);
                            }
                            if (null != threadContext) {
                                threadContext.endContext();
                            }
                            break block59;
                        }
                        catch (RolledbackException rolledbackException) {
                            FFDCFilter.processException((Throwable)rolledbackException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"326", (Object)this);
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Tolerating RolledbackException on a rollback request", (Object)((Object)rolledbackException));
                            }
                            Object var15_18 = null;
                            if (localTransactionCoordinator != null) {
                                localTransactionCurrent.resume(localTransactionCoordinator);
                            }
                            if (null != threadContext) {
                                threadContext.endContext();
                            }
                            break block59;
                        }
                    }
                    {
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"209", (Object)this);
                            throw new EJSPersistenceException("", (Throwable)WSJdbcUtil.mapException((WSJdbcObject)((WSJdbcObject)connection), (SQLException)sQLException));
                        }
                    }
                    catch (Throwable throwable) {
                        block62: {
                            block61: {
                                Object var12_14 = null;
                                try {
                                    block60: {
                                        if (connection != null) {
                                            connection.close();
                                        }
                                        if (localTransactionCoordinator2 == null) break block60;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"rolling back local tran that was started.");
                                        }
                                        localTransactionCoordinator2.complete(1);
                                    }
                                    Object var15_20 = null;
                                    if (localTransactionCoordinator == null) break block61;
                                }
                                catch (Throwable throwable2) {
                                    Object var15_24 = null;
                                    if (localTransactionCoordinator != null) {
                                        localTransactionCurrent.resume(localTransactionCoordinator);
                                    }
                                    if (null != threadContext) {
                                        threadContext.endContext();
                                    }
                                    throw throwable2;
                                }
                                localTransactionCurrent.resume(localTransactionCoordinator);
                            }
                            if (null != threadContext) {
                                threadContext.endContext();
                            }
                            break block62;
                            {
                                catch (SQLException sQLException) {
                                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"221", (Object)this);
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Failed to close connection", (Object)sQLException);
                                    }
                                    Object var15_21 = null;
                                    if (localTransactionCoordinator != null) {
                                        localTransactionCurrent.resume(localTransactionCoordinator);
                                    }
                                    if (null != threadContext) {
                                        threadContext.endContext();
                                    }
                                    break block62;
                                }
                                catch (InconsistentLocalTranException inconsistentLocalTranException) {
                                    FFDCFilter.processException((Throwable)inconsistentLocalTranException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"314", (Object)this);
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Tolerating InconsistentLocalTranException on rollback request", (Object)((Object)inconsistentLocalTranException));
                                    }
                                    Object var15_22 = null;
                                    if (localTransactionCoordinator != null) {
                                        localTransactionCurrent.resume(localTransactionCoordinator);
                                    }
                                    if (null != threadContext) {
                                        threadContext.endContext();
                                    }
                                    break block62;
                                }
                                catch (RolledbackException rolledbackException) {
                                    FFDCFilter.processException((Throwable)rolledbackException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"326", (Object)this);
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Tolerating RolledbackException on a rollback request", (Object)((Object)rolledbackException));
                                    }
                                    Object var15_23 = null;
                                    if (localTransactionCoordinator != null) {
                                        localTransactionCurrent.resume(localTransactionCoordinator);
                                    }
                                    if (null != threadContext) {
                                        threadContext.endContext();
                                    }
                                }
                            }
                        }
                        throw throwable;
                    }
                }
                this.dataSource = (PortableDataSource)dataSource;
                this.dbUser = string;
                this.dbPassword = string2;
                portableConnection = null;
                Connection connection = null;
                connection = dataSource.getConnection(string, string2);
                portableConnection = (PortableConnection)connection;
                this.supportsSelectForUpdate = portableConnection.getPortabilityLayer().supportsRowLockHint();
                this.supportsKeepUpdateLocks = portableConnection.getPortabilityLayer().supportsExtendedForUpdate(connection);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Connection supports Extended for Update:" + this.supportsKeepUpdateLocks));
                    Tr.debug((TraceComponent)tc, (String)("Connection supports Select   for Update:" + this.supportsSelectForUpdate));
                }
                if (portableConnection.getPortabilityLayer().supportsSchema()) {
                    this.schemaName = string3;
                    break block63;
                }
                this.schemaName = "";
            }
            Object var17_35 = null;
            try {
                if (portableConnection != null) {
                    portableConnection.close();
                }
                break block59;
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"267", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Failed to close connection", (Object)sQLException);
                }
                break block59;
            }
            {
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"255", (Object)this);
                    throw new EJSPersistenceException("", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block64: {
                    Object var17_36 = null;
                    try {
                        if (portableConnection != null) {
                            portableConnection.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"267", (Object)this);
                        if (!tc.isEventEnabled()) break block64;
                        Tr.event((TraceComponent)tc, (String)"Failed to close connection", (Object)sQLException);
                    }
                }
                throw throwable;
            }
        }
        this.postInit();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public final boolean dbSupportsSelectForUpdate() {
        return this.supportsSelectForUpdate;
    }

    public final boolean dbSupportsKeepUpdateLocks() {
        return this.supportsKeepUpdateLocks;
    }

    protected void postInit() {
    }

    public void create(EntityBean entityBean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"create(EntityBean)", (Object)this);
        }
        try {
            this._create(entityBean);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.create", (String)"319", (Object)this);
            if (this.newDataSource) {
                SQLException sQLException2 = this.dshelper.mapException(sQLException);
                if (sQLException2 instanceof DuplicateKeyException) {
                    throw new javax.ejb.DuplicateKeyException();
                }
                throw sQLException2;
            }
            SQLException sQLException3 = this.dataSource.getPortabilityLayer().translateException(sQLException);
            if (sQLException3 instanceof com.ibm.ejs.cm.portability.DuplicateKeyException) {
                throw new javax.ejb.DuplicateKeyException();
            }
            throw sQLException3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"create(EntityBean)");
        }
    }

    public EJBObject getBean(Object object) throws Exception {
        return this.home.getBean(this.getPrimaryKey(object), object);
    }

    public void checkCMPStoreOperation(BeanId beanId, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkCMPStoreOperation beanid[" + beanId + "] loadedForUpdate[" + bl + "] ivCMPWarningLogged[" + this.ivCMPWarningLogged + "] ivCMPAutoCommitWarningLogged[" + this.ivCMPAutoCommitWarningLogged + "]"));
        }
        if (this.newDataSource) {
            int n;
            String string;
            Connection connection = this.jdbcDataSource.getConnection(this.dbUser, this.dbPassword);
            if (!this.ivCMPWarningLogged && (string = this.dshelper.hasLostUpdateOrDeadLockOccurred(n = connection.getTransactionIsolation(), bl)) != null) {
                Tr.service((TraceComponent)tc2, (String)string, (Object)beanId);
                this.ivCMPWarningLogged = true;
                if (this.ivCMPWarningLogged && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkCMPStoreOperation WARNING beanid[" + beanId + "] loadedForUpdate[" + bl + "] Possible Lost Update or Deadlock Condition"));
                }
            }
        } else {
            PortableConnection portableConnection = (PortableConnection)this.dataSource.getConnection(this.dbUser, this.dbPassword);
            if (portableConnection.getAutoCommit()) {
                if (!this.ivCMPAutoCommitWarningLogged) {
                    Tr.service((TraceComponent)tc, (String)"POTENTIAL_LOST_UPDATE_CNTR0038W", (Object)beanId);
                    this.ivCMPAutoCommitWarningLogged = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("checkCMPStoreOperation: WARNING beanid[" + beanId + "] loadedForUpdate[" + bl + "] Possible Lost Update"));
                    }
                }
            } else if (!this.ivCMPWarningLogged) {
                PortabilityLayerExt portabilityLayerExt = portableConnection.getPortabilityLayer();
                this.ivCMPWarningLogged = portabilityLayerExt.checkCMPStoreOperation(beanId.toString(), (Connection)portableConnection, bl);
                if (this.ivCMPWarningLogged && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkCMPStoreOperation WARNING beanid[" + beanId + "] loadedForUpdate[" + bl + "] Possible Lost Update or Deadlock Condition"));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkCMPStoreOperation beanid[" + beanId + "] ivCMPWarningLogged[" + this.ivCMPWarningLogged + "] ivCMPAutoCommitWarningLogged[" + this.ivCMPAutoCommitWarningLogged + "]"));
        }
    }

    public PreparedStatement getPreparedStatement(String string) throws EJSPersistenceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPreparedStatement " + string));
        }
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            ContainerManagedBeanO containerManagedBeanO;
            PortabilityLayerExt portabilityLayerExt;
            connection = this.newDataSource ? this.jdbcDataSource.getConnection(this.dbUser, this.dbPassword) : this.dataSource.getConnection(this.dbUser, this.dbPassword);
            Object var4_4 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = 0;
            boolean bl5 = false;
            boolean bl6 = false;
            String string2 = null;
            ContainerTx containerTx = null;
            EJSDeployedSupport eJSDeployedSupport = (EJSDeployedSupport)this.home.getCurrentThreadDeployedSupport();
            EJBMethodInfo eJBMethodInfo = null;
            if (eJSDeployedSupport != null && (eJBMethodInfo = eJSDeployedSupport.getEJBMethodInfo()) != null) {
                bl = eJBMethodInfo.getIsCMP11FBPK();
                bl2 = eJBMethodInfo.getIsCMP11CustomFinderWithForUpdateAI();
                bl3 = eJBMethodInfo.getReadOnlyAttribute();
                string2 = eJBMethodInfo.getMethodName();
                containerTx = eJSDeployedSupport.getCurrentTx();
                if (containerTx != null) {
                    bl6 = eJBMethodInfo.getEJBComponentMetaData().getEJBModuleVersion() == 11 ? containerTx.isTransactionGlobal() : true;
                    n = containerTx.getIsolationLevel();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ContainerTx:" + containerTx + " CMP11FlushActive :" + containerTx.getCMP11FlushActive()));
                    }
                    if (n == 0) {
                        bl5 = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Isolevel of TRANSACTION_NONE encountered, using default database isolation level");
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling Method [" + string2 + "] DB ForUpdate: " + this.supportsSelectForUpdate + " DBExt ForUpdate:" + this.supportsKeepUpdateLocks + " CF w/RW AI:" + bl2 + " FBPK:" + bl + " read-only:" + bl3 + " Inherit:" + this.home.hasInheritance() + " Child:" + this.home.isChild()));
                }
            }
            if (tc.isDebugEnabled() && (eJSDeployedSupport == null || eJBMethodInfo == null)) {
                Tr.debug((TraceComponent)tc, (String)"Custom Finder SQL Update Processing Skipped");
            }
            if (bl6 && !containerTx.getCMP11FlushActive() && bl2 && !bl3) {
                boolean bl7;
                boolean bl8 = bl7 = this.supportsSelectForUpdate && this.supportsKeepUpdateLocks && !this.home.hasInheritance() && !this.home.isChild();
                if (this.newDataSource) {
                    if (bl5) {
                        try {
                            n = this.dshelper.getIsolationLevel(null);
                        }
                        catch (ResourceException resourceException) {
                            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", (String)"874", (Object)this);
                            throw new EJSPersistenceException("", (Throwable)resourceException);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Using database default isolation level for :" + n));
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ContainerTx (glbl):" + containerTx + " CurrentIsolevel:" + n));
                    }
                    string = this.intDSHelper.processSQL(string, n, this.supportsSelectForUpdate, bl7);
                } else {
                    PortableConnection portableConnection = (PortableConnection)connection;
                    portabilityLayerExt = portableConnection.getPortabilityLayer();
                    if (bl5) {
                        n = portabilityLayerExt.getPreferredIsolationLevel();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Using database default isolation level for :" + n));
                        }
                    }
                    string = portabilityLayerExt.processSQL(string, n, this.supportsSelectForUpdate, bl7);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Enhancing SQL Scenario, CF Case, SQL: " + string));
                }
                bl4 = true;
            }
            if (!bl4 && this.supportsSelectForUpdate && this.supportsKeepUpdateLocks && (containerManagedBeanO = (ContainerManagedBeanO)cvThreadLocal.get()) != null && containerManagedBeanO.getCalledFromLoadMethodForUpdate()) {
                boolean bl9;
                boolean bl10 = bl9 = this.supportsSelectForUpdate && this.supportsKeepUpdateLocks && !this.home.hasInheritance() && !this.home.isChild();
                if (this.newDataSource) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ContainerTx:" + containerTx + " CurrentIsolevel:" + n));
                    }
                    if (bl5) {
                        try {
                            n = this.dshelper.getIsolationLevel(null);
                        }
                        catch (ResourceException resourceException) {
                            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", (String)"938", (Object)this);
                            throw new EJSPersistenceException("", (Throwable)resourceException);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Using database default isolation level for :" + n));
                        }
                    }
                    string = this.intDSHelper.processSQL(string, n, false, bl9);
                } else {
                    portabilityLayerExt = (PortableConnection)connection;
                    PortabilityLayerExt portabilityLayerExt2 = portabilityLayerExt.getPortabilityLayer();
                    if (bl5) {
                        n = portabilityLayerExt2.getPreferredIsolationLevel();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Using database default isolation level for :" + n));
                        }
                    }
                    string = portabilityLayerExt2.processSQL(string, n, false, bl9);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Enhancing SQL Scenario, Load Ext For Update Case, SQL: " + string));
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SQL for prepareStatement:" + string));
            }
            preparedStatement = connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            block37: {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", (String)"466", (Object)this);
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sQLException2) {
                    FFDCFilter.processException((Throwable)sQLException2, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", (String)"477", (Object)this);
                    if (!tc.isDebugEnabled()) break block37;
                    Tr.debug((TraceComponent)tc, (String)"Connection close after error failed with: ", (Object)sQLException2);
                }
            }
            throw new EJSPersistenceException("getPStmt failed", (Throwable)sQLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPreparedStatement");
        }
        return preparedStatement;
    }

    protected final void returnPreparedStatement(PreparedStatement preparedStatement) throws EJSPersistenceException {
        Connection connection = null;
        try {
            connection = preparedStatement.getConnection();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.returnPreparedStatement", (String)"503", (Object)this);
            throw new EJSPersistenceException((Throwable)sQLException);
        }
        if (connection == null) {
            EJSPersistenceException eJSPersistenceException = new EJSPersistenceException("Prepared statement does not map to connection");
            Tr.error((TraceComponent)tc, (String)"PREPARED_STATEMENT_NOT_FOUND_CNTR0037E");
            throw eJSPersistenceException;
        }
        try {
            preparedStatement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.returnPreparedStatement", (String)"526", (Object)this);
            throw new EJSPersistenceException((Throwable)sQLException);
        }
    }

    public void preFind() throws RemoteException {
        this.home.preFind();
    }

    public final void setContextData(ContainerManagedBeanO containerManagedBeanO) {
        cvThreadLocal.set((Object)containerManagedBeanO);
    }

    public final Object[] getDataFromCache() {
        ContainerManagedBeanO containerManagedBeanO = (ContainerManagedBeanO)cvThreadLocal.get();
        return containerManagedBeanO.getDataCache();
    }

    public final void putDataIntoCache(Object[] objectArray) {
        ContainerManagedBeanO containerManagedBeanO = (ContainerManagedBeanO)cvThreadLocal.get();
        containerManagedBeanO.setDataCache(objectArray);
    }

    public abstract void _create(EntityBean var1) throws Exception;

    public abstract void remove(EntityBean var1) throws Exception;

    public abstract void refresh(EntityBean var1, boolean var2) throws Exception;

    public abstract void load(EntityBean var1, Object var2, boolean var3) throws Exception;

    public abstract Object getPrimaryKey(Object var1) throws Exception;

    public abstract void hydrate(EntityBean var1, Object var2, Object var3) throws Exception;

    public abstract void store(EntityBean var1) throws Exception;
}

