/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.lock;

import com.ibm.ejs.container.lock.DeadlockException;
import com.ibm.ejs.container.lock.LockException;
import com.ibm.ejs.container.lock.LockManager;
import com.ibm.ejs.container.lock.LockProxy;
import com.ibm.ejs.container.lock.LockReleasedException;
import com.ibm.ejs.container.lock.Locker;
import com.ibm.ejs.container.lock.Waiter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Lock
implements LockProxy {
    private static final TraceComponent tc = Tr.register((Class)Lock.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private int mode;
    private Object lockName;
    private Hashtable holders;
    private Hashtable waiters;
    private Vector waitQ;
    private LockManager lockMgr;
    private int numUsers;

    Lock(Object object, Locker locker, LockManager lockManager) {
        this.lockName = object;
        this.holders = new Hashtable();
        this.holders.put(locker, locker);
        ++this.numUsers;
        this.lockMgr = lockManager;
        this.mode = locker.getLockMode(object);
        this.waiters = new Hashtable();
        this.waitQ = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquire(Locker locker, int n, boolean bl) throws InterruptedException, LockException {
        Waiter waiter = null;
        Object object = this;
        synchronized (object) {
            if (this.numUsers == 0) {
                this.holders.put(locker, locker);
                this.mode = n;
                ++this.numUsers;
                return;
            }
            if (this.holders.get(locker) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Lock currently held by locker");
                }
                return;
            }
            if (this.mode == 0 && n == 0 && this.waiters.size() == 0) {
                this.holders.put(locker, locker);
                ++this.numUsers;
                return;
            }
            Waiter waiter2 = (Waiter)this.waiters.get(locker);
            if (waiter2 != null) {
                if (waiter2.mode != n) {
                    if (this.lockMgr.detectDeadlock(locker, this, n)) {
                        throw new DeadlockException();
                    }
                    if (n == 1) {
                        waiter2.mode = 1;
                    }
                }
                waiter = waiter2;
            } else {
                if (this.lockMgr.detectDeadlock(locker, this, n)) {
                    throw new DeadlockException();
                }
                waiter = new Waiter(this, locker, n);
                this.waiters.put(locker, waiter);
                this.lockMgr.waitEvent(waiter);
                ++this.numUsers;
                this.waitQ.addElement(waiter);
            }
        }
        if (!bl) {
            return;
        }
        object = waiter;
        synchronized (object) {
            if (waiter.released) {
                throw new LockReleasedException();
            }
            if (waiter.theLock.holders.get(waiter.locker) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"waiting for lock", (Object)new Object[]{this.lockName, locker, LockManager.modeStrs[this.mode]});
                }
                waiter.wait();
                if (waiter.released) {
                    throw new LockReleasedException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int release(Locker locker) {
        Waiter waiter;
        Waiter waiter2;
        if (this.holders.remove(locker) != null) {
            --this.numUsers;
        }
        if ((waiter2 = (Waiter)this.waiters.remove(locker)) != null) {
            --this.numUsers;
            waiter = waiter2;
            synchronized (waiter) {
                this.waitQ.removeElement(waiter2);
                waiter2.released = true;
                this.lockMgr.unwaitEvent(waiter2);
                waiter2.notify();
            }
        }
        if (this.holders.size() == 0) {
            Waiter waiter3;
            if (this.waiters.size() > 0) {
                waiter3 = waiter = (Waiter)this.waitQ.firstElement();
                synchronized (waiter3) {
                    this.waiters.remove(waiter.locker);
                    this.waitQ.removeElementAt(0);
                    this.holders.put(waiter.locker, waiter.locker);
                    this.mode = waiter.mode;
                    this.lockMgr.unwaitEvent(waiter);
                    waiter.notify();
                }
            }
            if (this.mode == 1) {
                return this.numUsers;
            }
            while (this.waiters.size() > 0) {
                waiter = (Waiter)this.waitQ.firstElement();
                if (waiter.mode == 1) {
                    return this.numUsers;
                }
                waiter3 = waiter;
                synchronized (waiter3) {
                    this.waiters.remove(waiter.locker);
                    this.waitQ.removeElementAt(0);
                    this.holders.put(waiter.locker, waiter.locker);
                    this.lockMgr.unwaitEvent(waiter);
                    waiter.notify();
                }
            }
        }
        return this.numUsers;
    }

    public final boolean isLock() {
        return true;
    }

    public Enumeration getHolders() {
        return this.holders.elements();
    }

    public boolean isHolder(Locker locker) {
        return this.holders.get(locker) != null;
    }
}

