/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.SessionBeanTimeoutException;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.StatefulBeanReaper;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.activator.ActivatorCacheFullException;
import com.ibm.ejs.container.activator.MasterKey;
import com.ibm.ejs.container.activator.SingletonActivationStrategy;
import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.drs.SfDRSClient;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.IllegalOperationException;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.websphere.csi.PassivationPolicy;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Date;
import javax.transaction.TransactionRolledbackException;

public abstract class StatefulSessionActivationStrategy
extends SingletonActivationStrategy {
    protected PassivationPolicy passivationPolicy;
    protected StatefulBeanReaper reaper;
    public StatefulPassivator ivPassivator;
    public SfDRSCache ivSfDRSCache;
    private static final TraceComponent tc = Tr.register((Class)StatefulSessionActivationStrategy.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy";

    StatefulSessionActivationStrategy(Activator activator, PassivationPolicy passivationPolicy) {
        this(activator, passivationPolicy, null);
    }

    StatefulSessionActivationStrategy(Activator activator, PassivationPolicy passivationPolicy, SfDRSCache sfDRSCache) {
        super(activator);
        this.passivationPolicy = passivationPolicy;
        this.reaper = activator.statefulBeanReaper;
        this.ivPassivator = activator.passivator;
        this.ivSfDRSCache = sfDRSCache;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)passivationPolicy);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Reaper", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    BeanO atCreate(ContainerTx containerTx, BeanO beanO) throws RemoteException {
        BeanO beanO2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"atCreate");
        }
        if ((beanO2 = super.atCreate(containerTx, beanO)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding beanO to reaper list");
            }
            StatefulBeanO statefulBeanO = (StatefulBeanO)beanO;
            this.reaper.add(statefulBeanO.getId(), statefulBeanO.getSessionTimeoutInMilliSeconds());
            if (statefulBeanO.sfsbFailoverEnabled()) {
                statefulBeanO.createDRSEntry();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atCreate");
        }
        return beanO2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BeanO atActivate(ContainerTx containerTx, BeanId beanId) throws RemoteException {
        BeanO beanO;
        block34: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("atActivate (" + beanId + ")"), (Object)containerTx);
            }
            beanO = null;
            Throwable throwable = null;
            MasterKey masterKey = new MasterKey(beanId);
            boolean bl = false;
            boolean bl2 = false;
            StatefulBeanO statefulBeanO = null;
            Object object = this.locks.getLock((Object)masterKey);
            synchronized (object) {
                try {
                    block33: {
                        try {
                            beanO = (BeanO)this.cache.find((Object)masterKey);
                            if (beanO == null) {
                                boolean bl3;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Bean not in cache");
                                }
                                if (EJSPlatformHelper.isZOS()) {
                                    bl3 = this.reaper.beanExistsAndTimedOut(beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND);
                                } else {
                                    boolean bl4 = bl3 = this.reaper.beanDoesNotExistOrHasTimedOut(beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND);
                                }
                                if (bl3) {
                                    if (this.reaper.beanExistsAndTimedOut(beanId)) {
                                        if (!tc.isDebugEnabled()) throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                        Tr.debug((TraceComponent)tc, (String)("Bean " + beanId + " in passivated filesystem or SfDRSCache, " + " but timed out."));
                                        throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                    }
                                    if (!tc.isDebugEnabled()) throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                    Tr.debug((TraceComponent)tc, (String)("Bean " + beanId + " not in the passivated filesystem either."));
                                    throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                }
                                beanO = beanId.getHome().createBeanO(beanId, containerTx);
                                this.cache.insert((Object)masterKey, (Object)beanO);
                                beanO.ivCacheKey = masterKey;
                                bl = true;
                                statefulBeanO = (StatefulBeanO)beanO;
                            } else {
                                bl2 = true;
                                statefulBeanO = (StatefulBeanO)beanO;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Found bean in cache");
                                }
                                if (containerTx != null) {
                                    containerTx.ivCallbackBeanO = beanO;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("CallbackBeanO = " + beanO));
                                    }
                                }
                            }
                            if (bl) {
                                beanO.activate(beanId, containerTx);
                                if (!this.reaper.beanExists(beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND)) {
                                    this.reaper.add(beanId, statefulBeanO.getSessionTimeoutInMilliSeconds());
                                    long l = statefulBeanO.getLastAccessTime();
                                    this.reaper.setLastAccessTime(beanId, l);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Bean last access: " + new Date(l).toString()));
                                    }
                                } else {
                                    this.reaper.setActive(beanId);
                                }
                                if (statefulBeanO.sfsbFailoverEnabled()) {
                                    statefulBeanO.updateDRSSetActiveProp();
                                }
                            }
                            if (statefulBeanO.timedOut(this.reaper)) {
                                throw new SessionBeanTimeoutException("Stateful bean " + beanO + " timed out");
                            }
                            if (!beanO.enlist(containerTx)) break block33;
                            this.cache.pin((Object)masterKey);
                        }
                        catch (InsufficientCacheSpaceException insufficientCacheSpaceException) {
                            FFDCFilter.processException((Throwable)insufficientCacheSpaceException, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", (String)"163", (Object)this);
                            throwable = insufficientCacheSpaceException;
                            throw new ActivatorCacheFullException();
                        }
                        catch (RemoteException remoteException) {
                            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", (String)"169", (Object)this);
                            throwable = remoteException;
                            throw remoteException;
                        }
                        catch (RuntimeException runtimeException) {
                            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", (String)"175", (Object)this);
                            throwable = runtimeException;
                            throw runtimeException;
                        }
                    }
                    Object var13_15 = null;
                    if (throwable != null && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"atActivation: exception raised", (Object)throwable);
                    }
                    if (throwable == null || beanO == null) break block34;
                    if (bl || bl2) {
                        try {
                            this.cache.remove((Object)masterKey, true);
                            beanO.ivCacheKey = null;
                            this.reaper.remove(beanId);
                            beanO.destroy();
                        }
                        catch (IllegalOperationException illegalOperationException) {
                            this.cache.unpin((Object)masterKey);
                        }
                    } else {
                        beanO.destroy();
                    }
                }
                catch (Throwable throwable2) {
                    Object var13_16 = null;
                    if (throwable != null && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"atActivation: exception raised", (Object)throwable);
                    }
                    if (throwable == null) throw throwable2;
                    if (beanO == null) throw throwable2;
                    if (!bl && !bl2) {
                        beanO.destroy();
                        throw throwable2;
                    }
                    try {}
                    catch (IllegalOperationException illegalOperationException) {
                        this.cache.unpin((Object)masterKey);
                        throw throwable2;
                    }
                    this.cache.remove((Object)masterKey, true);
                    beanO.ivCacheKey = null;
                    this.reaper.remove(beanId);
                    beanO.destroy();
                    throw throwable2;
                }
            }
        }
        if (!tc.isEntryEnabled()) return beanO;
        Tr.exit((TraceComponent)tc, (String)"atActivate", (Object)beanO);
        return beanO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atPostInvoke(ContainerTx containerTx, BeanO beanO) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"atPostInvoke", (Object)new Object[]{containerTx, beanO});
        }
        BeanId beanId = beanO.getId();
        Object object = beanO.ivCacheKey;
        this.reaper.setLastAccessTime(beanId);
        Object object2 = this.locks.getLock(object);
        synchronized (object2) {
            beanO = (BeanO)this.cache.findDontPinNAdjustPinCount(object, -1);
            if (beanO != null && (beanO.isRemoved() || beanO.isDiscarded())) {
                block9: {
                    if (containerTx != null) {
                        try {
                            containerTx.delist(beanO);
                        }
                        catch (TransactionRolledbackException transactionRolledbackException) {
                            FFDCFilter.processException((Throwable)transactionRolledbackException, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atPostInvoke", (String)"261", (Object)this);
                            if (!tc.isDebugEnabled()) break block9;
                            Tr.debug((TraceComponent)tc, (String)"atPostInvoke : transaction has rolledback");
                        }
                    }
                }
                ((BeanO)this.cache.remove(object, true)).destroy();
                beanO.ivCacheKey = null;
                this.reaper.remove(beanId);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atPostInvoke");
        }
    }

    void atDiscard(BeanO beanO) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"atDiscard", (Object)beanO);
        }
        try {
            BeanId beanId = ((StatefulBeanO)beanO).getId();
            StatefulBeanO statefulBeanO = (StatefulBeanO)beanO;
            if (!this.reaper.beanDoesNotExistOrHasTimedOut(beanId)) {
                if (EJSPlatformHelper.isZOS()) {
                    ((StatefulBeanO)beanO).setLastAccessTime(this.reaper.getLastAccessTime(beanId));
                }
                beanO.ivCacheKey = null;
                long l = this.reaper.getLastAccessTime(beanId);
                statefulBeanO.setLastAccessTime(l);
                beanO.passivate();
                this.reaper.setPassivated(beanId);
                statefulBeanO.destroyNotRemove();
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Discarding session bean", (Object)beanO);
                }
                this.reaper.remove(beanId);
                statefulBeanO.destroy();
                beanO.ivCacheKey = null;
            }
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atDiscard", (String)"368", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_PASSIVATE_EJB_CNTR0005W", (Object)new Object[]{beanO, this, remoteException});
            throw remoteException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atDiscard");
        }
    }

    void atRemove(ContainerTx containerTx, BeanO beanO) {
        super.atRemove(containerTx, beanO);
        this.reaper.remove(beanO.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void atTimeout(BeanId beanId) throws RemoteException {
        block23: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("atTimeout " + beanId));
            }
            BeanO beanO = null;
            Exception exception = null;
            MasterKey masterKey = new MasterKey(beanId);
            try {
                block26: {
                    try {
                        Object object = this.locks.getLock((Object)masterKey);
                        synchronized (object) {
                            block25: {
                                beanO = (BeanO)this.cache.find((Object)masterKey);
                                if (beanO != null) break block25;
                                if (this.reaper.beanExistsAndTimedOut(beanId)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Bean not in cache: removing file");
                                    }
                                    this.ivPassivator.remove(beanId, true);
                                    this.reaper.remove(beanId);
                                    BeanMetaData beanMetaData = beanId.getBeanMetaData();
                                    SfDRSClient sfDRSClient = beanMetaData.getSfDRSClient();
                                    if (sfDRSClient != null) {
                                        sfDRSClient.removeEntry(beanId);
                                    }
                                    break block26;
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Bean not in cache: already removed");
                                }
                                break block26;
                            }
                            if (this.reaper.beanDoesNotExistOrHasTimedOut(beanId)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Found bean in cache: passivating / removing");
                                }
                                try {
                                    beanO = (BeanO)this.cache.remove((Object)masterKey, true);
                                    beanO.ivCacheKey = null;
                                    this.reaper.remove(beanId);
                                    ((StatefulBeanO)beanO).uninstall();
                                }
                                catch (IllegalOperationException illegalOperationException) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Found bean in cache: active");
                                    }
                                    this.cache.unpin((Object)masterKey);
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Found bean in cache: no longer timed out");
                                }
                                this.cache.unpin((Object)masterKey);
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atTimeout", (String)"474", (Object)this);
                        exception = remoteException;
                        throw remoteException;
                    }
                    catch (RuntimeException runtimeException) {
                        FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atTimeout", (String)"480", (Object)this);
                        exception = runtimeException;
                        throw runtimeException;
                    }
                }
                Object var10_11 = null;
                if (exception == null) break block23;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (exception != null && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"atTimeout: exception raised", (Object)exception);
                }
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)tc, (String)"atTimeout");
                throw throwable;
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"atTimeout: exception raised", (Object)exception);
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"atTimeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atPassivate(BeanId beanId) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atPassivate " + beanId));
        }
        BeanO beanO = null;
        MasterKey masterKey = new MasterKey(beanId);
        try {
            Object object = this.locks.getLock((Object)masterKey);
            synchronized (object) {
                beanO = (BeanO)this.cache.find((Object)masterKey);
                if (beanO != null) {
                    StatefulBeanO statefulBeanO = (StatefulBeanO)beanO;
                    long l = this.reaper.getLastAccessTime(beanId);
                    statefulBeanO.setLastAccessTime(l);
                    beanO.passivate();
                    this.cache.remove((Object)masterKey, true);
                    beanO.ivCacheKey = null;
                    this.reaper.setPassivated(beanId);
                    if (EJSPlatformHelper.isZOS() || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND)) {
                        this.reaper.remove(beanId);
                    }
                    statefulBeanO.destroyNotRemove();
                }
            }
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atPassivate", (String)"525", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_PASSIVATE_EJB_CNTR0005W", (Object)new Object[]{beanO, this, remoteException});
            throw remoteException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atPassivate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atUninstall(BeanId beanId, BeanO beanO) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atUninstall (" + beanId + ")"));
        }
        MasterKey masterKey = new MasterKey(beanId);
        Object object = this.locks.getLock((Object)masterKey);
        synchronized (object) {
            beanO = (BeanO)this.cache.find((Object)masterKey);
            if (beanO != null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Found bean in cache: uninstalling");
                }
                try {
                    this.cache.remove((Object)masterKey, true);
                    beanO.ivCacheKey = null;
                    this.reaper.remove(beanId);
                    ((StatefulBeanO)beanO).uninstall();
                }
                catch (IllegalOperationException illegalOperationException) {
                    FFDCFilter.processException((Throwable)illegalOperationException, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atUninstall", (String)"590", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found bean in cache: active!");
                    }
                    this.cache.unpin((Object)masterKey);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Bean not in cache: removing file");
                }
                try {
                    if (this.reaper.remove(beanId)) {
                        this.ivPassivator.remove(beanId, false);
                    }
                }
                catch (RemoteException remoteException) {
                    FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atUninstall", (String)"598", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"REMOVE_FROM_PASSIVATION_STORE_FAILED_CNTR0016W", (Object)new Object[]{beanId, remoteException});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atUninstall");
        }
    }

    public StatefulBeanReaper getReaper() {
        return this.reaper;
    }
}

