/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.TimedObjectWrapper;
import com.ibm.ejs.container.TimerHandleImpl;
import com.ibm.ejs.container.TimerImpl;
import com.ibm.ejs.container.TimerServiceException;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.DeserializeObjectPrivileged;
import com.ibm.ejs.util.dopriv.SerializeObjectPrivileged;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.scheduler.TaskStatus;
import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.Runnable;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class TimerTaskHandler
extends Runnable {
    private static final TraceComponent tc = Tr.register((Class)TimerTaskHandler.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.TimerTaskHandler";
    private static final long serialVersionUID = -8200752857441853748L;
    private static final byte[] EYECATCHER = Constants.TIMER_TASK_EYE_CATCHER;
    private static final short PLATFORM = 1;
    private static final short VERSION_ID = 1;
    private transient BeanId ivBeanId;
    private transient byte[] ivBeanIdBytes;
    private transient Serializable ivInfo;
    private transient byte[] ivInfoBytes;
    private transient TimerServiceException ivBeanIdException;
    private transient TimerServiceException ivInfoException;

    TimerTaskHandler(BeanId beanId, Serializable serializable) throws IOException {
        if (tc.isEntryEnabled()) {
            String string = serializable == null ? null : serializable.getClass().getName();
            Tr.entry((TraceComponent)tc, (String)("<init>: " + beanId + ", " + string));
        }
        this.ivBeanId = beanId;
        this.ivBeanIdBytes = beanId.getByteArrayBytes();
        this.ivBeanIdException = null;
        this.ivInfo = serializable;
        this.ivInfoBytes = TimerTaskHandler.serializeObject(serializable);
        this.ivInfoException = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init>: " + this.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() throws Throwable {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("doWork: " + this.ivBeanId));
        }
        if (this.ivBeanIdException != null || this.ivInfoException != null) {
            TimerServiceException timerServiceException = this.ivBeanIdException != null ? this.ivBeanIdException : this.ivInfoException;
            timerServiceException.fillInStackTrace();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("doWork: " + timerServiceException));
            }
            throw timerServiceException;
        }
        EJSHome eJSHome = (EJSHome)this.ivBeanId.home;
        if (!eJSHome.enabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"doWork: home disabled - rebuilding beanId");
            }
            object = EJSContainer.getDefaultContainer();
            this.ivBeanId = BeanId.getBeanId(this.ivBeanId.getByteArray(), (EJSContainer)object);
            eJSHome = (EJSHome)this.ivBeanId.home;
            if (!eJSHome.beanMetaData.isTimedObject) {
                Tr.warning((TraceComponent)tc, (String)"HOME_NOT_FOUND_CNTR0092W", (Object)this.ivBeanId.getJ2EEName());
                throw new EJBNotFoundException("Incompatible Application Change: " + this.ivBeanId.getJ2EEName() + " no longer implements TimedObject.");
            }
        }
        object = this.getTaskStatus();
        String string = object.getTaskId();
        int n = object.hashCode();
        TimerImpl timerImpl = new TimerImpl(this.ivBeanId, string, n);
        TimedObjectWrapper timedObjectWrapper = eJSHome.getTimedObjectWrapper(this.ivBeanId);
        try {
            timedObjectWrapper.ejbTimeout(timerImpl);
            Object var8_8 = null;
            eJSHome.putTimedObjectWrapper(timedObjectWrapper);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            eJSHome.putTimedObjectWrapper(timedObjectWrapper);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("doWork: " + this.ivBeanId));
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("doWork: " + this.ivBeanId));
        }
    }

    public BeanId getTimedObjectId() throws TimerServiceException {
        if (this.ivBeanIdException != null) {
            this.ivBeanIdException.fillInStackTrace();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getTimedObjectId: " + this.ivBeanIdException));
            }
            throw this.ivBeanIdException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTimedObjectId: " + this.ivBeanId));
        }
        return this.ivBeanId;
    }

    public Serializable getInfo() throws TimerServiceException {
        if (this.ivInfoException != null) {
            this.ivInfoException.fillInStackTrace();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getInfo: " + this.ivInfoException));
            }
            throw this.ivInfoException;
        }
        return this.ivInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public J2EEName getJ2EEName() throws TimerServiceException, IllegalStateException {
        J2EEName j2EEName = null;
        if (this.ivBeanId != null) {
            j2EEName = this.ivBeanId.getJ2EEName();
            if (!tc.isDebugEnabled()) return j2EEName;
            Tr.debug((TraceComponent)tc, (String)("getJ2EEName: BeanId: " + j2EEName));
            return j2EEName;
        } else if (this.ivBeanIdBytes != null) {
            try {
                byte[] byArray = BeanId.getJ2EENameBytes(this.ivBeanIdBytes);
                j2EEName = EJSContainer.getJ2EENameFactory().create(byArray);
                if (!tc.isDebugEnabled()) return j2EEName;
                Tr.debug((TraceComponent)tc, (String)("getJ2EEName: BeanIdBytes: " + j2EEName));
                return j2EEName;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerTaskHandler.getJ2EEName", (String)"361", (Object)((Object)this));
                if (!tc.isDebugEnabled()) throw new TimerServiceException("Failure deserializing TimedObject identity", throwable);
                Tr.debug((TraceComponent)tc, (String)("getJ2EEName: BeanIdBytes: " + throwable));
                throw new TimerServiceException("Failure deserializing TimedObject identity", throwable);
            }
        } else {
            if (!tc.isDebugEnabled()) throw new IllegalStateException("TimedObject Identity not set.");
            Tr.debug((TraceComponent)tc, (String)"getJ2EEName: BeanId not set: IllegalStateException");
            throw new IllegalStateException("TimedObject Identity not set.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Serializable getPrimaryKey() throws TimerServiceException, IllegalStateException {
        Serializable serializable = null;
        if (this.ivBeanId != null) {
            serializable = this.ivBeanId.getPrimaryKey();
            if (!tc.isDebugEnabled()) return serializable;
            Tr.debug((TraceComponent)tc, (String)("getPrimaryKey: BeanId: " + serializable.toString()));
            return serializable;
        } else if (this.ivBeanIdBytes != null) {
            try {
                serializable = BeanId.getPrimaryKey(this.ivBeanIdBytes);
                if (!tc.isDebugEnabled()) return serializable;
                Tr.debug((TraceComponent)tc, (String)("getPrimaryKey: BeanIdBytes: " + serializable.toString()));
                return serializable;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerTaskHandler.getPrimaryKey", (String)"437", (Object)((Object)this));
                if (!tc.isDebugEnabled()) throw new TimerServiceException("Failure deserializing TimedObject identity", throwable);
                Tr.debug((TraceComponent)tc, (String)("getPrimaryKey: BeanIdBytes: " + throwable));
                throw new TimerServiceException("Failure deserializing TimedObject identity", throwable);
            }
        } else {
            if (!tc.isDebugEnabled()) throw new IllegalStateException("TimedObject Identity not set.");
            Tr.debug((TraceComponent)tc, (String)"getPrimaryKey: BeanId not set: IllegalStateException");
            throw new IllegalStateException("TimedObject Identity not set.");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("writeObject: " + (Object)((Object)this)));
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.write(EYECATCHER);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeObject(this.ivBeanIdBytes);
        objectOutputStream.writeObject(this.ivInfoBytes);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block10: {
            block9: {
                int n;
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"readObject");
                }
                objectInputStream.defaultReadObject();
                byte[] byArray = new byte[EYECATCHER.length];
                int n2 = 0;
                for (n = 0; n < EYECATCHER.length; n += n2) {
                    n2 = objectInputStream.read(byArray, n, EYECATCHER.length - n);
                    if (n2 != -1) continue;
                    throw new IOException("end of input stream while reading eye catcher");
                }
                for (n = 0; n < EYECATCHER.length; ++n) {
                    if (EYECATCHER[n] == byArray[n]) continue;
                    String string = new String(byArray);
                    throw new IOException("Invalid eye catcher '" + string + "' in TimerHandle input stream");
                }
                n = objectInputStream.readShort();
                short s = objectInputStream.readShort();
                if (s != 1) {
                    throw new InvalidObjectException("EJB TimerTaskHandler data stream is not of the correct version, this client should be updated.");
                }
                this.ivBeanIdBytes = (byte[])objectInputStream.readObject();
                this.ivInfoBytes = (byte[])objectInputStream.readObject();
                try {
                    ByteArray byteArray = new ByteArray(this.ivBeanIdBytes);
                    EJSContainer eJSContainer = EJSContainer.getDefaultContainer();
                    this.ivBeanId = BeanId.getBeanId(byteArray, eJSContainer);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerTaskHandler.readObject", (String)"567", (Object)((Object)this));
                    this.ivBeanIdException = new TimerServiceException("Failure deserializing TimedObject identity", throwable);
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("readObject: " + this.ivBeanIdException));
                }
            }
            try {
                this.ivInfo = (Serializable)TimerTaskHandler.deserializeObject(this.ivInfoBytes);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerTaskHandler.readObject", (String)"585", (Object)((Object)this));
                this.ivInfoException = new TimerServiceException("Failure deserializing TimedObject identity", throwable);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)("readObject: " + this.ivInfoException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("readObject: " + (Object)((Object)this)));
        }
    }

    private static byte[] serializeObject(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        SerializeObjectPrivileged serializeObjectPrivileged = SerializeObjectPrivileged.getSerializeObjectPrivileged();
        serializeObjectPrivileged.ivObjToSerialize = object;
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)serializeObjectPrivileged);
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ejs.container.TimerTaskHandler.serializeObject", (String)"642");
            IOException iOException = (IOException)privilegedActionException.getException();
            throw iOException;
        }
        byte[] byArray = serializeObjectPrivileged.ivSerializedObj;
        SerializeObjectPrivileged.releaseSerializeObjectPrivileged(serializeObjectPrivileged);
        return byArray;
    }

    private static Object deserializeObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        Object object = null;
        DeserializeObjectPrivileged deserializeObjectPrivileged = DeserializeObjectPrivileged.getDeserializeObjectPrivileged();
        deserializeObjectPrivileged.ivBytesToDeserialize = byArray;
        try {
            object = AccessController.doPrivileged((PrivilegedExceptionAction)deserializeObjectPrivileged);
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ejs.container.TimerTaskHandler.deserializeObject", (String)"698");
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (ClassNotFoundException)exception;
        }
        DeserializeObjectPrivileged.releaseDeserializeObjectPrivileged(deserializeObjectPrivileged);
        return object;
    }

    public boolean equals(Object object) {
        if (this.ivBeanIdException != null || this.ivInfoException != null) {
            TimerServiceException timerServiceException = this.ivBeanIdException != null ? this.ivBeanIdException : this.ivInfoException;
            timerServiceException.fillInStackTrace();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("equals: " + timerServiceException));
            }
            throw timerServiceException;
        }
        if (object instanceof TimerHandleImpl && super.equals(object)) {
            TimerTaskHandler timerTaskHandler = (TimerTaskHandler)((Object)object);
            if (this.ivBeanId.equals(timerTaskHandler.ivBeanId) && this.ivInfo.equals(timerTaskHandler.ivInfo)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(TimerTaskHandler timerTaskHandler) {
        if (this.ivBeanIdException != null || this.ivInfoException != null) {
            TimerServiceException timerServiceException = this.ivBeanIdException != null ? this.ivBeanIdException : this.ivInfoException;
            timerServiceException.fillInStackTrace();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("equals: " + timerServiceException));
            }
            throw timerServiceException;
        }
        return super.equals((Object)timerTaskHandler) && this.ivBeanId.equals(timerTaskHandler.ivBeanId) && this.ivInfo.equals(timerTaskHandler.ivInfo);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        String string = null;
        TaskStatus taskStatus = this.getTaskStatus();
        if (taskStatus != null) {
            string = taskStatus.getTaskId();
        }
        return "TimerTaskHandler(" + string + ", " + this.ivBeanId + ")";
    }
}

