/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanNotReentrantException;
import com.ibm.ejs.container.CreateFailureException;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.ExceptionMappingStrategy;
import com.ibm.ejs.container.InvalidTransactionLocalException;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIAccessException;
import com.ibm.websphere.csi.CSIActivityCompletedException;
import com.ibm.websphere.csi.CSIActivityRequiredException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSIInvalidActivityException;
import com.ibm.websphere.csi.CSIInvalidTransactionException;
import com.ibm.websphere.csi.CSINoSuchObjectException;
import com.ibm.websphere.csi.CSITransactionRequiredException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.csi.OrbUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityCompletedException;
import com.ibm.ws.javax.activity.ActivityRequiredException;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.ejb.ActivityCompletedLocalException;
import com.ibm.ws.javax.ejb.ActivityRequiredLocalException;
import com.ibm.ws.javax.ejb.InvalidActivityLocalException;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;

public class RemoteExceptionMappingStrategy
extends ExceptionMappingStrategy {
    protected static TraceComponent tc = Tr.register((Class)RemoteExceptionMappingStrategy.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.RemoteExceptionMappingStrategy";
    OrbUtils ivOrbUtils = null;

    public RemoteExceptionMappingStrategy(EJSDeployedSupport eJSDeployedSupport) {
        super(eJSDeployedSupport);
        this.ivOrbUtils = eJSDeployedSupport.container.orbUtils;
    }

    private Throwable mapException(RemoteException remoteException) {
        try {
            if (remoteException instanceof CSIException) {
                CSIException cSIException = (CSIException)((Object)remoteException);
                return this.mapCSIException(cSIException);
            }
            if (remoteException.detail instanceof CSIException) {
                CSIException cSIException = (CSIException)remoteException.detail;
                return this.mapCSIException(cSIException);
            }
            if (remoteException instanceof CreateFailureException) {
                if (this.ivOrbUtils == null) {
                    return remoteException;
                }
                return this.ivOrbUtils.mapException(remoteException);
            }
            if (remoteException.detail instanceof EJBException) {
                EJBException eJBException = (EJBException)remoteException.detail;
                return this.mapEJBException(eJBException);
            }
            if (this.ivOrbUtils == null) {
                return remoteException;
            }
            return this.ivOrbUtils.mapException(remoteException);
        }
        catch (CSIException cSIException) {
            FFDCFilter.processException((Throwable)cSIException, (String)"com.ibm.ejs.container.RemoteExceptionMappingStrategy.mapException", (String)"119", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_MAP_EXCEPTION_CNTR0013W", (Object)new Object[]{remoteException, cSIException});
            return remoteException;
        }
    }

    public final Exception setUncheckedException(Throwable throwable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setUncheckedException in param:" + throwable));
        }
        if (this.ex == null) {
            if (this.thisStrategiesOwner.preInvokeException && (throwable instanceof NoSuchObjectException || throwable instanceof CSIAccessException || throwable instanceof BeanNotReentrantException)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception should not cause rollback, changing to checked exception");
                }
                if (throwable instanceof BeanNotReentrantException) {
                    this.thisStrategiesOwner.beanO = null;
                }
                this.exType = ExceptionType.CHECKED_EXCEPTION;
            } else {
                this.exType = ExceptionType.UNCHECKED_EXCEPTION;
                ExceptionUtil.logException(throwable, this.thisStrategiesOwner.getEJBMethodInfo(), this.thisStrategiesOwner.getBeanO());
            }
            this.root = this.findRootCause(throwable);
            if (!(throwable instanceof RemoteException)) {
                throwable = new RemoteException("", throwable);
                throwable.setStackTrace(this.root.getStackTrace());
            }
            this.ex = (Exception)this.mapException((RemoteException)throwable);
        } else if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"setting unchecked exception again", (Object)throwable);
            Tr.event((TraceComponent)tc, (String)"original exception", (Object)this.ex);
        }
        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.RemoteExceptionMappingStrategy.setUncheckedException", (String)"200", (Object)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("setUncheckedException returning : " + this.ex));
        }
        this.ex.setStackTrace(this.root.getStackTrace());
        return (Exception)this.ex;
    }

    private Exception mapCSIException(CSIException cSIException) throws CSIException {
        Throwable throwable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mapCSIException: " + (Object)((Object)cSIException)));
        }
        Throwable throwable2 = null;
        String string = " ";
        if (cSIException instanceof CSITransactionRolledbackException) {
            throwable = new TransactionRolledbackException(string);
        } else if (cSIException instanceof CSIAccessException) {
            throwable = new AccessException(string);
        } else if (cSIException instanceof CSIInvalidTransactionException) {
            throwable = new InvalidTransactionException(string);
        } else if (cSIException instanceof CSITransactionRequiredException) {
            throwable = new TransactionRequiredException(string);
        } else if (cSIException instanceof CSIInvalidActivityException) {
            throwable = new InvalidActivityException(string);
        } else if (cSIException instanceof CSIActivityRequiredException) {
            throwable = new ActivityRequiredException(string);
        } else if (cSIException instanceof CSIActivityCompletedException) {
            throwable = new ActivityCompletedException(string);
        } else if (cSIException instanceof CSINoSuchObjectException) {
            throwable = new NoSuchObjectException(string);
        } else {
            cSIException.detail = null;
            throwable = new RemoteException(cSIException.getMessage());
        }
        boolean bl = false;
        String string2 = System.getProperty("com.ibm.websphere.ejbcontainer.includeRootExceptionOnRollback");
        if (string2 != null) {
            bl = string2.equalsIgnoreCase("true");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nested exceptions will be included on rollback when possible. " + throwable + ": " + this.thisStrategiesOwner.began));
            }
            if (throwable instanceof TransactionRolledbackException && this.thisStrategiesOwner.began) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Transaction was begun in context of this bean method.");
                }
                throwable = new RemoteException("", throwable);
            }
        }
        ((RemoteException)throwable).detail = this.root;
        throwable.setStackTrace(this.root.getStackTrace());
        if (this.ivOrbUtils != null) {
            int n;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mapCSIException calling OrbUtils.mapException: " + throwable));
            }
            throwable2 = (n = cSIException.getMinorCode()) == 0 ? this.ivOrbUtils.mapException((RemoteException)throwable) : this.ivOrbUtils.mapException((RemoteException)throwable, n);
        } else {
            throwable2 = throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("mapCSIException returning: " + throwable2));
        }
        return throwable2;
    }

    public Exception mapCSITransactionRolledBackException(CSITransactionRolledbackException cSITransactionRolledbackException) throws CSIException {
        if (this.root == null) {
            this.root = ExceptionUtil.findRootCause(cSITransactionRolledbackException);
        }
        Exception exception = this.mapCSIException((CSIException)((Object)cSITransactionRolledbackException));
        exception.setStackTrace(this.root.getStackTrace());
        return exception;
    }

    private Exception mapEJBException(EJBException eJBException) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mapEJBException: " + (Object)((Object)eJBException)));
        }
        Throwable throwable = null;
        String string = " ";
        Object object = eJBException instanceof TransactionRolledbackLocalException ? new TransactionRolledbackException(string) : (eJBException instanceof AccessLocalException ? new AccessException(string) : (eJBException instanceof InvalidTransactionLocalException ? new InvalidTransactionException(string) : (eJBException instanceof NoSuchObjectLocalException ? new NoSuchObjectException(string) : (eJBException instanceof TransactionRequiredLocalException ? new TransactionRequiredException(string) : (eJBException instanceof InvalidActivityLocalException ? new InvalidActivityException(string) : (eJBException instanceof ActivityRequiredLocalException ? new ActivityRequiredException(string) : (eJBException instanceof ActivityCompletedLocalException ? new ActivityCompletedException(string) : new RemoteException(string))))))));
        ((RemoteException)object).detail = this.root;
        ((Throwable)object).setStackTrace(this.root.getStackTrace());
        if (this.ivOrbUtils != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mapEJBException calling OrbUtils.mapException: " + object));
            }
            throwable = this.ivOrbUtils.mapException((RemoteException)object);
        } else {
            throwable = object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("mapEJBException returning: " + throwable));
        }
        return throwable;
    }
}

