/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.transport.MimeHeaderField;
import com.ibm.ws.webcontainer.transport.MimeHeadersEnumerator;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletOutputStream;

public class MimeHeaders {
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private byte[] buf;
    private static TraceComponent tc = Tr.register((Class)MimeHeaders.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    public MimeHeaders() {
        this(512);
    }

    public MimeHeaders(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor", (Object)String.valueOf(n));
        }
        this.buf = new byte[n];
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    protected MimeHeaderField appendHeader() {
        MimeHeaderField mimeHeaderField;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appendHeader");
        }
        if (this.count >= (n = this.headers.length)) {
            MimeHeaderField[] mimeHeaderFieldArray = new MimeHeaderField[this.count * 2];
            System.arraycopy(this.headers, 0, mimeHeaderFieldArray, 0, n);
            this.headers = mimeHeaderFieldArray;
        }
        if ((mimeHeaderField = this.headers[this.count]) == null) {
            this.headers[this.count] = mimeHeaderField = new MimeHeaderField();
        }
        ++this.count;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appendHeader");
        }
        return mimeHeaderField;
    }

    void appendHeader(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appendHeader", (Object)string);
        }
        MimeHeaderField mimeHeaderField = this.appendHeader();
        mimeHeaderField.setName(string);
        mimeHeaderField.setValue(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appendHeader");
        }
    }

    void appendIntHeader(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appendHeader", (Object)string);
        }
        MimeHeaderField mimeHeaderField = this.appendHeader();
        mimeHeaderField.setName(string);
        mimeHeaderField.setIntValue(n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appendHeader");
        }
    }

    void appendDateHeader(String string, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appendHeader", (Object)string);
        }
        MimeHeaderField mimeHeaderField = this.appendHeader();
        mimeHeaderField.setName(string);
        mimeHeaderField.setDateValue(l);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appendHeader");
        }
    }

    public void clear() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clear");
        }
        for (int i = 0; i < this.count; ++i) {
            this.headers[i].reset();
        }
        this.count = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    public boolean containsHeader(String string) {
        return this.find(string) != null;
    }

    public void dump(PrintStream printStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"dump");
        }
        for (int i = 0; i < this.headers.length; ++i) {
            printStream.println(this.headers[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"dump");
        }
    }

    protected MimeHeaderField find(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"find", (Object)string);
        }
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].nameEquals(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"find");
            }
            return this.headers[i];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"find - null");
        }
        return null;
    }

    public int getAll(byte[] byArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAll");
        }
        int n2 = n;
        for (int i = 0; i < this.count; ++i) {
            n += this.headers[i].getBytes(byArray, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAll");
        }
        return n - n2;
    }

    public long getDateHeader(String string) throws IllegalArgumentException {
        MimeHeaderField mimeHeaderField = this.find(string);
        return mimeHeaderField != null ? mimeHeaderField.getDateValue() : -1L;
    }

    protected MimeHeaderField getField(int n) {
        return n >= 0 && n < this.count ? this.headers[n] : null;
    }

    public int getFieldCount(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFieldCount", (Object)string);
        }
        int n = 0;
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].nameEquals(string)) continue;
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFieldCount");
        }
        return n;
    }

    public String getHeader(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getValue() : null;
    }

    public String getHeader(String string) {
        MimeHeaderField mimeHeaderField = this.find(string);
        return mimeHeaderField != null ? mimeHeaderField.getValue() : null;
    }

    public String getHeaderName(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getName() : null;
    }

    public String[] getHeaders(String string) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getHeaders", (Object)string);
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        for (n = 0; n < this.count; ++n) {
            if (!this.headers[n].nameEquals(string)) continue;
            String string2 = this.headers[n].getValue();
            vector.addElement(string2.trim());
        }
        if (vector.size() > 0) {
            stringArray = new String[vector.size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getHeaders");
        }
        return stringArray;
    }

    public int getIntHeader(String string) throws NumberFormatException {
        MimeHeaderField mimeHeaderField = this.find(string);
        return mimeHeaderField != null ? mimeHeaderField.getIntValue() : -1;
    }

    public Enumeration names() {
        return new MimeHeadersEnumerator(this);
    }

    public void putDateHeader(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putDateHeader", (Object)string);
        }
        this.putHeader(string).setDateValue();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"putDateHeader");
        }
    }

    public void putDateHeader(String string, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putDateHeader", (Object)string);
        }
        this.putHeader(string).setDateValue(l);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"putDateHeader");
        }
    }

    protected MimeHeaderField putHeader() {
        MimeHeaderField mimeHeaderField;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putHeader");
        }
        if (this.count >= (n = this.headers.length)) {
            MimeHeaderField[] mimeHeaderFieldArray = new MimeHeaderField[this.count * 2];
            System.arraycopy(this.headers, 0, mimeHeaderFieldArray, 0, n);
            this.headers = mimeHeaderFieldArray;
        }
        if ((mimeHeaderField = this.headers[this.count]) == null) {
            this.headers[this.count] = mimeHeaderField = new MimeHeaderField();
        }
        ++this.count;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"putHeader");
        }
        return mimeHeaderField;
    }

    protected MimeHeaderField putHeader(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putHeader", (Object)string);
        }
        if (string == null) {
            throw new IllegalArgumentException("Cannot set header with null name");
        }
        this.removeHeader(string);
        MimeHeaderField mimeHeaderField = this.putHeader();
        mimeHeaderField.setName(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"putHeader");
        }
        return mimeHeaderField;
    }

    public void putHeader(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putHeader", (Object)string);
        }
        this.putHeader(string).setValue(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"putHeader");
        }
    }

    public void putIntHeader(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putIntHeader", (Object)string);
        }
        this.putHeader(string).setIntValue(n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"putIntHeader");
        }
    }

    public void removeHeader(String string) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].nameEquals(string)) continue;
            MimeHeaderField mimeHeaderField = this.headers[i];
            mimeHeaderField.reset();
            this.headers[i] = this.headers[this.count - 1];
            this.headers[this.count - 1] = mimeHeaderField;
            --this.count;
            --i;
        }
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.count; ++i) {
            stringBuffer.append("{");
            stringBuffer.append(this.headers[i].toString());
            stringBuffer.append("}");
            if (i >= this.count - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void write(ServletOutputStream servletOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write");
        }
        for (int i = 0; i < this.count; ++i) {
            this.headers[i].write(servletOutputStream);
        }
        servletOutputStream.println();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }
}

