/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.ws.webcontainer.webapp.RootWebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.webcontainer.IPoolable;
import com.ibm.wsspi.webcontainer.IRequest;
import com.ibm.wsspi.webcontainer.IResponse;

public class SRTConnectionContext
implements Cloneable,
IPoolable {
    private Request _request;
    private WebAppDispatcherContext _dispatchContext = null;
    private Response _response;
    private static TraceComponent tc = Tr.register((Class)SRTConnectionContext.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    public SRTConnectionContext() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Constructor");
        }
        this._request = new SRTServletRequest(this);
        this._response = new SRTServletResponse(this);
        this._dispatchContext = new RootWebAppDispatcherContext(this._request);
        this._request.setWebAppDispatcherContext(this._dispatchContext);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Constructor: current WebAppDispatcherContext [" + this._dispatchContext + "] request [" + this._request + "] response [" + this._response));
        }
    }

    public void prepareForNextConnection(IRequest iRequest, IResponse iResponse) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"prepareForNextConnection");
        }
        this._request.initForNextRequest(iRequest);
        this._response.initForNextResponse(iResponse);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BEGIN : prepareForNextConnection: current WebAppDispatcherContext [" + this._dispatchContext + "] request [" + this._request + "] response [" + this._response));
        }
    }

    public void start() {
        this._response.start();
        this._request.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("END : finishConnection : current WebAppDispatcherContext [" + this._dispatchContext + "] request [" + this._request + "] response [" + this._response));
        }
        try {
            try {
                this._request.finish();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.srt.SRTConnectionContext.finishConnection", (String)"64", (Object)this);
                this._request.getWebAppDispatcherContext().getWebApp().logError("Error while finishing the connection", throwable);
            }
            try {
                this._response.finish();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.srt.SRTConnectionContext.finishConnection", (String)"74", (Object)this);
            }
            try {
                WebAppDispatcherContext webAppDispatcherContext = this._request.getWebAppDispatcherContext();
                if (webAppDispatcherContext.equals(this._dispatchContext)) {
                    this._dispatchContext.finish();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WebAppDispatcherContext mismatch: current[" + webAppDispatcherContext + "] expected [" + this._dispatchContext + "] request [" + this._request + "] dump hierachy and create new WebAppDispatcherContext "));
                    }
                    webAppDispatcherContext.dumpDispatchContextHierarchy();
                    this._dispatchContext = new RootWebAppDispatcherContext(this._request);
                    this._request.setWebAppDispatcherContext(this._dispatchContext);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.srt.SRTConnectionContext.finishConnection", (String)"84", (Object)this);
            }
            Object var3_5 = null;
            this._request.initForNextRequest(null);
            this._response.initForNextResponse(null);
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this._request.initForNextRequest(null);
            this._response.initForNextResponse(null);
            throw throwable;
        }
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    protected Object clone(SRTServletRequest sRTServletRequest, WebAppDispatcherContext webAppDispatcherContext) throws CloneNotSupportedException {
        SRTConnectionContext sRTConnectionContext = (SRTConnectionContext)super.clone();
        sRTConnectionContext._request = sRTServletRequest;
        sRTConnectionContext._dispatchContext = webAppDispatcherContext;
        return sRTConnectionContext;
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        this._request.destroy();
        this._response.destroy();
        this._dispatchContext = null;
        this._request = null;
        this._response = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }
}

