/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor;
import com.ibm.ws.webcontainer.servlet.FileServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileServletWrapper
extends FileServletWrapper {
    private ZipFile zipFile;
    private ZipEntry zipEntry;

    public ZipFileServletWrapper(IServletContext iServletContext, DefaultExtensionProcessor defaultExtensionProcessor, ZipFile zipFile, ZipEntry zipEntry) {
        super(iServletContext, defaultExtensionProcessor);
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    public String getServletName() {
        return "Zip File wrapper";
    }

    protected InputStream getInputStream() throws IOException {
        return this.zipFile.getInputStream(this.zipEntry);
    }

    protected long getLastModified() {
        return this.zipEntry.getTime();
    }

    protected int getContentLength() {
        return new Long(this.zipEntry.getSize()).intValue();
    }

    public void setParent(IServletContext iServletContext) {
    }

    public boolean isAvailable() {
        return new File(this.zipFile.getName()).exists();
    }
}

