/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.TimedServletPool;
import com.ibm.ws.webcontainer.servlet.TimedServletPoolElement;
import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class SingleThreadModelServlet
extends GenericServlet {
    private static final long serialVersionUID = 3617573808110710841L;
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    TimedServletPool _pool;
    Class _servletClass;

    public SingleThreadModelServlet() {
    }

    public SingleThreadModelServlet(Class clazz) {
        this.setServletClass(clazz);
    }

    public void init() throws ServletException {
        try {
            int n = 5;
            long l = 60000L;
            String string = this.getServletConfig().getServletContext().getInitParameter("singlethreadmodel.initialpoolsize");
            String string2 = this.getServletConfig().getServletContext().getInitParameter("singlethreadmodel.maxidletime");
            if (string != null) {
                try {
                    n = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    n = 5;
                    System.out.println("error initialPoolSize value setting to default value 5");
                }
            }
            if (string2 != null) {
                try {
                    l = Long.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    l = 60000L;
                    System.out.println("error maxIdleTime value setting to default value 60000");
                }
            }
            this._pool = new TimedServletPool(n, l, this.getServletClass(), this.getServletConfig());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet.init", (String)"64", (Object)((Object)this));
            throw new ServletException(throwable);
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        try {
            TimedServletPoolElement timedServletPoolElement = this._pool.getNextElement();
            timedServletPoolElement.getServlet().service(servletRequest, servletResponse);
            this._pool.returnElement(timedServletPoolElement);
            this._pool.removeExpiredElements();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet.service", (String)"84", (Object)((Object)this));
            throw new ServletException(throwable);
        }
    }

    public void destroy() {
        this._pool.removeAllElements();
    }

    public Class getServletClass() {
        return this._servletClass;
    }

    public void setServletClass(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            Object[] objectArray = new Object[]{clazz};
            throw new IllegalArgumentException(nls.getFormattedMessage("Class.{0}.does.not.implement.servlet", objectArray, "Class " + clazz + " does not implement servlet"));
        }
        this._servletClass = clazz;
    }

    public int getInstanceCount() {
        return this._pool.getSize();
    }
}

