/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.objectpool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.pool.ObjectPool;
import com.ibm.websphere.asynchbeans.pool.ObjectPoolManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.objectpool.ObjectPoolService;
import com.ibm.ws.runtime.service.RuntimeCtxImpl;
import com.ibm.ws.webcontainer.objectpool.BoundedObjectPool;
import com.ibm.ws.webcontainer.objectpool.ObjectPoolCreationException;

public class ObjectPoolFactory {
    protected static TraceComponent tc = Tr.register((Class)ObjectPoolFactory.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    private ObjectPoolFactory() {
    }

    public static ObjectPool getPool(RuntimeCtxImpl runtimeCtxImpl, Class clazz, int n) {
        try {
            if (n > 0) {
                return new BoundedObjectPool(clazz, n);
            }
            if (n == 0) {
                return null;
            }
            return ObjectPoolFactory.getBasePool(runtimeCtxImpl, clazz);
        }
        catch (ObjectPoolCreationException objectPoolCreationException) {
            return null;
        }
    }

    public static ObjectPool getBasePool(RuntimeCtxImpl runtimeCtxImpl, Class clazz) throws ObjectPoolCreationException {
        ObjectPool objectPool = null;
        ObjectPoolService objectPoolService = (ObjectPoolService)runtimeCtxImpl.getService(ObjectPoolService.class);
        if (objectPoolService != null) {
            ObjectPoolManager objectPoolManager = objectPoolService.getSystemObjectPoolManager();
            try {
                objectPool = objectPoolManager.getPool(clazz);
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.webcontainer.ObjectPoolFactory", (String)"50");
                Object[] objectArray = new Object[]{clazz.getName()};
                Tr.error((TraceComponent)tc, (String)"Object.Pool.Exception.Class.could.not.be.instantiated.[{0}]", (Object)objectArray);
                throw new ObjectPoolCreationException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.webcontainer.ObjectPoolFactory", (String)"58");
                Object[] objectArray = new Object[]{clazz.getName()};
                Tr.error((TraceComponent)tc, (String)"Object.Pool.Exception.Class.could.not.be.instantiated.[{0}]", (Object)objectArray);
                throw new ObjectPoolCreationException(illegalAccessException);
            }
        } else {
            Tr.warning((TraceComponent)tc, (String)"ObjectPoolService is unavailable. SRTConnectionContext pooling disabled");
        }
        return objectPool;
    }
}

